/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

public class Stock {
    private double quantity;
    private double pricePerUnit;
    private boolean sane;

    public Stock(double quantity, double pricePerUnit) {
        this.quantity = quantity;
        this.pricePerUnit = pricePerUnit;
        this.sane = true;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPricePerUnit() {
        return this.pricePerUnit;
    }

    public void setPricePerUnit(double pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public boolean isSane() {
        return this.sane;
    }

    public void becomeInsane() throws IllegalStateException {
        if (!(this.quantity < 1.0)) {
            throw new IllegalStateException(this + " i am sane!");
        }
        this.sane = false;
    }

    public double use(double quantity) {
        if (!this.isSane()) {
            this.quantity -= quantity;
            return this.quantity;
        }
        if (this.quantity >= quantity) {
            this.quantity -= quantity;
            return this.quantity;
        }
        double rest = this.quantity - quantity;
        this.quantity = 0.0;
        return rest;
    }

    public double getValue() {
        return this.quantity * this.pricePerUnit;
    }
}

