/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.ProveraStalnogGosta;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Role;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.parts.BooleanInput;
import com.dev63.restoran.parts.DateInput;
import com.dev63.restoran.parts.DoubleInput;
import com.dev63.restoran.parts.HostelAction2;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput;
import com.dev63.restoran.parts.TextInput;
import com.dev63.restoran.parts.TimeInput;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Settings {
    private JTree tree;
    private DefaultTreeModel model;
    private Map<String, Setting> map = new HashMap<String, Setting>();
    private Map<String, Option> optionMap = new HashMap<String, Option>();
    private RestoranServer server;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    SWTContainer parent;
    final Frame frame;

    public Settings(SWTContainer owner, Restoran hostel) {
        this.server = hostel.getServer();
        this.parent = owner;
        this.loadData();
        Shell shell = this.parent.getControl().getShell();
        Composite composite = new Composite((Composite)shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.frame = SWT_AWT.new_Frame((Composite)composite);
        this.tree = this.makeTree();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Settings.this.editSetting();
                }
            }
        });
        this.frame.add(this.tree);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(500, 800);
    }

    private JTree makeTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Option o : Option.values()) {
            if (!o.getShow().booleanValue()) continue;
            this.optionMap.put(o.getName(), o);
            this.insertOptionNode(root, o);
        }
        this.model = new DefaultTreeModel(root);
        return new JTree(this.model);
    }

    private void insertOptionNode(DefaultMutableTreeNode root, Option option) {
        String[] path;
        for (String s : path = option.getPath().split("~")) {
            root = this.findNode(root, s);
        }
        Setting s = this.map.get(option.getName());
        if (s == null) {
            s = new Setting();
            s.setActual(option.getDiefault());
            s.setName(option.getName());
        }
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(s);
        root.add(n);
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode root, String s) {
        DefaultMutableTreeNode n;
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            n = (DefaultMutableTreeNode)e.nextElement();
            if (!n.getUserObject().equals(s)) continue;
            return n;
        }
        n = new DefaultMutableTreeNode(s);
        root.add(n);
        return n;
    }

    private void loadData() {
        List<Setting> list = this.server.getSettings();
        for (Setting s : list) {
            this.map.put(s.getName(), s);
        }
    }

    private void editSetting() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = n.getUserObject();
        if (!(o instanceof Setting)) {
            return;
        }
        new EditSetting((Setting)o, n).setVisible(true);
    }

    private class EditSetting
    extends JDialog {
        private Setting input;
        private Option option;
        private Input value;
        private DefaultMutableTreeNode node;

        public EditSetting(Setting input, DefaultMutableTreeNode node) {
            super(Settings.this.frame);
            this.input = input;
            this.node = node;
            this.option = (Option)Settings.this.optionMap.get(input.getName());
            this.setTitle("Izmena opcije");
            this.getContentPane().setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            FormLayout layout = new FormLayout("right:max(60dlu;pref), 3dlu, 140dlu", "");
            DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, panel);
            formBuilder.setDefaultDialogBorder();
            this.add((Component)panel, "Center");
            formBuilder.append("Opcija", (Component)new JLabel(this.option.getPath()));
            switch (this.option.getType()) {
                case STRING: {
                    this.value = new TextInput("Naziv", true);
                    this.value.setResult(input.getActual());
                    break;
                }
                case INTEGER: {
                    IntInput ii = new IntInput("Naziv", true);
                    this.value = ii;
                    ii.setText(input.getActual());
                    break;
                }
                case DOUBLE: {
                    DoubleInput di = new DoubleInput("Naziv", true);
                    this.value = di;
                    di.setText(input.getActual());
                    break;
                }
                case BOOLEAN: {
                    BooleanInput bi = new BooleanInput(true);
                    this.value = bi;
                    bi.setResult(new Boolean(input.getActual()));
                    break;
                }
                case DATE: {
                    DateInput ti = new DateInput("Naziv", true);
                    this.value = ti;
                    ti.setText(input.getActual());
                    break;
                }
                case TIME: {
                    TimeInput tt = new TimeInput("Naziv", true);
                    this.value = tt;
                    tt.setText(input.getActual());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option type: " + (Object)((Object)this.option.getType()));
                }
            }
            formBuilder.append("Naziv", (Component)((JComponent)((Object)this.value)));
            this.addButtons(formBuilder);
            this.pack();
            int x = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
            int y = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
            this.setLocation(new Point(x, y));
        }

        private void addButtons(DefaultFormBuilder formBuilder) {
            JButton cancelButt = new JButton(new HostelAction2("Otkazi", Settings.this.server.getUser(), Role.USER){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditSetting.this.cancel();
                }
            });
            JButton okButt = new JButton(new HostelAction2("Unos", Settings.this.server.getUser(), Role.USER){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditSetting.this.ok();
                }
            });
            JPanel dugmici = ButtonBarFactory.buildOKCancelBar((JButton)okButt, (JButton)cancelButt);
            formBuilder.append((Component)dugmici, formBuilder.getColumnCount());
        }

        private void ok() {
            try {
                Option opt = (Option)Settings.this.optionMap.get(this.input.getName());
                if (opt.getName().equals("faktura.firma.spremacice")) {
                    int i = (Integer)this.value.getResult();
                    ProveraStalnogGosta psg = new ProveraStalnogGosta(Settings.this.server, i);
                    if (!psg.stalniGostPostoji()) {
                        JOptionPane.showMessageDialog(Settings.this.frame, "Nepostoje\u0107a firma za upisani Id");
                        return;
                    }
                    if (!psg.postojiNacinPlacanja()) {
                        JOptionPane.showMessageDialog(Settings.this.frame, "Izabaranoj firmi nije definisan nacin placanja");
                        return;
                    }
                }
                StringBuilder rec = new StringBuilder("Izmena podesavanja: " + this.option.getPath() + ", stara vrednost: " + this.input.getActual());
                switch (this.option.getType()) {
                    case STRING: {
                        this.input.setActual((String)this.value.getResult());
                        break;
                    }
                    case INTEGER: {
                        Integer i = (Integer)this.value.getResult();
                        this.input.setActual(String.valueOf(i));
                        break;
                    }
                    case DOUBLE: {
                        Double d = (Double)this.value.getResult();
                        this.input.setActual(String.valueOf(d));
                        break;
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)this.value.getResult();
                        this.input.setActual(String.valueOf(b));
                        break;
                    }
                    case DATE: {
                        Date t = (Date)this.value.getResult();
                        this.input.setActual(Settings.this.dateFormat.format(t));
                        break;
                    }
                    case TIME: {
                        Date tt = (Date)this.value.getResult();
                        this.input.setActual(Settings.this.timeFormat.format(tt));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown option type: " + (Object)((Object)this.option.getType()));
                    }
                }
                rec.append(", nova vrednost: " + this.input.getActual());
                Settings.this.server.log(rec.toString());
                Settings.this.server.changeSetting(this.input);
                Settings.this.model.nodeChanged(this.node);
                this.dispose();
            }
            catch (InputException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Greska", 2);
            }
        }

        private void cancel() {
            this.dispose();
        }
    }
}

