/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.frontoffice.GrafikSalePrikazBela;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Rezervacija;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;

public class Rezervacije {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private final DefaultListModel<Rezervacija> listModel;
    private final Label napomena;
    private final Restoran restoran;
    private final RestoranServer server;
    private final SWTContainer parent;
    final Shell shell;
    Group grupa2;
    Group grupa3;
    private static Rezervacija active;
    private Tura tura;
    public long id;
    ToolItem item3;
    Composite dugmici;
    Table tabela;
    Table atributi;
    List<Rezervacija> rezervacija = new ArrayList<Rezervacija>();
    Rectangle bounds;
    Display display;
    List<GrafikSale> sale;
    long idRcn = 0L;

    public Rezervacije(SWTContainer owner, Restoran restoran, RestoranServer server) {
        this.parent = owner;
        this.restoran = restoran;
        this.server = server;
        this.shell = this.parent.getControl().getShell();
        this.display = this.shell.getDisplay();
        this.sale = server.getGrafikeJPA();
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(4, false));
        GridData data = new GridData();
        panel1.setLayoutData((Object)data);
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(4, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/noviV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = this.bounds.width / 24;
        data.widthHint = (int)((double)this.bounds.height / 2.45);
        Group grupaText = new Group(panel1, 0);
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        Label uputstvo = new Label(panel1, 8);
        data = new GridData();
        data.widthHint = (int)((double)this.bounds.width / 16.7);
        data.heightHint = (int)((double)this.bounds.height / 10.8);
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = (int)((double)this.bounds.width / 5.49);
        data.heightHint = (int)((double)this.bounds.height / 2.16);
        GridData dataAtribut = new GridData();
        dataAtribut.widthHint = (int)((double)this.bounds.width / 3.2);
        dataAtribut.heightHint = (int)((double)this.bounds.height / 2.16);
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        this.grupa2 = new Group(panel2, 0);
        this.grupa2.setLayout((Layout)new GridLayout());
        this.grupa2.setText(String.format(barmasterText.getString("TEXT_SPISAK_REZERVACIJA"), new Object[0]));
        this.grupa2.setLayoutData((Object)data);
        this.grupa3 = new Group(panel2, 0);
        this.grupa3.setLayout((Layout)new GridLayout());
        this.grupa3.setText(String.format(barmasterText.getString("TEXT_ATRIBUTI_REZERVACIJA"), new Object[0]));
        this.grupa3.setLayoutData((Object)dataAtribut);
        Group grupa4 = new Group(panel2, 0);
        grupa4.setLayout((Layout)new GridLayout());
        grupa4.setText(String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0]));
        grupa4.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(barmasterText.getString("TEXT_NOVA_REZERVACIJA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rezervacije.this.addRezervacija();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(barmasterText.getString("TEXT_IZMENA_REZERVACIJA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rezervacije.this.updateRezervacije();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(barmasterText.getString("TEXT_BRISANJE_REZERVACIJA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rezervacije.this.deleteRezervacija();
            }
        });
        label1 = Dugmici.getGrafikSale(this.dugmici);
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rezervacije.this.prikazSale();
            }
        });
        label1 = Dugmici.veziRacun(this.dugmici);
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Rezervacije.this.veziRacun();
            }
        });
        this.makeTable();
        this.makeTableAtributi();
        this.listModel = new DefaultListModel();
        data = new GridData(1808);
        this.napomena = new Label((Composite)grupa4, 0);
        this.napomena.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimensionFS(this.shell);
    }

    private void makeTable() {
        this.tabela = new Table((Composite)this.grupa2, 66306);
        this.tabela.setHeaderVisible(true);
        this.tabela.setLinesVisible(true);
        GridData data2 = new GridData(4, 4, true, true);
        data2.heightHint = (int)((double)this.bounds.height / 5.4);
        this.tabela.setLayoutData((Object)data2);
        this.makeHeaders();
        this.insertRows();
        this.tabela.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.tabela.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rezervacije.this.atributi.removeAll();
                int index = Rezervacije.this.tabela.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                Rezervacije.this.setActiveRezervacije((Rezervacija)Rezervacije.this.listModel.getElementAt(index));
                Rezervacije.this.id = active.getId();
                Rezervacije.this.insertRowsAtributi(Rezervacije.this.id);
            }
        });
    }

    private void makeTableAtributi() {
        this.atributi = new Table((Composite)this.grupa3, 66306);
        this.atributi.setHeaderVisible(true);
        this.atributi.setLinesVisible(true);
        GridData data3 = new GridData(4, 4, true, true);
        data3.heightHint = 200;
        this.atributi.setLayoutData((Object)data3);
        this.makeHeadersAtributi();
        this.atributi.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.atributi.pack();
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.tabela, 131072);
        tc0.setText(String.format(barmasterText.getString("TEXT_IME"), new Object[0]));
        tc0.setWidth(this.bounds.width / 16);
        TableColumn tc1 = new TableColumn(this.tabela, 131072);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM_VREME"), new Object[0]));
        tc1.setWidth((int)((double)this.bounds.width / 12.8));
        TableColumn tc2 = new TableColumn(this.tabela, 131072);
        tc2.setText(String.format(barmasterText.getString("TEXT_STO"), new Object[0]));
        tc2.setWidth(this.bounds.width / 32);
        TableColumn tc3 = new TableColumn(this.tabela, 131072);
        tc3.setText(String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0]));
        tc3.setWidth(0);
    }

    private void makeHeadersAtributi() {
        TableColumn tca0 = new TableColumn(this.atributi, 131072);
        tca0.setText(String.format(barmasterText.getString("TEXT_IME"), new Object[0]));
        tca0.setWidth(this.bounds.width / 16);
        TableColumn tca1 = new TableColumn(this.atributi, 131072);
        tca1.setText(String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0]));
        tca1.setWidth((int)((double)this.bounds.width / 19.2));
        TableColumn tca2 = new TableColumn(this.atributi, 131072);
        tca2.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tca2.setWidth(this.bounds.width / 16);
        TableColumn tca3 = new TableColumn(this.atributi, 131072);
        tca3.setText(String.format(barmasterText.getString("TEXT_VREME"), new Object[0]));
        tca3.setWidth(this.bounds.width / 16);
        TableColumn tca4 = new TableColumn(this.atributi, 131072);
        tca4.setText(String.format(barmasterText.getString("TEXT_BROJ_STOLA_SKR"), new Object[0]));
        tca4.setWidth(this.bounds.width / 96);
        tca4.pack();
        TableColumn tca5 = new TableColumn(this.atributi, 131072);
        tca5.setText(String.format(barmasterText.getString("TEXT_BROJ_OSOBA_SKR"), new Object[0]));
        tca5.setWidth(this.bounds.width / 96);
        tca5.pack();
    }

    private void insertRows() {
        List<Rezervacija> rezervacije = this.server.getRezervacije();
        for (Rezervacija l : rezervacije) {
            TableItem ti = new TableItem(this.tabela, 0);
            if (l.getDatum().get(12) != 0 && l.getDatum().get(11) > 9) {
                ti.setText(new String[]{l.getIme(), "(" + l.getDatum().getTime().toString().substring(4, 10) + " " + l.getDatum().get(11) + ":" + l.getDatum().get(12) + ")", "" + l.getBrStola(), "" + l.getId()});
                continue;
            }
            if (l.getDatum().get(12) != 0 && l.getDatum().get(11) <= 9) {
                ti.setText(new String[]{l.getIme(), "(" + l.getDatum().getTime().toString().substring(4, 10) + " 0" + l.getDatum().get(11) + ":" + l.getDatum().get(12) + "0)", "" + l.getBrStola(), "" + l.getId()});
                continue;
            }
            if (l.getDatum().get(12) == 0 && l.getDatum().get(11) > 9) {
                ti.setText(new String[]{l.getIme(), "(" + l.getDatum().getTime().toString().substring(4, 10) + " " + l.getDatum().get(11) + ":" + l.getDatum().get(12) + "0)", "" + l.getBrStola(), "" + l.getId()});
                continue;
            }
            ti.setText(new String[]{l.getIme(), "(" + l.getDatum().getTime().toString().substring(4, 10) + " 0" + l.getDatum().get(11) + ":" + l.getDatum().get(12) + "0)", "" + l.getBrStola(), "" + l.getId()});
        }
    }

    private void insertRowsAtributi(long id) {
        Connection conn = this.server.getConnection();
        String query = "SELECT r.ime,r.tel,cast(r.datum as date) as datum,cast(r.vreme as time) as vreme,r.brStola,r.brOsoba from rezervacija r where r.id = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            TableItem ti = new TableItem(this.atributi, 0);
            while (rs.next()) {
                ti.setText(new String[]{rs.getString("ime"), rs.getString("tel"), rs.getString("datum"), rs.getString("vreme"), rs.getString("brStola"), rs.getString("brOsoba")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void reload() {
        this.listModel.clear();
        this.tabela.removeAll();
        this.atributi.removeAll();
        this.insertRows();
        List<Rezervacija> rezervacije = this.server.getRezervacije();
        for (Rezervacija l : rezervacije) {
            this.listModel.addElement(l);
        }
        active = null;
        this.napomena.setText("");
    }

    private void addRezervacija() {
        Shell shell2 = new Shell(this.shell, 34912);
        RezervacijeDialog gd = new RezervacijeDialog(SWTContainerClass.makeContainer(shell2, String.format(barmasterText.getString("TEXT_UNOS_NOVE_REZERVACIJE"), new Object[0])), null, this.restoran);
        SWTContainerClass.makeEnd(shell2);
        if (gd.getResult() != null) {
            Rezervacija rez = this.server.addRezervacija(gd.getResult());
            this.server.log(String.format(barmasterText.getString("TEXT_UNOS_NOVE_REZERVACIJE"), new Object[0]) + ":   " + rez);
            this.reload();
        }
    }

    private void updateRezervacije() {
        if (active == null) {
            return;
        }
        Shell shell2 = new Shell(this.shell, 34912);
        RezervacijeDialog re = new RezervacijeDialog(SWTContainerClass.makeContainer(shell2, String.format(barmasterText.getString("TEXT_IZMENA_REZERVACIJE"), new Object[0])), active, this.restoran);
        SWTContainerClass.makeEnd(shell2);
        if (re.getResult() != null) {
            this.server.log(String.format(barmasterText.getString("TEXT_IZMENA_REZERVACIJE"), new Object[0]) + ": " + re.getResult());
            this.restoran.getServer().updateRezervacija(re.getResult());
            this.reload();
        }
    }

    private void veziRacun() {
        this.insertColumnRezId();
        if (active == null) {
            return;
        }
        Connection conn = this.server.getConnection();
        String upit = "Select id from racun  order by id desc limit 1";
        try {
            PreparedStatement ps = conn.prepareStatement(upit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.idRcn = rs.getLong("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String query = "UPDATE  racun r set r.REZERVACIJA_ID=? where r.id = ?";
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setLong(1, active.getId());
            ps.setLong(2, this.idRcn);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.shell.close();
    }

    void racTuraRez() {
        if (active == null) {
            return;
        }
        Connection conn = this.server.getConnection();
        String query1 = "UPDATE  racun r set r.REZERVACIJA_ID=? where r.id = (Select t.RACUN_ID from tura t order by t.id desc limit 1)";
        try {
            PreparedStatement ps = conn.prepareStatement(query1);
            ps.setLong(1, active.getId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void deleteRezervacija() {
        if (active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_REZERVACIJU"), "'" + active.getIme().toUpperCase() + "'"));
        if (ok == 0) {
            this.server.log(String.format(barmasterText.getString("TEXT_BRISANJE_REZERVACIJA"), new Object[0]) + ": " + active);
            this.restoran.getServer().deleteRezervacija(active);
            active = null;
            this.napomena.setText("");
            this.reload();
        }
    }

    private void setActiveRezervacije(Rezervacija o) {
        active = o;
        String datum = o.getDatum().getTime().toString().substring(4, 10);
        StringBuilder bld = new StringBuilder("");
        bld.append(" ").append(String.format(barmasterText.getString("TEXT_IME"), new Object[0])).append(": ").append(o.getIme()).append("\n");
        if (o.getTel() != null) {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0])).append(": ").append(o.getTel()).append("\n");
        } else {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0])).append(": /").append("\n");
        }
        bld.append(" ").append(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0])).append(": ").append(datum).append("\n");
        if (o.getDatum().get(12) != 0) {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_VREME"), new Object[0])).append(": ").append(o.getDatum().get(11)).append(":").append(o.getDatum().get(12)).append("\n");
        } else {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_VREME"), new Object[0])).append(": ").append(o.getDatum().get(11)).append(":00\n");
        }
        bld.append(" ").append(String.format(barmasterText.getString("TEXT_BROJ_STOLA"), new Object[0])).append(": ").append(o.getBrStola()).append("\n");
        if (o.getBrOsoba() != -1) {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_BROJ_OSOBA"), new Object[0])).append(": ").append(o.getBrOsoba()).append("\n");
        } else {
            bld.append(" ").append(String.format(barmasterText.getString("TEXT_BROJ_OSOBA"), new Object[0])).append(": /").append("\n");
        }
        StringBuilder nap = new StringBuilder("");
        if (o.getNapomena() != null) {
            nap.append(" ").append(String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0])).append(": ").append(o.getNapomena()).append("\n");
        } else {
            nap.append(" ").append(String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0])).append(": /").append("\n");
        }
        this.napomena.setText(nap.toString());
    }

    private void prikazSale() {
        new GrafikSalePrikazBela(this.shell, this.server, new HashMap<Integer, String>(), null, this.sale);
    }

    public void insertColumnRezId() {
        Connection conn = this.restoran.getServer().getConnection();
        String column = "ALTER TABLE racun ADD COLUMN REZERVACIJA_ID BIGINT;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(column);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static class RezervacijeDialog {
        List<Rezervacija> kom;
        private final Combo komitent;
        private TextInput2 ime;
        private TextInput2 tel;
        private TextInput2 email;
        private final DateInput2 datum;
        private final IntInput2 brStola;
        private final IntInput2 brOsoba;
        private final TextInput2 napomena;
        private final Combo sat;
        private final Combo minut;
        private final Rezervacija input;
        private Rezervacija result;
        private final Restoran restoran;

        public RezervacijeDialog(SWTContainer parent, Rezervacija input, Restoran restoran) {
            this.input = input;
            this.restoran = restoran;
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            this.createTable();
            this.kom = restoran.getServer().getKomitente();
            Label komitentLabel = new Label((Composite)shell3, 4);
            komitentLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            komitentLabel.setText(String.format(barmasterText.getString("TEXT_KOMITENT"), new Object[0]));
            this.komitent = new Combo((Composite)shell3, 0);
            this.komitent.add(String.format(barmasterText.getString("TEXT_SVI_KOMITENTI"), new Object[0]));
            for (Rezervacija rk : this.kom) {
                this.komitent.add(rk.getIme());
            }
            this.komitent.select(0);
            this.komitent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (komitent.getSelectionIndex() != 0) {
                        ime.setResult(komitent.getText());
                        tel.setResult(kom.get(komitent.getSelectionIndex() - 1).getTel());
                        email.setResult(kom.get(komitent.getSelectionIndex() - 1).getEmail());
                    } else {
                        ime.setResult("");
                        tel.setResult("");
                        email.setResult("");
                    }
                }
            });
            Label imeLabel = new Label((Composite)shell3, 0);
            imeLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            imeLabel.setText(String.format(barmasterText.getString("TEXT_IME"), new Object[0]));
            if (this.komitent.getSelectionIndex() == 0) {
                this.ime = new TextInput2(parent, String.format(barmasterText.getString("TEXT_IME"), new Object[0]), false);
            } else {
                this.ime.setResult(this.komitent.getText());
            }
            Label telLabel = new Label((Composite)shell3, 0);
            telLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            telLabel.setText(String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0]));
            if (this.komitent.getSelectionIndex() == 0) {
                this.tel = new TextInput2(parent, String.format(barmasterText.getString("TEXT_TELEFON"), new Object[0]), true);
            } else {
                this.tel.setResult(this.kom.get(this.komitent.getSelectionIndex()).getTel());
            }
            Label emailLabel = new Label((Composite)shell3, 0);
            emailLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            emailLabel.setText(String.format(barmasterText.getString("TEXT_EMAIL"), new Object[0]));
            if (this.komitent.getSelectionIndex() == 0) {
                this.email = new TextInput2(parent, String.format(barmasterText.getString("TEXT_EMAIL"), new Object[0]), false);
            } else {
                this.email.setResult(this.kom.get(this.komitent.getSelectionIndex()).getEmail());
            }
            Label datumLabel = new Label((Composite)shell3, 0);
            datumLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            datumLabel.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
            this.datum = new DateInput2(parent, String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]), false, restoran.getServer());
            this.datum.setValutaPlacanja(true);
            this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, shell3));
            Label satLabel = new Label((Composite)shell3, 0);
            satLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            satLabel.setText(String.format(barmasterText.getString("TEXT_SAT"), new Object[0]));
            this.sat = new Combo((Composite)shell3, 8);
            this.sat.add("00h");
            this.sat.add("01h");
            this.sat.add("02h");
            this.sat.add("03h");
            this.sat.add("04h");
            this.sat.add("05h");
            this.sat.add("06h");
            this.sat.add("07h");
            this.sat.add("08h");
            this.sat.add("09h");
            this.sat.add("10h");
            this.sat.add("11h");
            this.sat.add("12h");
            this.sat.add("13h");
            this.sat.add("14h");
            this.sat.add("15h");
            this.sat.add("16h");
            this.sat.add("17h");
            this.sat.add("18h");
            this.sat.add("19h");
            this.sat.add("20h");
            this.sat.add("21h");
            this.sat.add("22h");
            this.sat.add("23h");
            this.sat.select(18);
            Label minutLabel = new Label((Composite)shell3, 0);
            minutLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            minutLabel.setText(String.format(barmasterText.getString("TEXT_MINUT"), new Object[0]));
            this.minut = new Combo((Composite)shell3, 8);
            this.minut.add("00");
            this.minut.add("15");
            this.minut.add("30");
            this.minut.add("45");
            this.minut.select(0);
            Label brStolaLabel = new Label((Composite)shell3, 0);
            brStolaLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            brStolaLabel.setText(String.format(barmasterText.getString("TEXT_BROJ_STOLA"), new Object[0]));
            this.brStola = new IntInput2(parent, String.format(barmasterText.getString("TEXT_BROJ_STOLA"), new Object[0]), false);
            Label brOsobaLabel = new Label((Composite)shell3, 0);
            brOsobaLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            brOsobaLabel.setText(String.format(barmasterText.getString("TEXT_BROJ_OSOBA"), new Object[0]));
            this.brOsoba = new IntInput2(parent, String.format(barmasterText.getString("TEXT_BROJ_OSOBA"), new Object[0]), true);
            Label napomenaLabel = new Label((Composite)shell3, 0);
            napomenaLabel.setBackground(shell3.getDisplay().getSystemColor(22));
            napomenaLabel.setText(String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0]));
            this.napomena = new TextInput2(parent, String.format(barmasterText.getString("TEXT_NAPOMENA"), new Object[0]), true);
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            data.horizontalSpan = 2;
            komitentLabel.setLayoutData((Object)data);
            imeLabel.setLayoutData((Object)data);
            telLabel.setLayoutData((Object)data);
            emailLabel.setLayoutData((Object)data);
            datumLabel.setLayoutData((Object)data);
            satLabel.setLayoutData((Object)data);
            minutLabel.setLayoutData((Object)data);
            brStolaLabel.setLayoutData((Object)data);
            brOsobaLabel.setLayoutData((Object)data);
            napomenaLabel.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.komitent.setLayoutData((Object)data);
            this.ime.getControl().setLayoutData((Object)data);
            this.tel.getControl().setLayoutData((Object)data);
            this.email.getControl().setLayoutData((Object)data);
            this.datum.getControl().setLayoutData((Object)data);
            this.sat.setLayoutData((Object)data);
            this.minut.setLayoutData((Object)data);
            this.brStola.getControl().setLayoutData((Object)data);
            this.brOsoba.getControl().setLayoutData((Object)data);
            this.napomena.getControl().setLayoutData((Object)data);
            shell3.pack();
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            Rezervacija o = this.input != null ? this.input : new Rezervacija();
            Calendar od = Calendar.getInstance();
            Calendar doo = Calendar.getInstance();
            Calendar izabran = Calendar.getInstance();
            try {
                izabran.setTime(this.datum.getResult());
                izabran.set(11, this.sat.getSelectionIndex());
                izabran.set(12, this.minut.getSelectionIndex() * 15);
                od.setTime(this.datum.getResult());
                int trajanjeS = this.restoran.getServer().getSetting(Option.TRAJANJE_REZERVACIJE).intValue() / 60;
                int trajanjeM = this.restoran.getServer().getSetting(Option.TRAJANJE_REZERVACIJE).intValue() % 60;
                od.set(11, this.sat.getSelectionIndex() - trajanjeS);
                od.set(12, this.minut.getSelectionIndex() * 15 - trajanjeM);
                doo.setTime(this.datum.getResult());
                doo.set(11, this.sat.getSelectionIndex() + trajanjeS);
                doo.set(12, this.minut.getSelectionIndex() * 15 + trajanjeM);
                List<Rezervacija> rezervacije = o.getId() != null ? this.restoran.getServer().proveraRezervacije(this.brStola.getResult(), od, doo, o.getId()) : this.restoran.getServer().proveraRezervacije(this.brStola.getResult(), od, doo);
                if (!rezervacije.isEmpty()) {
                    String rez = String.format(barmasterText.getString("PORUKA_IZABRANI_STO_JE_VEC_REZERVISAN_U"), new Object[0]) + " ";
                    for (Rezervacija r : rezervacije) {
                        if (r.getDatum().get(12) == 0) {
                            rez = rez + r.getDatum().get(11) + ":" + r.getDatum().get(12) + "0 ";
                            continue;
                        }
                        rez = rez + r.getDatum().get(11) + ":" + r.getDatum().get(12) + " ";
                    }
                    Konstante.getPoruka(parent.getControl().getShell(), rez);
                    parent.getControl().getShell().close();
                    return;
                }
                if (this.komitent.getSelectionIndex() != 0) {
                    o.setIme(this.komitent.getText());
                } else {
                    o.setIme(this.ime.getResult());
                }
                o.setTel(this.tel.getResult());
                o.setEmail(this.email.getResult());
                o.setDatum(izabran);
                o.setVreme(izabran);
                o.setBrStola(this.brStola.getResult());
                if (this.brOsoba.getResult() != null) {
                    o.setBrOsoba(this.brOsoba.getResult());
                } else {
                    o.setBrOsoba(-1);
                }
                o.setNapomena(this.napomena.getResult());
                this.result = o;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public Rezervacija getResult() {
            return this.result;
        }

        private void loadData() {
            Calendar c = this.input.getDatum();
            Date d = c.getTime();
            this.ime.setResult(this.input.getIme());
            this.tel.setResult(this.input.getTel());
            this.email.setResult(this.input.getEmail());
            try {
                this.datum.setResult(d);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.sat.select(c.get(11));
            this.minut.select(c.get(12) / 15);
            this.brStola.setResult(this.input.getBrStola());
            if (this.input.getBrOsoba() != -1) {
                this.brOsoba.setResult(this.input.getBrOsoba());
            }
            this.napomena.setResult(this.input.getNapomena());
        }

        private void createTable() {
            Connection conn = this.restoran.getServer().getConnection();
            String create = "CREATE TABLE IF NOT EXISTS `rezervacijekomitent` (`id` BIGINT(20) NOT NULL AUTO_INCREMENT,`ime` VARCHAR(256) NOT NULL DEFAULT '0',`telefon` VARCHAR(15) NULL DEFAULT '0',`email` VARCHAR(50) NULL DEFAULT '0',`STALNIGOST_ID` BIGINT(20) NULL DEFAULT '0',`selected` BIT(1) NULL DEFAULT NULL,PRIMARY KEY (`id`),INDEX `STALNIGOST_ID` (`STALNIGOST_ID`))COLLATE='utf8_general_ci' ENGINE=InnoDB AUTO_INCREMENT=28;";
            try {
                Statement st = conn.createStatement();
                st.executeUpdate(create);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

