/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Popis;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.IzracunajDnevniPromet;
import com.dev63.restoran.sistem.RekonstrukcijaKartica;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RekonstrukcijaSaPrikazom {
    private Shell shell;
    private RestoranServer server;
    private Date d2;
    private Date d1;
    private Restoran restoran;

    public RekonstrukcijaSaPrikazom(Restoran restoran, RestoranServer server, Date date, boolean medjuzbir) {
        this.shell = null;
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.d2 = date;
        this.d1 = date;
    }

    public RekonstrukcijaSaPrikazom(Shell parent, Restoran restoran, Date dateStart, Date dateEnd) {
        this.shell = parent;
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.d2 = dateEnd;
        this.d1 = dateStart;
    }

    public RekonstrukcijaSaPrikazom(Shell parent, Restoran restoran, Date date) {
        this.shell = parent;
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.d2 = date;
        this.d1 = date;
    }

    public void rekonstruisi() {
        this.reconstruct();
    }

    public void reconstruct() {
        try {
            Shell poruka1 = null;
            if (this.shell != null && !this.shell.isDisposed()) {
                poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija za\n" + Konstante.getDate(this.d2));
            }
            this.server.log(Konstante.getBundle().getString("LOG_REKONSTRUKCIJA"));
            System.gc();
            this.server.deleteKarticaJPA(Konstante.getPocetniDatum(this.d2, this.server), Konstante.getKrajnjiDatum(this.d2, this.server));
            this.server.deleteDnevnoStanje(this.d2);
            this.server.refresh();
            this.server.getBase().clear();
            this.fixPopisOnFirstDate(this.d2);
            boolean isDanasnji = Konstante.getOnlyDate(this.d2).compareTo(Konstante.getOnlyDate(new Date())) == 0;
            RekonstrukcijaKartica rk = new RekonstrukcijaKartica(this.restoran, this.d2, true, true, isDanasnji, null);
            this.server.refresh();
            System.gc();
            IzracunajDnevniPromet dp = new IzracunajDnevniPromet(this.d2, null, this.restoran.getServer());
            dp.createDnevnaStanja();
            this.server.addDnevnaStanja(dp.getDnevnaStanja());
            this.fixPopis(this.d1, Konstante.dateAfter(this.d2));
            if (poruka1 != null) {
                poruka1.close();
            }
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)ex.getMessage(), "Greska", 2);
        }
    }

    private void fixPopisOnFirstDate(Date datum) {
        Date zaFix = datum;
        List<Popis> popisiZaPocetni = this.server.readPopisClassic(zaFix);
        if (popisiZaPocetni.isEmpty()) {
            return;
        }
        this.server.deleteDnevnoStanje(Konstante.dateBefore(zaFix));
        for (Popis popis : popisiZaPocetni) {
            if (!popis.getSravnjenje().booleanValue()) continue;
            this.server.deleteKarticuPopisa(Konstante.getDatumKartica(Konstante.dateBefore(zaFix), this.server, 50), popis.getOdeljenje(), popis.getCrno());
        }
        IzracunajDnevniPromet dp = new IzracunajDnevniPromet(Konstante.dateBefore(zaFix), null, this.restoran.getServer());
        dp.createDnevnaStanja();
        this.server.addDnevnaStanja(dp.getDnevnaStanja());
        for (Popis popis : popisiZaPocetni) {
            if (!popis.getSravnjenje().booleanValue()) continue;
            popis = (Popis)this.server.getBase().find(Popis.class, (Object)popis.getId());
        }
    }

    private void fixPopis(Date dateStart, Date dateEnd) throws InputException {
        Date pocetni;
        Date date = pocetni = dateStart != null ? dateStart : new Date(0L);
        if (Konstante.getOnlyDate(dateEnd).equals(Konstante.getOnlyDate(pocetni))) {
            this.fixPopisOnFirstDate(pocetni);
        } else {
            List<Popis> popisi = this.server.readPopis(dateEnd);
            if (popisi.isEmpty()) {
                return;
            }
            for (Popis popis : popisi) {
                if (!popis.getSravnjenje().booleanValue()) continue;
            }
        }
    }
}

