/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.Utrosci;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.frontoffice.GrafikSalePrikazBela;
import com.dev63.restoran.lang.LangUtil;
import com.dev63.restoran.logs.ButtonLogger;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.sistem.Faktura;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.KombinovanoPlacanjeBela;
import com.dev63.restoran.sistem.Rastavljanje3;
import com.dev63.restoran.sistem.parts.rastavljanje.SplittingTableModel;
import com.dev63.restoran.stampa.FiskalniRacun;
import com.dev63.restoran.stampa.KopijaRacuna;
import com.dev63.restoran.swt.components.GuestCounting;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.extensions.contentproviders.LeftTableSplitContentProvider;
import com.dev63.restoran.swt.extensions.contentproviders.RightTableSplitContentProvider;
import com.dev63.restoran.swt.extensions.contentproviders.TableSplitListViewContentProvider;
import com.dev63.restoran.swt.extensions.labelproviders.LeftTableSplitListViewLabelProvider;
import com.dev63.restoran.swt.extensions.labelproviders.RightTableSplitListViewLabelProvider;
import com.dev63.restoran.swt.extensions.listeners.FunctionalListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Rastavljanje3Bela {
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private String broj = "";
    private Display display;
    private Shell shell;
    private Restoran restoran;
    private RestoranServer server;
    private Sto sto;
    private boolean menadzer;
    private SplittingTableModel model;
    private org.eclipse.swt.widgets.List listaLevo;
    private Composite menu;
    private org.eclipse.swt.widgets.List listaDesno;
    private Double kolicina;
    private Image bgImg;
    private Color fgColor;
    private Font bFont;
    private ListViewer leftLV;
    private ListViewer rightLV;
    Rectangle bounds;
    boolean guestCounting = false;
    String brStola = null;
    private ImageButton bPrebaci;
    private Konobar konobar;
    public boolean sefKonobarPotvrda;
    private Konobar odabraniKonobar = null;
    ButtonLogger buttonLogger;

    public Rastavljanje3Bela(Shell parent, Restoran restoran, Sto s, Konobar konobar, ButtonLogger buttonLogger) {
        this.display = parent.getDisplay();
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.sto = this.server.getSto(s.getBroj());
        this.menadzer = this.server.getSetting(Option.SIFRA_SASTAVLANJE_STOLOVA).booleanValue();
        this.konobar = konobar;
        this.buttonLogger = buttonLogger;
        this.guestCounting = BMTerminalSettings.getSetting(OptionBO.BROJANJE_GOSTIJU).booleanValue();
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        this.broj = "1";
        this.kolicina = Double.valueOf(this.broj);
        this.fgColor = this.display.getSystemColor(4);
        this.bFont = FontCache.getFont("Arial", (int)((double)this.bounds.height / 67.5), 1);
        SplittingTableModel.Builder modelBuilder = SplittingTableModel.builder().table(s).nextOrderNumber(this.server.sledeciBrojTure());
        this.brStola = String.valueOf(this.sto.getBroj());
        for (Tura t : this.server.getTureRastavljanje(this.sto.getBroj())) {
            this.server.getBase().refresh((Object)t);
            if (t.getRacun() != null) continue;
            try {
                if (t.getStavke().isEmpty()) {
                    modelBuilder.addOrder(t, this.server.readNenaplaceneStavkeRacuna(t));
                    continue;
                }
                modelBuilder.addOrder(t, t.getStavke());
            }
            catch (Exception e2) {
                modelBuilder.addOrder(t, this.server.readNenaplaceneStavkeRacuna(t));
            }
        }
        this.model = modelBuilder.build();
        this.shell = new Shell(parent, 32776);
        this.shell.setBackgroundMode(2);
        this.shell.setText(LangUtil.getLocalString("TEXT_RASTAVLJANJE", new Object[0]));
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setMaximized(true);
        GridData data2 = new GridData(4, 4, false, true);
        data2.widthHint = (int)((double)this.bounds.width / 11.16);
        Font font = FontCache.getFont("Arial", 16, 0);
        Composite levo = new Composite((Composite)this.shell, 0);
        levo.setLayout((Layout)new GridLayout());
        levo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listaLevo = new org.eclipse.swt.widgets.List(levo, 2560);
        this.listaLevo.setFont(font);
        this.leftLV = new ListViewer(this.listaLevo);
        this.menu = new Composite((Composite)this.shell, 0);
        this.menu.setLayoutData((Object)data2);
        this.menu.setLayout((Layout)new GridLayout());
        Composite desno = new Composite((Composite)this.shell, 0);
        desno.setLayout((Layout)new GridLayout());
        desno.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listaDesno = new org.eclipse.swt.widgets.List(desno, 2560);
        this.listaDesno.setFont(font);
        this.rightLV = new ListViewer(this.listaDesno);
        GridData data = new GridData(4, 4, true, true);
        this.listaLevo.setLayoutData((Object)data);
        this.listaDesno.setLayoutData((Object)data);
        this.load();
        this.leftLV.addSelectionChangedListener(e -> {
            if (this.bPrebaci == null) {
                return;
            }
            boolean previousState = this.bPrebaci.getEnabled();
            boolean newState = true;
            ISelection selection = e.getSelection();
            if (selection instanceof IStructuredSelection) {
                StavkaRacuna item;
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object selectedElement = null;
                selectedElement = structuredSelection.getFirstElement();
                if (selectedElement instanceof StavkaRacuna && (item = (StavkaRacuna)selectedElement).getGlavnaStavka() != null) {
                    newState = false;
                }
            }
            if (previousState != newState) {
                this.bPrebaci.setEnabled(newState);
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void reload() {
        this.leftLV.refresh();
        this.rightLV.refresh();
        this.kolicina = 1.0;
    }

    private void load() {
        this.napraviListuLevo();
        this.napraviToolBar();
        this.napraviListuDesno();
    }

    private void prebaciSve() {
        this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme:ceo sto (prebaceno sve na desnu stranu) ");
        this.model.moveAllRight();
        this.reload();
    }

    private void vratiSve() {
        this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: vrati sve (vraceno sve na levu stranu) ");
        this.model.moveAllLeft();
        this.reload();
    }

    private void prebaci() {
        IStructuredSelection iSel = (IStructuredSelection)this.leftLV.getSelection();
        Object o = iSel.getFirstElement();
        this.model.moveRight(o, this.kolicina);
        this.reload();
        this.leftLV.setSelection(new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        });
    }

    private void vrati() {
        double kol = 0.0;
    }

    private void napraviListuLevo() {
        this.leftLV.setContentProvider((IContentProvider)new LeftTableSplitContentProvider());
        this.leftLV.setLabelProvider((IBaseLabelProvider)new LeftTableSplitListViewLabelProvider());
        this.leftLV.setInput(this.model.getOrdersLeft());
        this.leftLV.refresh();
    }

    void napraviListuDesno() {
        this.rightLV.setContentProvider((IContentProvider)new RightTableSplitContentProvider());
        this.rightLV.setLabelProvider((IBaseLabelProvider)new RightTableSplitListViewLabelProvider());
        this.rightLV.setInput(this.model.getOrdersRight());
        this.rightLV.refresh();
    }

    private void napraviToolBar() {
        this.shell.setBackgroundMode(1);
        GridData data = new GridData(64);
        data.widthHint = this.bounds.width / 16;
        data.heightHint = (int)((double)this.bounds.height / 13.5);
        data.verticalIndent = 5;
        GridData data2 = new GridData();
        data2.widthHint = (int)((double)this.bounds.width / 11.7);
        data2.heightHint = (int)((double)this.bounds.height / 13.5);
        data2.verticalIndent = 5;
        Label lSto = new Label(this.menu, 0x1000040);
        lSto.setText(LangUtil.getLocalString("TEXT_STO_BROJ", new Object[0]).concat(" ").concat(String.valueOf(this.sto.getBroj())));
        lSto.setFont(this.listaLevo.getFont());
        lSto.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.bPrebaci = new ImageButton(this.menu, 131076);
        this.bPrebaci.setBackgroundImage(this.bgImg);
        this.bPrebaci.setForeground(this.fgColor);
        this.bPrebaci.setPadding(8);
        this.bPrebaci.setFont(this.bFont);
        this.bPrebaci.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: strelica na desno (stavka na desnu stranu)");
            this.prebaci();
        });
        this.bPrebaci.setLayoutData(data2);
        ImageButton bSto = new ImageButton(this.menu, 0);
        bSto.setBackgroundImage(this.bgImg);
        bSto.setForeground(this.fgColor);
        bSto.setFont(this.bFont);
        bSto.setText(LangUtil.getLocalString("TEXT_CEO_STO", new Object[0]));
        bSto.setLayoutData(data2);
        bSto.addSelectionListener(e -> this.prebaciSve());
        ImageButton bVratiNazad = new ImageButton(this.menu, 0);
        bVratiNazad.setBackgroundImage(this.bgImg);
        bVratiNazad.setForeground(this.fgColor);
        bVratiNazad.setFont(this.bFont);
        bVratiNazad.setText(LangUtil.getLocalString("TEXT_VRATI_SVE", new Object[0]));
        bVratiNazad.setLayoutData(data2);
        bVratiNazad.addSelectionListener(e -> this.vratiSve());
        ImageButton item3 = new ImageButton(this.menu, 8);
        item3.setBackgroundImage(this.bgImg);
        item3.setForeground(this.fgColor);
        item3.setFont(this.bFont);
        item3.setText(LangUtil.getLocalString("TEXT_PREBACI_NA_STO", new Object[0]));
        item3.setLayoutData(data2);
        item3.addSelectionListener(e -> {
            int size;
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: prebaci na sto (otvara se meni za prebacivanje) ");
            if (!this.model.getOrdersRight().isEmpty() && (size = this.model.getOrdersRight().values().stream().mapToInt(i -> i.size()).sum()) > 0) {
                this.naSto();
            }
        });
        ImageButton item4 = new ImageButton(this.menu, 8);
        item4.setBackgroundImage(this.bgImg);
        item4.setForeground(this.fgColor);
        item4.setFont(this.bFont);
        item4.setText(LangUtil.getLocalString("TEXT_KOMBINOVANO_PLACANJE", new Object[0]));
        item4.setLayoutData(data2);
        item4.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: kombinovano placanje (otvara se meni za kombinovano placanje) ");
            if (!this.model.getOrdersRight().isEmpty()) {
                KombinovanoPlacanjeBela kp = new KombinovanoPlacanjeBela(this.shell, this.restoran, this.getSumaDesno());
                List<Placanje> placanja = kp.getPlacanja();
                if (placanja == null) {
                    return;
                }
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, "Broj placanja iz rastavljanja : " + placanja.size());
                this.makeRacun(placanja, null);
            }
        });
        ImageButton item6 = new ImageButton(this.menu, 8);
        item6.setBackgroundImage(this.bgImg);
        item6.setForeground(this.fgColor);
        item6.setFont(this.bFont);
        item6.setText(LangUtil.getLocalString("TEXT_GOTOVINA", new Object[0]));
        item6.setLayoutData(data2);
        item6.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: gotovina (precica za gotovinu iz rastavljsnja) ");
            if (!this.model.getOrdersRight().isEmpty()) {
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje placanje = new Placanje();
                placanje.setNacin(NacinPlacanja.GOTOVINA);
                placanje.setIznos(this.getSumaDesno());
                placanja.add(placanje);
                this.makeRacun(placanja, null);
            }
        });
        ImageButton item7 = new ImageButton(this.menu, 8);
        item7.setBackgroundImage(this.bgImg);
        item7.setForeground(this.fgColor);
        item7.setFont(this.bFont);
        item7.setText(LangUtil.getLocalString("TEXT_SVI_NACINI", new Object[0]));
        item7.setLayoutData(data2);
        item7.addSelectionListener(e -> this.napraviOdabirPlacanja());
        ImageButton item5 = new ImageButton(this.menu, 8);
        item5.setBackgroundImage(this.bgImg);
        item5.setForeground(this.fgColor);
        item5.setFont(this.bFont);
        item5.setText(LangUtil.getLocalString("TEXT_IZLAZ", new Object[0]));
        item5.setLayoutData(data2);
        item5.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Izlaz (rastavljanje-sastavljanje) ");
            for (Map.Entry<Tura, Set<StavkaRacuna>> entry : this.model.getInitialOrders().entrySet()) {
                Tura tura = entry.getKey();
                this.server.getBase().refresh((Object)tura);
                Set<StavkaRacuna> list = entry.getValue();
                for (StavkaRacuna sr : list) {
                    this.server.getBase().refresh((Object)sr);
                }
            }
            this.shell.close();
        });
    }

    protected double getSumaDesno() {
        return Optional.ofNullable(this.rightLV).map(lv -> lv.getContentProvider()).filter(cp -> cp instanceof TableSplitListViewContentProvider).map(cp -> ((TableSplitListViewContentProvider)cp).getSum()).orElse(0.0);
    }

    private void napraviOdabirPlacanja() {
        this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: ostali nacini (otvara se meni za sva placanja) ");
        Shell popUpShell = Konstante.makeShell(new Shell(this.shell, 32768), "Odabir placanja");
        popUpShell.setBackgroundMode(1);
        popUpShell.setText("Odabir placanja");
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        popUpShell.setLayout((Layout)layout);
        HashMap<CrnoPlacanje, ImageButton> buttonsCrna = new HashMap<CrnoPlacanje, ImageButton>();
        GridData dataForBela = new GridData();
        dataForBela.horizontalAlignment = 16384;
        dataForBela.widthHint = 120;
        dataForBela.heightHint = 80;
        ImageButton gotovinaButton = new ImageButton((Composite)popUpShell, 8);
        gotovinaButton.setBackgroundImage(this.bgImg);
        gotovinaButton.setForeground(this.fgColor);
        gotovinaButton.setFont(this.bFont);
        gotovinaButton.setText(LangUtil.getLocalString("TEXT_GOTOVINA", new Object[0]));
        gotovinaButton.setLayoutData(dataForBela);
        gotovinaButton.addSelectionListener(e -> {
            if (!this.model.getOrdersRight().isEmpty()) {
                this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Gotovina (rastavljanje-sastavljanje svi nacini placanja) ");
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje placanje = new Placanje();
                placanje.setNacin(NacinPlacanja.GOTOVINA);
                placanje.setIznos(this.getSumaDesno());
                placanje.setVreme(new Date());
                placanja.add(placanje);
                popUpShell.close();
                this.makeRacun(placanja, null);
            }
        });
        ImageButton fakturaButton = new ImageButton((Composite)popUpShell, 8);
        fakturaButton.setBackgroundImage(this.bgImg);
        fakturaButton.setForeground(this.fgColor);
        fakturaButton.setFont(this.bFont);
        fakturaButton.setText(LangUtil.getLocalString("TEXT_FAKTURA", new Object[0]));
        fakturaButton.setLayoutData(dataForBela);
        fakturaButton.setEnabled(false);
        fakturaButton.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Faktura (rastavljanje-sastavljanje svi nacini placanja) ");
            if (!this.model.getOrdersRight().isEmpty()) {
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje placanje = new Placanje();
                placanje.setNacin(NacinPlacanja.FAKTURA);
                placanje.setIznos(this.getSumaDesno());
                placanje.setVreme(new Date());
                placanja.add(placanje);
                popUpShell.close();
                this.makeRacun(placanja, null);
            }
        });
        ImageButton cekButton = new ImageButton((Composite)popUpShell, 8);
        cekButton.setBackgroundImage(this.bgImg);
        cekButton.setForeground(this.fgColor);
        cekButton.setFont(this.bFont);
        cekButton.setText(LangUtil.getLocalString("TEXT_CEK", new Object[0]));
        cekButton.setLayoutData(dataForBela);
        cekButton.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Cek (rastavljanje-sastavljanje svi nacini placanja) ");
            if (!this.model.getOrdersRight().isEmpty()) {
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje placanje = new Placanje();
                placanje.setNacin(NacinPlacanja.CEK);
                placanje.setIznos(this.getSumaDesno());
                placanje.setVreme(new Date());
                placanja.add(placanje);
                popUpShell.close();
                this.makeRacun(placanja, null);
            }
        });
        ImageButton karticaButton = new ImageButton((Composite)popUpShell, 8);
        karticaButton.setBackgroundImage(this.bgImg);
        karticaButton.setForeground(this.fgColor);
        karticaButton.setFont(this.bFont);
        karticaButton.setText(LangUtil.getLocalString("TEXT_KARTICA", new Object[0]));
        karticaButton.setLayoutData(dataForBela);
        karticaButton.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Kartica (rastavljanje-sastavljanje svi nacini placanja) ");
            if (!this.model.getOrdersRight().isEmpty()) {
                ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                Placanje placanje = new Placanje();
                placanje.setNacin(NacinPlacanja.KARTICA);
                placanje.setIznos(this.getSumaDesno());
                placanje.setVreme(new Date());
                placanja.add(placanje);
                popUpShell.close();
                this.makeRacun(placanja, null);
            }
        });
        GridData dataForCrna = new GridData();
        dataForCrna.horizontalAlignment = 16384;
        dataForCrna.widthHint = 120;
        dataForCrna.heightHint = 75;
        for (CrnoPlacanje cp : this.server.readSvaCrnaPlacanja()) {
            if (cp.getNaziv().equalsIgnoreCase("medjuzbir") || cp.getNaziv().equalsIgnoreCase("HOTELSKI GOST") || !cp.getPrikazEkran().booleanValue()) continue;
            ImageButton button = new ImageButton((Composite)popUpShell, 8);
            if (cp.getSlika() == null) {
                button.setBackgroundImage(this.bgImg);
                button.setForeground(this.fgColor);
                button.setFont(this.bFont);
                button.setText(cp.getNaziv());
            } else {
                final Image[] img = new Image[1];
                try {
                    img[0] = new Image((Device)this.display, cp.getSlika());
                    button.setBackgroundImage(img[0]);
                    button.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent de) {
                            if (img[0] != null && !img[0].isDisposed()) {
                                img[0].dispose();
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    button.setBackgroundImage(this.bgImg);
                    button.setForeground(this.fgColor);
                    button.setFont(this.bFont);
                    button.setText(cp.getNaziv());
                }
            }
            button.setLayoutData(dataForCrna);
            button.addSelectionListener(e -> {
                if (!this.model.getOrdersRight().isEmpty()) {
                    popUpShell.close();
                    this.makeRacun(null, cp);
                }
            });
            buttonsCrna.put(cp, button);
        }
        ImageButton izlaz = new ImageButton((Composite)popUpShell, 8);
        izlaz.setBackgroundImage(this.bgImg);
        izlaz.setForeground(this.fgColor);
        izlaz.setFont(this.bFont);
        izlaz.setText(LangUtil.getLocalString("TEXT_IZLAZ", new Object[0]));
        GridData dataForIzlaz = new GridData();
        dataForIzlaz.horizontalAlignment = 131072;
        dataForIzlaz.horizontalSpan = 4;
        dataForIzlaz.widthHint = 164;
        dataForIzlaz.heightHint = 80;
        izlaz.setLayoutData(dataForIzlaz);
        izlaz.addSelectionListener(e -> {
            this.buttonLogger.info("Konobar: " + this.konobar.getPunoime() + ", sto:" + this.sto.getBroj() + ", pritisnuto dugme: Izlaz (rastavljanje-sastavljanje-svi nacini placanja) ");
            popUpShell.close();
        });
        popUpShell.pack();
        Konstante.centerShellOnDisplay(popUpShell);
        popUpShell.open();
        while (!popUpShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private boolean rastavi(List<Tura> leveTure, List<Tura> desneTure, List<StavkaRacuna> stavkeZaBrisanje) {
        boolean brisiSto = false;
        if (this.model.getOrdersLeft().isEmpty()) {
            brisiSto = true;
        }
        leveTure.addAll(this.model.getOrdersLeft().entrySet().parallelStream().map(e -> {
            Tura order = (Tura)e.getKey();
            order.isPripremljena();
            order.getPocetak();
            order.getKraj();
            order.getStavke().clear();
            order.getStavke().addAll(((Set)e.getValue()).parallelStream().peek(i -> i.setKolicina(i.getKolicinaZaRastavljanjeLevo())).peek(i -> i.getPodStavke().parallelStream().forEach(si -> si.setKolicina(si.getKolicinaZaRastavljanjeLevo()))).flatMap(i -> Stream.concat(Stream.of(i), i.getPodStavke().stream())).collect(Collectors.toList()));
            return order;
        }).collect(Collectors.toList()));
        desneTure.addAll(this.model.getOrdersRight().entrySet().parallelStream().filter(e -> ((Tura)e.getKey()).getId() != null).map(e -> {
            Tura order = (Tura)e.getKey();
            order.setBrojStola(this.sto.getBroj());
            order.setSaStola(this.brStola);
            order.getStavke().clear();
            order.getStavke().addAll(((Set)e.getValue()).parallelStream().peek(i -> i.setBrojStola(this.sto.getBroj())).peek(i -> i.setSaStola(this.brStola)).peek(i -> i.setKolicina(i.getKolicinaZaRastavljanjeDesno())).peek(i -> i.getPodStavke().parallelStream().forEach(si -> si.setKolicina(si.getKolicinaZaRastavljanjeDesno()))).peek(i -> i.getPodStavke().parallelStream().forEach(si -> si.setSaStola(this.brStola))).flatMap(i -> Stream.concat(Stream.of(i), i.getPodStavke().stream())).collect(Collectors.toList()));
            return order;
        }).collect(Collectors.toList()));
        this.model.getOrdersRight().entrySet().parallelStream().filter(e -> ((Tura)e.getKey()).getId() == null).peek(e -> stavkeZaBrisanje.addAll(((Set)e.getValue()).parallelStream().filter(i -> i.getKolicinaZaRastavljanjeLevo() == 0.0).collect(Collectors.toList()))).map(e -> {
            Tura order = (Tura)e.getKey();
            order.setBrojStola(this.sto.getBroj());
            order.setSaStola(this.brStola);
            order.setPocetak(this.model.getOrdersLeft().keySet().iterator().next().getPocetak());
            order.setKraj(this.model.getOrdersLeft().keySet().iterator().next().getKraj());
            order.setPripremljena(this.model.getOrdersLeft().keySet().iterator().next().isPripremljena());
            order.setStavke(SplittingTableModel.groupTakenItemsIntoNewItems((Collection)e.getValue()).stream().flatMap(i -> Stream.concat(Stream.of(i), i.getPodStavke().stream())).collect(Collectors.toList()));
            return (Tura)e.getKey();
        }).findAny().ifPresent(o -> desneTure.add((Tura)o));
        return brisiSto;
    }

    private void prebaciNaSto(Sto sto2) {
        LinkedList<StavkaRacuna> stavkeZaBrisanje = new LinkedList<StavkaRacuna>();
        LinkedList<Tura> tureZaUpdate = new LinkedList<Tura>();
        LinkedList<Tura> tureLevo = new LinkedList<Tura>();
        LinkedList<Tura> tureDesno = new LinkedList<Tura>();
        boolean ceoSto = this.rastavi(tureLevo, tureDesno, stavkeZaBrisanje);
        if (tureLevo.isEmpty()) {
            tureDesno.parallelStream().peek(o -> o.setBrojStola(sto2.getBroj())).flatMap(o -> o.getStavke().parallelStream()).forEach(i -> i.setBrojStola(sto2.getBroj()));
        } else {
            tureDesno.parallelStream().peek(o -> o.setBrojStola(sto2.getBroj())).peek(o -> o.setPripremljena(((Tura)tureLevo.stream().findFirst().get()).isPripremljena())).peek(o -> o.setPocetak(((Tura)tureLevo.stream().findFirst().get()).getPocetak())).peek(o -> o.setKraj(((Tura)tureLevo.stream().findFirst().get()).getKraj())).peek(o -> o.setSaStola(this.brStola)).flatMap(o -> o.getStavke().parallelStream()).forEach(i -> i.setBrojStola(sto2.getBroj()));
        }
        tureZaUpdate.addAll(tureLevo);
        tureZaUpdate.addAll(tureDesno);
        try {
            this.server.updateTuraRastavljanje(tureZaUpdate, stavkeZaBrisanje, ceoSto && this.sto.getBroj().compareTo(sto2.getBroj()) != 0 ? this.sto : null);
            Optional<Tura> newOrder = tureDesno.stream().filter(t -> t.getId() == null).findFirst();
            if (newOrder.isPresent()) {
                this.server.incrementBrojTure(Integer.toString(newOrder.get().getBrojTure() + 1));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void makeRacun(List<Placanje> placanja, CrnoPlacanje cp) {
        boolean faktura;
        GuestCounting gc;
        placanja = Optional.ofNullable(placanja).orElseGet(LinkedList::new);
        String brojGostiju = null;
        StalniGost sg = null;
        String naziv = "";
        String adresa = "";
        String pib = "";
        Double popust = null;
        if (this.guestCounting && (brojGostiju = (gc = new GuestCounting()).vratiBrojGostiju()) == null) {
            return;
        }
        boolean crno = cp != null;
        boolean bl = faktura = crno ? false : placanja.parallelStream().anyMatch(p -> NacinPlacanja.FAKTURA.equals((Object)p.getNacin()));
        if (faktura && placanja.size() != 1) {
            Konstante.getPoruka(this.shell, LangUtil.getLocalString("PORUKA_FAKTURA_SE_NE_MOZE_KOMBINOVATI", new Object[0]));
            return;
        }
        Racun racun = new Racun();
        racun.setStorniran(false);
        if (!this.konobar.getNivo().equals("SEF")) {
            racun.setKonobar(this.server.konobarZaSto(this.sto.getBroj()));
        } else if (this.konobar.getNaplata().booleanValue()) {
            racun.setKonobar(this.konobar);
        } else {
            racun.setKonobar(this.server.konobarZaSto(this.sto.getBroj()));
        }
        racun.setDatum(new Date());
        racun.setPopust(0.0);
        racun.setFiskalniOdstampan(false);
        racun.setBrojStola(this.sto.getBroj());
        racun.setZatvoren(Boolean.TRUE);
        racun.setKasa(this.server.getCurrentCounter());
        racun.setBrojGostiju(brojGostiju);
        racun.setBrojRacuna(crno ? this.server.nextNonFiscalBillNumber() : this.server.nextFiscalBillNumber());
        racun.setZdBroj(this.server.getLastOpenZD().getZdBroj());
        if (faktura) {
            Faktura f = new Faktura(null, new Shell(this.shell, 65536), this.server);
            if (f.getOtkazi()) {
                return;
            }
            sg = f.getStalniGost();
            naziv = f.getNaziv();
            adresa = f.getAdresa();
            pib = f.getPib();
            popust = f.getPopust();
            int vp = f.getValuta();
            racun.setBrojFakture(this.server.sledeciBrojFakture());
            racun.setPopust(Double.valueOf(Math.round(popust * 100.0)));
            racun.setStalniGost(sg);
        }
        if (!crno) {
            racun.setPlacanja(placanja);
        } else {
            racun.setCrnoPlacanje(cp.getNaziv());
        }
        racun.setTure(new LinkedList<Tura>());
        LinkedList<Tura> tureLevo = new LinkedList<Tura>();
        LinkedList<Tura> tureDesno = new LinkedList<Tura>();
        LinkedList<StavkaRacuna> stavkeZaBrisanje = new LinkedList<StavkaRacuna>();
        boolean ceoSto = this.rastavi(tureLevo, tureDesno, stavkeZaBrisanje);
        Optional<Tura> newOrder = tureDesno.stream().filter(t -> t.getId() == null).findFirst();
        racun.setZdBroj(this.server.getLastOpenZD().getZdBroj());
        racun.setStavke1(((Tura)tureDesno.get(0)).getStavke());
        racun.setStavke1(new LinkedList<StavkaRacuna>());
        try {
            racun = this.server.makeRacunUpdateTureRastavljanje(racun, tureLevo, tureDesno, stavkeZaBrisanje, ceoSto ? this.sto : null);
            if (newOrder.isPresent()) {
                this.server.incrementBrojTure(Integer.toString(newOrder.get().getBrojTure() + 1));
            }
            if (!Utrosci.upisDnevnogUtroska(racun, this.server)) {
                this.server.log("racun.getId() " + racun.getId());
                SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli dnevniutrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                return;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(ex.getMessage());
            mb.open();
            return;
        }
        Racun rCopy = (Racun)SerializationUtils.clone((Serializable)racun);
        System.out.println("rCopy.getStavke1().size() = " + rCopy.getStavke1().size());
        if (!crno) {
            try {
                new FiskalniRacun(this.restoran).printFiscal(rCopy, rCopy.getKonobar().getSkrIme());
            }
            catch (MenuVATGroupUndefinedException ex) {
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FiscalException ex) {
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SQLException ex) {
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SerialIOException ex) {
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception e) {
                rCopy.setFiskalniOdstampan(false);
            }
        } else {
            try {
                new KopijaRacuna(this.server, rCopy);
            }
            catch (MenuVATGroupUndefinedException ex) {
                Logger.getLogger(Rastavljanje3.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (faktura) {
            int brojKopija = this.server.getSetting(Option.BROJ_KOPIJA_FAKTURE).intValue();
            new FakturaRacun(this.display, this.restoran, rCopy, this.restoran.getStope(), brojKopija, "", false, null);
        }
        this.shell.close();
    }

    public void naSto() {
        OdabirStola os = new OdabirStola(this.shell, this.server);
        if (os.getOutSto() == null) {
            return;
        }
        if (os.getOutSto().getBlokiran().booleanValue()) {
            SWTMessage.showLocalizedMessageDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_IZABRANI_STO_JE_BLOKIRAN"), new Object[0]));
            this.shell.close();
            return;
        }
        if (os.getOutSto().getId() == null) {
            this.server.addStoQuery(os.getOutSto());
        }
        this.prebaciNaSto(os.getOutSto());
        this.shell.close();
    }

    private class OdabirStola {
        private RestoranServer server;
        private Image numBack;
        private Image backImg;
        private Font buttFont;
        private Font numFont;
        private Color buttCol;
        private Color textCol;
        private Display display;
        private Text text;
        private Text text2;
        private Map<Integer, String> naziviStolova;
        private Sto outSto = null;
        protected boolean zatvori = false;

        public OdabirStola(Shell parent, RestoranServer serverica) {
            this.server = serverica;
            this.display = parent.getDisplay();
            this.naziviStolova = this.server.getNaziviStolova();
            Shell shell = new Shell(parent, 32776);
            shell.setBackgroundMode(2);
            shell.setMaximized(true);
            Color bgColor = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getBackgroundColor());
            shell.addDisposeListener(e -> bgColor.dispose());
            shell.setLayout((Layout)new GridLayout());
            shell.setBackground(bgColor);
            Composite numerickaContainer = new Composite((Composite)shell, 0);
            numerickaContainer.setLayout((Layout)new GridLayout(2, false));
            numerickaContainer.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
            this.numFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getNumButtonFont());
            this.buttCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getButtonFontColor());
            shell.addDisposeListener(e -> this.buttCol.dispose());
            this.textCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getTextFontColor());
            shell.addDisposeListener(e -> this.textCol.dispose());
            Composite numerickaParent = new Composite(numerickaContainer, 2048);
            numerickaParent.setLayout((Layout)new GridLayout(2, false));
            numerickaParent.setLayoutData((Object)new GridData(131072, 128, true, true));
            GridData data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            GridData data2 = new GridData();
            data2.widthHint = 150;
            data2.heightHint = 30;
            Label label = new Label(numerickaParent, 0);
            label.setText(LangUtil.getLocalString("TEXT_PREBACIVANJE_NA_STO", new Object[0]).concat(": "));
            label.setLayoutData((Object)data);
            this.text = new Text(numerickaParent, 2048);
            this.text.setLayoutData((Object)data);
            Label label2 = new Label(numerickaParent, 0);
            label2.setText(LangUtil.getLocalString("TEXT_SIFRA_KONOBARA", new Object[0]).concat(": "));
            label2.setLayoutData((Object)data);
            this.text2 = new Text(numerickaParent, 0x400800);
            this.text2.setLayoutData((Object)data);
            this.text2.addListener(1, event -> {
                if (event.keyCode == 0x1000050 || event.keyCode == 13) {
                    this.server.log("Log za rastavljanje/sastavljanje: sa stola " + Rastavljanje3Bela.this.sto.getBroj() + " na sto " + this.text.getText() + ", Konobar: " + this.text2.getText() + "");
                    this.onPotvrda(shell);
                }
            });
            Composite numericka = new Composite(numerickaContainer, 2048);
            numericka.setLayout((Layout)new GridLayout(4, false));
            numericka.setBackgroundMode(1);
            numericka.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
            GridData gridData = new GridData();
            gridData.heightHint = 80;
            gridData.widthHint = 80;
            GridData gridData2 = new GridData();
            gridData2.widthHint = 164;
            gridData2.heightHint = 80;
            gridData2.horizontalAlignment = 0x1000000;
            GridData gridData3 = new GridData();
            gridData3.heightHint = 80;
            gridData3.widthHint = 80;
            gridData3.horizontalSpan = 2;
            ImageButton b07 = this.createNumButton(numericka, 524288, gridData, "7");
            ImageButton b08 = this.createNumButton(numericka, 524288, gridData, "8");
            ImageButton b09 = this.createNumButton(numericka, 524288, gridData, "9");
            ImageButton otkazi = this.createButton(numericka, 0, gridData2, LangUtil.getLocalString("TEXT_OTKAZI", new Object[0]), e -> {
                Rastavljanje3Bela.this.buttonLogger.info("Konobar: " + Rastavljanje3Bela.this.konobar.getPunoime() + ", sto:" + Rastavljanje3Bela.this.sto.getBroj() + " na sto:" + this.text.getText() + " na konobara sa sifrom:" + this.text2.getText() + ", pritisnuto dugme: otkazi (ekran zavrsni za rastavljanje-sastavljanja-) ");
                shell.close();
            });
            ImageButton b04 = this.createNumButton(numericka, 524288, gridData, "4");
            ImageButton b05 = this.createNumButton(numericka, 524288, gridData, "5");
            ImageButton b06 = this.createNumButton(numericka, 524288, gridData, "6");
            ImageButton grafik = this.createButton(numericka, 0, gridData2, LangUtil.getLocalString("TEXT_GRAFIK_SALE", new Object[0]), e -> {
                Rastavljanje3Bela.this.buttonLogger.info("Konobar: " + Rastavljanje3Bela.this.konobar.getPunoime() + ", sto:" + Rastavljanje3Bela.this.sto.getBroj() + " na sto:" + this.text.getText() + " na konobara sa sifrom:" + this.text2.getText() + ", pritisnuto dugme: Grafik sale (ekran zavrsni za rastavljanje-sastavljanja-) ");
                GrafikSalePrikazBela gsp = new GrafikSalePrikazBela(shell, this.server, this.naziviStolova, Rastavljanje3Bela.this.sto.getKonobar(), this.server.getGrafikeJPA());
                if (gsp.getBrojStola() != null) {
                    this.text.setText(gsp.getBrojStola().toString());
                    this.text2.setFocus();
                }
            });
            ImageButton b01 = this.createNumButton(numericka, 524288, gridData, "1");
            ImageButton b02 = this.createNumButton(numericka, 524288, gridData, "2");
            ImageButton b03 = this.createNumButton(numericka, 524288, gridData3, "3");
            ImageButton b00 = this.createNumButton(numericka, 524288, gridData, "0");
            ImageButton bDelete = this.createNumButton(numericka, 540676, gridData, "\b");
            bDelete.setPadding(8);
            bDelete.setText("");
            Label l9 = new Label(numericka, 0);
            l9.setLayoutData((Object)gridData);
            ImageButton bConfirm = this.createButton(numericka, 0, gridData2, LangUtil.getLocalString("TEXT_POTVRDI", new Object[0]), e -> {
                Rastavljanje3Bela.this.buttonLogger.info("Konobar: " + Rastavljanje3Bela.this.konobar.getPunoime() + ", sto:" + Rastavljanje3Bela.this.sto.getBroj() + " na sto:" + this.text.getText() + " na konobara sa sifrom:" + this.text2.getText() + ", pritisnuto dugme: Potvrdi (ekran zavrsni za rastavljanje-sastavljanja-) ");
                this.server.log("Log za rastavljanje/sastavljanje: sa stola " + Rastavljanje3Bela.this.sto.getBroj() + " na sto " + this.text.getText() + ", Konobar: " + this.text2.getText() + "");
                this.onPotvrda(shell);
            });
            numericka.pack();
            numerickaParent.pack();
            numerickaContainer.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }

        public void makeKonobari(final Shell shellic) {
            final Shell shellSefKonobari = new Shell(shellic, 32768);
            shellSefKonobari.setLayout((Layout)new GridLayout(1, false));
            shellSefKonobari.setMaximized(false);
            Rectangle bounds = shellSefKonobari.getDisplay().getPrimaryMonitor().getBounds();
            int w = 600;
            int h = 600;
            shellSefKonobari.setSize(w, h);
            shellSefKonobari.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
            Composite allTogether = new Composite((Composite)shellSefKonobari, 0);
            allTogether.setLayout((Layout)new GridLayout(1, true));
            Composite numericka = new Composite(allTogether, 2048);
            numericka.setLayout((Layout)new GridLayout(1, false));
            Group cenovniciDetalji = new Group(numericka, 4);
            cenovniciDetalji.setText("Operateri");
            GridLayout layout = new GridLayout();
            layout.numColumns = 5;
            cenovniciDetalji.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            cenovniciDetalji.setLayoutData((Object)data);
            GridData gridData2 = new GridData();
            gridData2.widthHint = w / 5 - 10;
            gridData2.heightHint = 80;
            for (Konobar konobar : this.server.readSveKonobar()) {
                final Button btnKonobar = new Button((Composite)cenovniciDetalji, 0);
                btnKonobar.setText(konobar.getPunoime() + " (" + konobar.getNivo() + ")");
                btnKonobar.setData((Object)konobar);
                btnKonobar.setForeground(this.buttCol);
                btnKonobar.setBackgroundImage(this.backImg);
                btnKonobar.setLayoutData((Object)gridData2);
                btnKonobar.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        Rastavljanje3Bela.this.odabraniKonobar = (Konobar)btnKonobar.getData();
                        shellic.close();
                    }
                });
            }
            Group izlaz = new Group(numericka, 4);
            izlaz.setText("Operateri");
            layout = new GridLayout();
            layout.numColumns = 5;
            izlaz.setLayout((Layout)layout);
            data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            izlaz.setLayoutData((Object)data);
            gridData2 = new GridData();
            gridData2.widthHint = w / 5 - 10;
            gridData2.heightHint = 80;
            Button btnIzlaz = new Button((Composite)izlaz, 0);
            btnIzlaz.setText("Otka\u017ei");
            btnIzlaz.setFont(this.buttFont);
            btnIzlaz.setForeground(this.buttCol);
            btnIzlaz.setBackgroundImage(this.backImg);
            btnIzlaz.setLayoutData((Object)gridData2);
            btnIzlaz.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdabirStola.this.zatvori = true;
                    shellSefKonobari.close();
                }
            });
            shellSefKonobari.open();
            while (!shellSefKonobari.isDisposed()) {
                if (shellSefKonobari.getDisplay().readAndDispatch()) continue;
                shellSefKonobari.getDisplay().sleep();
            }
        }

        public void makeNumeric(Shell shell) {
            final Shell shellSefKonobar = new Shell(shell, 32768);
            shellSefKonobar.setLayout((Layout)new GridLayout(1, false));
            shellSefKonobar.setMaximized(false);
            Rectangle bounds = shellSefKonobar.getDisplay().getPrimaryMonitor().getBounds();
            int w = 600;
            int h = 600;
            shellSefKonobar.setSize(w, h);
            shellSefKonobar.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
            Composite allTogether = new Composite((Composite)shellSefKonobar, 0);
            allTogether.setLayout((Layout)new GridLayout(1, true));
            Composite numericka = new Composite(allTogether, 2048);
            numericka.setLayout((Layout)new GridLayout(4, false));
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.heightHint = 40;
            gridData.verticalAlignment = 0x1000000;
            Font font = this.buttFont;
            Label naslov = new Label(numericka, 0x1000000);
            naslov.setFont(font);
            naslov.setText("Odaberite konobara na kojeg zelite da zaduzite sto");
            naslov.setLayoutData((Object)gridData);
            GridData gridData2 = new GridData();
            gridData2.widthHint = w / 3 - 20;
            gridData2.heightHint = 80;
            ImageButton sefSto = new ImageButton(numericka, 0);
            sefSto.setText("Sef zaduzuje sto");
            sefSto.setFont(this.buttFont);
            sefSto.setForeground(this.buttCol);
            sefSto.setBackgroundImage(this.backImg);
            sefSto.setLayoutData(gridData2);
            sefSto.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Rastavljanje3Bela.this.sefKonobarPotvrda = true;
                    shellSefKonobar.close();
                }
            });
            ImageButton konobarSto = new ImageButton(numericka, 0);
            konobarSto.setText("Konobar zaduzuje sto");
            konobarSto.setFont(this.buttFont);
            konobarSto.setForeground(this.buttCol);
            konobarSto.setBackgroundImage(this.backImg);
            konobarSto.setLayoutData(gridData2);
            konobarSto.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Rastavljanje3Bela.this.sefKonobarPotvrda = false;
                    shellSefKonobar.close();
                }
            });
            ImageButton konobariSto = new ImageButton(numericka, 0);
            konobariSto.setText("Odaberi konobara");
            konobariSto.setFont(this.buttFont);
            konobariSto.setForeground(this.buttCol);
            konobariSto.setBackgroundImage(this.backImg);
            konobariSto.setLayoutData(gridData2);
            konobariSto.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdabirStola.this.makeKonobari(shellSefKonobar);
                }
            });
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            new Label(numericka, 0);
            gridData2 = new GridData();
            gridData2.widthHint = w / 3 - 20;
            gridData2.heightHint = 80;
            ImageButton izlaz = new ImageButton(numericka, 0);
            izlaz.setText("Otka\u017ei");
            izlaz.setFont(this.buttFont);
            izlaz.setForeground(this.buttCol);
            izlaz.setBackgroundImage(this.backImg);
            izlaz.setLayoutData(gridData2);
            izlaz.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdabirStola.this.zatvori = true;
                    shellSefKonobar.close();
                }
            });
            shellSefKonobar.open();
            while (!shellSefKonobar.isDisposed()) {
                if (shellSefKonobar.getDisplay().readAndDispatch()) continue;
                shellSefKonobar.getDisplay().sleep();
            }
        }

        private ImageButton createButton(Composite parent, int style, GridData layoutData, String title, FunctionalListener selectionListener) {
            ImageButton button = new ImageButton(parent, style);
            button.setBackgroundImage(this.backImg);
            button.setForeground(this.buttCol);
            button.setFont(this.buttFont);
            button.setText(title);
            button.setLayoutData(layoutData);
            button.addListener(13, selectionListener);
            return button;
        }

        private ImageButton createNumButton(Composite parent, int style, Object layoutData, String title) {
            ImageButton numButton = new ImageButton(parent, style);
            numButton.setBackgroundImage(this.numBack);
            numButton.setForeground(this.buttCol);
            numButton.setFont(this.numFont);
            numButton.setText(title);
            numButton.setLayoutData(layoutData);
            this.addListenerNumeric(title, (Control)numButton);
            return numButton;
        }

        private void addListenerNumeric(String s, Control b) {
            b.addListener(13, e -> {
                Event event = new Event();
                event.character = s.charAt(0);
                event.type = 1;
                Display.getCurrent().post(event);
                event = new Event();
                event.character = s.charAt(0);
                event.type = 2;
                Display.getCurrent().post(event);
            });
        }

        private void onPotvrda(Shell numericka2) {
            if (!this.text.getText().isEmpty()) {
                int br;
                try {
                    br = Integer.valueOf(this.text.getText());
                    if (this.text2.getText().isEmpty()) {
                        this.text2.setFocus();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Konstante.getPoruka(numericka2, "Pogresan unos!");
                    this.text.setFocus();
                    return;
                }
                Konobar konobar = null;
                if (!Rastavljanje3Bela.this.menadzer) {
                    konobar = this.server.konobarBySifra(this.text2.getText());
                    if (konobar == null) {
                        Konstante.getPoruka(numericka2, "Konobar sa unesenom sifrom ne postoji!");
                        this.text2.setFocus();
                        return;
                    }
                    if (konobar.getNivo().equals("SEF")) {
                        this.makeNumeric(numericka2);
                    }
                    if (this.zatvori) {
                        return;
                    }
                    if (Rastavljanje3Bela.this.odabraniKonobar != null) {
                        konobar = Rastavljanje3Bela.this.odabraniKonobar;
                    } else if (!Rastavljanje3Bela.this.sefKonobarPotvrda) {
                        konobar = this.server.konobarBySifra(this.text2.getText());
                    }
                } else {
                    if (this.server.getSto(br) == null) {
                        konobar = this.server.konobarBySifra(this.text2.getText());
                        if (konobar == null) {
                            Konstante.getPoruka(numericka2, "Morate uneti sifru konobara!");
                            this.text2.setFocus();
                            return;
                        }
                        if (konobar.getNivo().equals("SEF")) {
                            this.makeNumeric(numericka2);
                        }
                    } else {
                        konobar = this.server.konobarBySifra(this.text2.getText());
                        if (konobar.getNivo().equals("SEF")) {
                            this.makeNumeric(numericka2);
                        }
                    }
                    if (this.zatvori) {
                        return;
                    }
                    if (Rastavljanje3Bela.this.odabraniKonobar != null) {
                        konobar = Rastavljanje3Bela.this.odabraniKonobar;
                    } else if (!Rastavljanje3Bela.this.sefKonobarPotvrda) {
                        konobar = this.server.konobarBySifra(this.text2.getText());
                    }
                }
                Sto sto2 = this.server.getSto(br);
                if (sto2 == null) {
                    sto2 = new Sto();
                    sto2.setBroj(br);
                    sto2.setBlokiran(false);
                    sto2.setKonobar(konobar);
                } else if (!sto2.getKonobar().equals(konobar)) {
                    Konstante.getPoruka(numericka2, "Uneta sifra ne odgovara sifri konobara!");
                    this.text2.setFocus();
                    return;
                }
                this.outSto = sto2;
                numericka2.close();
            } else {
                this.text.setFocus();
            }
        }

        public Sto getOutSto() {
            return this.outSto;
        }
    }
}

