/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.sistem.Faktura;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.KombinovanoPlacanje;
import com.dev63.restoran.stampa.FiskalniRacun;
import com.dev63.restoran.stampa.StampaKopijeRacuna1;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.resources.FontCache;
import com.dev63.restoran.swt.resources.ImageCache;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Rastavljanje2 {
    boolean isText = true;
    boolean isText2 = false;
    Text text;
    Text text2;
    String broj = "";
    private Display display;
    private Shell shell;
    private Restoran restoran;
    private RestoranServer server;
    private Sto sto;
    private boolean menadzer;
    public final Comparator<Tura> TURA_NUMBER = new Comparator<Tura>(){

        @Override
        public int compare(Tura s1, Tura s2) {
            Integer i1 = s1.getBrojTure();
            Integer i2 = s2.getBrojTure();
            return i1.compareTo(i2);
        }
    };
    private SortedMap<Tura, List<StavkaRacuna>> tureStavkeLevo = new TreeMap<Tura, List<StavkaRacuna>>(this.TURA_NUMBER);
    private SortedMap<Tura, List<StavkaRacuna>> tureStavkeLevoPocetna = new TreeMap<Tura, List<StavkaRacuna>>(this.TURA_NUMBER);
    private Map<Tura, List<StavkaRacuna>> tureStavkeDesno = new HashMap<Tura, List<StavkaRacuna>>();
    private Map<Integer, StavkaRacuna> stavkeIndexLevo = new HashMap<Integer, StavkaRacuna>();
    private Map<StavkaRacuna, Double> mapaPocetnihKolicina = new HashMap<StavkaRacuna, Double>();
    private Map<Integer, StavkaRacuna> stavkeIndexDesno = new HashMap<Integer, StavkaRacuna>();
    private org.eclipse.swt.widgets.List listaLevo;
    private Composite menu;
    private org.eclipse.swt.widgets.List listaDesno;
    private double sumaLevo;
    private double sumaDesno;
    private Map<Integer, Tura> tureIndexLevo = new HashMap<Integer, Tura>();
    private Map<Integer, Tura> tureIndexDesno = new HashMap<Integer, Tura>();
    private Tura nova;
    private Double kolicina;
    private Image bgImg;
    private Color fgColor;
    private Font bFont;

    public Rastavljanje2(Shell parent, Restoran restoran, Sto s) {
        this.display = parent.getDisplay();
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.sto = this.server.getSto(s.getBroj());
        this.menadzer = this.server.getSetting(Option.SIFRA_SASTAVLANJE_STOLOVA).booleanValue();
        this.bgImg = ImageCache.getImage("blanko164x80.png");
        this.fgColor = this.display.getSystemColor(4);
        this.bFont = FontCache.getFont("Arial", 16, 1);
        for (Tura tura : this.server.getNenaplaceneTure(this.sto.getBroj())) {
            this.server.getBase().refresh((Object)tura);
            try {
                if (tura.getStavke().isEmpty()) {
                    this.tureStavkeLevo.put(tura, this.server.readNenaplaceneStavkeRacuna(tura));
                    continue;
                }
                this.tureStavkeLevo.put(tura, tura.getStavke());
            }
            catch (Exception e) {
                this.tureStavkeLevo.put(tura, this.server.readNenaplaceneStavkeRacuna(tura));
            }
        }
        this.tureStavkeLevoPocetna = new TreeMap<Tura, List<StavkaRacuna>>(this.tureStavkeLevo);
        for (Map.Entry entry : this.tureStavkeLevo.entrySet()) {
            List list = (List)entry.getValue();
            for (StavkaRacuna sr : list) {
                this.mapaPocetnihKolicina.put(sr, (double)sr.getKolicina());
                System.out.println(sr.getId() + ": " + sr.getKolicina());
            }
        }
        this.shell = new Shell(parent, 32768);
        this.shell.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_RASTAVLJANJE"));
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setMaximized(true);
        GridData data2 = new GridData(1040);
        data2.widthHint = 172;
        Font font = FontCache.getFont("Arial", 16, 0);
        this.listaLevo = new org.eclipse.swt.widgets.List((Composite)this.shell, 2560);
        this.listaLevo.setFont(font);
        this.menu = new Composite((Composite)this.shell, 512);
        this.menu.setLayoutData((Object)data2);
        this.menu.setLayout((Layout)new GridLayout());
        this.listaDesno = new org.eclipse.swt.widgets.List((Composite)this.shell, 2560);
        this.listaDesno.setFont(font);
        GridData data = new GridData(1808);
        this.listaLevo.setLayoutData((Object)data);
        this.listaDesno.setLayoutData((Object)data);
        this.novaTura();
        this.load();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void reload() {
        this.listaLevo.removeAll();
        this.listaDesno.removeAll();
        this.napraviListuLevo();
        this.napraviListuDesno();
    }

    private void load() {
        this.napraviListuLevo();
        this.napraviToolBar();
        this.napraviListuDesno();
    }

    private void prebaci() {
        double kol = 0.0;
        int index = this.listaLevo.getSelectionIndex();
        if (index == 0) {
            this.tureStavkeDesno.clear();
            for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeLevoPocetna.entrySet()) {
                Tura tura = entry.getKey();
                List<StavkaRacuna> list = entry.getValue();
                for (StavkaRacuna sr : list) {
                    sr.setKolicina(this.mapaPocetnihKolicina.get(sr));
                }
                this.tureStavkeDesno.put(tura, list);
            }
            this.tureStavkeLevo.clear();
            this.reload();
        } else if (this.tureIndexLevo.get(this.listaLevo.getSelectionIndex()) != null) {
            Tura t = this.tureIndexLevo.get(this.listaLevo.getSelectionIndex());
            HashMap<Tura, List<StavkaRacuna>> noveTureDesno = new HashMap<Tura, List<StavkaRacuna>>(this.tureStavkeDesno);
            for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeDesno.entrySet()) {
                Tura tura = entry.getKey();
                if (tura.equals(t)) {
                    noveTureDesno.remove(tura);
                    continue;
                }
                if (!tura.equals(this.nova)) continue;
                List<StavkaRacuna> list = entry.getValue();
                LinkedList<StavkaRacuna> listaNova = new LinkedList<StavkaRacuna>(list);
                for (StavkaRacuna sr : list) {
                    if (!sr.getTura().equals(t)) continue;
                    listaNova.remove(sr);
                }
                if (listaNova.isEmpty()) {
                    noveTureDesno.remove(tura);
                    continue;
                }
                noveTureDesno.put(tura, listaNova);
            }
            for (StavkaRacuna sr : (List)this.tureStavkeLevoPocetna.get(t)) {
                sr.setKolicina(this.mapaPocetnihKolicina.get(sr));
            }
            noveTureDesno.put(t, (List<StavkaRacuna>)this.tureStavkeLevoPocetna.get(t));
            this.tureStavkeDesno = noveTureDesno;
            this.tureStavkeLevo.remove(t);
            this.reload();
        } else if (this.stavkeIndexLevo.containsKey(this.listaLevo.getSelectionIndex())) {
            StavkaRacuna srNova = new StavkaRacuna();
            StavkaRacuna sr = this.stavkeIndexLevo.get(this.listaLevo.getSelectionIndex());
            if (sr == null) {
                return;
            }
            Tura t = sr.getTura();
            ArrayList<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
            for (StavkaRacuna stRa : (List)this.tureStavkeLevo.get(t)) {
                if (stRa.equals(sr)) {
                    if (stRa.getKolicina() <= 1.0) {
                        srNova = sr;
                        continue;
                    }
                    kol = 1.0;
                    srNova.setKolicina(kol);
                    srNova.setBrojStola(sr.getBrojStola());
                    srNova.setCena(sr.getCena());
                    srNova.setNaziv(sr.getNaziv());
                    srNova.setTura(sr.getTura());
                    srNova.setArtikal(sr.getArtikal());
                    stRa.setKolicina(stRa.getKolicina() - 1.0);
                    stavke.add(stRa);
                    continue;
                }
                stavke.add(stRa);
            }
            if (stavke.isEmpty()) {
                this.tureStavkeLevo.remove(t);
            } else {
                this.tureStavkeLevo.put(t, stavke);
            }
            if (this.tureStavkeDesno.isEmpty()) {
                ArrayList<StavkaRacuna> stavke2 = new ArrayList<StavkaRacuna>();
                if (!this.tureStavkeDesno.containsKey(this.nova)) {
                    this.tureStavkeDesno.put(this.nova, new LinkedList());
                }
                for (StavkaRacuna str : this.tureStavkeDesno.get(this.nova)) {
                    stavke2.add(str);
                }
                stavke2.add(srNova);
                this.tureStavkeDesno.put(this.nova, stavke2);
            } else {
                boolean ima = false;
                for (Tura tura : this.tureStavkeDesno.keySet()) {
                    if (!tura.equals(this.nova)) continue;
                    for (StavkaRacuna str : this.tureStavkeDesno.get(tura)) {
                        if (!str.getArtikal().equals(sr.getArtikal())) continue;
                        ima = true;
                        str.setKolicina(str.getKolicina() + srNova.getKolicina());
                    }
                }
                if (!ima) {
                    ArrayList<StavkaRacuna> stavke2 = new ArrayList<StavkaRacuna>();
                    if (!this.tureStavkeDesno.containsKey(this.nova)) {
                        this.tureStavkeDesno.put(this.nova, new LinkedList());
                    }
                    for (StavkaRacuna str : this.tureStavkeDesno.get(this.nova)) {
                        stavke2.add(str);
                    }
                    stavke2.add(srNova);
                    this.tureStavkeDesno.put(this.nova, stavke2);
                }
            }
            this.reload();
        }
    }

    private void vrati() {
        double kol = 0.0;
        int index = this.listaDesno.getSelectionIndex();
    }

    private void napraviListuLevo() {
        this.sumaLevo = 0.0;
        this.tureIndexLevo.clear();
        this.stavkeIndexLevo.clear();
        int index = 1;
        if (this.tureStavkeLevo.size() > 0) {
            this.listaLevo.add(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_STO_BROJ") + " " + this.sto.getBroj());
            for (Tura tura : this.tureStavkeLevo.keySet()) {
                this.listaLevo.add(" " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PORUDZBINA_BROJ") + " " + tura.getBrojTure());
                this.tureIndexLevo.put(index, tura);
                ++index;
                for (StavkaRacuna sr : (List)this.tureStavkeLevo.get(tura)) {
                    this.listaLevo.add("    -" + Konstante.getNumber1(sr.getKolicina()) + "x " + sr.getNaziv() + "  " + Konstante.getNumber2(sr.getVrednost()) + "");
                    this.sumaLevo += sr.getVrednost().doubleValue();
                    this.stavkeIndexLevo.put(index, sr);
                    ++index;
                }
            }
            this.listaLevo.add("");
            this.listaLevo.add(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO") + ": " + Konstante.getNumber2(this.sumaLevo) + "");
        }
    }

    void napraviListuDesno() {
        this.sumaDesno = 0.0;
        if (this.tureStavkeDesno.size() > 0) {
            for (Tura t : this.tureStavkeDesno.keySet()) {
                this.listaDesno.add(" " + ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PORUDZBINA_BROJ") + " " + t.getBrojTure());
                for (StavkaRacuna sr : this.tureStavkeDesno.get(t)) {
                    this.listaDesno.add("    -" + Konstante.getNumber1(sr.getKolicina()) + "x " + sr.getNaziv() + "  " + Konstante.getNumber2(sr.getVrednost()) + "");
                    this.sumaDesno += sr.getVrednost().doubleValue();
                }
            }
            this.listaDesno.add("");
            this.listaDesno.add(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO") + ": " + Konstante.getNumber2(this.sumaDesno) + "");
        }
    }

    private void novaTura() {
        this.nova = new Tura();
        this.nova.setDatum(new Date());
        this.nova.setPocetak(new Timestamp(0L));
        this.nova.setKraj(new Timestamp(0L));
        this.nova.setBrojStola(this.sto.getBroj());
        this.nova.setBrojTure(this.server.sledeciBrojTure());
    }

    private void napraviToolBar() {
        this.shell.setBackgroundMode(1);
        GridData data = new GridData(64);
        data.widthHint = 120;
        data.heightHint = 80;
        data.verticalIndent = 5;
        GridData data2 = new GridData();
        data2.widthHint = 164;
        data2.heightHint = 80;
        data2.verticalIndent = 5;
        ImageButton item1 = new ImageButton(this.menu, 8);
        item1.setBackgroundImage(this.bgImg);
        item1.setForeground(this.fgColor);
        item1.setFont(this.bFont);
        item1.setText(">");
        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Rastavljanje2.this.listaLevo.getSelectionIndex() < 0) {
                    return;
                }
                Rastavljanje2.this.prebaci();
            }
        });
        item1.setLayoutData(data2);
        ImageButton item3 = new ImageButton(this.menu, 8);
        item3.setBackgroundImage(this.bgImg);
        item3.setForeground(this.fgColor);
        item3.setFont(this.bFont);
        item3.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PREBACI_NA_STO"));
        item3.setLayoutData(data2);
        item3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!Rastavljanje2.this.tureStavkeDesno.isEmpty()) {
                    int size = 0;
                    for (List list : Rastavljanje2.this.tureStavkeDesno.values()) {
                        size += list.size();
                    }
                    if (size > 0) {
                        // empty if block
                    }
                    Rastavljanje2.this.naSto();
                }
            }
        });
        ImageButton item4 = new ImageButton(this.menu, 8);
        item4.setBackgroundImage(this.bgImg);
        item4.setForeground(this.fgColor);
        item4.setFont(this.bFont);
        item4.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KOMBINOVANO_PLACANJE"));
        item4.setLayoutData(data2);
        item4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Rastavljanje2.this.tureStavkeDesno.size() != 0) {
                    KombinovanoPlacanje kp = new KombinovanoPlacanje(Rastavljanje2.this.shell, Rastavljanje2.this.restoran, Rastavljanje2.this.sumaDesno);
                    List<Placanje> placanja = kp.getPlacanja();
                    if (placanja == null) {
                        return;
                    }
                    Rastavljanje2.this.makeRacun(placanja, null);
                    Konstante.getPoruka(Rastavljanje2.this.shell, "Racun naplacen!");
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        ImageButton item6 = new ImageButton(this.menu, 8);
        item6.setBackgroundImage(this.bgImg);
        item6.setForeground(this.fgColor);
        item6.setFont(this.bFont);
        item6.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_GOTOVINA"));
        item6.setLayoutData(data2);
        item6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Rastavljanje2.this.tureStavkeDesno.size() != 0) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje placanje = new Placanje();
                    placanje.setNacin(NacinPlacanja.GOTOVINA);
                    placanje.setIznos(Rastavljanje2.this.sumaDesno);
                    placanja.add(placanje);
                    Rastavljanje2.this.makeRacun(placanja, null);
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        ImageButton item7 = new ImageButton(this.menu, 8);
        item7.setBackgroundImage(this.bgImg);
        item7.setForeground(this.fgColor);
        item7.setFont(this.bFont);
        item7.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_SVI_NACINI"));
        item7.setLayoutData(data2);
        item7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rastavljanje2.this.napraviOdabirPlacanja();
            }
        });
        ImageButton item5 = new ImageButton(this.menu, 8);
        item5.setBackgroundImage(this.bgImg);
        item5.setForeground(this.fgColor);
        item5.setFont(this.bFont);
        item5.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZLAZ"));
        item5.setLayoutData(data2);
        item5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (Map.Entry entry : Rastavljanje2.this.tureStavkeLevoPocetna.entrySet()) {
                    Tura tura = (Tura)entry.getKey();
                    Rastavljanje2.this.server.getBase().refresh((Object)tura);
                    List list = (List)entry.getValue();
                    for (StavkaRacuna sr : list) {
                        Rastavljanje2.this.server.getBase().refresh((Object)sr);
                    }
                }
                Rastavljanje2.this.shell.close();
            }
        });
    }

    private void napraviOdabirPlacanja() {
        final Shell popUpShell = Konstante.makeShell(new Shell(this.shell, 32768), "Odabir placanja");
        popUpShell.setBackgroundMode(1);
        popUpShell.setText("Odabir placanja");
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        popUpShell.setLayout((Layout)layout);
        HashMap<CrnoPlacanje, ImageButton> buttonsCrna = new HashMap<CrnoPlacanje, ImageButton>();
        GridData dataForBela = new GridData();
        dataForBela.horizontalAlignment = 16384;
        dataForBela.widthHint = 120;
        dataForBela.heightHint = 80;
        ImageButton gotovinaButton = new ImageButton((Composite)popUpShell, 8);
        gotovinaButton.setBackgroundImage(this.bgImg);
        gotovinaButton.setForeground(this.fgColor);
        gotovinaButton.setFont(this.bFont);
        gotovinaButton.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_GOTOVINA"));
        gotovinaButton.setLayoutData(dataForBela);
        gotovinaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Rastavljanje2.this.tureStavkeDesno.size() != 0) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje placanje = new Placanje();
                    placanje.setNacin(NacinPlacanja.GOTOVINA);
                    placanje.setIznos(Rastavljanje2.this.sumaDesno);
                    placanja.add(placanje);
                    Rastavljanje2.this.makeRacun(placanja, null);
                    popUpShell.close();
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        ImageButton fakturaButton = new ImageButton((Composite)popUpShell, 8);
        fakturaButton.setBackgroundImage(this.bgImg);
        fakturaButton.setForeground(this.fgColor);
        fakturaButton.setFont(this.bFont);
        fakturaButton.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_FAKTURA"));
        fakturaButton.setLayoutData(dataForBela);
        fakturaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!Rastavljanje2.this.tureStavkeDesno.isEmpty()) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje placanje = new Placanje();
                    placanje.setNacin(NacinPlacanja.FAKTURA);
                    placanje.setIznos(Rastavljanje2.this.sumaDesno);
                    placanja.add(placanje);
                    Rastavljanje2.this.makeRacun(placanja, null);
                    popUpShell.close();
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        ImageButton cekButton = new ImageButton((Composite)popUpShell, 8);
        cekButton.setBackgroundImage(this.bgImg);
        cekButton.setForeground(this.fgColor);
        cekButton.setFont(this.bFont);
        cekButton.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CEK"));
        cekButton.setLayoutData(dataForBela);
        cekButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Rastavljanje2.this.tureStavkeDesno.size() != 0) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje placanje = new Placanje();
                    placanje.setNacin(NacinPlacanja.CEK);
                    placanje.setIznos(Rastavljanje2.this.sumaDesno);
                    placanja.add(placanje);
                    Rastavljanje2.this.makeRacun(placanja, null);
                    popUpShell.close();
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        ImageButton karticaButton = new ImageButton((Composite)popUpShell, 8);
        karticaButton.setBackgroundImage(this.bgImg);
        karticaButton.setForeground(this.fgColor);
        karticaButton.setFont(this.bFont);
        karticaButton.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KARTICA"));
        karticaButton.setLayoutData(dataForBela);
        karticaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!Rastavljanje2.this.tureStavkeDesno.isEmpty()) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje placanje = new Placanje();
                    placanje.setNacin(NacinPlacanja.KARTICA);
                    placanje.setIznos(Rastavljanje2.this.sumaDesno);
                    placanja.add(placanje);
                    Rastavljanje2.this.makeRacun(placanja, null);
                    popUpShell.close();
                    Rastavljanje2.this.shell.close();
                }
            }
        });
        GridData dataForCrna = new GridData();
        dataForCrna.horizontalAlignment = 16384;
        dataForCrna.widthHint = 120;
        dataForCrna.heightHint = 75;
        for (final CrnoPlacanje cp : this.server.readSvaCrnaPlacanja()) {
            if (cp.getNaziv().equalsIgnoreCase("medjuzbir")) continue;
            ImageButton button = new ImageButton((Composite)popUpShell, 8);
            if (cp.getSlika() == null) {
                button.setBackgroundImage(this.bgImg);
                button.setForeground(this.fgColor);
                button.setFont(this.bFont);
                button.setText(cp.getNaziv());
            } else {
                final Image[] img = new Image[1];
                try {
                    img[0] = new Image((Device)this.display, cp.getSlika());
                    button.setBackgroundImage(img[0]);
                    button.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent de) {
                            if (img[0] != null && !img[0].isDisposed()) {
                                img[0].dispose();
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    button.setBackgroundImage(this.bgImg);
                    button.setForeground(this.fgColor);
                    button.setFont(this.bFont);
                    button.setText(cp.getNaziv());
                }
            }
            button.setLayoutData(dataForCrna);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    if (Rastavljanje2.this.tureStavkeDesno.size() != 0) {
                        Rastavljanje2.this.makeRacun(null, cp);
                        popUpShell.close();
                        Rastavljanje2.this.shell.close();
                    }
                }
            });
            buttonsCrna.put(cp, button);
        }
        Button izlaz = new Button((Composite)popUpShell, 8);
        izlaz.setImage(new Image((Device)this.display, ImagePath.getPath() + "/izlaz.gif"));
        GridData dataForIzlaz = new GridData();
        dataForIzlaz.horizontalAlignment = 131072;
        dataForIzlaz.horizontalSpan = 4;
        dataForIzlaz.widthHint = 164;
        dataForIzlaz.heightHint = 80;
        izlaz.setLayoutData((Object)dataForIzlaz);
        izlaz.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                popUpShell.close();
            }
        });
        popUpShell.pack();
        Konstante.centerShellOnDisplay(this.shell);
        popUpShell.open();
        while (!popUpShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void naplata(NacinPlacanja np, CrnoPlacanje cp) {
        if (np == null && cp == null || cp != null && np != null) {
            return;
        }
        boolean crno = false;
        Date datum = new Date();
        if (cp != null) {
            crno = false;
        }
        Racun racun = new Racun();
        racun.setDatum(datum);
        racun.setStorniran(false);
        racun.setBrojStola(this.sto.getBroj());
        racun.setFiskalniOdstampan(Boolean.FALSE);
        racun.setZatvoren(Boolean.FALSE);
        racun.setPopust(new Double(0.0));
        racun.setKonobar(this.sto.getKonobar());
        if (crno) {
            racun.setCrnoPlacanje(cp.getNaziv());
        }
        for (Tura tura : this.tureStavkeDesno.keySet()) {
            tura.setRacun(racun);
        }
    }

    private void prebaciNaSto(Sto sto2) {
        if (this.tureStavkeLevo.isEmpty()) {
            Tura tura;
            HashMap<Tura, List<StavkaRacuna>> noveTure = new HashMap<Tura, List<StavkaRacuna>>();
            for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeDesno.entrySet()) {
                tura = entry.getKey();
                List<StavkaRacuna> list = entry.getValue();
                if (tura.equals(this.nova)) {
                    this.server.incrementBrojTure(Integer.valueOf(this.nova.getBrojTure() + 1).toString());
                }
                tura.setBrojStola(sto2.getBroj());
                tura = this.server.updateTuraJPA(tura);
                LinkedList noveStavke = new LinkedList();
                for (StavkaRacuna sr : list) {
                    sr.setBrojStola(sto2.getBroj());
                    sr.setTura(tura);
                    sr = this.server.updateStavkaRacunaJPA(sr);
                    noveStavke.add(sr);
                }
                noveTure.put(tura, noveStavke);
            }
            this.tureStavkeDesno = noveTure;
            for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeLevoPocetna.entrySet()) {
                tura = entry.getKey();
                this.server.getBase().refresh((Object)tura);
                boolean sadrzi = false;
                for (Map.Entry entry2 : this.tureStavkeDesno.entrySet()) {
                    Tura turaD = (Tura)entry2.getKey();
                    if (!turaD.equals(tura)) continue;
                    sadrzi = true;
                }
                if (sadrzi || !tura.getStavke().isEmpty()) continue;
                try {
                    this.server.deleteTuraJPA2(tura);
                }
                catch (Exception ex) {
                    Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.server.log("Prebacivanje svih artikala, sto :" + this.sto.getBroj() + "-->" + sto2.getBroj());
            this.server.deleteStoJPA(this.sto.getBroj());
        } else {
            for (Tura tura : this.tureStavkeLevoPocetna.keySet()) {
                block9: for (StavkaRacuna sr : (List)this.tureStavkeLevoPocetna.get(tura)) {
                    for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeLevo.entrySet()) {
                        List<StavkaRacuna> list = entry.getValue();
                        for (StavkaRacuna srl : list) {
                            if (!srl.equals(sr)) continue;
                            continue block9;
                        }
                    }
                    for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeDesno.entrySet()) {
                        Tura tura2 = entry.getKey();
                        List<StavkaRacuna> list = entry.getValue();
                        for (StavkaRacuna srd : list) {
                            if (!srd.equals(sr)) continue;
                            continue block9;
                        }
                    }
                    this.server.deleteStavkaRacunaJPA(sr);
                }
                if (this.tureStavkeLevo.containsKey(tura) || this.tureStavkeDesno.containsKey(tura)) continue;
                this.server.getBase().refresh((Object)tura);
                try {
                    this.server.deleteTuraJPA2(tura);
                }
                catch (Exception exception) {
                    Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
            for (Map.Entry entry : this.tureStavkeLevo.entrySet()) {
                Tura tura = (Tura)entry.getKey();
                List list = (List)entry.getValue();
                tura.setBrojStola(this.sto.getBroj());
                Tura tura3 = this.server.updateTuraJPA(tura);
                for (StavkaRacuna sr : list) {
                    sr.setTura(tura3);
                    sr.setBrojStola(this.sto.getBroj());
                    sr = this.server.updateStavkaRacunaJPA(sr);
                }
                this.server.getBase().refresh((Object)tura3);
            }
            HashMap<Tura, List<StavkaRacuna>> noveTureDesno = new HashMap<Tura, List<StavkaRacuna>>();
            for (Map.Entry<Tura, List<StavkaRacuna>> entry : this.tureStavkeDesno.entrySet()) {
                Tura tura = entry.getKey();
                List<StavkaRacuna> list = entry.getValue();
                if (tura.equals(this.nova)) {
                    this.server.incrementBrojTure(Integer.valueOf(this.nova.getBrojTure() + 1).toString());
                }
                tura.setBrojStola(sto2.getBroj());
                tura = this.server.updateTuraJPA(tura);
                LinkedList<StavkaRacuna> noveStavke = new LinkedList<StavkaRacuna>();
                for (StavkaRacuna sr : list) {
                    sr.setTura(tura);
                    sr.setBrojStola(sto2.getBroj());
                    sr = this.server.updateStavkaRacunaJPA(sr);
                    noveStavke.add(sr);
                }
                this.server.getBase().refresh((Object)tura);
                tura.setStavke(noveStavke);
                tura = this.server.updateTuraJPA(tura);
                noveTureDesno.put(tura, noveStavke);
            }
            this.tureStavkeDesno = noveTureDesno;
        }
    }

    public void makeRacun(List<Placanje> placanja, CrnoPlacanje cp) {
        if (placanja == null) {
            placanja = new LinkedList<Placanje>();
        }
        StalniGost sg = null;
        String naziv = "";
        String adresa = "";
        String pib = "";
        Double popust = null;
        boolean crno = false;
        boolean faktura = false;
        if (cp != null) {
            crno = true;
        }
        if (!crno) {
            for (Placanje placanje : placanja) {
                NacinPlacanja nacinPlacanja = placanje.getNacin();
                if (!nacinPlacanja.equals((Object)NacinPlacanja.FAKTURA)) continue;
                faktura = true;
            }
        }
        if (faktura && placanja.size() != 1) {
            Konstante.getPoruka(this.shell, ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_FAKTURA_SE_NE_MOZE_KOMBINOVATI"));
            return;
        }
        Racun racun = new Racun();
        racun.setStorniran(false);
        racun.setKonobar(this.server.konobarZaSto(this.sto.getBroj()));
        racun.setDatum(new Date());
        racun.setPopust(0.0);
        racun.setFiskalniOdstampan(false);
        racun.setBrojStola(this.sto.getBroj());
        racun.setZatvoren(Boolean.TRUE);
        if (faktura) {
            Faktura f = new Faktura(null, new Shell(this.shell, 65536), this.server);
            if (f.getOtkazi()) {
                return;
            }
            sg = f.getStalniGost();
            naziv = f.getNaziv();
            adresa = f.getAdresa();
            pib = f.getPib();
            popust = f.getPopust();
            int vp = f.getValuta();
            racun.setBrojFakture(this.server.sledeciBrojFakture());
            racun.setPopust(Double.valueOf(Math.round(popust * 100.0)));
            racun.setStalniGost(sg);
        }
        this.prebaciNaSto(this.sto);
        if (!crno) {
            racun.setPlacanja(placanja);
        } else {
            racun.setCrnoPlacanje(cp.getNaziv());
        }
        racun.setStavke1(new LinkedList<StavkaRacuna>());
        racun.setTure(new LinkedList<Tura>());
        for (Map.Entry entry : this.tureStavkeDesno.entrySet()) {
            Tura tura = (Tura)entry.getKey();
            this.server.getBase().refresh((Object)tura);
            List list = (List)entry.getValue();
            LinkedList<StavkaRacuna> listaNova = new LinkedList<StavkaRacuna>();
            for (StavkaRacuna sr : list) {
                this.server.getBase().refresh((Object)sr);
                racun.getStavke1().add(sr);
                listaNova.add(sr);
            }
            tura.setStavke(listaNova);
            racun.getTure().add(tura);
        }
        Racun rCopy = (Racun)SerializationUtils.clone((Serializable)racun);
        try {
            this.server.makeRacunAndTura(racun);
        }
        catch (Exception exception) {
            Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, exception);
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(exception.getMessage());
            mb.open();
            return;
        }
        if (!crno) {
            try {
                new FiskalniRacun(this.restoran).printFiscal(rCopy, rCopy.getKonobar().getSkrIme());
            }
            catch (FiscalException fiscalException) {
                Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, fiscalException);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, sQLException);
            }
            catch (SerialIOException serialIOException) {
                Logger.getLogger(Rastavljanje2.class.getName()).log(Level.SEVERE, null, serialIOException);
            }
            catch (Exception exception) {
                racun.setFiskalniOdstampan(false);
            }
        } else {
            new StampaKopijeRacuna1(rCopy, this.restoran);
        }
        if (faktura) {
            int n = this.server.getSetting(Option.BROJ_KOPIJA_FAKTURE).intValue();
            new FakturaRacun(this.display, this.restoran, racun, this.restoran.getStope(), n, "", false, null);
        }
    }

    public void makeRacunFaktura(Faktura fak) {
    }

    public void naSto() {
        final Shell numericka2 = new Shell(this.shell, 65536);
        numericka2.setLayout((Layout)new GridLayout(2, true));
        numericka2.setMaximized(true);
        Composite numericka0 = new Composite((Composite)numericka2, 2048);
        numericka0.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        GridData data2 = new GridData();
        data2.widthHint = 150;
        data2.heightHint = 30;
        Shell shell2 = new Shell(this.display, 0);
        Label label = new Label(numericka0, 0);
        label.setText("Prebacivanje na sto:");
        label.setLayoutData((Object)data);
        this.text = new Text(numericka0, 2048);
        this.text.setLayoutData((Object)data);
        this.addListener(this.text);
        Label label2 = new Label(numericka0, 0);
        label2.setText("Sifra konobara:");
        label2.setLayoutData((Object)data);
        this.text2 = new Text(numericka0, 0x400800);
        this.text2.setLayoutData((Object)data);
        this.addListener(this.text2);
        this.text2.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000050 || event.keyCode == 13) {
                    Rastavljanje2.this.onPotvrda(numericka2);
                }
            }
        });
        numericka0.setLayout((Layout)new GridLayout(2, false));
        Composite numericka = new Composite((Composite)numericka2, 2048);
        numericka.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData();
        gridData.heightHint = 80;
        gridData.widthHint = 80;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 164;
        gridData2.heightHint = 80;
        gridData2.horizontalAlignment = 0x1000000;
        GridData gridData3 = new GridData();
        gridData3.heightHint = 80;
        gridData3.widthHint = 80;
        gridData3.horizontalSpan = 2;
        Image br1 = new Image((Device)this.display, ImagePath.getPath() + "/7.gif");
        Button b = new Button(numericka, 0);
        b.setLayoutData((Object)gridData);
        b.setImage(br1);
        this.addListenerNumeric("7", b);
        Button b3 = new Button(numericka, 0);
        b3.setImage(new Image((Device)this.display, ImagePath.getPath() + "/8.gif"));
        b3.setLayoutData((Object)gridData);
        this.addListenerNumeric("8", b3);
        Button b4 = new Button(numericka, 0);
        b4.setImage(new Image((Device)this.display, ImagePath.getPath() + "/9.gif"));
        b4.setLayoutData((Object)gridData);
        this.addListenerNumeric("9", b4);
        Button otkazi = new Button(numericka, 0x1000040);
        otkazi.setLayoutData((Object)gridData2);
        otkazi.setImage(new Image((Device)this.display, ImagePath.getPath() + "/ponisti1.gif"));
        otkazi.setBackground(this.display.getSystemColor(1));
        otkazi.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                numericka2.close();
            }
        });
        Button b6 = new Button(numericka, 0);
        b6.setImage(new Image((Device)this.display, ImagePath.getPath() + "/4.gif"));
        b6.setLayoutData((Object)gridData);
        this.addListenerNumeric("4", b6);
        Button b7 = new Button(numericka, 0);
        b7.setImage(new Image((Device)this.display, ImagePath.getPath() + "/5.gif"));
        b7.setLayoutData((Object)gridData);
        this.addListenerNumeric("5", b7);
        Button b8 = new Button(numericka, 0);
        b8.setImage(new Image((Device)this.display, ImagePath.getPath() + "/6.gif"));
        b8.setLayoutData((Object)gridData3);
        this.addListenerNumeric("6", b8);
        Button b0 = new Button(numericka, 0);
        b0.setImage(new Image((Device)this.display, ImagePath.getPath() + "/1.gif"));
        b0.setLayoutData((Object)gridData);
        this.addListenerNumeric("1", b0);
        Button tacka = new Button(numericka, 0);
        tacka.setImage(new Image((Device)this.display, ImagePath.getPath() + "/2.gif"));
        tacka.setLayoutData((Object)gridData);
        this.addListenerNumeric("2", tacka);
        Button b1 = new Button(numericka, 0);
        b1.setImage(new Image((Device)this.display, ImagePath.getPath() + "/3.gif"));
        b1.setLayoutData((Object)gridData3);
        this.addListenerNumeric("3", b1);
        Button b5 = new Button(numericka, 0);
        b5.setImage(new Image((Device)this.display, ImagePath.getPath() + "/0.gif"));
        b5.setLayoutData((Object)gridData);
        this.addListenerNumeric("0", b5);
        data = new GridData();
        data.horizontalSpan = 4;
        data.widthHint = 164;
        data.heightHint = 80;
        data.horizontalAlignment = 0x1000000;
        Button b9 = new Button(numericka, 0);
        b9.setImage(new Image((Device)this.display, ImagePath.getPath() + "/tacka.gif"));
        b9.setLayoutData((Object)gridData);
        Button nazad = new Button(numericka, 0);
        nazad.setImage(new Image((Device)this.display, ImagePath.getPath() + "/levo.gif"));
        nazad.setLayoutData((Object)gridData);
        nazad.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!Rastavljanje2.this.broj.equals("")) {
                    Rastavljanje2.this.broj = Rastavljanje2.this.broj.substring(0, Rastavljanje2.this.broj.length() - 1);
                    if (Rastavljanje2.this.isText) {
                        Rastavljanje2.this.text.setText(Rastavljanje2.this.broj);
                    } else {
                        Rastavljanje2.this.text2.setText(Rastavljanje2.this.broj);
                    }
                }
            }
        });
        Button stPorudz = new Button(numericka, 0x1000040);
        stPorudz.setLayoutData((Object)gridData2);
        stPorudz.setImage(new Image((Device)this.display, ImagePath.getPath() + "/potvrda1.gif"));
        stPorudz.setBackground(this.display.getSystemColor(1));
        stPorudz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rastavljanje2.this.onPotvrda(numericka2);
            }
        });
        data = new GridData();
        data.verticalIndent = 200;
        data.verticalAlignment = 128;
        data.horizontalIndent = 50;
        numericka0.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 200;
        data.horizontalIndent = 0;
        numericka.setLayoutData((Object)data);
        numericka.pack();
        numericka0.pack();
        numericka2.open();
    }

    public void addListenerNumeric(final String s, Button b) {
        b.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rastavljanje2.this.broj = Rastavljanje2.this.broj + s;
                if (Rastavljanje2.this.isText) {
                    Rastavljanje2.this.text.setText(Rastavljanje2.this.broj);
                } else {
                    Rastavljanje2.this.text2.setText(Rastavljanje2.this.broj);
                }
            }
        });
    }

    public void addListener(final Text t) {
        t.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (t.equals(Rastavljanje2.this.text2)) {
                    Rastavljanje2.this.text2.forceFocus();
                    Rastavljanje2.this.isText2 = true;
                    Rastavljanje2.this.isText = false;
                    Rastavljanje2.this.broj = Rastavljanje2.this.text2.getText();
                    return;
                }
                if (t.equals(Rastavljanje2.this.text)) {
                    Rastavljanje2.this.text.forceFocus();
                    Rastavljanje2.this.isText = true;
                    Rastavljanje2.this.isText2 = false;
                    Rastavljanje2.this.broj = Rastavljanje2.this.text.getText();
                    return;
                }
            }
        });
    }

    private void onPotvrda(Shell numericka2) {
        if (!this.text.getText().isEmpty()) {
            int br;
            try {
                br = Integer.valueOf(this.text.getText());
                if (!this.text2.getText().isEmpty()) {
                    int n = Integer.valueOf(this.text2.getText());
                }
            }
            catch (Exception ex) {
                Konstante.getPoruka(numericka2, "Pogresan unos!");
                return;
            }
            Konobar konobar = null;
            if (!this.menadzer) {
                konobar = this.server.konobarBySifra(this.text2.getText());
                if (konobar == null) {
                    Konstante.getPoruka(numericka2, "Konobar sa unesenom sifrom ne postoji!");
                    return;
                }
            } else if (this.server.getSto(br) == null) {
                konobar = this.server.konobarBySifra(this.text2.getText());
                if (konobar == null) {
                    Konstante.getPoruka(numericka2, "Morate uneti sifru konobara!");
                    return;
                }
            } else {
                konobar = this.server.getSto(br).getKonobar();
            }
            if (this.tureStavkeLevo.isEmpty() && this.server.getSto(br) != null) {
                Konstante.getPoruka(numericka2, "Kompletan sadrzaj stola mozete prebaciti samo na prazan sto !");
                return;
            }
            Sto sto2 = this.server.getSto(br);
            if (sto2 == null) {
                sto2 = new Sto();
                sto2.setBroj(br);
                sto2.setBlokiran(false);
                sto2.setKonobar(konobar);
                sto2 = this.server.addStoQuery(sto2);
            } else if (!sto2.getKonobar().equals(konobar)) {
                Konstante.getPoruka(numericka2, "Uneta sifra ne odgovara sifri konobara!");
                return;
            }
            this.prebaciNaSto(sto2);
            numericka2.close();
            this.shell.close();
        } else {
            if (this.isText) {
                this.isText = false;
                this.isText2 = true;
                this.text2.forceFocus();
                this.broj = this.text2.getText();
                return;
            }
            if (this.isText2) {
                this.isText2 = false;
                this.isText = true;
                this.broj = this.text.getText();
                this.text.forceFocus();
                return;
            }
        }
    }
}

