/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.izvestaji.PrometPoKonobarima2018;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PrometZaKonobaraUnos {
    RestoranServer server;
    Restoran restoran;
    Text text;
    Shell shell;
    Display display;

    public PrometZaKonobaraUnos(Display s, Restoran r, Konobar konobar) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.display = s;
        if (konobar == null) {
            this.shell = new Shell(this.display, 64);
            this.shell.setLayout((Layout)new GridLayout(2, false));
            this.shell.setSize(400, 100);
            this.shell.setText(String.format(Konstante.getBundle().getString("TEXT_UNESITE_SIFRU_KONOBARA"), new Object[0]));
            GridData data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            this.text = new Text((Composite)this.shell, 0x400000);
            this.text.setLayoutData((Object)data);
            Button ok = new Button((Composite)this.shell, 8);
            ok.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
            ok.setLayoutData((Object)data);
            ok.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PrometZaKonobaraUnos.this.potvrda();
                }
            });
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
        } else {
            this.potvrda(konobar);
        }
    }

    public void potvrda() {
        Konobar konobar = this.server.konobarBySifra(this.text.getText());
        if (konobar != null) {
            Date pdate = Konstante.getOnlyDate(new Date());
            this.shell.close();
            new PrometPoKonobarima2018(this.shell, this.restoran, pdate, Konstante.getOnlyDate(new Date()), konobar, false, Arrays.asList(NacinPlacanja.values()), StavkeSumarno.getCrnaNaziviIzvestaji(this.server), true, false);
        }
    }

    public void potvrda(Konobar konobar) {
        if (konobar != null) {
            boolean b;
            try {
                b = this.server.getSetting(Option.RADNO_VREME).booleanValue();
            }
            catch (Exception e) {
                b = false;
            }
            Date pdate = b ? Konstante.getOnlyDate(this.server.getLastDateZD()) : Konstante.getOnlyDate(this.server.getLastDateZD());
            new PrometPoKonobarima2018(this.shell, this.restoran, pdate, pdate, konobar, false, Arrays.asList(NacinPlacanja.values()), StavkeSumarno.getCrnaNaziviIzvestaji(this.server), true, true);
        }
    }
}

