/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.PreostalaKolicina;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PrijemnicaUnos {
    RestoranServer server;
    SWTContainer parent;
    List<StalniGost> dobavljaci;
    Combo dobavljac;
    DateInput2 datum;
    DateInput2 datum2;
    final Table table;
    double ukupnaVred = 0.0;
    Label total;
    Button plus;
    Button minus;
    Shell shell;
    String brojPrijemnice;
    Odeljenje magacin;
    List<PrijemnicaStavka> stavke = new ArrayList<PrijemnicaStavka>();
    Boolean poPoslednjimCenama;
    Text pretraga;
    Combo artikal;
    Label tv2;
    Label tv2bp;
    DoubleInput2 cenaKomad;
    DoubleInput2 cenaKomadBezPoreza;
    Button crno;
    Label preostalaKolicina2;
    TipPrijemnice type;

    public PrijemnicaUnos(SWTContainer owner, Restoran restoran, TipPrijemnice tip) {
        this.type = tip == null ? TipPrijemnice.PRIJEMNICA : tip;
        this.server = restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.dobavljaci = this.server.allDobavljaci();
        this.magacin = this.server.returnMagacin();
        this.poPoslednjimCenama = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA).booleanValue();
        Label pm = new Label((Composite)this.shell, 0);
        pm.setText("Proizvodno mesto:");
        pm.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label ma = new Label((Composite)this.shell, 0);
        ma.setText("MAGACIN");
        ma.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label dat = new Label((Composite)this.shell, 0);
        dat.setText("Datum prijema:");
        dat.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum = new DateInput2(this.parent, "Datum prijema", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        Label dat2 = new Label((Composite)this.shell, 0);
        dat2.setText("Datum azuriranja:");
        dat2.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.datum2 = new DateInput2(this.parent, "Datum azuriranja", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum2.getControl().setEnabled(false);
        Label d = new Label((Composite)this.shell, 0);
        d.setText("Dobavljac");
        d.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.dobavljac = new Combo((Composite)this.shell, 2572);
        for (int i = 0; i < this.dobavljaci.size(); ++i) {
            this.dobavljac.add(this.dobavljaci.get(i).getSkrNaziv());
            this.dobavljac.select(0);
        }
        Label c = new Label((Composite)this.shell, 0);
        c.setText("Dodatne zalihe");
        c.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.crno = new Button((Composite)this.shell, 32);
        Label opisL = new Label((Composite)this.shell, 0);
        opisL.setText("Opis:");
        opisL.setBackground(this.shell.getDisplay().getSystemColor(22));
        final Text opis = new Text((Composite)this.shell, 2560);
        Label separator1 = new Label((Composite)this.shell, 258);
        this.table = new Table((Composite)this.shell, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
        nazivArtikla.setText("Naziv artikla");
        nazivArtikla.setWidth(180);
        TableColumn kolicina = new TableColumn(this.table, 0x1000000);
        kolicina.setText("Kolicina");
        kolicina.setWidth(110);
        TableColumn jmere = new TableColumn(this.table, 0x1000000);
        jmere.setText("J.M");
        jmere.setWidth(110);
        TableColumn cKomad = new TableColumn(this.table, 0x1000000);
        cKomad.setText("Cena kom.");
        cKomad.setWidth(110);
        TableColumn nv = new TableColumn(this.table, 0x1000000);
        nv.setText("Nab. cena");
        nv.setWidth(110);
        this.plus = Dugmici.getPlusButton((Composite)this.shell);
        this.plus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrijemnicaUnos.this.unosStavkePrijemnice(PrijemnicaUnos.this.shell, PrijemnicaUnos.this.table);
            }
        });
        this.minus = Dugmici.getMinusButton((Composite)this.shell);
        this.minus.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int i = PrijemnicaUnos.this.table.getSelectionIndex();
                Double d = Double.valueOf(PrijemnicaUnos.this.table.getItem(i).getText(4).replace(',', '.'));
                PrijemnicaUnos.this.table.remove(i);
                PrijemnicaUnos.this.stavke.remove(i);
                PrijemnicaUnos.this.ukupnaVred -= d.doubleValue();
                PrijemnicaUnos.this.total.setText(Konstante.getNumber2(PrijemnicaUnos.this.ukupnaVred) + " din");
            }
        });
        Label separator2 = new Label((Composite)this.shell, 258);
        Label t = new Label((Composite)this.shell, 0);
        t.setText("Ukupna vrednost prijemnice:");
        t.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.total = new Label((Composite)this.shell, 0);
        this.total.setText("");
        this.total.setBackground(this.shell.getDisplay().getSystemColor(22));
        Label separator3 = new Label((Composite)this.shell, 258);
        Button cancelButt = Dugmici.getCancelButton(this.shell);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrijemnicaUnos.this.parent.getControl().getShell().close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(this.shell);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(this.shell);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PrijemnicaUnos.this.stavke.size() < 1) {
                    Konstante.getPoruka(PrijemnicaUnos.this.shell, "Morate uneti podatke za bar jedan artikal !");
                    return;
                }
                Prijemnica p = new Prijemnica();
                try {
                    Calendar dc = Calendar.getInstance();
                    if (PrijemnicaUnos.this.datum.getResult().after(new Date())) {
                        Konstante.getPoruka(PrijemnicaUnos.this.shell, "Uneti datum je neprihvatljiv!");
                        return;
                    }
                    dc.setTime(PrijemnicaUnos.this.datum.getResult());
                    String brojPrijemnice = PrijemnicaUnos.this.server.selectNextPrijemnicaNumber(PrijemnicaUnos.this.crno.getSelection(), PrijemnicaUnos.this.type, PrijemnicaUnos.this.datum.getResult());
                    p.setBrPrijemnice(brojPrijemnice);
                    p.setDobavljac(PrijemnicaUnos.this.dobavljaci.get(PrijemnicaUnos.this.dobavljac.getSelectionIndex()));
                    p.setDatumPrijemnice(PrijemnicaUnos.this.datum.getResult());
                    p.setDatumUnosa(new Date());
                    p.setUname(PrijemnicaUnos.this.server.getUser().getName());
                    p.setOpis(opis.getText());
                    p.setTotal(PrijemnicaUnos.this.ukupnaVred);
                    p.setTip(PrijemnicaUnos.this.type);
                    p.setCrno(PrijemnicaUnos.this.crno.getSelection());
                    for (PrijemnicaStavka ps : PrijemnicaUnos.this.stavke) {
                        ps.setPrijemnica(p);
                        if (PrijemnicaUnos.this.type.getTip() != TipTrebovanja.DokumentAtribut.IZLAZNI) continue;
                        ps.setKolicina(-ps.getKolicina().doubleValue());
                    }
                    p.setStavke(PrijemnicaUnos.this.stavke);
                    try {
                        PrijemnicaUnos.this.server.addPrijemnica(p, PrijemnicaUnos.this.stavke);
                    }
                    catch (Exception ex) {
                        Konstante.getPoruka(PrijemnicaUnos.this.shell, ex.getMessage());
                        Logger.getLogger(PrijemnicaUnos.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                        return;
                    }
                    for (PrijemnicaStavka ps : PrijemnicaUnos.this.stavke) {
                        PrijemnicaUnos.this.sravniStavkuPrijemnice(ps);
                    }
                    PrijemnicaUnos.this.shell.close();
                }
                catch (InputException inputException) {
                    // empty catch block
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        data.horizontalSpan = 2;
        pm.setLayoutData((Object)data);
        d.setLayoutData((Object)data);
        dat.setLayoutData((Object)data);
        dat2.setLayoutData((Object)data);
        c.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.heightHint = 25;
        data.horizontalAlignment = 16384;
        ma.setLayoutData((Object)data);
        this.dobavljac.setLayoutData((Object)data);
        this.datum.getControl().setLayoutData((Object)data);
        this.datum2.getControl().setLayoutData((Object)data);
        this.total.setLayoutData((Object)data);
        this.crno.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        opisL.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator1.setLayoutData((Object)data);
        separator2.setLayoutData((Object)data);
        separator3.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 620;
        data.heightHint = 150;
        this.table.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.heightHint = 60;
        data.widthHint = 600;
        opis.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 250;
        data.horizontalAlignment = 16384;
        t.setLayoutData((Object)data);
        this.shell.open();
    }

    public void unosStavkePrijemnice(Shell shell, final Table table) {
        final Shell shell2 = new Shell(shell.getDisplay());
        shell2.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 4;
        int y = bounds.y + rect.height / 4;
        shell2.setLocation(x, y);
        SortedMap<String, Long> zalihe = this.server.getArtikli(this.magacin.getId());
        if (zalihe.size() < 1) {
            Konstante.getPoruka(shell, "U magacinu nema artikala!");
            return;
        }
        final SWTContainer parent2 = new SWTContainer((Composite)shell2);
        Label pk2 = new Label((Composite)shell2, 0);
        pk2.setText("Stanje (" + this.magacin.getNaziv().toLowerCase() + ")");
        pk2.setBackground(shell2.getDisplay().getSystemColor(22));
        this.preostalaKolicina2 = new Label((Composite)shell2, 0);
        this.preostalaKolicina2.setText("");
        this.preostalaKolicina2.setSize(y, y);
        this.preostalaKolicina2.setBackground(shell2.getDisplay().getSystemColor(22));
        Label p = new Label((Composite)shell2, 0);
        p.setText("Pretraga:");
        p.setBackground(shell.getDisplay().getSystemColor(22));
        this.pretraga = new Text((Composite)shell2, 0);
        this.pretraga.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String str = PrijemnicaUnos.this.pretraga.getText();
                    PrijemnicaUnos.this.artikal.removeAll();
                    if (str.length() > 0) {
                        for (String s : PrijemnicaUnos.this.server.getArtikliBezSlozByTacanBarCodeIliNaziv(PrijemnicaUnos.this.magacin.getId(), str).keySet()) {
                            PrijemnicaUnos.this.artikal.add(s);
                        }
                    }
                    if (PrijemnicaUnos.this.artikal.getItems().length == 0 && str.length() >= 3) {
                        for (String s : PrijemnicaUnos.this.server.getArtikliBezSlozByNameBarCode(PrijemnicaUnos.this.magacin.getId(), str).keySet()) {
                            PrijemnicaUnos.this.artikal.add(s);
                        }
                    }
                    PrijemnicaUnos.this.artikal.select(0);
                }
            }
        });
        Label a = new Label((Composite)shell2, 0);
        a.setText("Artikal:");
        a.setBackground(shell2.getDisplay().getSystemColor(22));
        this.artikal = new Combo((Composite)shell2, 2572);
        for (String s : zalihe.keySet()) {
            this.artikal.add(s);
        }
        this.artikal.select(0);
        this.artikal.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                if (PrijemnicaUnos.this.crno.getSelection()) {
                    PrijemnicaUnos.this.preostalaKolicina2.setText(Konstante.getNumber4(PreostalaKolicina.izracunajZaliheCrne(art, PrijemnicaUnos.this.magacin, PrijemnicaUnos.this.server)));
                } else {
                    PrijemnicaUnos.this.preostalaKolicina2.setText(Konstante.getNumber4(PreostalaKolicina.izracunajZaliheBele(art, PrijemnicaUnos.this.magacin, PrijemnicaUnos.this.server)));
                }
                PrijemnicaUnos.this.tv2.setText(Konstante.getNumber2(art.getTrenutnaNV()));
                PrijemnicaUnos.this.tv2bp.setText(Konstante.getNumber2(art.getTrenutnaNV() * (1.0 - Konstante.getKontraPdvPoPG(art.getPoreskaGrupa()))));
            }
        });
        Label k = new Label((Composite)shell2, 0);
        k.setText("Kolicina :");
        k.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
        Label cbp = new Label((Composite)shell2, 0);
        cbp.setText("Cena po komadu bez poreza:");
        cbp.setBackground(shell2.getDisplay().getSystemColor(22));
        this.cenaKomadBezPoreza = new DoubleInput2(parent2, "Cena po komadu bez poreza", false);
        Label ck = new Label((Composite)shell2, 0);
        ck.setText("Cena po komadu sa porezom:");
        ck.setBackground(shell2.getDisplay().getSystemColor(22));
        this.cenaKomad = new DoubleInput2(parent2, "Cena po komadu sa porezom", false);
        Label nvbp = new Label((Composite)shell2, 0);
        nvbp.setText("Nabavna vrednost bez poreza:");
        nvbp.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 nabVrednostBezPoreza = new DoubleInput2(parent2, "Nabavna vrednost bez poreza", false);
        Label nv = new Label((Composite)shell2, 0);
        nv.setText("Nabavna vrednost sa porezom:");
        nv.setBackground(shell2.getDisplay().getSystemColor(22));
        final DoubleInput2 nabVrednost = new DoubleInput2(parent2, "Nabavna vrednost", false);
        Label tvbp = new Label((Composite)shell2, 0);
        tvbp.setText("Trenutna nab. vr. bez poreza:");
        tvbp.setBackground(shell2.getDisplay().getSystemColor(22));
        this.tv2bp = new Label((Composite)shell2, 0);
        this.tv2bp.setBackground(shell2.getDisplay().getSystemColor(22));
        Label tv = new Label((Composite)shell2, 0);
        tv.setText("Trenutna nab. vr. sa porezom:");
        tv.setBackground(shell2.getDisplay().getSystemColor(22));
        this.tv2 = new Label((Composite)shell2, 0);
        this.tv2.setBackground(shell2.getDisplay().getSystemColor(22));
        this.cenaKomadBezPoreza.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent ke) {
                Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                double pdv = Konstante.getPdvPoPG(art.getPoreskaGrupa());
                double kontraPdv = Konstante.getKontraPdvPoPG(art.getPoreskaGrupa());
                try {
                    double temp = PrijemnicaUnos.this.cenaKomadBezPoreza.getResult();
                    PrijemnicaUnos.this.cenaKomad.setResult(temp * (1.0 + pdv));
                    System.out.println("prodajna cena " + PrijemnicaUnos.this.cenaKomad.getResult());
                    nabVrednostBezPoreza.setResult(temp * kolicina.getResult());
                    nabVrednost.setResult(PrijemnicaUnos.this.cenaKomad.getResult() * kolicina.getResult());
                }
                catch (InputException ex) {
                    Logger.getLogger(PrijemnicaUnos.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            public void keyPressed(KeyEvent ke) {
            }
        });
        this.cenaKomad.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                double pdv = Konstante.getPdvPoPG(art.getPoreskaGrupa());
                double kontraPdv = Konstante.getKontraPdvPoPG(art.getPoreskaGrupa());
                try {
                    double temp = PrijemnicaUnos.this.cenaKomad.getResult();
                    PrijemnicaUnos.this.cenaKomadBezPoreza.setResult(temp * (1.0 - kontraPdv));
                    nabVrednostBezPoreza.setResult(PrijemnicaUnos.this.cenaKomadBezPoreza.getResult() * kolicina.getResult());
                    nabVrednost.setResult(temp * kolicina.getResult());
                }
                catch (InputException ex) {
                    Logger.getLogger(PrijemnicaUnos.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        nabVrednostBezPoreza.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                double pdv = Konstante.getPdvPoPG(art.getPoreskaGrupa());
                double kontraPdv = Konstante.getKontraPdvPoPG(art.getPoreskaGrupa());
                try {
                    double temp = nabVrednostBezPoreza.getResult();
                    PrijemnicaUnos.this.cenaKomadBezPoreza.setResult(temp / kolicina.getResult());
                    PrijemnicaUnos.this.cenaKomad.setResult(PrijemnicaUnos.this.cenaKomadBezPoreza.getResult() * (1.0 + pdv));
                    nabVrednost.setResult(temp * (1.0 + pdv));
                }
                catch (InputException ex) {
                    Logger.getLogger(PrijemnicaUnos.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        nabVrednost.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                double pdv = Konstante.getPdvPoPG(art.getPoreskaGrupa());
                double kontraPdv = Konstante.getKontraPdvPoPG(art.getPoreskaGrupa());
                try {
                    double temp = nabVrednost.getResult();
                    PrijemnicaUnos.this.cenaKomadBezPoreza.setResult(temp * (1.0 - kontraPdv) / kolicina.getResult());
                    PrijemnicaUnos.this.cenaKomad.setResult(temp / kolicina.getResult());
                    nabVrednostBezPoreza.setResult(temp * (1.0 - kontraPdv));
                }
                catch (InputException ex) {
                    Logger.getLogger(PrijemnicaUnos.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                parent2.getControl().getShell().close();
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    if (kolicina.getResult() * PrijemnicaUnos.this.cenaKomad.getResult() - 0.01 <= nabVrednost.getResult() && nabVrednost.getResult() <= kolicina.getResult() * PrijemnicaUnos.this.cenaKomad.getResult() + 0.01) {
                        Artikal art = PrijemnicaUnos.this.server.getArtikal(PrijemnicaUnos.this.artikal.getItem(PrijemnicaUnos.this.artikal.getSelectionIndex()));
                        PrijemnicaStavka sp = new PrijemnicaStavka();
                        sp.setArtikal(art);
                        sp.setPdvStopa(Konstante.getPdvPoPG(art.getPoreskaGrupa()));
                        sp.setKolicina(kolicina.getResult());
                        sp.setVrednost(nabVrednostBezPoreza.getResult());
                        sp.setKomad(PrijemnicaUnos.this.cenaKomadBezPoreza.getResult());
                        PrijemnicaUnos.this.stavke.add(sp);
                        TableItem item = new TableItem(table, 0);
                        item.setText(new String[]{art.getName(), Konstante.getNumber4(kolicina.getResult()), art.getJedinicaMere(), Konstante.getNumber2(PrijemnicaUnos.this.cenaKomad.getResult()), Konstante.getNumber2(nabVrednost.getResult())});
                        PrijemnicaUnos.this.ukupnaVred += nabVrednost.getResult().doubleValue();
                    } else {
                        Konstante.getPoruka(shell2, "Nabavna vrednsot nije u skladu sa jedinicnom cenom i kolicinom!");
                        return;
                    }
                    PrijemnicaUnos.this.total.setText(Konstante.getNumber2(PrijemnicaUnos.this.ukupnaVred) + " din");
                    shell2.close();
                }
                catch (InputException ex) {
                    Konstante.getPoruka(shell2, ex.getMessage());
                }
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        this.artikal.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        a.setLayoutData((Object)data);
        k.setLayoutData((Object)data);
        nv.setLayoutData((Object)data);
        nvbp.setLayoutData((Object)data);
        tv.setLayoutData((Object)data);
        tvbp.setLayoutData((Object)data);
        this.tv2.setLayoutData((Object)data);
        this.tv2bp.setLayoutData((Object)data);
        cbp.setLayoutData((Object)data);
        ck.setLayoutData((Object)data);
        p.setLayoutData((Object)data);
        cancelButt.setLayoutData((Object)data);
        kolicina.getControl().setLayoutData((Object)data);
        nabVrednost.getControl().setLayoutData((Object)data);
        nabVrednostBezPoreza.getControl().setLayoutData((Object)data);
        this.cenaKomad.getControl().setLayoutData((Object)data);
        this.cenaKomadBezPoreza.getControl().setLayoutData((Object)data);
        this.pretraga.setLayoutData((Object)data);
        this.preostalaKolicina2.setLayoutData((Object)data);
        pk2.setLayoutData((Object)data);
        shell2.pack();
        shell2.open();
    }

    public void sravniStavkuPrijemnice(PrijemnicaStavka ps) throws InputException {
        try {
            Artikal art = ps.getArtikal();
            Kartica kartica1 = new Kartica();
            kartica1.setArtikal(art);
            kartica1.setOdeljenje(this.magacin);
            kartica1.setCrno(this.crno.getSelection());
            kartica1.setDatum(Konstante.getDatumKartica(this.datum.getResult(), this.server, 10));
            kartica1.setKolicina(ps.getKolicina());
            kartica1.setNabavnaCena(ps.getKomad());
            kartica1.setDokument(this.brojPrijemnice + " (p)");
            double trStanje1 = PreostalaKolicina.izracunajZalihe(art, this.magacin, this.server);
            trStanje1 += ps.getKolicina().doubleValue();
            double vrednost1 = ps.getVrednost();
            List<Kartica> kartice = this.server.readKartice(art, this.magacin);
            if (kartice.size() >= 1) {
                for (Kartica k : kartice) {
                    vrednost1 += k.getKolicina() * k.getNabavnaCena();
                }
            }
            if (this.poPoslednjimCenama.booleanValue()) {
                art.setTrenutnaNV(ps.getKomad() * (1.0 + Konstante.getPdvPoPG(art.getPoreskaGrupa())));
            } else if (trStanje1 != 0.0) {
                art.setTrenutnaNV(vrednost1 / trStanje1 * (1.0 + Konstante.getPdvPoPG(art.getPoreskaGrupa())));
            } else {
                art.setTrenutnaNV(0.0);
            }
            this.server.updateArtikalNV(art);
            this.server.addKartica(kartica1);
        }
        catch (InputException ex) {
            Konstante.getPoruka(this.shell, ex.getMessage());
        }
    }
}

