/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Podgrupe {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private PodgrupaArtikala active;
    private int rb = 0;
    Composite dugmici;

    public Podgrupe(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/podgrupeV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 500;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_PODGRUPE_ARTIKALA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 55;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_SPISAK_PODGRUPA_ARTIKALA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(this.barmasterText.getString("TEXT_ATRIBUTI_PODGRUPE_ARTIKALA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_NOVA_PODGRUPA_ARTIKALA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Podgrupe.this.addPodgrupaArtikala();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_IZMENA_PODGRUPE_ARTIKALA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Podgrupe.this.updatePodgrupaArtikala();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE_PODGRUPE_ARTIKALA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Podgrupe.this.deletePodgrupaArtikala();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = Podgrupe.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                Podgrupe.this.setActivePodgrupaArtikala((PodgrupaArtikala)Podgrupe.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
    }

    private void reload() {
        this.listModel.clear();
        List<PodgrupaArtikala> podgrupe = this.server.readPodgrupePoPrioritetu();
        this.rb = podgrupe.size() + 1;
        for (PodgrupaArtikala l : podgrupe) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addPodgrupaArtikala() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        PodgrupaArtikalaDialog sd = new PodgrupaArtikalaDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVE_PODGRUPE_ARTIKALA"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_UNOS_PODGRUPE"), new Object[0]) + ":   " + sd.getResult());
            this.restoran.getServer().addPodrupaArtikala(sd.getResult());
            this.reload();
        }
    }

    private void updatePodgrupaArtikala() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        PodgrupaArtikalaDialog sd = new PodgrupaArtikalaDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_IZMENA_PODGRUPE_ARTIKALA"), new Object[0])), this.active);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_PODGRUPE"), new Object[0]) + ": " + sd.getResult());
            this.restoran.getServer().updatePodgrupaArtikala(sd.getResult());
            this.reload();
        }
    }

    private void deletePodgrupaArtikala() {
        if (this.active == null) {
            return;
        }
        if (this.server.readArtikal(this.active).size() >= 1) {
            int style = 65600;
            MessageBox messageBox = new MessageBox(this.shell, style);
            messageBox.setText(String.format(this.barmasterText.getString("TEXT_INFO"), new Object[0]));
            messageBox.setMessage(String.format(this.barmasterText.getString("PORUKA_MORATE_PRETHODNO_OBRISATI_SVE_ARTIKLE_IZABRANE_PODGRUPE"), new Object[0]));
            messageBox.open();
        } else {
            int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_PODGRUPU_ARTIKALA"), this.active.getNaziv()));
            if (ok == 0) {
                this.server.log(String.format(this.barmasterText.getString("LOG_BRISANJE_PODGRUPE_ARTIKALA"), new Object[0]) + ": " + this.active);
                this.restoran.getServer().deletePodgrupaArtikala(this.active);
                this.active = null;
                this.display.setText("");
                this.reload();
            }
        }
    }

    private void setActivePodgrupaArtikala(PodgrupaArtikala o) {
        this.active = o;
        List<Artikal> artikli = this.server.readArtikal(o);
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_SKRACENI_NAZIV"), new Object[0]) + ": ").append(o.getSkrNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_GRUPA"), new Object[0]) + ": ").append(o.getGrupa().getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_PRIORITET"), new Object[0]) + ": ").append(o.getPrioritet()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_ARTIKLI"), new Object[0]) + ": ").append("\n");
        for (int i = 0; i < artikli.size(); ++i) {
            bld.append("- ").append(artikli.get(i).getName()).append("\n");
        }
        this.display.setText(bld.toString());
    }

    private class PodgrupaArtikalaDialog {
        private TextInput2 name;
        private TextInput2 skrName;
        private Combo grupe;
        private IntInput2 prioritet;
        private PodgrupaArtikala input;
        private PodgrupaArtikala result;
        String putanjaSlike;
        Label slika;
        Shell shell3;
        List<GrupaArtikala> ga;

        public PodgrupaArtikalaDialog(SWTContainer parent, PodgrupaArtikala input) {
            this.ga = Podgrupe.this.server.readGrupeArtikala();
            this.input = input;
            this.shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Label n = new Label((Composite)this.shell3, 0);
            n.setBackground(this.shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(Podgrupe.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
            this.name = new TextInput2(parent, String.format(Podgrupe.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]), false);
            if (input == null) {
                this.name.getControl().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent fe) {
                    }

                    public void focusLost(FocusEvent fe) {
                        try {
                            PodgrupaArtikalaDialog.this.skrName.setResult(PodgrupaArtikalaDialog.this.name.getResult());
                        }
                        catch (InputException ex) {
                            Logger.getLogger(Podgrupe.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
            Label sn = new Label((Composite)this.shell3, 0);
            sn.setBackground(this.shell3.getDisplay().getSystemColor(22));
            sn.setText(String.format(Podgrupe.this.barmasterText.getString("TEXT_SKRACENI_NAZIV"), new Object[0]));
            this.skrName = new TextInput2(parent, String.format(Podgrupe.this.barmasterText.getString("TEXT_SKRACENI_NAZIV"), new Object[0]), false);
            Label p = new Label((Composite)this.shell3, 0);
            p.setBackground(this.shell3.getDisplay().getSystemColor(22));
            p.setText(String.format(Podgrupe.this.barmasterText.getString("TEXT_PRIORITET"), new Object[0]));
            this.prioritet = new IntInput2(parent, String.format(Podgrupe.this.barmasterText.getString("TEXT_PRIORITET"), new Object[0]), (Integer)Podgrupe.this.rb, false);
            Label g = new Label((Composite)this.shell3, 0);
            g.setBackground(this.shell3.getDisplay().getSystemColor(22));
            g.setText(String.format(Podgrupe.this.barmasterText.getString("TEXT_GRUPA_ARTIKALA"), new Object[0]));
            this.grupe = new Combo((Composite)this.shell3, 2572);
            for (GrupaArtikala grupa : this.ga) {
                this.grupe.add(grupa.toString());
                this.grupe.select(0);
            }
            Button button = new Button((Composite)this.shell3, 8);
            Image izb = new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/izborSlike.gif");
            button.setImage(izb);
            button.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)izb));
            this.slika = new Label((Composite)this.shell3, 0);
            this.slika.setBackground(this.shell3.getDisplay().getSystemColor(22));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(PodgrupaArtikalaDialog.this.shell3, 4100);
                    File file = new File(".");
                    dialog.setFilterPath(ImagePath.getPath() + "\\artikli");
                    String path = dialog.open();
                    if (path != null) {
                        file = new File(path);
                        if (file.isFile()) {
                            PodgrupaArtikalaDialog.this.putanjaSlike = file.toString();
                        }
                        PodgrupaArtikalaDialog.this.slika.setImage(new Image((Device)PodgrupaArtikalaDialog.this.shell3.getDisplay(), PodgrupaArtikalaDialog.this.putanjaSlike));
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton(this.shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PodgrupaArtikalaDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(this.shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(this.shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PodgrupaArtikalaDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            this.shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            data.horizontalSpan = 2;
            n.setLayoutData((Object)data);
            sn.setLayoutData((Object)data);
            g.setLayoutData((Object)data);
            p.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            data.heightHint = 30;
            this.name.getControl().setLayoutData((Object)data);
            this.skrName.getControl().setLayoutData((Object)data);
            this.grupe.setLayoutData((Object)data);
            this.prioritet.getControl().setLayoutData((Object)data);
            data = new GridData(64);
            data.widthHint = 100;
            data.heightHint = 60;
            this.slika.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 40;
            data.horizontalSpan = 2;
            button.setLayoutData((Object)data);
            this.shell3.pack();
        }

        private void ok(SWTContainer parent) {
            PodgrupaArtikala pga = this.input != null ? this.input : new PodgrupaArtikala();
            try {
                pga.setNaziv(this.name.getResult());
                pga.setSkrNaziv(this.skrName.getResult());
                pga.setGrupa(this.ga.get(this.grupe.getSelectionIndex()));
                pga.setPrioritet(this.prioritet.getResult());
                if (this.putanjaSlike != null) {
                    pga.setSlika(this.putanjaSlike);
                }
                this.result = pga;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(Podgrupe.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        public PodgrupaArtikala getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getNaziv());
            this.skrName.setResult(this.input.getSkrNaziv());
            Long grupaId = this.input.getGrupa().getId();
            for (GrupaArtikala grar : this.ga) {
                if (grupaId.equals(grar.getId())) {
                    this.grupe.select(this.ga.indexOf(grar));
                }
                this.prioritet.setResult(this.input.getPrioritet());
                if (this.input.getSlika() == null) continue;
                this.slika.setImage(new Image((Device)this.shell3.getDisplay(), this.input.getSlika()));
            }
        }
    }
}

