/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.GrupaOdeljenja;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.IntInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Odeljenja {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Odeljenje active;
    Composite dugmici;
    private Button b;
    private Shell outerShell;

    public Odeljenja(SWTContainer owner, Restoran hostel, boolean bo, Shell outerShell) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.outerShell = outerShell;
        Shell shell = this.parent.getControl().getShell();
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/odeljenjaV.gif"));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_PROIZVODNA_MESTA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_SPISAK_PROIZVODNIH_MESTA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(this.barmasterText.getString("TEXT_ATRIBUTI_PROIZVODNOG_MESTA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_NOVO_PROIZVODNO_MESTO"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Odeljenja.this.addOdeljenje();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_IZMENA_PROIZVODNOG_MESTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Odeljenja.this.updateOdeljenje();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE_PROIZVODNOG_MESTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Odeljenja.this.deleteOdeljenje();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = Odeljenja.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                Odeljenja.this.setActiveOdeljenje((Odeljenje)Odeljenja.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        this.listModel.clear();
        List<Odeljenje> odeljenja = this.restoran.getServer().readOdeljenje();
        for (Odeljenje l : odeljenja) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addOdeljenje() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        Odeljenje mag = this.server.returnMagacin();
        boolean magExists = false;
        if (mag != null) {
            magExists = true;
        }
        OdeljenjeDialog od = new OdeljenjeDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVOG_PROIZVODNOG_MESTA"), new Object[0])), null, magExists, false);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_UNOS_PROZIVODNOG_MESTA_SKR"), new Object[0]) + ": " + od.getResult());
            this.restoran.getServer().addOdeljenje(od.getResult());
            this.reload();
        }
    }

    private void updateOdeljenje() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        Odeljenje mag = this.server.returnMagacin();
        boolean magExists = false;
        if (mag != null) {
            magExists = true;
        }
        OdeljenjeDialog od = new OdeljenjeDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_IZMENA_PROIZVODNOG_MESTA"), new Object[0])), this.active, magExists, this.active.getMagacin() != null ? this.active.getMagacin() : mag != null && mag.getId() == this.active.getId());
        SWTContainerClass.makeEnd(shell2);
        Odeljenje o = od.getResult();
        if (o != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_PROIZVODNOG_MESTA_SKR"), new Object[0]) + ": " + o);
            o.setArtikli(null);
            this.restoran.getServer().updateOdeljenje(o);
            this.reload();
        }
    }

    private void deleteOdeljenje() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_PROIZVODNO_MESTO_IZ_SISTEMA"), this.active.getNaziv()));
        if (ok == 0) {
            this.server.log(String.format(this.barmasterText.getString("LOG_BRISANJE_PROIZVODNOG_MESTA"), new Object[0]) + ": " + this.active);
            this.restoran.getServer().deleteOdeljenje(this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveOdeljenje(Odeljenje o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_KRATAK_NAZIV"), new Object[0]) + ": ").append(o.getKratkiNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_DEFAULT_STAMPAC"), new Object[0]) + ": ").append(o.getStampac() == null ? "/" : o.getStampac()).append("\n");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_PRIKAZ"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_JELO"), new Object[0]) + ": ").append(this.active.getJelo() != false ? String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])).append("\n");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_PRIKAZ"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_PICE"), new Object[0]) + ": ").append(this.active.getPice() != false ? String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])).append("\n");
        this.display.setText(bld.toString());
        if (o.getNaziv().equalsIgnoreCase(Konstante.getMagacinName())) {
            // empty if block
        }
    }

    private class OdeljenjeDialog {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private TextInput2 name;
        private TextInput2 shortName;
        private IntInput2 blanko;
        private IntInput2 kopije;
        private Button magacin;
        private Button jelo;
        private Button pice;
        private boolean magacinExists = false;
        private boolean isMagacin = false;
        final Combo stampac;
        private ComboViewer cvGrupa;
        List<Stampac> stampaci = Odeljenja.access$600(Odeljenja.this).readStampac();
        private Odeljenje input;
        private Odeljenje result;
        String putanjaSlike;
        Label slika;
        Shell shell3;
        List<Button> pmButtons;
        private List<Button> kaseDugmici = new LinkedList<Button>();

        public OdeljenjeDialog(SWTContainer parent, Odeljenje inputOd, boolean magacinExists, boolean isMagacin) {
            this.input = inputOd;
            this.magacinExists = magacinExists;
            this.isMagacin = isMagacin;
            this.shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Label m = new Label((Composite)this.shell3, 0);
            m.setBackground(this.shell3.getDisplay().getSystemColor(22));
            m.setText(String.format(this.barmasterText.getString("TEXT_MAGACIN"), new Object[0]));
            this.magacin = new Button((Composite)this.shell3, 32);
            this.magacin.setEnabled(Odeljenja.this.server.vratiMagacin() == false);
            this.magacin.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    OdeljenjeDialog.this.odeljenjeJeMagacin();
                }
            });
            Label grupaL = new Label((Composite)this.shell3, 0);
            grupaL.setText(String.format(Konstante.getBundle().getString("TEXT_GRUPA"), new Object[0]));
            this.cvGrupa = new ComboViewer((Composite)this.shell3, 12);
            this.cvGrupa.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.cvGrupa.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    String text = "";
                    if (element instanceof GrupaOdeljenja) {
                        GrupaOdeljenja go = (GrupaOdeljenja)element;
                        text = go.getNaziv();
                    }
                    return text;
                }
            });
            this.cvGrupa.setInput(Odeljenja.this.server.findAllGrupeOdeljenja());
            if (this.input != null && ((List)this.cvGrupa.getInput()).contains(this.input.getGrupaOdeljenja())) {
                this.cvGrupa.setSelection((ISelection)new StructuredSelection(Arrays.asList(this.input.getGrupaOdeljenja())));
            }
            Label n = new Label((Composite)this.shell3, 0);
            n.setBackground(this.shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
            this.name = new TextInput2(parent, String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]), false);
            if (this.input == null) {
                this.name.getControl().addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent fe) {
                    }

                    public void focusLost(FocusEvent fe) {
                        try {
                            OdeljenjeDialog.this.shortName.setResult(OdeljenjeDialog.this.name.getResult());
                        }
                        catch (InputException ex) {
                            Logger.getLogger(Odeljenja.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
            Label s = new Label((Composite)this.shell3, 0);
            s.setBackground(this.shell3.getDisplay().getSystemColor(22));
            s.setText(String.format(this.barmasterText.getString("TEXT_KRATAK_NAZIV"), new Object[0]));
            this.shortName = new TextInput2(parent, String.format(this.barmasterText.getString("TEXT_KRATAK_NAZIV"), new Object[0]), false);
            Label label1 = new Label((Composite)this.shell3, 0);
            label1.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_DEFAULT_STAMPACA"), new Object[0]));
            label1.setBackground(this.shell3.getDisplay().getSystemColor(22));
            this.stampac = new Combo((Composite)this.shell3, 2572);
            Label jl = new Label((Composite)this.shell3, 0);
            jl.setBackground(this.shell3.getDisplay().getSystemColor(22));
            jl.setText(String.format(Konstante.getBundle().getString("TEXT_DNEVNI_PROMET_UGOSTITELJA_SKR"), new Object[0]) + " " + String.format(Konstante.getBundle().getString("TEXT_PRIKAZ"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_JELO"), new Object[0]));
            this.jelo = new Button((Composite)this.shell3, 32);
            Label pl = new Label((Composite)this.shell3, 0);
            pl.setBackground(this.shell3.getDisplay().getSystemColor(22));
            pl.setText(String.format(Konstante.getBundle().getString("TEXT_DNEVNI_PROMET_UGOSTITELJA_SKR"), new Object[0]) + " " + String.format(Konstante.getBundle().getString("TEXT_PRIKAZ"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_PICE"), new Object[0]));
            this.pice = new Button((Composite)this.shell3, 32);
            Label empL = new Label((Composite)this.shell3, 0);
            Group gProdajnaMesta = new Group((Composite)this.shell3, 0);
            gProdajnaMesta.setLayout((Layout)new GridLayout());
            ((GridLayout)gProdajnaMesta.getLayout()).verticalSpacing = 10;
            ((GridLayout)gProdajnaMesta.getLayout()).marginTop = 5;
            ((GridLayout)gProdajnaMesta.getLayout()).marginBottom = 5;
            ((GridLayout)gProdajnaMesta.getLayout()).marginLeft = 5;
            gProdajnaMesta.setText(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_MESTA"), new Object[0]));
            List<ProdajnoMesto> pms = Odeljenja.this.server.findAllProdajnoMesto();
            this.pmButtons = new LinkedList<Button>();
            for (ProdajnoMesto pm : pms) {
                Odeljenja.this.b = new Button((Composite)gProdajnaMesta, 32);
                Odeljenja.this.b.setText(pm.getNaziv());
                Odeljenja.this.b.setData((Object)pm);
                Odeljenja.this.b.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
                Odeljenja.this.b.setEnabled(!isMagacin);
                if (this.input != null && !this.input.getMagacin().booleanValue() && this.input.getProdajnaMesta().contains(pm)) {
                    Odeljenja.this.b.setSelection(true);
                }
                if (this.input == null) {
                    Odeljenja.this.b.setSelection(true);
                }
                this.pmButtons.add(Odeljenja.this.b);
            }
            for (Stampac st : this.stampaci) {
                this.stampac.add(st.toString());
                this.stampac.select(0);
            }
            Button button = new Button((Composite)this.shell3, 8);
            Image choiceImg = new Image((Device)this.shell3.getDisplay(), ImagePath.getPath() + "/izborSlike.gif");
            button.setImage(choiceImg);
            button.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)choiceImg));
            this.slika = new Label((Composite)this.shell3, 0);
            this.slika.setBackground(this.shell3.getDisplay().getSystemColor(22));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(OdeljenjeDialog.this.shell3, 4100);
                    File file = new File(".");
                    dialog.setFilterPath(ImagePath.getPath() + "\\odeljenja");
                    String path = dialog.open();
                    if (path != null) {
                        file = new File(path);
                        if (file.isFile()) {
                            OdeljenjeDialog.this.putanjaSlike = file.toString();
                        }
                        Image img = new Image((Device)OdeljenjeDialog.this.shell3.getDisplay(), OdeljenjeDialog.this.putanjaSlike);
                        OdeljenjeDialog.this.slika.setImage(img);
                        OdeljenjeDialog.this.slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
                    }
                }
            });
            Group gKase = new Group((Composite)this.shell3, 0);
            gKase.setText(String.format(Konstante.getBundle().getString("TEXT_KASE"), new Object[0]));
            gKase.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
            gKase.setLayout((Layout)new GridLayout());
            for (Kasa kasa : Odeljenja.this.server.findAllKasa()) {
                Button bK = new Button((Composite)gKase, 32);
                bK.setData((Object)kasa);
                bK.setText(kasa.getOznaka());
                bK.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                for (Odeljenje o : kasa.getOdeljenja()) {
                    System.out.println(o.getNaziv());
                }
                if (this.input != null && !this.input.getMagacin().booleanValue() && kasa.getOdeljenja().contains(this.input)) {
                    bK.setSelection(true);
                }
                this.kaseDugmici.add(bK);
            }
            Button cancelButt = Dugmici.getCancelButton(this.shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdeljenjeDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(this.shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(this.shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OdeljenjeDialog.this.ok(parent2);
                }
            });
            if (this.input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            this.shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            data.horizontalSpan = 2;
            n.setLayoutData((Object)data);
            m.setLayoutData((Object)data);
            s.setLayoutData((Object)data);
            jl.setLayoutData((Object)data);
            pl.setLayoutData((Object)data);
            label1.setLayoutData((Object)data);
            grupaL.setLayoutData((Object)data);
            empL.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.name.getControl().setLayoutData((Object)data);
            this.magacin.setLayoutData((Object)data);
            this.shortName.getControl().setLayoutData((Object)data);
            this.stampac.setLayoutData((Object)data);
            this.jelo.setLayoutData((Object)data);
            this.pice.setLayoutData((Object)data);
            gProdajnaMesta.setLayoutData((Object)new GridData(4, 4, true, true));
            data = new GridData(64);
            data.widthHint = 40;
            data.heightHint = 30;
            this.slika.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 40;
            data.horizontalSpan = 2;
            button.setLayoutData((Object)data);
            this.shell3.pack();
        }

        protected void odeljenjeJeMagacin() {
            if (this.magacin.getSelection()) {
                Odeljenja.this.b.setEnabled(false);
                Odeljenja.this.b.setSelection(false);
            } else {
                Odeljenja.this.b.setEnabled(true);
                Odeljenja.this.b.setSelection(true);
            }
        }

        private void ok(SWTContainer parent) {
            if (this.cvGrupa.getSelection().isEmpty()) {
                SWTMessage.showLocalizedWarningDialog(this.shell3, String.format(Konstante.getBundle().getString("PORUKA_MORATE_IZABRATI_GRUPU_PROIZVODNOG_MESTA"), new Object[0]));
                this.cvGrupa.getCombo().setFocus();
                this.cvGrupa.getCombo().setListVisible(true);
                return;
            }
            Odeljenje o = this.input != null ? this.input : new Odeljenje();
            try {
                o.setNaziv(this.name.getResult());
                o.setKratkiNaziv(this.shortName.getResult());
                if (Odeljenja.this.server.readStampac().size() < 1) {
                    o.setStampac(null);
                } else {
                    o.setStampac(this.stampaci.get(this.stampac.getSelectionIndex()));
                }
                GrupaOdeljenja go = (GrupaOdeljenja)((IStructuredSelection)this.cvGrupa.getSelection()).getFirstElement();
                o.setGrupaOdeljenja((GrupaOdeljenja)Odeljenja.this.server.getBase().find(GrupaOdeljenja.class, (Object)go.getId()));
                o.setJelo(this.jelo.getSelection());
                o.setPice(this.pice.getSelection());
                o.setMagacin(this.magacin.getSelection());
                if (this.putanjaSlike != null) {
                    o.setSlika(this.putanjaSlike);
                }
                LinkedList<ProdajnoMesto> pmList = new LinkedList<ProdajnoMesto>();
                for (Button button : this.pmButtons) {
                    if (!button.getSelection()) continue;
                    ProdajnoMesto pm = (ProdajnoMesto)button.getData();
                    pm = (ProdajnoMesto)Odeljenja.this.server.getBase().find(ProdajnoMesto.class, (Object)pm.getId());
                    pmList.add(pm);
                }
                o.setProdajnaMesta(pmList);
                try {
                    Odeljenja.this.server.deleteKasaOdeljenje(o);
                }
                catch (Exception e) {
                    System.out.println("Unosi se novo odeljenje");
                }
                for (Button b : this.kaseDugmici) {
                    if (!b.getSelection()) continue;
                    String name = b.getText();
                    Odeljenja.this.server.insertIntoKasa_Odeljenje(Odeljenja.this.server.getKasaByName(b.getText()), o);
                }
                this.result = o;
                parent.getControl().getShell().dispose();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().dispose();
        }

        public Odeljenje getResult() {
            return this.result;
        }

        private void loadData() {
            this.magacin.setSelection(this.input.getMagacin() == null ? false : this.input.getMagacin());
            this.name.setResult(this.input.getNaziv());
            this.shortName.setResult(this.input.getKratkiNaziv());
            if (this.input.getStampac() != null) {
                this.stampac.select(this.stampaci.indexOf(this.input.getStampac()));
            }
            if (this.input.getJelo() != null) {
                this.jelo.setSelection(this.input.getJelo().booleanValue());
            }
            if (this.input.getPice() != null) {
                this.pice.setSelection(this.input.getPice().booleanValue());
            }
            if (this.input.getSlika() != null) {
                this.slika.setImage(new Image((Device)this.shell3.getDisplay(), this.input.getSlika()));
            }
        }

        private void refreshOdeljenja() {
            Control[] controls = Odeljenja.this.outerShell.getChildren();
            ExpandBar eb = (ExpandBar)controls[0];
            ExpandItem[] items = eb.getItems();
            ExpandItem magacin = items[0];
            magacin.setExpanded(true);
            Composite mc = (Composite)magacin.getControl();
            mc.dispose();
            Composite com = new Composite((Composite)eb, 0);
            magacin.setControl((Control)com);
            Label l = new Label(com, 0);
            l.setText("Nesaaaaa");
        }
    }
}

