/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevniUtrosak;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Otpis;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.OtpisUtrosak;
import com.dev63.restoran.model.Proizvodnja;
import com.dev63.restoran.model.ProizvodnjaStavka;
import com.dev63.restoran.model.ProizvodnjaUtrosak;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.UtrosakDoc;
import com.dev63.restoran.model.UtrosakDocStavke;
import com.dev63.restoran.model.UtrosakDocUtrosak;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTMessage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class NovaRekonstrukcija {
    private DateInput2 datum;
    private RestoranServer server;
    public SWTContainer parent;
    public Shell shell;
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public NovaRekonstrukcija(SWTContainer parent, Restoran restoran, final boolean saZDom) {
        this.parent = parent;
        this.server = restoran.getServer();
        this.shell = parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(1, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        slika.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/artikliV.gif"));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 664 - slika.getImage().getBounds().width;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(saZDom ? String.format(Konstante.getBundle().getString("TEXT_DNEVNI_PROMET_2"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_DNEVNI_PROMET_2_BEZ_ZD"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 670;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout(2, false));
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 670;
        data.heightHint = 60;
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout(3, false));
        grupa3.setText("");
        grupa3.setLayoutData((Object)data);
        SWTContainer parent2 = new SWTContainer((Composite)grupa1);
        Label od = new Label((Composite)grupa1, 0);
        od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
        this.datum = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
        Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NovaRekonstrukcija.this.cancel();
            }
        });
        Button okButt = Dugmici.getOkButton((Composite)grupa3);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NovaRekonstrukcija.this.ok(saZDom);
            }
        });
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.horizontalIndent = 10;
        data.widthHint = 150;
        data.heightHint = 30;
        od.setLayoutData((Object)data);
        this.datum.getControl().setLayoutData((Object)data);
        SWTContainerClass.setDimension(this.shell);
    }

    private void cancel() {
        this.parent.getControl().getShell().close();
    }

    private void ok(boolean ZD2) {
        this.zdAndRacunZaPeriod(ZD2);
    }

    private synchronized void zdAndRacunZaPeriod(boolean ZD2) {
        try {
            if (ZD2) {
                this.server.updateZdBrojNUllzaPeriod(this.datum.getResult());
                if (this.server.getZdBrojIsNull()) {
                    Date firstPrviZd = this.server.getDatumisNotNUll();
                    boolean prodji = true;
                    long zdBroj = this.server.getZdBrojisNotNUllMax();
                    for (ZD zd : this.server.getAllZDListZdBrojNUll()) {
                        if (firstPrviZd.compareTo(zd.getDatum()) != 0) {
                            firstPrviZd = zd.getDatum();
                            prodji = true;
                        }
                        if (prodji) {
                            zd.setZdBroj(++zdBroj);
                            prodji = false;
                        } else {
                            zd.setZdBroj(zdBroj);
                        }
                        this.server.updateZD(zd);
                    }
                }
                if (this.server.getRacunZdBrojIsNull()) {
                    this.server.updateRacunZdBroj();
                }
            }
            this.server.deleteUtrosciNUllzaPeriod(this.datum.getResult());
            Shell poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija u toku, sacekajte sa radom");
            try {
                ZD z = this.server.getZDbyDatum(this.datum.getResult());
                for (Racun racun : this.server.getRacuneAfterDate(z.getZdBroj())) {
                    if (this.upisDnevnogUtroska(racun)) continue;
                    this.server.log("Problem sa racunom broj: " + String.valueOf(racun.getId()));
                    System.out.println("Racunnn");
                    SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli dnevniutrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                    break;
                }
            }
            catch (InputException e) {
                e.printStackTrace();
            }
            for (Otpis aktivanOtpis : this.server.readOtpisFromDate(this.datum.getResult())) {
                this.server.deleteOtpisUtrosakNullByOtpis(aktivanOtpis);
                if (this.unosUtrosakaOtpisa(aktivanOtpis, aktivanOtpis.getStavke(), aktivanOtpis.getOdeljenje())) continue;
                System.out.println(aktivanOtpis.getId());
                this.server.log("Problem sa otpisom broj: " + String.valueOf(aktivanOtpis.getId()));
                System.out.println("Otpisss");
                SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli otpisutrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                return;
            }
            for (Proizvodnja proizvodnja : this.server.readProizvodnja(this.datum.getResult())) {
                this.server.deleteProizvodnjaUtrosakNullByProizvodnja(proizvodnja);
                if (this.unosUtrosakaProizvodnje(proizvodnja, proizvodnja.getStavke(), proizvodnja.getOdeljenje())) continue;
                this.server.log("Problem sa proizvodnjom broj: " + String.valueOf(proizvodnja.getId()));
                System.out.println("Proizvodnjaaa");
                SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli proizvodnjautrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                return;
            }
            for (UtrosakDoc utrosakDoc : this.server.readUtrosakDoc(this.datum.getResult())) {
                this.server.deleteUtrosakDocUtrosakNullByUtrosakDoc(utrosakDoc);
                if (this.unosUtrosakaDocUtrosak(utrosakDoc, utrosakDoc.getStavke(), utrosakDoc.getOdeljenje())) continue;
                this.server.log("Problem sa utrosakDoc broj: " + String.valueOf(utrosakDoc.getId()));
                System.out.println("Utrosaaaaak");
                SWTMessage.showMessageDialog(this.shell, "Neuspesan upis utrosaka u tabeli utrosakdocutrosak", String.format(barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                return;
            }
            poruka1.close();
            System.out.println("Successfully commited changes to the database!");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                System.out.println("Successfully rolled back changes from the database!");
            }
            catch (Exception e1) {
                System.out.println("Could not rollback updates " + e1.getMessage());
            }
        }
    }

    public boolean upisDnevnogUtroska(Racun racun) {
        System.out.println("ovde kreiram utroske");
        ZD zd = this.server.getZDbyID(racun.getZdBroj());
        boolean upis = false;
        List<Object> listaDU = new LinkedList();
        try {
            listaDU = this.server.getDnevniUtrosakList(zd.getZdBroj());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (StavkaRacuna sr : racun.getStavke()) {
                artikal_kolicina.put(sr.getArtikal(), sr.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    Kasa kasa = this.server.getCurrentCounter();
                    if (kasa == null) {
                        kasa = racun.getKasa();
                    }
                    if (kasa.getOdeljenja().contains(o)) {
                        prolazi = true;
                    }
                    if (!prolazi || artikal.getTip() != TipArtikla.SLOZ && artikal.getTip() != TipArtikla.DODA) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this.server, artikal.getOdeljenje(), racun.getDatum()), this.server, o, racun.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                    normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Artikal artikal : normativ_kolicina.keySet()) {
                    konacnaLista.put(artikal, normativ_kolicina.get(artikal));
                }
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                }
                for (Artikal artikal : konacnaLista.keySet()) {
                    boolean isti = false;
                    DnevniUtrosak dUtrosak = null;
                    for (DnevniUtrosak dnevniUtrosak : listaDU) {
                        boolean osnovnoDodatno = false;
                        if (racun.getCrnoPlacanje() != null) {
                            boolean bl = osnovnoDodatno = !racun.getCrnoPlacanje().equals("") && racun.getNaOsnovno() == false;
                        }
                        if (artikal.getId() != dnevniUtrosak.getArtikal().getId() || artikal.getOdeljenje() != dnevniUtrosak.getOdeljenje() || !String.valueOf(osnovnoDodatno).equals(String.valueOf(dnevniUtrosak.isDodatno()))) continue;
                        isti = true;
                        dnevniUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(dnevniUtrosak.getArtikal()) + dnevniUtrosak.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                        dUtrosak = dnevniUtrosak;
                        break;
                    }
                    if (isti) {
                        this.server.updateDU(dUtrosak);
                        continue;
                    }
                    dUtrosak = new DnevniUtrosak();
                    dUtrosak.setArtikal(artikal);
                    dUtrosak.setOdeljenje(artikal.getOdeljenje());
                    dUtrosak.setZdBroj(zd.getZdBroj());
                    dUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    dUtrosak.setNabavnaCena(artikal.getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(artikal, racun.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(artikal, 1.0));
                    if (racun.getCrnoPlacanje() != null) {
                        dUtrosak.setDodatno(!racun.getCrnoPlacanje().equals("") && racun.getNaOsnovno() == false);
                    } else {
                        dUtrosak.setDodatno(false);
                    }
                    this.server.insertDU(dUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }

    protected synchronized boolean unosUtrosakaOtpisa(Otpis aktivanOtpis, List<OtpisStavka> stavke, Odeljenje odeljenje) {
        System.out.println("ovde kreiram utroske otpisa");
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (OtpisStavka os : stavke) {
                artikal_kolicina.put(os.getArtikal(), os.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    if (!prolazi && odeljenje.equals(o)) {
                        prolazi = true;
                    }
                    if (!prolazi || artikal.getTip() != TipArtikla.SLOZ && artikal.getTip() != TipArtikla.DODA) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this.server, artikal.getOdeljenje(), aktivanOtpis.getDatum()), this.server, o, aktivanOtpis.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                    normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Artikal artikal : normativ_kolicina.keySet()) {
                    konacnaLista.put(artikal, normativ_kolicina.get(artikal));
                }
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                }
                for (Artikal artikal : konacnaLista.keySet()) {
                    OtpisUtrosak oUtrosak = new OtpisUtrosak();
                    oUtrosak.setOtpis(aktivanOtpis);
                    oUtrosak.setArtikal(artikal);
                    oUtrosak.setOdeljenje(artikal.getOdeljenje());
                    oUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    oUtrosak.setNabavnaCena(artikal.getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(artikal, aktivanOtpis.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(artikal, 1.0));
                    this.server.insertOtpisUtrosak(oUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }

    protected synchronized boolean unosUtrosakaDocUtrosak(UtrosakDoc aktivanUtrosakDoc, List<UtrosakDocStavke> stavke, Odeljenje odeljenje) {
        System.out.println("ovde kreiram utrosakdocutrosak");
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (UtrosakDocStavke os : stavke) {
                artikal_kolicina.put(os.getArtikal(), os.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    prolazi = odeljenje.equals(o);
                    if (!prolazi || artikal.getTip() != TipArtikla.SLOZ && artikal.getTip() != TipArtikla.DODA) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this.server, artikal.getOdeljenje(), aktivanUtrosakDoc.getDatum()), this.server, o, aktivanUtrosakDoc.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                    normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Artikal artikal : normativ_kolicina.keySet()) {
                    konacnaLista.put(artikal, normativ_kolicina.get(artikal));
                }
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                }
                for (Artikal artikal : konacnaLista.keySet()) {
                    UtrosakDocUtrosak utrosak = new UtrosakDocUtrosak();
                    utrosak.setUtrosakDoc(aktivanUtrosakDoc);
                    utrosak.setArtikal(artikal);
                    utrosak.setOdeljenje(artikal.getOdeljenje());
                    utrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    utrosak.setNabavnaCena(artikal.getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV(artikal, aktivanUtrosakDoc.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV(artikal, 1.0));
                    this.server.insertUDocUtrosak(utrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }

    protected synchronized boolean unosUtrosakaProizvodnje(Proizvodnja p, List<ProizvodnjaStavka> stavke, Odeljenje odeljenje) {
        System.out.println("ovde kreiram utroske proizvodnje");
        boolean upis = false;
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap normativ_kolicina = new HashMap();
            HashMap<Artikal, Double> konacnaLista = new HashMap<Artikal, Double>();
            boolean prolazi = false;
            for (ProizvodnjaStavka proizvodnjaStavka : stavke) {
                artikal_kolicina.put(proizvodnjaStavka.getArtikal(), proizvodnjaStavka.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    prolazi = odeljenje.equals(o);
                    if (!prolazi || artikal.getTip() != TipArtikla.POLU) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenje22(SkidanjeNormativa.razloziArtikalPoluproizvodProizvodnja(artikal, (Double)artikal_kolicina.get(artikal), this.server, p.getDatum()), this.server, o, p.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    konacnaLista.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Map.Entry entry : konacnaLista.entrySet()) {
                    ProizvodnjaUtrosak proizvodnjaUtrosak = new ProizvodnjaUtrosak();
                    proizvodnjaUtrosak.setProizvodnja(p);
                    proizvodnjaUtrosak.setArtikal((Artikal)entry.getKey());
                    proizvodnjaUtrosak.setOdeljenje(((Artikal)entry.getKey()).getOdeljenje());
                    proizvodnjaUtrosak.setKolicina(BigDecimal.valueOf((Double)entry.getValue()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    proizvodnjaUtrosak.setNabavnaCena(((Artikal)entry.getKey()).getTip() != TipArtikla.POLU ? this.server.getLastNabavnaCenaBelaBezPDV((Artikal)entry.getKey(), p.getDatum()) : this.server.getNabavnaCenaPoluproizvodBezPDV((Artikal)entry.getKey(), 1.0));
                    this.server.insertPU(proizvodnjaUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }
}

