/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.GlavniMeni;
import com.dev63.restoran.model.GlavniMeniLogin;
import com.dev63.restoran.model.GlavniMeniPodgrupa;
import com.dev63.restoran.model.GlavniMeniPodgrupaLogin;
import com.dev63.restoran.model.Login;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Korisnici {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Login active;
    private Group treeGroup;
    private Group dataGroup;
    private Tree tree;
    Composite dugmici;
    private ArrayList<GlavniMeni> glavniMeniList = new ArrayList();
    private ArrayList<GlavniMeniPodgrupa> glavniMeniListPodgrupa = new ArrayList();

    public Korisnici(SWTContainer owner, Restoran r) {
        this.parent = owner;
        this.restoran = r;
        this.server = this.restoran.getServer();
        Shell shell = this.parent.getControl().getShell();
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/korisniciV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_KORISNICI_SISTEMA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_KORISNIKA_SISTEMA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_ATRIBUTI_KORISNIKA_SISTEMA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_NOVI_KORISNIK_SISTEMA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Korisnici.this.addLogin();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_IZMENA_KORISNIKA_SISTEMA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Korisnici.this.updateLogin();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_KORISNIKA_SISTEMA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Korisnici.this.deleteLogin();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = Korisnici.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                Korisnici.this.setActiveLogin((Login)Korisnici.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        this.reload();
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        this.listModel.clear();
        List<Login> korisnici = this.restoran.getServer().getLogins();
        if (korisnici == null) {
            this.listModel.addElement(String.format(Konstante.getBundle().getString("TEXT_TRENUTNO_NEMA_KORISNIKA"), new Object[0]));
        } else {
            for (Login l : korisnici) {
                this.listModel.addElement(l);
            }
        }
        this.active = null;
        this.display.setText("");
    }

    private void addLogin() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        KorisnickiDialog2 kd = new KorisnickiDialog2(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_NOVI_KORISNIK_SISTEMA"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (kd.getResult() != null) {
            Login l = kd.getResult();
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_NOVI_KORISNIK_SISTEMA"), new Object[0]) + ": " + l + ", " + String.format(Konstante.getBundle().getString("TEXT_ADMINISTRATOR"), new Object[0]) + "->" + l.getAdmin() + ", " + String.format(Konstante.getBundle().getString("TEXT_PUN_PRISTUP"), new Object[0]) + "->" + l.getService());
            this.server.addLogin(l);
            System.out.println("glavniMeniList.size() " + this.glavniMeniList.size());
            this.server.brisanjeGlavnogMenijaByLogin(l.getId());
            for (GlavniMeni glavniMeni : this.glavniMeniList) {
                GlavniMeniLogin glavniMeniLogin = new GlavniMeniLogin();
                glavniMeniLogin.setGlavniMeniId(glavniMeni.getId());
                glavniMeniLogin.setLoginId(l.getId());
                this.server.addGlavniMeniLogin(glavniMeniLogin);
            }
            this.server.brisanjeGlavnogMenijaPodgrupaByLogin(l.getId());
            for (GlavniMeniPodgrupa gmp : this.glavniMeniListPodgrupa) {
                GlavniMeniPodgrupaLogin gmol = new GlavniMeniPodgrupaLogin(l.getId(), gmp.getId(), gmp.getNaziv());
                this.server.addGlavniMeniPodgrupaLogin(gmol);
            }
            this.reload();
        }
    }

    private void updateLogin() {
        if (this.active == null) {
            return;
        }
        boolean oldAdmin = this.active.getAdmin();
        boolean oldService = this.active.getService();
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        KorisnickiDialog2 kd = new KorisnickiDialog2(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_IZMENA_KORISNIKA_SISTEMA"), new Object[0])), this.active);
        SWTContainerClass.makeEnd(shell2);
        if (kd.getResult() != null) {
            Login l = kd.getResult();
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_IZMENA_KORISNIKA_SISTEMA"), new Object[0]) + ": " + l + ", " + String.format(Konstante.getBundle().getString("TEXT_ADMINISTRATOR"), new Object[0]) + ": " + oldAdmin + "=>" + l.getAdmin() + ", " + String.format(Konstante.getBundle().getString("TEXT_PUN_PRISTUP"), new Object[0]) + ": " + oldService + "=>" + l.getService());
            this.server.updateLogin(l);
            System.out.println("glavniMeniList.size() " + this.glavniMeniList.size());
            this.server.brisanjeGlavnogMenijaByLogin(l.getId());
            for (GlavniMeni glavniMeni : this.glavniMeniList) {
                GlavniMeniLogin glavniMeniLogin = new GlavniMeniLogin();
                glavniMeniLogin.setGlavniMeniId(glavniMeni.getId());
                glavniMeniLogin.setLoginId(l.getId());
                this.server.addGlavniMeniLogin(glavniMeniLogin);
            }
            this.server.brisanjeGlavnogMenijaPodgrupaByLogin(l.getId());
            for (GlavniMeniPodgrupa gmp : this.glavniMeniListPodgrupa) {
                GlavniMeniPodgrupaLogin gmol = new GlavniMeniPodgrupaLogin(l.getId(), gmp.getId(), gmp.getNaziv());
                this.server.addGlavniMeniPodgrupaLogin(gmol);
            }
            this.reload();
        }
    }

    private void deleteLogin() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(Konstante.getBundle().getString("TEXT_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_KORISNIKA_SISTEMA"), this.active.getName()));
        if (ok == 0) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_KORISNIKA_SISTEMA"), new Object[0]) + ": " + this.active + ", " + String.format(Konstante.getBundle().getString("TEXT_ADMINISTRATOR"), new Object[0]) + " ->" + this.active.getAdmin() + ", " + String.format(Konstante.getBundle().getString("TEXT_PUN_PRISTUP"), new Object[0]) + "->" + this.active.getService());
            this.server.deleteLogin(this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveLogin(Login login) {
        this.active = login;
        StringBuilder bld = new StringBuilder("");
        bld.append(String.format(Konstante.getBundle().getString("TEXT_IME"), new Object[0]) + ": ").append(login.getName()).append("\n");
        bld.append(String.format(Konstante.getBundle().getString("TEXT_ADMINISTRATOR"), new Object[0]) + ": ").append(login.getAdmin() != false ? String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])).append("\n");
        bld.append(String.format(Konstante.getBundle().getString("TEXT_PUN_PRISTUP"), new Object[0]) + ": ").append(login.getService() != false ? String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_NE"), new Object[0])).append("\n");
        this.display.setText(bld.toString());
    }

    private void loadTreeData() {
        if (this.tree.getItems().length > 0) {
            this.tree.removeAll();
        }
        this.popuniGlavniMeniGrupe();
    }

    private void popuniGlavniMeniGrupe() {
        List<GlavniMeni> glavniMeniji = this.server.readGlavniMeni();
        List<Object> gmLogin = new ArrayList();
        if (this.active != null) {
            gmLogin = this.server.readGlavniMeniLoginByLoginId(this.active.getId());
        }
        for (GlavniMeni gm : glavniMeniji) {
            TreeItem grupa = new TreeItem(this.tree, 0);
            grupa.setText(gm.getNaziv());
            if (this.active == null) {
                this.selektujGrupu(grupa);
            } else {
                for (GlavniMeniLogin glavniMeniLogin : gmLogin) {
                    if (!this.glavniMeniDodeljenKorisniku(glavniMeniLogin, gm)) continue;
                    this.selektujGrupu(grupa);
                }
            }
            this.popuniGlavniMeniPodgrupe(gm.getId(), grupa);
        }
    }

    private void popuniGlavniMeniPodgrupe(long glavniMeniId, TreeItem glavniMeni) {
        List<GlavniMeniPodgrupa> glavniMeniPodgrupe = this.server.readGlavniMeniPodgrupe();
        List<Object> gmPodgrupeLogin = new ArrayList();
        if (this.active != null) {
            gmPodgrupeLogin = this.server.readGlavniMeniPodgrupaLoginByLoginId(this.active.getId());
        }
        for (GlavniMeniPodgrupa gmPodgrupa : glavniMeniPodgrupe) {
            if (!this.podgrupaPripadaGrupi(glavniMeniId, gmPodgrupa.getGlavniMeniId())) continue;
            TreeItem podgrupa = new TreeItem(glavniMeni, 0);
            podgrupa.setText(gmPodgrupa.getNaziv());
            if (this.active == null) {
                this.selektujGrupu(podgrupa);
                continue;
            }
            for (GlavniMeniPodgrupaLogin glavniMeniPodgrupaLogin : gmPodgrupeLogin) {
                if (!this.glavniMeniPodgrupaDodeljenaKorisniku(glavniMeniPodgrupaLogin, gmPodgrupa)) continue;
                this.selektujGrupu(podgrupa);
            }
        }
    }

    private boolean glavniMeniDodeljenKorisniku(GlavniMeniLogin gml, GlavniMeni gm) {
        return gml.getGlavniMeniId() == gm.getId().longValue();
    }

    private boolean glavniMeniPodgrupaDodeljenaKorisniku(GlavniMeniPodgrupaLogin gmlp, GlavniMeniPodgrupa gmp) {
        return gmlp.getGlavniMeniPodgrupaId() == gmp.getId().longValue();
    }

    public ArrayList<GlavniMeniPodgrupa> vratiSelektovanePodgrupe() {
        ArrayList<GlavniMeniPodgrupa> glavniMeniPodgrupe = new ArrayList<GlavniMeniPodgrupa>();
        for (TreeItem glavniMeni : this.tree.getItems()) {
            TreeItem[] podgrupe = glavniMeni.getItems();
            if (podgrupe.length <= 0) continue;
            for (TreeItem podgrupa : podgrupe) {
                if (!podgrupa.getChecked()) continue;
                GlavniMeniPodgrupa gmp = this.server.readGlavniMeniPodgrupaByNaziv(podgrupa.getText());
                glavniMeniPodgrupe.add(gmp);
            }
        }
        return glavniMeniPodgrupe;
    }

    public ArrayList<GlavniMeni> vratiSelektovaneGrupe() {
        ArrayList<GlavniMeni> glavniMeniji = new ArrayList<GlavniMeni>();
        for (TreeItem glavniMeni : this.tree.getItems()) {
            if (!glavniMeni.getChecked()) continue;
            GlavniMeni gm = this.server.readGlavniMeniByNaziv(glavniMeni.getText());
            glavniMeniji.add(gm);
        }
        return glavniMeniji;
    }

    private boolean podgrupaPripadaGrupi(long idGrupeIzGrupe, long idGrupeIzPodgrupe) {
        return idGrupeIzGrupe == idGrupeIzPodgrupe;
    }

    private int brojPodgrupa(TreeItem item) {
        return item.getItemCount();
    }

    private TreeItem[] podgrupe(TreeItem item) {
        return item.getItems();
    }

    private boolean grupaSelektovana(TreeItem item) {
        return item.getChecked();
    }

    private boolean minimumJednaPodgrupaSelektovana(TreeItem[] podgrupe) {
        for (TreeItem pg : podgrupe) {
            if (!pg.getChecked()) continue;
            return true;
        }
        return false;
    }

    private void selektujSvePodgrupe(TreeItem[] podgrupe) {
        for (TreeItem pg : podgrupe) {
            pg.setChecked(true);
        }
    }

    private void deselektujSvePodgrupe(TreeItem[] podgrupe) {
        for (TreeItem pg : podgrupe) {
            pg.setChecked(false);
        }
    }

    private void selektujGrupu(TreeItem item) {
        item.setChecked(true);
    }

    private void deselektujGrupu(TreeItem item) {
        item.setChecked(false);
    }

    private class KorisnickiDialog2 {
        private TextInput2 name;
        private Text passa;
        private Text passb;
        private Button adminTrue;
        private Button serviceTrue;
        private Button boPlusTrue;
        private Button otvaraTrebovanje;
        private Login input;
        private Login result;

        public KorisnickiDialog2(SWTContainer parent, Login input) {
            this.input = input;
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Korisnici.this.dataGroup = new Group((Composite)shell3, 0);
            Korisnici.this.dataGroup.setText("Podaci");
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            Korisnici.this.dataGroup.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            Korisnici.this.dataGroup.setLayoutData((Object)data);
            Label n = new Label((Composite)Korisnici.this.dataGroup, 0);
            n.setText(String.format(Konstante.getBundle().getString("TEXT_IME"), new Object[0]));
            this.name = new TextInput2((Composite)Korisnici.this.dataGroup, String.format(Konstante.getBundle().getString("TEXT_IME"), new Object[0]), false);
            Label s1 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s1.setText(String.format(Konstante.getBundle().getString("TEXT_SIFRA"), new Object[0]));
            this.passa = new Text((Composite)Korisnici.this.dataGroup, 0x400800);
            Label s2 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s2.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDA_SIFRE"), new Object[0]));
            this.passb = new Text((Composite)Korisnici.this.dataGroup, 0x400800);
            Label s3 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s3.setText(String.format(Konstante.getBundle().getString("TEXT_ADMINISTRATOR"), new Object[0]));
            this.adminTrue = new Button((Composite)Korisnici.this.dataGroup, 32);
            this.adminTrue.setText(String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]));
            Label s4 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s4.setText(String.format(Konstante.getBundle().getString("TEXT_PUN_PRISTUP"), new Object[0]));
            this.serviceTrue = new Button((Composite)Korisnici.this.dataGroup, 32);
            this.serviceTrue.setText(String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]));
            Label s41 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s41.setText(String.format(Konstante.getBundle().getString("TEXT_BO_PLUS"), new Object[0]));
            this.boPlusTrue = new Button((Composite)Korisnici.this.dataGroup, 32);
            this.boPlusTrue.setText(String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]));
            Label s42 = new Label((Composite)Korisnici.this.dataGroup, 0);
            s42.setText(String.format(Konstante.getBundle().getString("TEXT_OTVARA_TREBOVANJE"), new Object[0]));
            this.otvaraTrebovanje = new Button((Composite)Korisnici.this.dataGroup, 32);
            this.otvaraTrebovanje.setText(String.format(Konstante.getBundle().getString("TEXT_DA"), new Object[0]));
            Korisnici.this.treeGroup = new Group((Composite)shell3, 0);
            Korisnici.this.treeGroup.setText("Glavni Meni");
            layout = new GridLayout();
            layout.numColumns = 2;
            Korisnici.this.treeGroup.setLayout((Layout)layout);
            data = new GridData(1808);
            Korisnici.this.treeGroup.setLayoutData((Object)data);
            Korisnici.this.tree = new Tree((Composite)Korisnici.this.treeGroup, 2848);
            GridData treeGridData = new GridData();
            treeGridData.grabExcessHorizontalSpace = true;
            treeGridData.grabExcessVerticalSpace = true;
            treeGridData.verticalAlignment = 4;
            treeGridData.horizontalAlignment = 4;
            treeGridData.heightHint = 180;
            Korisnici.this.tree.setLayoutData((Object)treeGridData);
            Korisnici.this.tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        if (Korisnici.this.brojPodgrupa(item) > 0) {
                            if (Korisnici.this.grupaSelektovana(item)) {
                                Korisnici.this.selektujSvePodgrupe(Korisnici.this.podgrupe(item));
                            } else {
                                Korisnici.this.deselektujSvePodgrupe(Korisnici.this.podgrupe(item));
                            }
                        } else {
                            TreeItem grupa = item.getParentItem();
                            if (Korisnici.this.minimumJednaPodgrupaSelektovana(Korisnici.this.podgrupe(grupa))) {
                                Korisnici.this.selektujGrupu(grupa);
                            } else {
                                Korisnici.this.deselektujGrupu(grupa);
                            }
                        }
                    }
                }
            });
            Korisnici.this.loadTreeData();
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    KorisnickiDialog2.this.cancel(parent2);
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    KorisnickiDialog2.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            layout = new GridLayout(2, false);
            shell3.setLayout((Layout)layout);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            data.horizontalAlignment = 131072;
            this.name.getControl().setLayoutData((Object)data);
            this.passa.setLayoutData((Object)data);
            this.passb.setLayoutData((Object)data);
            this.adminTrue.setLayoutData((Object)data);
            this.serviceTrue.setLayoutData((Object)data);
            this.boPlusTrue.setLayoutData((Object)data);
            this.otvaraTrebovanje.setLayoutData((Object)data);
            s1.setLayoutData((Object)data);
            s2.setLayoutData((Object)data);
            s3.setLayoutData((Object)data);
            s4.setLayoutData((Object)data);
            s41.setLayoutData((Object)data);
            s42.setLayoutData((Object)data);
            n.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell3);
        }

        private void ok(SWTContainer parent) {
            Login login = this.input != null ? this.input : new Login();
            try {
                login.setName(this.name.getResult());
                String a = new String(this.passa.getText()).trim();
                char[] cArray = a.toCharArray();
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character c = Character.valueOf(cArray[i]);
                    try {
                        int n2 = Integer.valueOf(c.toString());
                        continue;
                    }
                    catch (Exception e) {
                        Konstante.getPoruka(parent.getControl().getShell(), String.format(Konstante.getBundle().getString("PORUKA_SIFRA_NE_SME_DA_SADRZI_KARAKTER_KOJI_NIJE_CIFRA"), new Object[0]));
                        return;
                    }
                }
                String b = new String(this.passb.getText()).trim();
                if (!a.equals(b)) {
                    SWTOptionPane.showMessageDialog(parent, (Object)String.format(Konstante.getBundle().getString("TEXT_SIFRE_SE_NE_POKLAPAJU"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
                    return;
                }
                login.setPass(a);
                login.setAdmin(this.adminTrue.getSelection());
                login.setService(this.serviceTrue.getSelection());
                login.setBoPlus(this.boPlusTrue.getSelection());
                login.setOtvaraTrebovanje(this.otvaraTrebovanje.getSelection());
                Korisnici.this.glavniMeniListPodgrupa = Korisnici.this.vratiSelektovanePodgrupe();
                Korisnici.this.glavniMeniList = Korisnici.this.vratiSelektovaneGrupe();
                this.result = login;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        public Login getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getName());
            this.passa.setText(this.input.getPass());
            this.passb.setText(this.input.getPass());
            if (this.input.getAdmin().booleanValue()) {
                this.adminTrue.setSelection(true);
            }
            if (this.input.getService().booleanValue()) {
                this.serviceTrue.setSelection(true);
            }
            if (this.input.getBoPlus() == null) {
                this.input.setBoPlus(false);
            }
            if (this.input.getBoPlus().booleanValue()) {
                this.boPlusTrue.setSelection(true);
            }
            if (this.input.getOtvaraTrebovanje() == null) {
                this.input.setOtvaraTrebovanje(false);
            }
            if (this.input.getOtvaraTrebovanje().booleanValue()) {
                this.otvaraTrebovanje.setSelection(true);
            }
        }
    }
}

