/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KombinovanoPlacanje {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Logger log;
    SWTContainer parent;
    private Label totalLabel;
    private Label restLabel;
    private DoubleInput2 gotovina;
    private DoubleInput2 cek;
    private DoubleInput2 kartica;
    Shell numericka2;
    private double total = 0.0;
    private String broj = "";
    private boolean isText = true;
    private boolean isText2 = false;
    private boolean isText3 = false;
    private Image buttBgImg;
    private Image numButtBgImg;
    private Color fgColor;
    private Color pozadina;
    private Color svCrno;
    private Color tamnoSivo;
    private Font buttFont;
    private Font numButtFont;
    List<Placanje> placanja = new ArrayList<Placanje>();

    public KombinovanoPlacanje(Shell shellP, Restoran restoran, double suma) {
        Display display = shellP.getDisplay();
        Display device = shellP.getDisplay();
        this.pozadina = new Color((Device)device, 115, 119, 128);
        this.svCrno = new Color((Device)device, 34, 37, 46);
        this.tamnoSivo = new Color((Device)device, 49, 53, 64);
        this.log = restoran.getLog();
        this.numericka2 = new Shell(shellP, 32768);
        this.numericka2.setLayout((Layout)new GridLayout(2, true));
        this.numericka2.setMaximized(true);
        this.numericka2.setBackground(this.svCrno);
        Composite shell = new Composite((Composite)this.numericka2, 2048);
        shell.setBackground(this.tamnoSivo);
        this.fgColor = new Color((Device)display, BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        this.numButtFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getNumButtonFont());
        this.parent = new SWTContainer(shell);
        this.total = suma;
        this.numericka2.setText(String.format(this.barmasterText.getString("TEXT_KOMBINOVANO_PLACANJE"), new Object[0]));
        Label totalL = new Label(shell, 16384);
        totalL.setText(String.format(this.barmasterText.getString("TEXT_UKUPNO_ZA_UPLATU"), new Object[0]) + ":");
        totalL.setBackground(shell.getDisplay().getSystemColor(1));
        totalL.setBackground(this.tamnoSivo);
        totalL.setForeground(display.getSystemColor(1));
        this.totalLabel = new Label(shell, 16384);
        this.totalLabel.setText(Konstante.getNumber2(this.total));
        this.totalLabel.setBackground(shell.getDisplay().getSystemColor(1));
        Label gotovinaL = new Label(shell, 16384);
        gotovinaL.setText(String.format(this.barmasterText.getString("TEXT_GOTOVINA"), new Object[0]) + ":");
        gotovinaL.setBackground(this.tamnoSivo);
        gotovinaL.setForeground(display.getSystemColor(1));
        this.gotovina = new DoubleInput2(this.parent, String.format(this.barmasterText.getString("TEXT_GOTOVINA"), new Object[0]), true);
        this.gotovina.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.gotovina.getControl().addMouseListener((MouseListener)new FillInAdapter(this.gotovina));
        Label cekL = new Label(shell, 16384);
        cekL.setText(String.format(this.barmasterText.getString("TEXT_CEK"), new Object[0]) + ":");
        cekL.setBackground(this.tamnoSivo);
        cekL.setForeground(display.getSystemColor(1));
        this.cek = new DoubleInput2(this.parent, String.format(this.barmasterText.getString("TEXT_CEK"), new Object[0]), true);
        this.cek.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.cek.getControl().addMouseListener((MouseListener)new FillInAdapter(this.cek));
        Label karticaL = new Label(shell, 16384);
        karticaL.setText(String.format(this.barmasterText.getString("TEXT_KARTICA"), new Object[0]) + ":");
        karticaL.setBackground(this.tamnoSivo);
        karticaL.setForeground(display.getSystemColor(1));
        this.kartica = new DoubleInput2(this.parent, String.format(this.barmasterText.getString("TEXT_KARTICA"), new Object[0]), true);
        this.kartica.getControl().addKeyListener((KeyListener)new RestAdapter());
        this.kartica.getControl().addMouseListener((MouseListener)new FillInAdapter(this.kartica));
        Label restL = new Label(shell, 16384);
        restL.setBackground(shell.getDisplay().getSystemColor(1));
        restL.setText(String.format(this.barmasterText.getString("TEXT_OSTATAK"), new Object[0]) + ":");
        restL.setBackground(this.tamnoSivo);
        restL.setForeground(display.getSystemColor(1));
        this.restLabel = new Label(shell, 16384);
        this.restLabel.setText(Konstante.getNumber2(this.total));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 40;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 150;
        data.heightHint = 30;
        totalL.setLayoutData((Object)data);
        restL.setLayoutData((Object)data);
        gotovinaL.setLayoutData((Object)data);
        cekL.setLayoutData((Object)data);
        karticaL.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 150;
        data.horizontalSpan = 2;
        data.heightHint = 30;
        this.totalLabel.setLayoutData((Object)data);
        this.gotovina.getControl().setLayoutData((Object)data);
        this.cek.getControl().setLayoutData((Object)data);
        this.kartica.getControl().setLayoutData((Object)data);
        this.restLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 150;
        GridData data2 = new GridData(256);
        data2.horizontalSpan = 3;
        Composite numericka = new Composite((Composite)this.numericka2, 2048);
        numericka.setLayout((Layout)new GridLayout(4, false));
        numericka.setBackground(this.pozadina);
        numericka.setBackgroundMode(1);
        GridData gridData = new GridData();
        gridData.heightHint = 80;
        gridData.widthHint = 80;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 164;
        gridData2.heightHint = 80;
        gridData2.horizontalAlignment = 0x1000000;
        GridData gridData3 = new GridData();
        gridData3.heightHint = 80;
        gridData3.widthHint = 80;
        gridData3.horizontalSpan = 2;
        ImageButton b = new ImageButton(numericka, 0);
        b.setBackgroundImage(this.numButtBgImg);
        b.setForeground(this.fgColor);
        b.setFont(this.numButtFont);
        b.setText("7");
        b.setLayoutData(gridData);
        this.addListenerNumeric("7", (Control)b);
        ImageButton b3 = new ImageButton(numericka, 0);
        b3.setBackgroundImage(this.numButtBgImg);
        b3.setForeground(this.fgColor);
        b3.setFont(this.numButtFont);
        b3.setText("8");
        b3.setLayoutData(gridData);
        this.addListenerNumeric("8", (Control)b3);
        ImageButton b4 = new ImageButton(numericka, 0);
        b4.setBackgroundImage(this.numButtBgImg);
        b4.setForeground(this.fgColor);
        b4.setFont(this.numButtFont);
        b4.setText("9");
        b4.setLayoutData(gridData);
        this.addListenerNumeric("9", (Control)b4);
        ImageButton otkazi = new ImageButton(numericka, 0x1000040);
        otkazi.setBackgroundImage(this.buttBgImg);
        otkazi.setForeground(this.fgColor);
        otkazi.setFont(this.buttFont);
        otkazi.setText(String.format(this.barmasterText.getString("TEXT_OTKAZI"), new Object[0]));
        otkazi.setLayoutData(gridData2);
        otkazi.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                KombinovanoPlacanje.this.placanja = null;
                KombinovanoPlacanje.this.cancel();
            }
        });
        ImageButton b6 = new ImageButton(numericka, 0);
        b6.setBackgroundImage(this.numButtBgImg);
        b6.setForeground(this.fgColor);
        b6.setFont(this.numButtFont);
        b6.setText("4");
        b6.setLayoutData(gridData);
        this.addListenerNumeric("4", (Control)b6);
        ImageButton b7 = new ImageButton(numericka, 0);
        b7.setBackgroundImage(this.numButtBgImg);
        b7.setForeground(this.fgColor);
        b7.setFont(this.numButtFont);
        b7.setText("5");
        b7.setLayoutData(gridData);
        this.addListenerNumeric("5", (Control)b7);
        ImageButton b8 = new ImageButton(numericka, 0);
        b8.setBackgroundImage(this.numButtBgImg);
        b8.setForeground(this.fgColor);
        b8.setFont(this.numButtFont);
        b8.setText("6");
        b8.setLayoutData(gridData3);
        this.addListenerNumeric("6", (Control)b8);
        ImageButton b0 = new ImageButton(numericka, 0);
        b0.setBackgroundImage(this.numButtBgImg);
        b0.setForeground(this.fgColor);
        b0.setFont(this.numButtFont);
        b0.setText("1");
        b0.setLayoutData(gridData);
        this.addListenerNumeric("1", (Control)b0);
        ImageButton tacka = new ImageButton(numericka, 0);
        tacka.setBackgroundImage(this.numButtBgImg);
        tacka.setForeground(this.fgColor);
        tacka.setFont(this.numButtFont);
        tacka.setText("2");
        tacka.setLayoutData(gridData);
        this.addListenerNumeric("2", (Control)tacka);
        ImageButton b1 = new ImageButton(numericka, 0);
        b1.setBackgroundImage(this.numButtBgImg);
        b1.setForeground(this.fgColor);
        b1.setFont(this.numButtFont);
        b1.setText("3");
        b1.setLayoutData(gridData3);
        this.addListenerNumeric("3", (Control)b1);
        ImageButton b5 = new ImageButton(numericka, 0);
        b5.setBackgroundImage(this.numButtBgImg);
        b5.setForeground(this.fgColor);
        b5.setFont(this.numButtFont);
        b5.setText("0");
        b5.setLayoutData(gridData);
        this.addListenerNumeric("0", (Control)b5);
        data = new GridData();
        data.horizontalSpan = 4;
        data.widthHint = 164;
        data.heightHint = 80;
        data.horizontalAlignment = 0x1000000;
        ImageButton b9 = new ImageButton(numericka, 0);
        b9.setBackgroundImage(this.numButtBgImg);
        b9.setForeground(this.fgColor);
        b9.setFont(this.numButtFont);
        b9.setText(",");
        b9.setLayoutData(gridData);
        ImageButton nazad = new ImageButton(numericka, 16388);
        nazad.setPadding(8);
        nazad.setLayoutData(gridData);
        nazad.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!KombinovanoPlacanje.this.broj.equals("")) {
                    KombinovanoPlacanje.this.broj = KombinovanoPlacanje.this.broj.substring(0, KombinovanoPlacanje.this.broj.length() - 1);
                    if (KombinovanoPlacanje.this.isText) {
                        try {
                            KombinovanoPlacanje.this.gotovina.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                        }
                        catch (NumberFormatException exc) {
                            KombinovanoPlacanje.this.gotovina.setResult(0.0);
                        }
                        return;
                    }
                    if (KombinovanoPlacanje.this.isText2) {
                        try {
                            KombinovanoPlacanje.this.cek.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                        }
                        catch (NumberFormatException exc) {
                            KombinovanoPlacanje.this.gotovina.setResult(0.0);
                        }
                        return;
                    }
                    if (KombinovanoPlacanje.this.isText3) {
                        try {
                            KombinovanoPlacanje.this.kartica.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                        }
                        catch (NumberFormatException exc) {
                            KombinovanoPlacanje.this.gotovina.setResult(0.0);
                        }
                    }
                }
            }
        });
        ImageButton stPorudz = new ImageButton(numericka, 0x1000040);
        stPorudz.setBackgroundImage(this.buttBgImg);
        stPorudz.setForeground(this.fgColor);
        stPorudz.setFont(this.buttFont);
        stPorudz.setText(String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]));
        stPorudz.setLayoutData(gridData2);
        stPorudz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (KombinovanoPlacanje.this.isText3 || KombinovanoPlacanje.this.restLabel.getText().equals("0,00")) {
                    if (KombinovanoPlacanje.this.ok()) {
                        KombinovanoPlacanje.this.cancel();
                    }
                } else {
                    KombinovanoPlacanje.this.broj = "";
                    if (KombinovanoPlacanje.this.isText) {
                        KombinovanoPlacanje.this.isText = false;
                        KombinovanoPlacanje.this.isText2 = true;
                        KombinovanoPlacanje.this.cek.getControl().forceFocus();
                        return;
                    }
                    if (KombinovanoPlacanje.this.isText2) {
                        KombinovanoPlacanje.this.isText2 = false;
                        KombinovanoPlacanje.this.isText3 = true;
                        KombinovanoPlacanje.this.kartica.getControl().forceFocus();
                        return;
                    }
                }
            }
        });
        data = new GridData();
        data.verticalIndent = 200;
        data.horizontalIndent = 50;
        data.verticalAlignment = 128;
        shell.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 200;
        data.horizontalIndent = 0;
        numericka.setLayoutData((Object)data);
        numericka.pack();
        shell.pack();
        this.numericka2.open();
        this.numericka2.setMaximized(true);
        this.numericka2.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        this.fgColor.dispose();
    }

    private void addListenerNumeric(final String s, Control b) {
        b.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                KombinovanoPlacanje.this.broj = KombinovanoPlacanje.this.broj + s;
                if (!KombinovanoPlacanje.this.isText2 && !KombinovanoPlacanje.this.isText3) {
                    KombinovanoPlacanje.this.gotovina.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                } else if (KombinovanoPlacanje.this.isText2) {
                    KombinovanoPlacanje.this.cek.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                } else {
                    KombinovanoPlacanje.this.kartica.setResult(Double.valueOf(KombinovanoPlacanje.this.broj));
                }
                try {
                    KombinovanoPlacanje.this.calcRest();
                }
                catch (InputException ex) {
                    SWTOptionPane.showMessageDialog(KombinovanoPlacanje.this.parent, (Object)ex.getMessage(), String.format(KombinovanoPlacanje.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
                    KombinovanoPlacanje.this.placanja = null;
                }
            }
        });
    }

    private boolean ok() {
        try {
            if (this.total == 0.0) {
                Konstante.getPoruka(this.numericka2, "Iznos racuna ne moze biti 0!");
                this.placanja = null;
                return false;
            }
            if (this.calcRest() != 0.0) {
                Konstante.getPoruka(this.numericka2, "Morate uneti iznos koji pokriva celokupnu vrednost racuna!");
                this.placanja = null;
                return false;
            }
            this.addPlacanje();
            return true;
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            this.placanja = null;
            return false;
        }
    }

    private void addPlacanje() {
        this.placanja = new ArrayList<Placanje>();
        try {
            if (this.kartica.getResult() > 0.0) {
                Placanje kp = new Placanje();
                kp.setIznos(this.kartica.getResult());
                kp.setNacin(NacinPlacanja.KARTICA);
                this.placanja.add(kp);
            }
            if (this.cek.getResult() > 0.0) {
                Placanje fp = new Placanje();
                fp.setIznos(this.cek.getResult());
                fp.setNacin(NacinPlacanja.CEK);
                this.placanja.add(fp);
            }
            if (this.gotovina.getResult() > 0.0) {
                Placanje gp = new Placanje();
                gp.setIznos(this.gotovina.getResult());
                gp.setNacin(NacinPlacanja.GOTOVINA);
                this.placanja.add(gp);
            }
        }
        catch (InputException ex) {
            SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
        }
    }

    private void cancel() {
        this.parent.getControl().getShell().close();
    }

    public List<Placanje> getPlacanja() {
        return this.placanja;
    }

    private double calcRest() throws InputException {
        double rest = this.total;
        rest -= this.gotovina.getResult().doubleValue();
        rest -= this.cek.getResult().doubleValue();
        rest -= this.kartica.getResult().doubleValue();
        rest = (double)Math.round(rest * 100.0) / 100.0;
        this.restLabel.setText(Konstante.getNumber2(rest));
        return rest;
    }

    private class FillInAdapter
    extends MouseAdapter {
        private DoubleInput2 input;

        public FillInAdapter(DoubleInput2 input) {
            this.input = input;
        }

        public void mouseUp(MouseEvent e) {
            try {
                double rest = KombinovanoPlacanje.this.calcRest();
                if (rest <= 0.0) {
                    return;
                }
                if (this.input.getResult() != 0.0) {
                    return;
                }
                this.input.setResult(rest);
                KombinovanoPlacanje.this.calcRest();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }

    private class RestAdapter
    extends KeyAdapter {
        private RestAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            try {
                KombinovanoPlacanje.this.calcRest();
            }
            catch (InputException inputException) {
                // empty catch block
            }
        }
    }
}

