/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.KasaGrafik;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.Konobari;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class KasaGrafici {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private Kasa kasa;
    private int rb = 0;
    Composite dugmici;

    public KasaGrafici(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/artikliV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_KASE_GRAFICI"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 140;
        data.heightHint = 500;
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK__KASA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 320;
        data.heightHint = 500;
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_DODELJENI_GRAFICI"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_DODELA_GRAFIKA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                KasaGrafici.this.updateKase();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = KasaGrafici.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                KasaGrafici.this.setActiveKasa((Kasa)KasaGrafici.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<Kasa> sveKase = this.server.findAllKasa();
        this.rb = sveKase.size() + 1;
        for (Kasa k : sveKase) {
            this.listModel.addElement(k);
        }
        this.kasa = null;
        this.display.setText("");
    }

    private void updateKase() {
        if (this.kasa == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        KasaGraficiDialog sd = new KasaGraficiDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_KASE_GRAFICI"), new Object[0])), this.kasa);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_KASE_GRAFICI"), new Object[0]) + ": " + sd.getResult());
            this.reload();
        }
    }

    private void setActiveKasa(Kasa k) {
        this.kasa = k;
        List<Long> kg = this.server.getListGrafiksKasa(k);
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_SLIKA"), new Object[0]) + ": ").append(k.getOznaka()).append("\n");
        this.display.setText(bld.toString());
    }

    private class KasaGraficiDialog {
        private List<Button> graficiDugmici;
        private List<KasaGrafik> listaKasaGrafika;
        private List<GrafikSale> listaGrafika;
        private Kasa input;
        private Kasa result;
        private Map<String, TextInput2> mapa = new HashMap<String, TextInput2>();

        public KasaGraficiDialog(SWTContainer parent, Kasa input) {
            this.input = input;
            this.listaKasaGrafika = new LinkedList<KasaGrafik>();
            this.listaGrafika = new LinkedList<GrafikSale>();
            this.listaKasaGrafika = KasaGrafici.this.server.getGrafikeOdKase(input);
            for (KasaGrafik kg : this.listaKasaGrafika) {
                GrafikSale gs = KasaGrafici.this.server.getgrafikById(kg.getGrafikID());
                this.listaGrafika.add(gs);
            }
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            this.graficiDugmici = new LinkedList<Button>();
            shell3.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            KasaGraficiDialog.this.ok(parent2);
                        }
                    }
                }
            });
            List<GrafikSale> gsList = null;
            try {
                gsList = KasaGrafici.this.server.getGrafikeJPA();
            }
            catch (Exception ex) {
                Logger.getLogger(Konobari.class.getName()).log(Level.SEVERE, null, ex);
            }
            LinkedList gsKList = null;
            if (input != null) {
                // empty if block
            }
            if (gsKList == null) {
                gsKList = new LinkedList();
            }
            Group gGrafici = new Group((Composite)shell3, 0);
            gGrafici.setText(String.format(Konstante.getBundle().getString("TEXT_GRAFICI"), new Object[0]));
            gGrafici.setLayoutData((Object)new GridData(4, 4, false, false, 5, 5));
            gGrafici.setLayout((Layout)new GridLayout(3, false));
            for (GrafikSale gs : gsList) {
                Button bK = new Button((Composite)gGrafici, 32);
                Label l = new Label((Composite)gGrafici, 0);
                l.setText(String.format(Konstante.getBundle().getString("TEXT_PRIORITET"), new Object[0]));
                TextInput2 t = new TextInput2((Composite)gGrafici, String.format(Konstante.getBundle().getString("TEXT_PRIORITET"), new Object[0]), true);
                t.setName("" + gs.getNaziv());
                bK.setSelection(gsKList.contains(gs));
                bK.setData((Object)gs);
                bK.setText(gs.getNaziv());
                bK.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
                this.graficiDugmici.add(bK);
                this.mapa.put(gs.getNaziv(), t);
            }
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    KasaGraficiDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    KasaGraficiDialog.this.ok(parent2);
                }
            });
            shell3.setDefaultButton(okButt);
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            SWTContainerClass.setDimension(KasaGrafici.this.shell);
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            Kasa k = this.input != null ? this.input : new Kasa();
            try {
                KasaGrafici.this.server.deleteKasaGrafik(k);
                for (Button button : this.graficiDugmici) {
                    GrafikSale gsa;
                    if (!button.getSelection() || (gsa = (GrafikSale)button.getData()) == null) continue;
                    TextInput2 ti2 = this.mapa.get(gsa.getNaziv());
                    int pr = ti2.getText() != "" ? Integer.parseInt(ti2.getText()) : 0;
                    KasaGrafici.this.server.addKasaGrafikSale(k, gsa, pr);
                }
                this.result = k;
                parent.getControl().getShell().close();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }

        public Kasa getResult() {
            return this.result;
        }

        private void loadData() {
            int rez = 0;
            HashMap<Long, Integer> mapaPrioriteta = new HashMap<Long, Integer>();
            for (KasaGrafik kgf : this.listaKasaGrafika) {
                mapaPrioriteta.put(kgf.getGrafikID(), kgf.getPrioritet());
            }
            for (Button button : this.graficiDugmici) {
                GrafikSale gsa = (GrafikSale)button.getData();
                if (gsa == null) continue;
                TextInput2 ti2 = this.mapa.get(gsa.getNaziv());
                rez = mapaPrioriteta.get(gsa.getId()) != null ? (Integer)mapaPrioriteta.get(gsa.getId()) : 0;
                ti2.setResult("" + rez);
                if (!this.listaGrafika.contains(gsa)) continue;
                button.setSelection(true);
            }
        }
    }
}

