/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.KarticeUtrosci;
import com.dev63.restoran.sistem.StockValue;
import com.dev63.restoran.sistem.UpravljanjePrijemnicom;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.ImageButton;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class KarticaPregled {
    Restoran restoran;
    RestoranServer server;
    SWTContainer parent;
    Odeljenje odeljenje;
    static Shell shell;
    static Table table;
    static Table tableBela;
    static Table tableBelaNova;
    static Table tableCrna;
    static Table tableCrnaNova;

    public KarticaPregled(SWTContainer owner, Restoran restoran, final Artikal artikal, Odeljenje ode) {
        this.restoran = restoran;
        this.server = restoran.getServer();
        this.parent = owner;
        shell = this.parent.getControl().getShell();
        this.odeljenje = ode;
        table = KarticaPregled.getKarticaTable((Composite)shell, ode, artikal, this.server, shell);
        ImageButton printButton = new ImageButton((Composite)shell, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText("Stampa");
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(table), false, true, "Pregled kartice za artikal: " + artikal.getName() + ", proizvodno mesto: " + KarticaPregled.this.odeljenje.getNaziv(), shell, KarticaPregled.this.server);
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 70;
        gd.heightHint = 20;
        printButton.setLayoutData(gd);
        SWTContainerClass.setDimension(shell);
        shell.setLayout((Layout)new GridLayout());
        shell.open();
    }

    public static Table getKarticaTable(final Composite c, final Odeljenje odeljenje, final Artikal artikal, final RestoranServer server, final Shell shell) {
        final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        StockValue stockValueBelo = new StockValue();
        StockValue stockValueCrno = new StockValue();
        Date popisPoslednjiDate = server.getPoslednjiSravnjeniPopis();
        long vreme = popisPoslednjiDate != null ? popisPoslednjiDate.getTime() : server.getFirstDateZD().getTime();
        final DateInput2 datum = new DateInput2(c, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(vreme), false, server);
        datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(datum, shell));
        Button prikazi = new Button(c, 8);
        prikazi.setText("Prikazi");
        prikazi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                table.removeAll();
                KarticeUtrosci karticeUtrosci = new KarticeUtrosci(server);
                try {
                    if (odeljenje.getNaziv().equals("MAGACIN")) {
                        karticeUtrosci.getKarticeMagacin(artikal, datum.getResult(), table, 0, 1);
                    } else {
                        karticeUtrosci.getUkupneKartice(artikal, odeljenje, datum.getResult(), table);
                    }
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
            }
        });
        ScrolledComposite compositeTable = new ScrolledComposite(c, 512);
        table = new Table((Composite)compositeTable, 68356);
        compositeTable.setContent((Control)table);
        table.setSize(900, 500);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Button stampa = new Button(c, 8);
        stampa.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(table), false, true, String.format(barmasterText.getString("TEXT_ROBNE_KARTICE_ARTIKLA"), new Object[0]) + " " + artikal.getName(), c.getShell(), server);
            }
        });
        Button export = new Button(c, 8);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(table, shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        TableColumn d = new TableColumn(table, 0x1000000);
        d.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        d.setWidth(90);
        TableColumn u = new TableColumn(table, 0x1000000);
        u.setText(String.format(barmasterText.getString("TEXT_ULAZ_ROBE"), new Object[0]));
        u.setWidth(90);
        TableColumn i = new TableColumn(table, 0x1000000);
        i.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]).toUpperCase() + ")");
        i.setWidth(90);
        TableColumn i2 = new TableColumn(table, 0x1000000);
        i2.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        i2.setWidth(90);
        TableColumn st = new TableColumn(table, 0x1000000);
        st.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        st.setWidth(90);
        TableColumn nv = new TableColumn(table, 0x1000000);
        nv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(100);
        TableColumn nvSpdv = new TableColumn(table, 0x1000000);
        nvSpdv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
        nvSpdv.setWidth(120);
        TableColumn vz = new TableColumn(table, 0x1000000);
        vz.setText(String.format(barmasterText.getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV_SKR"), new Object[0]));
        vz.setWidth(90);
        TableColumn dok = new TableColumn(table, 0x1000000);
        dok.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        dok.setWidth(150);
        return table;
    }

    public static Table getKarticaTableBele(final Composite c, final Odeljenje odeljenje, final Artikal artikal, final RestoranServer server, Shell shell) {
        final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        StockValue stockValue = new StockValue();
        Date popisPoslednjiDate = server.getPoslednjiSravnjeniPopis();
        long vreme = popisPoslednjiDate != null ? popisPoslednjiDate.getTime() : server.getFirstDateZD().getTime();
        final DateInput2 datum = new DateInput2(c, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(vreme), false, server);
        datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(datum, shell));
        Button prikazi = new Button(c, 8);
        prikazi.setText("Prikazi");
        prikazi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                tableBela.removeAll();
                KarticeUtrosci karticeUtrosci = new KarticeUtrosci(server);
                try {
                    if (odeljenje.getNaziv().equals("MAGACIN")) {
                        karticeUtrosci.getKarticeMagacin(artikal, datum.getResult(), tableBela, 0, -1);
                    } else {
                        karticeUtrosci.getKartice(artikal, odeljenje, datum.getResult(), tableBela, 0, -1);
                    }
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
            }
        });
        ScrolledComposite compositeTable = new ScrolledComposite(c, 512);
        tableBela = new Table((Composite)compositeTable, 68356);
        compositeTable.setContent((Control)table);
        tableBela.setSize(900, 500);
        tableBela.setHeaderVisible(true);
        tableBela.setLinesVisible(true);
        tableBela.addListener(6, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        Button stampa = new Button(c, 8);
        stampa.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(tableBela), false, true, String.format(barmasterText.getString("TEXT_OSNOVNE_ROBNE_KARTICE_ARTIKLA"), new Object[0]) + " " + artikal.getName(), c.getShell(), server);
            }
        });
        TableColumn d = new TableColumn(tableBela, 0x1000000);
        d.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        d.setWidth(90);
        TableColumn u = new TableColumn(tableBela, 0x1000000);
        u.setText(String.format(barmasterText.getString("TEXT_ULAZ_ROBE"), new Object[0]));
        u.setWidth(70);
        TableColumn i = new TableColumn(tableBela, 0x1000000);
        i.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]).toUpperCase() + ")");
        i.setWidth(80);
        TableColumn i2 = new TableColumn(tableBela, 0x1000000);
        i2.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        i2.setWidth(90);
        TableColumn st = new TableColumn(tableBela, 0x1000000);
        st.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        st.setWidth(90);
        TableColumn nv = new TableColumn(tableBela, 0x1000000);
        nv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(100);
        TableColumn nvSpdv = new TableColumn(tableBela, 0x1000000);
        nvSpdv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
        nvSpdv.setWidth(120);
        TableColumn vz = new TableColumn(tableBela, 0x1000000);
        vz.setText(String.format(barmasterText.getString("TEXT_VREDNOST_ZALIHA_SKR"), new Object[0]));
        vz.setWidth(90);
        TableColumn dok = new TableColumn(tableBela, 0x1000000);
        dok.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        dok.setWidth(150);
        return tableBela;
    }

    public static Table getKarticaTableCrne(final Composite c, final Odeljenje odeljenje, final Artikal artikal, final RestoranServer server, Shell shell) {
        final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        StockValue stockValue = new StockValue();
        Date popisPoslednjiDate = server.getPoslednjiSravnjeniPopis();
        long vreme = popisPoslednjiDate != null ? popisPoslednjiDate.getTime() : server.getFirstDateZD().getTime();
        final DateInput2 datum = new DateInput2(c, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(vreme), false, server);
        datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(datum, shell));
        Button prikazi = new Button(c, 8);
        prikazi.setText("Prikazi");
        prikazi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                tableCrna.removeAll();
                KarticeUtrosci karticeUtrosci = new KarticeUtrosci(server);
                try {
                    if (odeljenje.getNaziv().equals("MAGACIN")) {
                        karticeUtrosci.getKarticeMagacin(artikal, datum.getResult(), tableCrna, 1, -1);
                    } else {
                        karticeUtrosci.getKartice(artikal, odeljenje, datum.getResult(), tableCrna, 1, -1);
                    }
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
            }
        });
        ScrolledComposite compositeTable = new ScrolledComposite(c, 512);
        tableCrna = new Table((Composite)compositeTable, 68356);
        compositeTable.setContent((Control)table);
        tableCrna.setSize(900, 500);
        tableCrna.setHeaderVisible(true);
        tableCrna.setLinesVisible(true);
        Button stampa = new Button(c, 8);
        stampa.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(tableCrna), false, true, String.format(barmasterText.getString("TEXT_DODATNE_ROBNE_KARTICE_ARTIKLA"), new Object[0]) + " " + artikal.getName(), c.getShell(), server);
            }
        });
        TableColumn d = new TableColumn(tableCrna, 0x1000000);
        d.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        d.setWidth(90);
        TableColumn u = new TableColumn(tableCrna, 0x1000000);
        u.setText(String.format(barmasterText.getString("TEXT_ULAZ_ROBE"), new Object[0]));
        u.setWidth(90);
        TableColumn i = new TableColumn(tableCrna, 0x1000000);
        i.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]).toUpperCase() + ")");
        i.setWidth(90);
        TableColumn i2 = new TableColumn(tableCrna, 0x1000000);
        i2.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        i2.setWidth(90);
        TableColumn st = new TableColumn(tableCrna, 0x1000000);
        st.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        st.setWidth(90);
        TableColumn nv = new TableColumn(tableCrna, 0x1000000);
        nv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(100);
        TableColumn nvSpdv = new TableColumn(tableCrna, 0x1000000);
        nvSpdv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
        nvSpdv.setWidth(120);
        TableColumn vz = new TableColumn(tableCrna, 0x1000000);
        vz.setText(String.format(barmasterText.getString("TEXT_VREDNOST_ZALIHA_SKR"), new Object[0]));
        vz.setWidth(90);
        TableColumn dok = new TableColumn(tableCrna, 0x1000000);
        dok.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        dok.setWidth(150);
        return tableCrna;
    }

    public static Table getKarticaTableBeleNove(final Composite c, final Odeljenje odeljenje, final Artikal artikal, final RestoranServer server, Shell shell) {
        final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        final StockValue stockValue = new StockValue();
        Date popisPoslednjiDate = server.getPoslednjiSravnjeniPopis();
        long vreme = popisPoslednjiDate != null ? popisPoslednjiDate.getTime() : server.getFirstDateZD().getTime();
        final DateInput2 datum = new DateInput2(c, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(vreme), false, server);
        datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(datum, shell));
        Button prikazi = new Button(c, 8);
        prikazi.setText("Prikazi");
        prikazi.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                tableBelaNova.removeAll();
                List<Kartica> kartice = null;
                try {
                    kartice = server.readKarticeBele(artikal, odeljenje);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LinkedList<String> magDok = new LinkedList<String>();
                LinkedList<String> odDok = new LinkedList<String>();
                for (TipPrijemnice tipPrijemnice : TipPrijemnice.values()) {
                    magDok.add(tipPrijemnice.getDocMark());
                }
                magDok.add("(p)");
                magDok.add(TipTrebovanja.POVRAT_U_MAGACIN.getDocMark());
                for (Enum enum_ : TipTrebovanja.values()) {
                    odDok.add(((TipTrebovanja)enum_).getDocMark());
                }
                double stanje = 0.0;
                double vrednost = 0.0;
                double nc = 0.0;
                double ukupanUlaz = 0.0;
                double ukupanIzlaz = 0.0;
                try {
                    stanje = server.getSumBelo(Konstante.getYesterdayDate(datum.getResult()), odeljenje, artikal, false, true);
                }
                catch (InputException e) {
                    e.printStackTrace();
                }
                for (Kartica k : kartice) {
                    System.out.println(k.getDokument());
                    if (k.getKolicina() == 0.0 && !k.getDokument().contains("Popis")) continue;
                    nc = 0.0;
                    String ulaz = "";
                    String izlaz = "";
                    stanje = k.getDokument().contains("Popis") ? k.getKolicina() : (stanje += k.getKolicina().doubleValue());
                    if (odeljenje.getMagacin() != null && odeljenje.getMagacin().booleanValue() || odeljenje.getNaziv().equalsIgnoreCase(Konstante.getMagacinName())) {
                        for (String string : magDok) {
                            if (!k.getDokument().endsWith(string)) continue;
                            nc = k.getNabavnaCena();
                        }
                    } else {
                        nc = k.getNabavnaCena();
                    }
                    double pocetnaVrednost = stockValue.getValue();
                    if (k.getKolicina() < 0.0) {
                        ukupanIzlaz -= k.getKolicina().doubleValue();
                        izlaz = Konstante.getNumber4(0.0 - k.getKolicina());
                        stockValue.remove(Math.abs(k.getKolicina()));
                    } else {
                        ukupanUlaz += k.getKolicina().doubleValue();
                        ulaz = Konstante.getNumber4(k.getKolicina());
                        stockValue.add(Math.abs(k.getKolicina()), nc);
                    }
                    vrednost = stockValue.getValue();
                    TableItem item = new TableItem(tableBelaNova, 0);
                    if (nc == 0.0) {
                        nc = Math.abs(pocetnaVrednost - vrednost) / Math.abs(k.getKolicina());
                    }
                    if (k.getDokument() != null && k.getDokument().length() > 5 && k.getDokument().substring(0, 5).equals(String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]))) {
                        item.setText(new String[]{Konstante.getDate(k.getDatum()), "", "", "", Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
                        item.setBackground(c.getDisplay().getSystemColor(15));
                        continue;
                    }
                    item.setText(new String[]{Konstante.getDate(k.getDatum()), ulaz, k.getIzlazKOM() != null ? k.getIzlazKOM().toString() : "", izlaz, Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
                }
                TableItem item = new TableItem(tableBelaNova, 0);
                item.setText(new String[]{String.format(barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber4(ukupanUlaz), "", Konstante.getNumber4(ukupanIzlaz), "", "", ""});
                for (TableColumn tc : tableBelaNova.getColumns()) {
                    tc.pack();
                }
            }
        });
        ScrolledComposite compositeTable = new ScrolledComposite(c, 512);
        tableBelaNova = new Table((Composite)compositeTable, 68356);
        compositeTable.setContent((Control)table);
        tableBelaNova.setSize(900, 500);
        tableBelaNova.setHeaderVisible(true);
        tableBelaNova.setLinesVisible(true);
        tableBelaNova.addListener(6, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        Button stampa = new Button(c, 8);
        stampa.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(tableBelaNova), false, true, String.format(barmasterText.getString("TEXT_OSNOVNE_ROBNE_KARTICE_ARTIKLA"), new Object[0]) + " " + artikal.getName(), c.getShell(), server);
            }
        });
        TableColumn d = new TableColumn(tableBelaNova, 0x1000000);
        d.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        d.setWidth(90);
        TableColumn u = new TableColumn(tableBelaNova, 0x1000000);
        u.setText(String.format(barmasterText.getString("TEXT_ULAZ_ROBE"), new Object[0]));
        u.setWidth(90);
        TableColumn i = new TableColumn(tableBelaNova, 0x1000000);
        i.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]).toUpperCase() + ")");
        i.setWidth(90);
        TableColumn i2 = new TableColumn(tableBelaNova, 0x1000000);
        i2.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        i2.setWidth(90);
        TableColumn st = new TableColumn(tableBelaNova, 0x1000000);
        st.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        st.setWidth(90);
        TableColumn nv = new TableColumn(tableBelaNova, 0x1000000);
        nv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(80);
        TableColumn vz = new TableColumn(tableBelaNova, 0x1000000);
        vz.setText(String.format(barmasterText.getString("TEXT_VREDNOST_ZALIHA_SKR"), new Object[0]));
        vz.setWidth(90);
        TableColumn dok = new TableColumn(tableBelaNova, 0x1000000);
        dok.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        dok.setWidth(150);
        return tableBelaNova;
    }

    public static Table getKarticaTableCrneNove(final Composite c, final Odeljenje odeljenje, final Artikal artikal, final RestoranServer server, Shell shell) {
        final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        final StockValue stockValue = new StockValue();
        Date popisPoslednjiDate = server.getPoslednjiSravnjeniPopis();
        long vreme = popisPoslednjiDate != null ? popisPoslednjiDate.getTime() : server.getFirstDateZD().getTime();
        final DateInput2 datum = new DateInput2(c, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(vreme), false, server);
        datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(datum, shell));
        Button prikazi = new Button(c, 8);
        prikazi.setText("Prikazi");
        prikazi.addListener(13, new Listener(){

            /*
             * WARNING - void declaration
             */
            public void handleEvent(Event event) {
                tableCrnaNova.removeAll();
                List<Kartica> kartice = null;
                try {
                    void var18_25;
                    kartice = server.readKarticeNovaCrno(artikal, odeljenje, datum.getResult());
                    double stanje = 0.0;
                    double vrednost = 0.0;
                    double nc = 0.0;
                    double ukupanUlaz = 0.0;
                    double ukupanIzlaz = 0.0;
                    stanje = server.getSumBelo(Konstante.getYesterdayDate(datum.getResult()), odeljenje, artikal, true, true);
                    LinkedList<String> magDok = new LinkedList<String>();
                    LinkedList<String> odDok = new LinkedList<String>();
                    for (TipPrijemnice tipPrijemnice : TipPrijemnice.values()) {
                        magDok.add(tipPrijemnice.getDocMark());
                    }
                    magDok.add("(p)");
                    for (Enum enum_ : TipTrebovanja.values()) {
                        odDok.add(((TipTrebovanja)enum_).getDocMark());
                    }
                    for (Kartica k : kartice) {
                        void var18_23;
                        if (k.getKolicina() == 0.0) continue;
                        nc = 0.0;
                        String ulaz = "";
                        String string = "";
                        stanje = k.getDokument().contains("Popis") ? k.getKolicina() : (stanje += k.getKolicina().doubleValue());
                        if (odeljenje.getNaziv().equalsIgnoreCase(Konstante.getMagacinName())) {
                            for (String string2 : magDok) {
                                if (!k.getDokument().endsWith(string2)) continue;
                                nc = k.getNabavnaCena();
                            }
                        } else {
                            nc = k.getNabavnaCena();
                        }
                        double pocetnaVrednost = stockValue.getValue();
                        if (k.getKolicina() < 0.0) {
                            ukupanIzlaz -= k.getKolicina().doubleValue();
                            String string3 = Konstante.getNumber4(0.0 - k.getKolicina());
                            stockValue.remove(Math.abs(k.getKolicina()));
                        } else {
                            ukupanUlaz += k.getKolicina().doubleValue();
                            ulaz = Konstante.getNumber4(k.getKolicina());
                            stockValue.add(Math.abs(k.getKolicina()), nc);
                        }
                        vrednost = stockValue.getValue();
                        TableItem item = new TableItem(tableCrnaNova, 0);
                        if (nc == 0.0) {
                            nc = Math.abs(pocetnaVrednost - vrednost) / Math.abs(k.getKolicina());
                        }
                        if (k.getDokument() != null && k.getDokument().length() > 5 && k.getDokument().substring(0, 5).equals(String.format(barmasterText.getString("TEXT_POPIS"), new Object[0]))) {
                            item.setText(new String[]{Konstante.getDate(k.getDatum()), "", "", "", Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
                            item.setBackground(c.getDisplay().getSystemColor(15));
                            continue;
                        }
                        item.setText(new String[]{Konstante.getDate(k.getDatum()), ulaz, k.getIzlazKOM() != null ? k.getIzlazKOM().toString() : "", var18_23, Konstante.getNumber4(stanje), Konstante.getNumber4(nc), Konstante.getNumber4(vrednost), k.getDokument()});
                    }
                    TableItem item = new TableItem(tableCrnaNova, 0);
                    item.setText(new String[]{String.format(barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber4(ukupanUlaz), "", Konstante.getNumber4(ukupanIzlaz), "", "", ""});
                    TableColumn[] tableColumnArray = tableCrnaNova.getColumns();
                    int n = tableColumnArray.length;
                    boolean bl = false;
                    while (var18_25 < n) {
                        TableColumn tc = tableColumnArray[var18_25];
                        tc.pack();
                        ++var18_25;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ScrolledComposite compositeTable = new ScrolledComposite(c, 512);
        tableCrnaNova = new Table((Composite)compositeTable, 68356);
        compositeTable.setContent((Control)table);
        tableCrnaNova.setSize(900, 500);
        tableCrnaNova.setHeaderVisible(true);
        tableCrnaNova.setLinesVisible(true);
        Button stampa = new Button(c, 8);
        stampa.setText(String.format(barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(tableCrnaNova), false, true, String.format(barmasterText.getString("TEXT_DODATNE_ROBNE_KARTICE_ARTIKLA"), new Object[0]) + " " + artikal.getName(), c.getShell(), server);
            }
        });
        TableColumn d = new TableColumn(tableCrnaNova, 0x1000000);
        d.setText(String.format(barmasterText.getString("TEXT_DATUM"), new Object[0]));
        d.setWidth(90);
        TableColumn u = new TableColumn(tableCrnaNova, 0x1000000);
        u.setText(String.format(barmasterText.getString("TEXT_ULAZ_ROBE"), new Object[0]));
        u.setWidth(90);
        TableColumn i = new TableColumn(tableCrnaNova, 0x1000000);
        i.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_KOMAD_SKR"), new Object[0]).toUpperCase() + ")");
        i.setWidth(90);
        TableColumn i2 = new TableColumn(tableCrnaNova, 0x1000000);
        i2.setText(String.format(barmasterText.getString("TEXT_IZLAZ_ROBE"), new Object[0]) + " (" + String.format(barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]) + ")");
        i2.setWidth(90);
        TableColumn st = new TableColumn(tableCrnaNova, 0x1000000);
        st.setText(String.format(barmasterText.getString("TEXT_STANJE"), new Object[0]));
        st.setWidth(90);
        TableColumn nv = new TableColumn(tableCrnaNova, 0x1000000);
        nv.setText(String.format(barmasterText.getString("TEXT_NABAVNA_CENA_SKR"), new Object[0]));
        nv.setWidth(80);
        TableColumn vz = new TableColumn(tableCrnaNova, 0x1000000);
        vz.setText(String.format(barmasterText.getString("TEXT_VREDNOST_ZALIHA_SKR"), new Object[0]));
        vz.setWidth(90);
        TableColumn dok = new TableColumn(tableCrnaNova, 0x1000000);
        dok.setText(String.format(barmasterText.getString("TEXT_DOKUMENT"), new Object[0]));
        dok.setWidth(150);
        return tableCrnaNova;
    }

    public static class DocumentListener
    implements Listener {
        private Shell shell;
        private Restoran rest;

        public DocumentListener(Shell shell, Restoran rest) {
            this.shell = shell;
            this.rest = rest;
        }

        public void handleEvent(Event event) {
            TableItem ti;
            String docMark;
            Table t = (Table)event.widget;
            int colIndex = -1;
            for (TableColumn tableColumn : t.getColumns()) {
                if (tableColumn.getText().equalsIgnoreCase(String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DOKUMENT"), new Object[0]))) {
                    // empty if block
                }
                colIndex = t.indexOf(tableColumn);
            }
            int rowIdx = t.getSelectionIndex();
            System.out.println("rowIdx = " + rowIdx);
            if (colIndex > -1 && rowIdx > -1 && rowIdx < t.getItemCount() && (docMark = (ti = t.getItem(rowIdx)).getText(colIndex)) != null && docMark.length() > 0) {
                HashMap<String, Enum> pMarks = new HashMap<String, Enum>();
                HashMap<String, TipTrebovanja> tMarks = new HashMap<String, TipTrebovanja>();
                for (TipTrebovanja tipTrebovanja : TipTrebovanja.values()) {
                    tMarks.put(tipTrebovanja.getDocMark(), tipTrebovanja);
                }
                for (Enum enum_ : TipPrijemnice.values()) {
                    pMarks.put(((TipPrijemnice)enum_).getDocMark(), enum_);
                }
                if (docMark.contains("(")) {
                    int f = docMark.indexOf("(");
                    int l = docMark.indexOf(")");
                    String typ = docMark.substring(f + 1, l);
                    String string = docMark.substring(0, f);
                    Trebovanje treb = this.rest.getServer().findTrebovanjeByDocMark(string, null);
                    if (treb != null) {
                        new UpravljanjeTrebovanjem(this.shell, this.rest, treb, treb.getU(), treb.getIz(), tMarks.containsKey(typ) ? (TipTrebovanja)((Object)tMarks.get(typ)) : TipTrebovanja.DIREKTNO_SA_KNJIZ, null, true, true, true);
                    } else {
                        Prijemnica pr = this.rest.getServer().findPrijemnicaByDocMark(docMark, null);
                        if (pr != null) {
                            new UpravljanjePrijemnicom(this.shell, this.rest, pr, pMarks.containsKey(typ) ? (TipPrijemnice)((Object)pMarks.get(typ)) : TipPrijemnice.PRIJEMNICA, null, true, true);
                        }
                    }
                } else if (docMark.contains("-")) {
                    Prijemnica pr;
                    int f = docMark.lastIndexOf("-");
                    String typ = docMark.substring(f + 1, docMark.length());
                    if (tMarks.containsKey(typ)) {
                        Trebovanje treb = this.rest.getServer().findTrebovanjeByDocMark(docMark, (TipTrebovanja)((Object)tMarks.get(typ)));
                        if (treb != null) {
                            new UpravljanjeTrebovanjem(this.shell, this.rest, treb, treb.getU(), treb.getIz(), treb.getTip(), null, true, true, true);
                        }
                    } else if (pMarks.containsKey(typ) && (pr = this.rest.getServer().findPrijemnicaByDocMark(docMark, (TipPrijemnice)((Object)pMarks.get(typ)))) != null) {
                        new UpravljanjePrijemnicom(this.shell, this.rest, pr, pr.getTip(), null, true, true);
                    }
                }
            }
        }
    }
}

