/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.JediniceMere;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class JMere {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private JediniceMere active;
    ToolItem item3;
    Composite dugmici;

    public JMere(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        Shell shell = this.parent.getControl().getShell();
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/JMV.gif"));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText("Jedinice mere");
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
        Button uputstvo = new Button(panel1, 8);
        uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText("Opcije");
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText("Spisak jedinica mera");
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText("Atributi jedinice mere");
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  Nova jedinica mere");
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                JMere.this.addJMere();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  Izmena jedinice mere");
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                JMere.this.updateJMere();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText("  Brisanje jedinice mere");
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                JMere.this.deleteJMere();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = JMere.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                JMere.this.setActiveJMere((JediniceMere)JMere.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        this.listModel.clear();
        List<JediniceMere> odeljenja = this.restoran.getServer().readJedMere();
        for (JediniceMere l : odeljenja) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addJMere() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        JMereDialog od = new JMereDialog(SWTContainerClass.makeContainer(shell2, "Unos novog proizvodnog mesta"), null);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log("Unos proizvodnog mesta:   " + od.getResult());
            this.restoran.getServer().addJedMere(od.getResult());
            this.reload();
        }
    }

    private void updateJMere() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        JMereDialog od = new JMereDialog(SWTContainerClass.makeContainer(shell2, "Izmena odeljenja"), this.active);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log("Izmena prodajnog mesta: " + od.getResult());
            this.restoran.getServer().updateJedMere(od.getResult());
            this.reload();
        }
    }

    private void deleteJMere() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)("Da li ste sigurni da zelite da uklonite drzavu " + this.active.getNaziv() + " iz sistema?"));
        if (ok == 0) {
            this.server.log("Brisanje drzave: " + this.active);
            this.restoran.getServer().deleteJedMere(this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveJMere(JediniceMere o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" Naziv: ").append(o.getNaziv()).append("\n");
        this.display.setText(bld.toString());
    }

    private class JMereDialog {
        private TextInput2 name;
        private JediniceMere input;
        private JediniceMere result;

        public JMereDialog(SWTContainer parent, JediniceMere input) {
            this.input = input;
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Label n = new Label((Composite)shell3, 0);
            n.setBackground(shell3.getDisplay().getSystemColor(22));
            n.setText("Naziv");
            this.name = new TextInput2(parent, "Naziv", false);
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    JMereDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    JMereDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            data.horizontalSpan = 2;
            n.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.name.getControl().setLayoutData((Object)data);
            shell3.pack();
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            JediniceMere o = this.input != null ? this.input : new JediniceMere();
            try {
                o.setNaziv(this.name.getResult());
                this.result = o;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }

        public JediniceMere getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getNaziv());
        }
    }
}

