/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.TipArtikla;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IzracunajDnevniPromet2 {
    private Restoran restoran;
    private RestoranServer server;
    List<Kartica> kartica2 = new ArrayList<Kartica>();
    Date day1;
    static List<DnevnoStanje> stanja;
    Date pocetni = null;
    Date krajnji = null;
    Map<Long, List<Normativ>> mapaN;
    Map<Long, Artikal> mapaA;
    Map<Long, Double> mapaK;
    List<Artikal> artikli;
    List<Artikal> sviArtikli;

    public IzracunajDnevniPromet2(Restoran r, Date datum, boolean belo, boolean crno, Odeljenje od) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.pocetni = Konstante.getPocetniDatum(datum, this.server);
        this.krajnji = Konstante.getKrajnjiDatum(datum, this.server);
        stanja = new ArrayList<DnevnoStanje>();
        if (!this.pocetni.after(datum) || Konstante.getDate(datum).equals(Konstante.getDate(this.pocetni))) {
            List<Odeljenje> odeljenja;
            if (od == null) {
                odeljenja = this.server.readOdeljenjeBezMag2();
            } else {
                odeljenja = new ArrayList<Odeljenje>();
                odeljenja.add(od);
            }
            if (belo) {
                this.artikli = this.server.getArtikliStavkeBelo2(this.pocetni, this.krajnji);
                this.mapaN = this.makeMap(this.server.getNormativiBelo(this.pocetni, this.krajnji), this.artikli);
                this.mapaA = this.makeMap2(this.artikli);
                this.mapaK = this.server.getArtikliKolicineBelo2(this.pocetni, this.krajnji);
                this.kartica2 = new ArrayList<Kartica>();
                for (Kartica k : this.server.getKarticeZaDane(this.pocetni, this.krajnji, false)) {
                    this.kartica2.add(k);
                    this.mapaA.put(k.getArtikal().getId(), k.getArtikal());
                }
                for (Artikal a : this.server.getArtikliNormativiBelo2(this.pocetni, this.krajnji)) {
                    this.mapaA.put(a.getId(), a);
                }
                for (Artikal ar : this.artikli) {
                    for (Kartica k : SkidanjeNormativa.napraviKartice2(SkidanjeNormativa.razloziArtikal2(ar, this.mapaK.get(ar.getId()), this.server, this.mapaN, this.mapaA), this.server, this.pocetni)) {
                        this.kartica2.add(k);
                    }
                }
                this.makeMap3();
                for (Odeljenje o : odeljenja) {
                    for (Artikal a : this.sviArtikli) {
                        if (this.izracunajUlaz(a, o) == 0.0 && this.izracunajIzlaz(a, o) == 0.0) continue;
                        DnevnoStanje ds = new DnevnoStanje();
                        ds.setArtikal(a.getName());
                        ds.setArtikalID(a.getId());
                        ds.setDatum(datum);
                        ds.setBeloUlaz(this.izracunajUlaz(a, o));
                        ds.setBeloIzlaz(this.izracunajIzlaz(a, o));
                        ds.setCrnoUlaz(0.0);
                        ds.setCrnoIzlaz(0.0);
                        ds.setOdeljenje(o);
                        stanja.add(ds);
                    }
                }
            }
            if (crno) {
                this.artikli = this.server.getArtikliStavkeCrno2(this.pocetni, this.krajnji);
                this.mapaN = this.makeMap(this.server.getNormativiCrno(this.pocetni, this.krajnji), this.artikli);
                this.mapaA = this.makeMap2(this.artikli);
                this.mapaK = this.server.getArtikliKolicineCrno2(this.pocetni, this.krajnji);
                this.kartica2 = new ArrayList<Kartica>();
                for (Kartica k : this.server.getKarticeZaDane(this.pocetni, this.krajnji, true)) {
                    this.kartica2.add(k);
                    this.mapaA.put(k.getArtikal().getId(), k.getArtikal());
                }
                for (Artikal a : this.server.getArtikliNormativiCrno2(this.pocetni, this.krajnji)) {
                    this.mapaA.put(a.getId(), a);
                }
                for (Artikal ar : this.artikli) {
                    for (Kartica k : SkidanjeNormativa.napraviKartice2(SkidanjeNormativa.razloziArtikal2(ar, this.mapaK.get(ar.getId()), this.server, this.mapaN, this.mapaA), this.server, this.pocetni)) {
                        this.kartica2.add(k);
                    }
                }
                this.makeMap3();
                for (Odeljenje o : odeljenja) {
                    for (Artikal a : this.sviArtikli) {
                        if (this.izracunajUlaz(a, o) == 0.0 && this.izracunajIzlaz(a, o) == 0.0) continue;
                        boolean b = true;
                        for (DnevnoStanje d : stanja) {
                            if (!d.getArtikalID().equals(a.getId()) || !d.getOdeljenje().getId().equals(o.getId())) continue;
                            d.setCrnoUlaz(this.izracunajUlaz(a, o));
                            d.setCrnoIzlaz(this.izracunajIzlaz(a, o));
                            b = false;
                            break;
                        }
                        if (!b) continue;
                        DnevnoStanje ds = new DnevnoStanje();
                        ds.setArtikal(a.getName());
                        ds.setArtikalID(a.getId());
                        ds.setDatum(datum);
                        ds.setCrnoUlaz(this.izracunajUlaz(a, o));
                        ds.setCrnoIzlaz(this.izracunajIzlaz(a, o));
                        ds.setOdeljenje(o);
                        ds.setBeloUlaz(0.0);
                        ds.setBeloIzlaz(0.0);
                        stanja.add(ds);
                    }
                }
            }
        }
    }

    public static List<DnevnoStanje> getDnevnaStanja() {
        return stanja;
    }

    public double izracunajUlaz(Artikal a, Odeljenje o) {
        double ulaz = 0.0;
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().getId().equals(o.getId())) continue;
            if (k.getDokument() != null && k.getDokument().startsWith("Otpis")) {
                ulaz += k.getKolicina().doubleValue();
            }
            if (!(k.getKolicina() > 0.0)) continue;
            ulaz += k.getKolicina().doubleValue();
        }
        return ulaz;
    }

    public double izracunajIzlaz(Artikal a, Odeljenje o) {
        double izlaz = 0.0;
        for (Kartica k : this.kartica2) {
            if (!k.getArtikal().equals(a) || !k.getOdeljenje().getId().equals(o.getId()) || k.getDokument() != null && k.getDokument().startsWith("Otpis") || !(k.getKolicina() < 0.0)) continue;
            izlaz -= k.getKolicina().doubleValue();
        }
        return izlaz;
    }

    Map<Long, List<Normativ>> makeMap(List<Normativ> normativi, List<Artikal> ar) {
        HashMap<Long, List<Normativ>> mapa = new HashMap<Long, List<Normativ>>();
        for (Artikal a : ar) {
            if (!a.getTip().equals((Object)TipArtikla.SLOZ)) continue;
            ArrayList<Normativ> no = new ArrayList<Normativ>();
            for (Normativ n : normativi) {
                if (!n.getArtikal().getId().equals(a.getId())) continue;
                no.add(n);
            }
            mapa.put(a.getId(), no);
        }
        return mapa;
    }

    Map<Long, Artikal> makeMap2(List<Artikal> ar) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        for (Artikal a : ar) {
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    void makeMap3() {
        this.sviArtikli = new ArrayList<Artikal>();
        for (Kartica k : this.kartica2) {
            if (k.getArtikal().getName() == null) {
                k.setArtikal(this.mapaA.get(k.getArtikal().getId()));
            }
            if (this.sviArtikli.contains(k.getArtikal())) continue;
            this.sviArtikli.add(k.getArtikal());
        }
    }
}

