/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class IzracunajDnevniPromet {
    private Date zaDan;
    private final RestoranServer server;
    private List<Odeljenje> odeljenja;
    private List<Kartica> kartice;
    private List<DnevnoStanje> dnevnaStanja;

    public IzracunajDnevniPromet(Date zaDan, List<Odeljenje> odeljenja, RestoranServer server) {
        this.zaDan = zaDan;
        this.server = server;
        this.odeljenja = odeljenja == null ? this.server.readOdeljenje() : odeljenja;
    }

    public IzracunajDnevniPromet(List<Kartica> kartice, RestoranServer server) {
        this.server = server;
        this.kartice = kartice;
    }

    private void setKartice() {
        if (this.kartice != null) {
            return;
        }
        this.kartice = new ArrayList<Kartica>();
        for (Odeljenje odeljenje : this.odeljenja) {
            this.kartice.addAll(this.server.readKartice(this.zaDan, odeljenje));
        }
    }

    public void createDnevnaStanja() {
        this.setKartice();
        this.dnevnaStanja = new ArrayList<DnevnoStanje>();
        HashMap<Key, DnevnoStanje> dnevnaStanjaPoKljucu = new HashMap<Key, DnevnoStanje>();
        for (Kartica kartica : this.kartice) {
            DnevnoStanje ds;
            Key key;
            if (kartica.getArtikal().getId() == 304L) {
                System.out.println();
            }
            if (dnevnaStanjaPoKljucu.containsKey(key = new Key(kartica.getArtikal(), kartica.getOdeljenje()))) {
                ds = (DnevnoStanje)dnevnaStanjaPoKljucu.get(key);
                this.setValues(kartica, ds);
                continue;
            }
            ds = new DnevnoStanje();
            ds.setArtikal(kartica.getArtikal().getName());
            ds.setArtikalID(kartica.getArtikal().getId());
            ds.setOdeljenje(kartica.getOdeljenje());
            ds.setDatum(kartica.getDatum());
            ds.setBeloIzlaz(0.0);
            ds.setBeloUlaz(0.0);
            ds.setCrnoIzlaz(0.0);
            ds.setCrnoUlaz(0.0);
            this.setValues(kartica, ds);
            dnevnaStanjaPoKljucu.put(key, ds);
        }
        this.dnevnaStanja.addAll(dnevnaStanjaPoKljucu.values());
    }

    private void setValues(Kartica kartica, DnevnoStanje ds) {
        double kolicina = 0.0;
        kolicina = kartica.getDokument().toUpperCase().contains("OTPIS") ? (kartica.getIzlazKOM() != null ? (double)kartica.getIzlazKOM().intValue() : kartica.getKolicina()) : kartica.getKolicina();
        boolean crno = Boolean.TRUE.equals(kartica.getCrno());
        if (crno) {
            if (kartica.getDokument().toUpperCase().contains("OTPIS")) {
                ds.setCrnoUlaz(ds.getCrnoUlaz() + kolicina);
            } else if (kartica.getDokument().toUpperCase().contains("UTROSAK")) {
                ds.setCrnoIzlaz(ds.getCrnoIzlaz() - kolicina);
            } else if (kolicina < 0.0) {
                ds.setCrnoIzlaz(ds.getCrnoIzlaz() - kolicina);
            } else {
                ds.setCrnoUlaz(ds.getCrnoUlaz() + kolicina);
            }
        } else if (kartica.getDokument().toUpperCase().contains("OTPIS")) {
            ds.setBeloUlaz(ds.getBeloUlaz() + kolicina);
        } else if (kartica.getDokument().toUpperCase().contains("UTROSAK")) {
            ds.setBeloIzlaz(ds.getBeloIzlaz() - kolicina);
        } else if (kolicina < 0.0) {
            ds.setBeloIzlaz(ds.getBeloIzlaz() - kolicina);
        } else {
            ds.setBeloUlaz(ds.getBeloUlaz() + kolicina);
        }
    }

    public List<DnevnoStanje> getDnevnaStanja() {
        if (this.dnevnaStanja == null) {
            this.createDnevnaStanja();
        }
        return this.dnevnaStanja;
    }

    private class Key {
        private final Artikal artikal;
        private final Odeljenje odeljenje;

        public Key(Artikal artikal, Odeljenje odeljenje) {
            this.artikal = artikal;
            this.odeljenje = odeljenje;
        }

        public int hashCode() {
            int hashFirst = this.artikal != null ? this.artikal.hashCode() : 0;
            int hashSecond = this.odeljenje != null ? this.odeljenje.hashCode() : 0;
            return 37 * hashFirst + 41 * hashSecond;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.artikal.getId() == this.artikal.getId() && key.odeljenje.getId() == this.odeljenje.getId();
        }
    }
}

