/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IzlazneFakture {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<Odeljenje> odeljenja;
    List<Racun> fakture;
    StalniGost komitenti;
    Date day1;
    Date day2;
    boolean roba;
    boolean trosak;
    boolean nerealizovano;
    private static final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public IzlazneFakture(Shell s, Restoran re, final Date d1, final Date d2, StalniGost komitenti, boolean nerealizovano) {
        this.shell = s;
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.komitenti = komitenti;
        this.nerealizovano = nerealizovano;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(5, false));
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 5;
        this.table.setLayoutData((Object)data);
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                if (IzlazneFakture.this.table.getSelectionIndex() > -1) {
                    // empty if block
                }
            }
        });
        this.makeHeaders();
        this.insertRows();
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText("Stampa A4");
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(IzlazneFakture.this.table), false, true, "Promet po artiklima: " + Konstante.getDate(d1) + "-->" + Konstante.getDate(d2), IzlazneFakture.this.shell, IzlazneFakture.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button stampFakGotRac = new Button((Composite)this.shell, 72);
        try {
            stampFakGotRac.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        stampFakGotRac.setText(String.format(barmasterText.getString("TEXT_STAMPA_FAKTURE"), new Object[0]));
        stampFakGotRac.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (IzlazneFakture.this.table.getSelectionIndex() == -1) {
                    return;
                }
                TableItem item = IzlazneFakture.this.table.getItem(IzlazneFakture.this.table.getSelectionIndex());
                long id = Long.parseLong(item.getText(IzlazneFakture.this.table.getColumnCount() - 1));
                Racun r = (Racun)IzlazneFakture.this.server.getBase().find(Racun.class, (Object)id);
                IzlazneFakture.this.server.getBase().refresh((Object)r);
                new FakturaRacun(IzlazneFakture.this.shell.getDisplay(), IzlazneFakture.this.restoran, r, IzlazneFakture.this.restoran.getStope(), 1, r.getBrojBI(), false, null);
            }
        });
        stampFakGotRac.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 8);
        export.setLayoutData((Object)data);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(IzlazneFakture.this.table, IzlazneFakture.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button knjizi = new Button((Composite)this.shell, 8);
        knjizi.setLayoutData((Object)data);
        knjizi.setText(String.format(Konstante.getBundle().getString("TEXT_KNJIZI"), new Object[0]));
        knjizi.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EntityManager base = IzlazneFakture.this.server.getBase();
                Racun r = null;
                if (IzlazneFakture.this.table.getSelectionIndex() > -1) {
                    r = IzlazneFakture.this.fakture.get(IzlazneFakture.this.table.getSelectionIndex());
                    if (r.getRealizovan()) {
                        return;
                    }
                } else {
                    return;
                }
                Placanje pla = IzlazneFakture.this.server.findIznosRacun(r);
                boolean tacno = Konstante.getPorukaDaNe(IzlazneFakture.this.shell, "Da li zelite da proknjizite iznos od " + Konstante.getNumber2(pla.getIznos())).isOdgovorPozitivan();
                if (tacno) {
                    Knjizenje k = new Knjizenje();
                    try {
                        if (r != null) {
                            k.setDatumRealizacije(new Date());
                            k.setDatumUnosa(new Date());
                            k.setRealizovaniIznos(Double.parseDouble(Konstante.getNumber2(pla.getIznos())));
                            k.setRealizovano(true);
                            k.setRacun(r);
                            IzlazneFakture.this.server.CreateKnjizenje(k);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                base.refresh((Object)r);
                IzlazneFakture.this.table.removeAll();
                IzlazneFakture.this.insertRows();
            }
        });
        data.horizontalAlignment = 131072;
        Button izlaz = new Button((Composite)this.shell, 8);
        izlaz.setText("Izlaz");
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzlazneFakture.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void refreshRacune() {
        this.insertRows();
    }

    public void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Broj fakture");
        tc4.setWidth(100);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("Datum dokumenta");
        tc2.setWidth(120);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("Kupac");
        tc3.setWidth(250);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("Vrednost fakture");
        tc9.setWidth(100);
        TableColumn tc10 = new TableColumn(this.table, 131072);
        tc10.setText("Realizovan");
        tc10.setWidth(100);
        TableColumn tc11 = new TableColumn(this.table, 131072);
        tc11.setText("Id");
        tc11.setWidth(0);
        tc11.setResizable(false);
    }

    public void insertRows() {
        this.fakture = this.server.findRacunDatumKomitent(this.day1, this.day2, this.komitenti, this.nerealizovano);
        double vrednostFakture = 0.0;
        double total = 0.0;
        for (Racun r : this.fakture) {
            vrednostFakture = this.server.vrednostFakture(r);
            new TableItem(this.table, 0).setText(new String[]{"" + r.getBrojFakture(), Konstante.getDate(r.getDatum()), r.getStalniGost() == null ? "'nema podatak'" : r.getStalniGost().getNaziv(), Konstante.getNumber2(vrednostFakture), r.getRealizovan() ? "DA" : "NE", String.valueOf(r.getId())});
            total += vrednostFakture;
        }
        new TableItem(this.table, 0).setText(new String[]{"", "", "Total: ", String.format("%.2f", total)});
    }

    public static class IzlazneFaktureInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo komitent;
        Date day1;
        Date day2;
        private List<StalniGost> komitenti;
        SWTContainer parent;
        private Button nr;

        public IzlazneFaktureInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
            this.komitenti = this.server.readStalniGostiKupci();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Knjiga izlaznih faktura");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter pregleda");
            grupa2.setLayoutData((Object)data);
            Label pa = new Label((Composite)grupa2, 0);
            pa.setText("Odaberi komitenta: ");
            this.komitent = new Combo((Composite)grupa2, 0);
            this.komitent.add(String.format(barmasterText.getString("TEXT_SVI_KOMITENTI"), new Object[0]));
            for (StalniGost sg : this.komitenti) {
                this.komitent.add(sg.getNaziv());
            }
            this.komitent.select(0);
            Label n = new Label((Composite)grupa2, 0);
            n.setText("Nerealizovano: ");
            this.nr = new Button((Composite)grupa2, 32);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            n.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            pa.setLayoutData((Object)data);
            this.komitent.setLayoutData((Object)data);
            this.nr.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                StalniGost ss = this.komitent.getSelectionIndex() == 0 ? null : this.komitenti.get(this.komitent.getSelectionIndex() - 1);
                this.server.log("Pregled ulaznih faktura: od datuma->" + this.day1 + " do datuma ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText("Knjiga ulaznih faktura za period: " + Konstante.getDate(this.day1) + " -> " + Konstante.getDate(this.day2));
                new IzlazneFakture(shell2, this.restoran, this.day1, this.day2, ss, this.nr.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

