/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.ImagePath;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.PodgrupaArtikala;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IzborPodgrupe {
    Shell shell;
    RestoranServer server;
    List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    Display display;
    Text text;
    private List<Artikal> artikliSvi;
    private List<Artikal> artikliIzlaz;
    private Map<GrupaArtikala, Set<PodgrupaArtikala>> mapaGrupa = new HashMap<GrupaArtikala, Set<PodgrupaArtikala>>();
    private Map<PodgrupaArtikala, Set<Artikal>> mapaPodgrupa = new HashMap<PodgrupaArtikala, Set<Artikal>>();
    private Map<String, Artikal> mapaArtikala = new HashMap<String, Artikal>();
    private Map<String, Artikal> aIn = new HashMap<String, Artikal>();
    private Map<String, PodgrupaArtikala> pgaIn = new HashMap<String, PodgrupaArtikala>();
    private Map<String, GrupaArtikala> gaIn = new HashMap<String, GrupaArtikala>();

    public IzborPodgrupe(Display d, RestoranServer server) {
        HashSet<BObject> set;
        this.shell = new Shell(d, 0);
        this.shell.setText("Izbor podgrupe");
        this.display = this.shell.getDisplay();
        this.server = server;
        this.artikliSvi = server.findAllArticlesComplexAndHalfProductsNoBlocked();
        this.artikliIzlaz = new LinkedList<Artikal>();
        for (Artikal a : this.artikliSvi) {
            this.mapaArtikala.put(a.getName(), a);
            if (this.mapaPodgrupa.containsKey(a.getPodgrupa())) {
                this.mapaPodgrupa.get(a.getPodgrupa()).add(a);
                continue;
            }
            set = new HashSet<BObject>();
            set.add(a);
            this.mapaPodgrupa.put(a.getPodgrupa(), set);
        }
        for (PodgrupaArtikala pg : this.mapaPodgrupa.keySet()) {
            if (this.mapaGrupa.containsKey(pg.getGrupa())) {
                this.mapaGrupa.get(pg.getGrupa()).add(pg);
                continue;
            }
            set = new HashSet();
            set.add(pg);
            this.mapaGrupa.put(pg.getGrupa(), set);
        }
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.setMaximized(true);
        Composite c1 = new Composite((Composite)this.shell, 0);
        c1.setLayout((Layout)new FillLayout());
        GridData data = new GridData(1040);
        data.widthHint = 629;
        c1.setLayoutData((Object)data);
        Composite c3 = new Composite((Composite)this.shell, 0);
        c3.setLayout((Layout)new FillLayout());
        data = new GridData(1040);
        data.widthHint = 200;
        c3.setLayoutData((Object)data);
        Composite c2 = new Composite((Composite)this.shell, 0);
        c2.setLayout((Layout)new GridLayout());
        data = new GridData(1040);
        data.widthHint = 175;
        c2.setLayoutData((Object)data);
        Tree tree = new Tree(c1, 2080);
        this.text = new Text(c3, 2112);
        data = new GridData(768);
        data.heightHint = 80;
        Button ok = new Button(c2, 16777288);
        ok.setImage(new Image((Device)this.display, ImagePath.getPath() + "/potvrda1.gif"));
        ok.setBackground(this.display.getSystemColor(1));
        ok.setLayoutData((Object)data);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                for (GrupaArtikala ga : IzborPodgrupe.this.gaIn.values()) {
                    for (PodgrupaArtikala pga : (Set)IzborPodgrupe.this.mapaGrupa.get(ga)) {
                        for (Artikal a : (Set)IzborPodgrupe.this.mapaPodgrupa.get(pga)) {
                            if (IzborPodgrupe.this.artikliIzlaz.contains(a)) continue;
                            IzborPodgrupe.this.getArtikliIzlaz().add(a);
                        }
                    }
                }
                for (PodgrupaArtikala pga : IzborPodgrupe.this.pgaIn.values()) {
                    for (Artikal a : (Set)IzborPodgrupe.this.mapaPodgrupa.get(pga)) {
                        if (IzborPodgrupe.this.artikliIzlaz.contains(a)) continue;
                        IzborPodgrupe.this.getArtikliIzlaz().add(a);
                    }
                }
                for (Artikal a : IzborPodgrupe.this.aIn.values()) {
                    if (IzborPodgrupe.this.artikliIzlaz.contains(a)) continue;
                    IzborPodgrupe.this.getArtikliIzlaz().add(a);
                }
                IzborPodgrupe.this.shell.close();
            }
        });
        Button izlaz = new Button(c2, 0x1000040);
        izlaz.setImage(new Image((Device)this.display, ImagePath.getPath() + "/ponisti1.gif"));
        izlaz.setBackground(this.display.getSystemColor(1));
        izlaz.setLayoutData((Object)data);
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IzborPodgrupe.this.podgrupe = new ArrayList<PodgrupaArtikala>();
                IzborPodgrupe.this.shell.close();
            }
        });
        for (GrupaArtikala ga : this.mapaGrupa.keySet()) {
            TreeItem item0 = new TreeItem(tree, 0);
            item0.setText(ga.getNaziv());
            for (PodgrupaArtikala pa : this.mapaGrupa.get(ga)) {
                TreeItem item1 = new TreeItem(item0, 0);
                item1.setText(pa.getNaziv());
                for (Artikal a : this.mapaPodgrupa.get(pa)) {
                    TreeItem item2 = new TreeItem(item1, 0);
                    item2.setText(a.getName());
                }
            }
        }
        this.refresh();
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList items = new ArrayList();
                if (event.detail == 32) {
                    TreeItem source = (TreeItem)event.item;
                    boolean checked = source.getChecked();
                    IzborPodgrupe.checkItems(source, checked);
                    IzborPodgrupe.checkPath(source.getParentItem(), checked, false);
                    int level = 0;
                    for (TreeItem ti = source; ti != null; ti = ti.getParentItem()) {
                        ++level;
                    }
                    block0 : switch (level) {
                        case 1: {
                            for (GrupaArtikala ga : IzborPodgrupe.this.mapaGrupa.keySet()) {
                                if (!ga.getNaziv().equals(source.getText())) continue;
                                if (checked) {
                                    IzborPodgrupe.this.getGaIn().put(ga.getNaziv(), ga);
                                    break block0;
                                }
                                if (!IzborPodgrupe.this.getGaIn().containsKey(ga.getNaziv())) break block0;
                                IzborPodgrupe.this.getGaIn().remove(ga.getNaziv());
                                break block0;
                            }
                            break;
                        }
                        case 2: {
                            for (PodgrupaArtikala pga : IzborPodgrupe.this.mapaPodgrupa.keySet()) {
                                if (!pga.getNaziv().equals(source.getText())) continue;
                                if (checked) {
                                    IzborPodgrupe.this.getPgaIn().put(pga.getNaziv(), pga);
                                    break block0;
                                }
                                if (!IzborPodgrupe.this.getPgaIn().containsKey(pga.getNaziv())) break block0;
                                IzborPodgrupe.this.getPgaIn().remove(pga.getNaziv());
                                break block0;
                            }
                            break;
                        }
                        case 3: {
                            if (!IzborPodgrupe.this.mapaArtikala.containsKey(source.getText())) break;
                            if (checked) {
                                IzborPodgrupe.this.getaIn().put(source.getText(), (Artikal)IzborPodgrupe.this.mapaArtikala.get(source.getText()));
                                break;
                            }
                            if (!IzborPodgrupe.this.getaIn().containsKey(source.getText())) break;
                            IzborPodgrupe.this.getaIn().remove(source.getText());
                        }
                    }
                    IzborPodgrupe.this.refresh();
                }
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public List<PodgrupaArtikala> getPodgrupe() {
        return this.podgrupe;
    }

    public void refresh() {
        try {
            this.text.setText("");
            Comparator<GrupaArtikala> cga = new Comparator<GrupaArtikala>(){

                @Override
                public int compare(GrupaArtikala o1, GrupaArtikala o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            };
            Comparator<PodgrupaArtikala> cpga = new Comparator<PodgrupaArtikala>(){

                @Override
                public int compare(PodgrupaArtikala o1, PodgrupaArtikala o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            };
            Comparator<Artikal> ca = new Comparator<Artikal>(){

                @Override
                public int compare(Artikal o1, Artikal o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            };
            LinkedList<GrupaArtikala> lga = new LinkedList<GrupaArtikala>(this.gaIn.values());
            Collections.sort(lga, cga);
            LinkedList<PodgrupaArtikala> lpga = new LinkedList<PodgrupaArtikala>(this.pgaIn.values());
            Collections.sort(lpga, cpga);
            LinkedList<Artikal> la = new LinkedList<Artikal>(this.aIn.values());
            Collections.sort(la, ca);
            int i = 1;
            String s = "\nIZABRANE GRUPE:\n__________________________\n";
            for (GrupaArtikala ga : lga) {
                s = s + "\n" + i++ + ") " + ga.getNaziv();
            }
            i = 1;
            s = s + "\n\nIZABRANE PODGRUPE:\n__________________________\n";
            for (PodgrupaArtikala pga : lpga) {
                s = s + "\n" + i++ + ") " + pga.getNaziv();
            }
            i = 1;
            s = s + "\n\nIZABRANI ARTIKLI:\n__________________________\n";
            for (Artikal a : la) {
                s = s + "\n" + i++ + ") " + a.getName();
            }
            this.text.setText(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            TreeItem[] items = item.getItems();
            for (int index = 0; index < items.length; ++index) {
                TreeItem child = items[index];
                if (!child.getGrayed() && checked == child.getChecked()) continue;
                grayed = true;
                checked = true;
                break;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        IzborPodgrupe.checkPath(item.getParentItem(), checked, grayed);
    }

    static void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        for (int i = 0; i < items.length; ++i) {
            IzborPodgrupe.checkItems(items[i], checked);
        }
    }

    public Map<String, Artikal> getaIn() {
        return this.aIn;
    }

    public Map<String, PodgrupaArtikala> getPgaIn() {
        return this.pgaIn;
    }

    public Map<String, GrupaArtikala> getGaIn() {
        return this.gaIn;
    }

    public List<Artikal> getArtikliIzlaz() {
        return this.artikliIzlaz;
    }
}

