/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.GrupaTroskova;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class GrupeTroskova {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private GrupaTroskova active;
    ToolItem item3;
    Composite dugmici;

    public GrupeTroskova(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        Shell shell = this.parent.getControl().getShell();
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image troskoviImg = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/troskoviV.gif");
        slika.setImage(troskoviImg);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)troskoviImg));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_GRUPE_TROSKOVA"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        Button uputstvo = new Button(panel1, 8);
        Image uputstvoImg = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(uputstvoImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)uputstvoImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_SPISAK_GRUPA_TROSKOVA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(this.barmasterText.getString("TEXT_ATRIBUTI_GRUPE_TROSKOVA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_NOVA_GRUPA_TROSKOVA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeTroskova.this.addGrupaTroskova();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_IZMENA_GRUPE_TROSKOVA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeTroskova.this.updateGrupaTroskova();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE_GRUPE_TROSKOVA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GrupeTroskova.this.deleteGrupaTroskova();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = GrupeTroskova.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                GrupeTroskova.this.setActiveGrupaTroskova((GrupaTroskova)GrupeTroskova.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(shell);
    }

    private void reload() {
        if (this.lista.getList().isDisposed()) {
            return;
        }
        this.listModel.clear();
        List<GrupaTroskova> grupeTroskova = this.server.getGrupeTroskova();
        for (GrupaTroskova l : grupeTroskova) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addGrupaTroskova() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        GrupaTroskovaDialog od = new GrupaTroskovaDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVE_GRUPE_TROSKOVA"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_UNOS_GRUPE_TROSKOVA"), new Object[0]) + ":   " + od.getResult());
            GrupaTroskova gt = od.getResult();
            this.restoran.getServer().addGrupaTroskova(od.getResult());
        }
        this.reload();
    }

    private void updateGrupaTroskova() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        GrupaTroskovaDialog od = new GrupaTroskovaDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_IZMENA_GRUPE_TROSKOVA"), new Object[0])), this.active);
        SWTContainerClass.makeEnd(shell2);
        if (od.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_GRUPE_TROSKOVA"), new Object[0]) + ": " + od.getResult());
            GrupaTroskova gt = od.getResult();
            GrupaTroskova grupaTroskova = this.restoran.getServer().updateGrupaTroskova(od.getResult());
        }
        this.reload();
    }

    private void deleteGrupaTroskova() {
        if (this.active == null) {
            return;
        }
        if (this.active.getTroskovi() != null && !this.active.getTroskovi().isEmpty() || this.active.getPodGrupe() != null && !this.active.getPodGrupe().isEmpty()) {
            SWTMessage.showMessageDialog(this.parent.getComposite().getShell(), String.format(this.barmasterText.getString("PORUKA_NE_MOZETE_OBRISATI_GRUPU_TROSKOVA_KOJOJ_SU_DODELJENI_TROSKOVI_ILI_PODGRUPE"), new Object[0]));
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_OBRISETE_IZABRANU_GRUPU_TROSKOVA"), this.active.getNaziv()));
        if (ok == 0) {
            this.server.log(String.format(this.barmasterText.getString("LOG_BRISANJE_GRUPE_TROSKOVA"), new Object[0]) + ": " + this.active);
            if (this.active.getNadGrupa() != null) {
                this.active.getNadGrupa().getPodGrupe().remove(this.active);
            }
            this.server.updateGrupaTroskova(this.active.getNadGrupa());
            this.restoran.getServer().deleteGrupaTroskova(this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveGrupaTroskova(GrupaTroskova o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NADREDJENA_GRUPA"), new Object[0]) + ": ").append(o.getNadGrupa() != null ? o.getNadGrupa().getNaziv() : String.format(this.barmasterText.getString("TEXT_NE_POSTOJI"), new Object[0])).append("\n");
        this.display.setText(bld.toString());
    }

    private class GrupaTroskovaDialog {
        private TextInput2 name;
        private GrupaTroskova input;
        private GrupaTroskova result;
        private Combo ngCombo;
        private List<GrupaTroskova> grupeList;
        private List<GrupaTroskova> grupeComboList;

        public GrupaTroskovaDialog(SWTContainer parent, GrupaTroskova input) {
            this.input = input;
            this.grupeList = GrupeTroskova.this.server.getGrupeTroskovaFirstLevel();
            this.grupeComboList = new LinkedList<GrupaTroskova>();
            Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            Label n = new Label((Composite)shell3, 0);
            n.setAlignment(131072);
            n.setBackground(shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(GrupeTroskova.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + " :");
            this.name = new TextInput2(parent, String.format(GrupeTroskova.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]), false);
            Label ng = new Label((Composite)shell3, 0);
            ng.setBackground(shell3.getDisplay().getSystemColor(22));
            ng.setText(String.format(Konstante.getBundle().getString("TEXT_NADREDJENA_GRUPA_TROSKOVA"), new Object[0]) + " :");
            ng.setAlignment(131072);
            this.ngCombo = new Combo((Composite)shell3, 12);
            this.ngCombo.add(String.format(Konstante.getBundle().getString("TEXT_NEMA_NADREDJENU_GRUPU_TROSKOVA"), new Object[0]));
            this.grupeComboList.add(null);
            this.fillInCombo(this.grupeList, 1);
            if (input != null && input.getNadGrupa() != null) {
                this.ngCombo.select(this.grupeComboList.indexOf(input.getNadGrupa()));
            } else {
                this.ngCombo.select(0);
            }
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GrupaTroskovaDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GrupaTroskovaDialog.this.ok(parent2);
                }
            });
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, true);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            GridData data = new GridData(640);
            n.setLayoutData((Object)data);
            ng.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.name.getControl().setLayoutData((Object)data);
            this.ngCombo.setLayoutData((Object)data);
            shell3.pack();
        }

        private void fillInCombo(List<GrupaTroskova> gtList, int level) {
            String prefix = "";
            for (int i = 2; i < level; ++i) {
                prefix = prefix + "   |";
            }
            if (level > 1) {
                prefix = prefix + "   ";
            }
            for (GrupaTroskova gt : gtList) {
                if (gt.equals(this.input)) continue;
                this.ngCombo.add(prefix + gt.getNaziv());
                this.grupeComboList.add(gt);
                if (gt.getPodGrupe() == null || gt.getPodGrupe().isEmpty()) continue;
                int newLevel = level + 1;
                this.fillInCombo(gt.getPodGrupe(), newLevel);
            }
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            GrupaTroskova o = this.input != null ? this.input : new GrupaTroskova();
            try {
                o.setNaziv(this.name.getResult());
                GrupaTroskova novaNG = this.grupeComboList.get(this.ngCombo.getSelectionIndex());
                if (o.getNadGrupa() != null) {
                    if (!o.getNadGrupa().equals(novaNG)) {
                        o.getNadGrupa().getPodGrupe().remove(o);
                        GrupeTroskova.this.server.updateGrupaTroskova(o.getNadGrupa());
                        o.setNadGrupa(novaNG);
                        if (novaNG != null) {
                            novaNG.getPodGrupe().add(o);
                            GrupeTroskova.this.server.updateGrupaTroskova(novaNG);
                        }
                    }
                } else if (novaNG != null) {
                    o.setNadGrupa(novaNG);
                    novaNG.getPodGrupe().add(o);
                    GrupeTroskova.this.server.updateGrupaTroskova(novaNG);
                } else {
                    GrupeTroskova.this.server.updateGrupaTroskova(o);
                }
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(GrupeTroskova.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public GrupaTroskova getResult() {
            return this.result;
        }

        private void loadData() {
            this.name.setResult(this.input.getNaziv());
        }
    }
}

