/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.ArtikalAtribut;
import com.dev63.restoran.model.Atribut;
import com.dev63.restoran.sistem.Atributi;
import com.dev63.restoran.swt.resources.FontCache;
import com.dev63.restoran.swt.resources.ImageCache;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GrupeAtributArtikal
extends Composite {
    EntityManager base;

    public GrupeAtributArtikal(final Composite parent, int style, final Restoran restoran, final List<Atribut> input, Atribut at, final Artikal art) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        final RestoranServer server = restoran.getServer();
        Font f = FontCache.getFont("Arial", 14, 1);
        final LinkedList<Atribut> dostupniAtributi = new LinkedList<Atribut>(server.getGrupaAtributa());
        try {
            final LinkedList<Atribut> atributiIzBaze = new LinkedList<Atribut>(server.listaArtikalAtribut(art.getId()));
            for (int t = 0; t < atributiIzBaze.size(); ++t) {
                for (int y = 0; y < dostupniAtributi.size(); ++y) {
                    if (dostupniAtributi.get(y) != atributiIzBaze.get(t)) continue;
                    dostupniAtributi.remove(y);
                }
            }
            Composite left = new Composite((Composite)this, 0);
            left.setLayout((Layout)new GridLayout());
            left.setLayoutData((Object)new GridData(4, 4, true, true));
            Label l = new Label(left, 0x1000000);
            l.setFont(f);
            l.setText(String.format(Konstante.getBundle().getString("TEXT_DOSTUPNI_OPISI_ZA_ARTIKLE"), new Object[0]));
            l.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final ListViewer lvLeft = new ListViewer(left, 2560);
            lvLeft.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            lvLeft.getList().setFont(f);
            lvLeft.setContentProvider((IContentProvider)new ArrayContentProvider());
            lvLeft.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Atribut at = (Atribut)element;
                    return at.getNaziv();
                }
            });
            lvLeft.setInput(dostupniAtributi);
            Composite control = new Composite((Composite)this, 0);
            control.setLayout((Layout)new GridLayout());
            control.setLayoutData((Object)new GridData(4, 4, false, true));
            Composite right = new Composite((Composite)this, 0);
            right.setLayout((Layout)new GridLayout());
            right.setLayoutData((Object)new GridData(4, 4, true, true));
            Label r = new Label(right, 0x1000040);
            r.setFont(f);
            r.setText(String.format(Konstante.getBundle().getString("TEXT_OPISI_VEZANI_ZA_ARTIKAL"), new Object[0]));
            r.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final ListViewer lvRight = new ListViewer(right, 2560);
            lvRight.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            lvRight.getList().setFont(f);
            lvRight.setContentProvider((IContentProvider)new ArrayContentProvider());
            lvRight.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Atribut at = (Atribut)element;
                    return at.getNaziv();
                }
            });
            lvRight.setInput(atributiIzBaze);
            GridData gd = new GridData(0x1000000, 0x1000000, true, false);
            gd.widthHint = 160;
            gd.heightHint = 80;
            Label spac = new Label(control, 0);
            spac.setLayoutData((Object)gd);
            Button toRight = new Button(control, 16777288);
            toRight.setImage(ImageCache.getImage("strelaDesno.png"));
            toRight.setLayoutData((Object)gd);
            toRight.addSelectionListener((SelectionListener)new SelectionAdapter(){
                String atribut = "";

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection iSel = (IStructuredSelection)lvLeft.getSelection();
                    Atribut at = (Atribut)iSel.getFirstElement();
                    try {
                        long atId = at.getId();
                        this.atribut = at.getNaziv();
                        System.out.println("Ovo je odabrani atribut " + atId + " " + this.atribut + " za artikal " + art.getName());
                        if (at != null && art != null) {
                            dostupniAtributi.remove(at);
                            atributiIzBaze.add(at);
                            server.addArtikalAtribut(new ArtikalAtribut(art.getId(), atId));
                        }
                        lvLeft.refresh();
                        lvRight.refresh();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            Button toLeft = new Button(control, 16777288);
            toLeft.setImage(ImageCache.getImage("strelaLevo.png"));
            toLeft.setLayoutData((Object)gd);
            toLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){
                long id = 0L;

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection iSel = (IStructuredSelection)lvRight.getSelection();
                    Atribut at = (Atribut)iSel.getFirstElement();
                    try {
                        this.id = at.getId();
                        String atribut = at.getNaziv();
                        if (at != null) {
                            dostupniAtributi.add(at);
                            atributiIzBaze.remove(at);
                            System.out.println("Ovo je izbrisani atribut " + this.id + " " + atribut + " za artikal " + art.getName());
                            server.deleteArikalAtribut(art.getId(), this.id);
                        }
                        lvLeft.refresh();
                        lvRight.refresh();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            Button ne = new Button(control, 16777288);
            ne.setText(String.format(Konstante.getBundle().getString("TEXT_UPRAVLJAJ_OPISIMA"), new Object[0]));
            ne.setFont(f);
            ne.setLayoutData((Object)gd);
            ne.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = new Shell(parent.getShell(), 34912);
                    new Atributi(SWTContainerClass.makeContainer(shell, Konstante.getBundle().getString("TEXT_ADMINISTRACIJA_OPISA_ARTIKALA")), restoran);
                    shell.open();
                    while (!shell.isDisposed()) {
                        if (shell.getDisplay().readAndDispatch()) continue;
                        shell.getDisplay().sleep();
                    }
                    List<Atribut> osvezenaLista = server.getGrupaAtributa();
                    LinkedList<Atribut> ukloniLista = new LinkedList<Atribut>();
                    for (Atribut at1 : input) {
                        boolean ima = true;
                        for (Atribut at2 : osvezenaLista) {
                            if (at1.getId().compareTo(at2.getId()) != 0) continue;
                            ima = false;
                            break;
                        }
                        if (ima) continue;
                        ukloniLista.add(at1);
                    }
                    for (Atribut at : ukloniLista) {
                        input.remove(at);
                    }
                    dostupniAtributi.clear();
                    dostupniAtributi.addAll(server.findAtributNotInList(input));
                    lvLeft.refresh();
                    lvRight.refresh();
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

