/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GraficiSale {
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private GrafikSale grafikSale;
    private int rb = 0;
    Composite dugmici;

    public GraficiSale(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/konobariV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_GRAFIK_SALE"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 140;
        data.heightHint = 500;
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_GRAFIKA_SALE"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 320;
        data.heightHint = 500;
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_PUTANJE_GRAFIKA_SALE"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_NOVI_GRAFIK_SALE"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GraficiSale.this.addGrafikSale();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_IZMENA_GRAFIKA_SALE"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GraficiSale.this.updateGrafikSale();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_BRISANJE_GRAFIKA_SALE"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                GraficiSale.this.deleteGrafikSale();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = GraficiSale.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                GraficiSale.this.setActiveGrafikSale((GrafikSale)GraficiSale.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<GrafikSale> graficiSaleLista = this.restoran.getServer().getGrafike();
        this.rb = graficiSaleLista.size() + 1;
        for (GrafikSale gf : graficiSaleLista) {
            this.listModel.addElement(gf);
        }
        this.grafikSale = null;
        this.display.setText("");
    }

    private void addGrafikSale() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        GrafikSaleDialog gd = new GrafikSaleDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_NOVI_GRAFIK_SALE"), new Object[0])), null);
        SWTContainerClass.makeEnd(shell2);
        if (gd.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_NOVI_GRAFIK_SALE"), new Object[0]) + ": " + gd.getResult());
            this.restoran.getServer().addGrafikSale(gd.getResult());
            this.reload();
        }
    }

    private void updateGrafikSale() {
        if (this.grafikSale == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        GrafikSaleDialog sd = new GrafikSaleDialog(SWTContainerClass.makeContainer(shell2, String.format(Konstante.getBundle().getString("TEXT_GRAFIK_SALE"), new Object[0])), this.grafikSale);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_GRAFIK_SALE"), new Object[0]) + ": " + sd.getResult());
            System.out.println("Grafiksale " + sd.getResult());
            this.restoran.getServer().updateGrafikaSale(sd.getResult());
            this.reload();
        }
    }

    private void deleteGrafikSale() {
        if (this.grafikSale == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)("Da li ste sigurni da zelite da uklonite  " + this.grafikSale.getNaziv() + " iz sistema?"));
        if (ok == 0) {
            this.server.log("Brisanje grafika sale: " + this.grafikSale);
            this.restoran.getServer().deleteGrafikSale(this.grafikSale);
            this.grafikSale = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveGrafikSale(GrafikSale gs) {
        this.grafikSale = gs;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_SLIKA"), new Object[0]) + ": ").append(gs.getSlika()).append("\n");
        this.display.setText(bld.toString());
    }

    private class GrafikSaleDialog {
        private TextInput2 naziv;
        private Button slika;
        private String putanja;
        private GrafikSale input;
        private GrafikSale result;

        public GrafikSaleDialog(SWTContainer parent, GrafikSale input) {
            this.input = input;
            final Shell shell3 = parent.getControl().getShell();
            final SWTContainer parent2 = parent;
            shell3.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            GrafikSaleDialog.this.ok(parent2);
                        }
                    }
                }
            });
            Label n = new Label((Composite)shell3, 0);
            n.setBackground(shell3.getDisplay().getSystemColor(22));
            n.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]));
            this.naziv = new TextInput2(parent, String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]), false);
            Label sn = new Label((Composite)shell3, 0);
            sn.setBackground(shell3.getDisplay().getSystemColor(22));
            sn.setText(String.format(Konstante.getBundle().getString("TEXT_SLIKA"), new Object[0]));
            this.slika = new Button((Composite)shell3, 8);
            this.slika.setText("Nadji sliku");
            this.slika.addListener(3, new Listener(){

                public void handleEvent(Event arg0) {
                    String[] FILTER_EXTS = new String[]{"*", "*.png", "*.jpg", "*.gif"};
                    Text fileName = new Text((Composite)shell3, 2048);
                    FileDialog dlg = new FileDialog(shell3, 4096);
                    dlg.setFilterExtensions(FILTER_EXTS);
                    String fn = dlg.open();
                    if (fn != null) {
                        fileName.setText(fn);
                    }
                    GrafikSaleDialog.this.putanja = fileName.getText();
                }
            });
            Button cancelButt = Dugmici.getCancelButton(shell3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GrafikSaleDialog.this.cancel(parent2);
                }
            });
            Button helpButt = Dugmici.getHelpButton(shell3);
            helpButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                }
            });
            Button okButt = Dugmici.getOkButton(shell3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GrafikSaleDialog.this.ok(parent2);
                }
            });
            shell3.setDefaultButton(okButt);
            if (input != null) {
                this.loadData();
            }
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell3.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalSpan = 2;
            data.horizontalAlignment = 131072;
            n.setLayoutData((Object)data);
            sn.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            this.naziv.getControl().setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 100;
            data.heightHint = 30;
            this.slika.setLayoutData((Object)data);
            SWTContainerClass.setDimension(GraficiSale.this.shell);
        }

        private void cancel(SWTContainer parent) {
            parent.getControl().getShell().close();
        }

        private void ok(SWTContainer parent) {
            System.out.println(this.putanja);
            GrafikSale gs = this.input != null ? this.input : new GrafikSale();
            try {
                gs.setNaziv(this.naziv.getResult());
                gs.setSlika(this.putanja);
                this.result = gs;
                parent.getControl().getShell().close();
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }

        public GrafikSale getResult() {
            return this.result;
        }

        private void loadData() {
            this.naziv.setResult(this.input.getNaziv());
            if (this.input.getSlika() != null) {
                this.putanja = this.input.getSlika();
            }
        }
    }
}

