/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.ObjectWrapper;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GotovinskiRacunUska {
    private RestoranServer server;

    public GotovinskiRacunUska(Display display, Restoran restoran, Racun r, List<ObjectWrapper> stope) {
        this.server = restoran.getServer();
        Shell shell = new Shell(display);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Racun");
        shell.setMaximized(true);
        Document doc = new Document(false);
        ArrayList<String> dokument = new ArrayList<String>();
        dokument.addAll(this.makeHeader());
        dokument.addAll(this.makeInvoiceHeader(r));
        this.makeMainTable(doc, r, stope);
        this.makePDVTable(doc, r, stope);
        this.makePlacanjeTable(doc, r);
        doc.addElement((Element)this.makeFooter(r.getKonobar()));
        doc.addElement((Element)this.makePotpisFooter());
        doc.setDefaultFooter();
        Composite composite = new Composite((Composite)shell, 0x1040000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        frame.add((Component)Print.printPreview((Document)doc));
        Konstante.endShell(shell);
    }

    private List<String> makeHeader() {
        ArrayList<String> ret = new ArrayList<String>();
        Setting naziv = this.server.getSetting(Option.OBJEKAT_NAZIV);
        Setting adresa = this.server.getSetting(Option.OBJEKAT_ADRESA);
        Setting obveznikPDV = this.server.getSetting(Option.U_SISTEMU_PDV);
        Setting banka = this.server.getSetting(Option.BANKA);
        Setting mesto = this.server.getSetting(Option.OBJEKAT_MESTO);
        Setting pib = this.server.getSetting(Option.OBJEKAT_PIB);
        Setting racun = this.server.getSetting(Option.RACUN_OBJEKTA);
        Setting telefon = this.server.getSetting(Option.OBJEKAT_TELEFON);
        Setting maticni = this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ);
        Setting web = this.server.getSetting(Option.WEB_ADRESA);
        Setting fax = this.server.getSetting(Option.FAX);
        Setting sifraDelatnosti = this.server.getSetting(Option.SIFRA_DELATNOSTI);
        Setting email = this.server.getSetting(Option.EMAIL);
        ret.add(naziv != null ? "" + adresa.stringValue() : "");
        ret.add(adresa != null ? "Adresa: " + adresa.stringValue() : "");
        ret.add(mesto != null ? "Mesto: " + mesto.stringValue() : "");
        ret.add(obveznikPDV != null ? (obveznikPDV.booleanValue() ? "Obveznik PDV-a: DA" : "Obveznik PDV-a: NE") : "");
        ret.add(pib != null ? "PIB: " + pib.stringValue() : "");
        ret.add(racun != null ? "Racun RSD: " + racun.stringValue() : "");
        ret.add(telefon != null ? "Tel: " + telefon.stringValue() : "");
        ret.add(maticni != null ? "Maticni broj: " + maticni.stringValue() : "");
        ret.add(web != null ? "Web: " + web.stringValue() : "");
        ret.add(fax != null ? "Fax: " + fax.stringValue() : "");
        ret.add(sifraDelatnosti != null ? "Sifra delatnosti: " + sifraDelatnosti.stringValue() : "");
        ret.add(email != null ? "email: " + email.stringValue() : "");
        return ret;
    }

    private List<String> makeInvoiceHeader(Racun r) {
        ArrayList<String> ret = new ArrayList<String>();
        Setting ms = this.server.getSetting(Option.OBJEKAT_MESTO);
        ret.add(r.getStalniGost() != null ? "Kupac: " + r.getStalniGost().getNaziv() : "Kupac: ");
        ret.add(r.getStalniGost() != null ? "Adresa: " + r.getStalniGost().getAdersa() : "Adresa: ");
        ret.add(r.getStalniGost() != null ? "PIB: " + r.getStalniGost().getPib() : "PIB: ");
        ret.add("Datum izdavanja: " + Konstante.getFullFormat(new Date()));
        ret.add("Datum prometa: " + Konstante.getFullFormat(r.getDatum()));
        ret.add("Mesto prometa: " + ms != null ? ms.stringValue() : "");
        return ret;
    }

    private void makeMainTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"usluga", "jm", "kol", "grupa", "pdv", "cena", "iznos"};
        model.setColumnIdentifiers(columns);
        for (StavkaRacuna st : r.getStavke()) {
            Object[] row = new String[columns.length];
            int pos = 0;
            row[pos++] = st.getNaziv();
            row[pos++] = st.getArtikal().getJedinicaMere();
            row[pos++] = Konstante.getNumber1(st.getKolicina());
            double pdv = 0.0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(st.getArtikal().getPoreskaGrupa())) continue;
                row[pos++] = ow.getPercent() + "%";
                pdv = st.getVrednost() / (double)(100 + ow.getPercent()) * (double)ow.getPercent();
                break;
            }
            row[pos++] = String.valueOf(Konstante.getNumber2(pdv));
            row[pos++] = String.valueOf(Konstante.getNumber2(st.getArtikal().getCena()));
            row[pos++] = String.valueOf(Konstante.getNumber2(st.getVrednost()));
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("usluga", "Naziv usluge", 35));
        list.add(new TableColumn("jm", "JM", 15));
        list.add(new TableColumn("kol", "Kolicina", 15));
        list.add(new TableColumn("grupa", "PDV %", 9, "right"));
        list.add(new TableColumn("pdv", "PDV", 25, "right"));
        list.add(new TableColumn("cena", "Cena", 25, "right"));
        list.add(new TableColumn("iznos", "Iznos", 30, "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
        Block total = new Block("Ukupno: " + Konstante.getNumber2(r.total()));
        total.setTextAlign("right");
        total.setBold(true);
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
    }

    private void makePDVTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        Block pdvNaslov = new Block("Obracun PDV:");
        pdvNaslov.setPaddingTop(5);
        pdvNaslov.setPaddingBottom(2);
        pdvNaslov.setBold(true);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"grupa", "stopa", "osnova", "iznos"};
        model.setColumnIdentifiers(columns);
        HashMap<PoreskaGrupa, Double> taxMap = new HashMap<PoreskaGrupa, Double>();
        HashMap<PoreskaGrupa, Double> baseMap = new HashMap<PoreskaGrupa, Double>();
        double porez = 0.0;
        for (StavkaRacuna st : r.getStavke()) {
            Double t;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(st.getArtikal().getPoreskaGrupa())) continue;
                stopa = ow.getPercent();
                break;
            }
            t = (t = (Double)taxMap.get(st.getArtikal().getPoreskaGrupa())) != null ? t : 0.0;
            Double b = (Double)baseMap.get(st.getArtikal().getPoreskaGrupa());
            b = b != null ? b : 0.0;
            t = t + st.getVrednost() / (double)(100 + stopa) * (double)stopa;
            b = b + st.getVrednost() / (double)(100 + stopa) * 100.0;
            taxMap.put(st.getArtikal().getPoreskaGrupa(), t);
            baseMap.put(st.getArtikal().getPoreskaGrupa(), b);
        }
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (taxMap.get(pg) == null) continue;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(pg)) continue;
                stopa = ow.getPercent();
            }
            Object[] row = new String[columns.length];
            Double base = (Double)baseMap.get(pg);
            Double tax = (Double)taxMap.get(pg);
            porez += tax.doubleValue();
            int pos = 0;
            row[pos++] = pg.toString();
            row[pos++] = String.valueOf(stopa);
            row[pos++] = Konstante.getNumber2(base);
            row[pos++] = Konstante.getNumber2(tax);
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("grupa", "Poreska grupa"));
        list.add(new TableColumn("stopa", "Poreska stopa", "right"));
        list.add(new TableColumn("osnova", "Osnovica", "right"));
        list.add(new TableColumn("iznos", "Porez", "right"));
        Table table = new Table((TableModel)model, list);
        doc.addElement((Element)table);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        Block total = new Block("Ukupno porez: " + Konstante.getNumber2(porez));
        total.setBold(true);
        total.setTextAlign("right");
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
    }

    private void makePlacanjeTable(Document doc, Racun r) {
        Block pdvNaslov = new Block("");
        pdvNaslov.setPaddingTop(15);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"datum", "vreme", "nacin", "iznos"};
        model.setColumnIdentifiers(columns);
        if (r.getPlacanja() != null) {
            Object[] row = null;
            for (Placanje rp : r.getPlacanja()) {
                row = new String[columns.length];
                int pos = 0;
                row[pos++] = Konstante.getFullFormat(r.getDatum());
                row[pos++] = rp.getNacin().name();
                row[pos++] = Konstante.getNumber2(rp.getIznos());
                row[pos++] = "";
                model.addRow(row);
            }
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("vreme", "Vreme"));
        list.add(new TableColumn("nacin", "Nacin placanja"));
        list.add(new TableColumn("iznos", "Iznos", "right"));
        list.add(new TableColumn("", "", "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
    }

    private Block makeFooter(Konobar k) {
        Block b = new Block("Arial", 12, false, false);
        String kon = k.getSkrIme() != null ? k.getSkrIme() : k.getPunoime();
        Split s = new Split((Element)new Block("Uslugu izvrsio: " + kon), (Element)new Block(""), (Element)new Block(""));
        b.addElement((Element)s);
        this.addCenterElement(b, Option.RACUN_FOOTER_1, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_2, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_3, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_4, "");
        b.setPaddingTop(12);
        return b;
    }

    private void addCenterElement(Block b, Option option, String prefix) {
        Setting s = this.server.getSetting(option);
        if (s != null) {
            Block c = new Block((Element)new Text(prefix + s.stringValue()));
            c.setTextAlign("center");
            Center center = new Center((Element)c);
            center.setContentHeight(6);
            center.setContentWidth(150);
            b.addElement((Element)center);
        }
    }

    public Block makePotpisFooter() {
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________________");
        b3.setTextAlign("left");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        Block b4 = new Block("Mesto pecata");
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block("Potpis ovlascenog lica");
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        b.setPaddingTop(32);
        return b;
    }
}

