/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.print.Block;
import com.dev63.print.Center;
import com.dev63.print.Document;
import com.dev63.print.Element;
import com.dev63.print.Print;
import com.dev63.print.Split;
import com.dev63.print.Table;
import com.dev63.print.TableColumn;
import com.dev63.print.Text;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.ObjectWrapper;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.stampa.InvoicePrintBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.widgets.Display;

public class GotovinskiRacun {
    private static final String REPORT_ROOT_DIR = "C:/BarMaster/image/";
    private RestoranServer server;
    private String brojBI;

    public GotovinskiRacun(Display display, Restoran restoran, final Racun r, final List<ObjectWrapper> stope, final String brojBI) {
        this.server = restoran.getServer();
        this.brojBI = brojBI;
        Runnable printThread = new Runnable(){

            @Override
            public void run() {
                Setting noviRac = GotovinskiRacun.this.server.getSetting(Option.GOTOVINSKI_RACUN_NOVI_TIP);
                Setting logoFakt = GotovinskiRacun.this.server.getSetting(Option.LOGO_ZAGLAVLJA_FAKTURE);
                Setting footer = GotovinskiRacun.this.server.getSetting(Option.FOOTER_FAKTURE);
                if (noviRac != null && noviRac.booleanValue()) {
                    InvoicePrintBuilder.InvoiceData id = new InvoicePrintBuilder.InvoiceData();
                    Setting naziv = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_NAZIV);
                    Setting nazivPreduzeca = GotovinskiRacun.this.server.getSetting(Option.PREDUZECE_NAZIV);
                    Setting mesto = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_MESTO);
                    Setting adresa = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_ADRESA);
                    Setting obveznikPDV = GotovinskiRacun.this.server.getSetting(Option.U_SISTEMU_PDV);
                    Setting banka = GotovinskiRacun.this.server.getSetting(Option.BANKA);
                    Setting pib = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_PIB);
                    Setting racunBanka = GotovinskiRacun.this.server.getSetting(Option.RACUN_OBJEKTA);
                    Setting telefon = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_TELEFON);
                    Setting maticni = GotovinskiRacun.this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ);
                    Setting web = GotovinskiRacun.this.server.getSetting(Option.WEB_ADRESA);
                    Setting fax = GotovinskiRacun.this.server.getSetting(Option.FAX);
                    Setting sifraDelatnosti = GotovinskiRacun.this.server.getSetting(Option.SIFRA_DELATNOSTI);
                    Setting email = GotovinskiRacun.this.server.getSetting(Option.EMAIL);
                    Setting valuta = GotovinskiRacun.this.server.getSetting(Option.RACUN_VALUTA_PLACANJA);
                    Calendar datumValute = Calendar.getInstance();
                    datumValute.setTime(r.getDatum());
                    id.setAdresa(adresa != null && adresa.stringValue() != null ? adresa.stringValue() : "");
                    id.setAdresaKupca(r.getKomitent() != null && r.getKomitent().getAdresa() != null ? r.getKomitent().getAdresa() + "\n" + r.getKomitent().getMesto() : "");
                    id.setBanka(banka != null && banka.stringValue() != null ? banka.stringValue() : "");
                    id.setBrRacuna(r.getId());
                    id.setDatumIzdavanja(r.getDatum());
                    id.setDatumPrometa(r.getDatum());
                    id.setDelatnost(sifraDelatnosti != null && sifraDelatnosti.stringValue() != null ? sifraDelatnosti.stringValue() : "");
                    id.setEmail(email != null && email.stringValue() != null ? email.stringValue() : "");
                    id.setFax(fax != null && fax.stringValue() != null ? fax.stringValue() : "");
                    id.setLogoPath(logoFakt != null && logoFakt.stringValue() != null ? logoFakt.stringValue() : "");
                    id.setFooterPath(footer != null && footer.stringValue() != null ? footer.stringValue() : "");
                    id.setMatBroj(maticni != null && maticni.stringValue() != null ? maticni.stringValue() : "");
                    id.setMestoIzdavanja(mesto != null && mesto.stringValue() != null ? mesto.stringValue() : "");
                    id.setMestoPrometa(mesto != null && mesto.stringValue() != null ? mesto.stringValue() : "");
                    id.setNazivKupca(r.getKomitent() != null && r.getKomitent().getNaziv() != null ? r.getKomitent().getNaziv() : "");
                    id.setPib(pib != null && pib.stringValue() != null ? pib.stringValue() : "");
                    id.setPibKupca(r.getKomitent() != null && r.getKomitent().getPib() != null ? r.getKomitent().getPib() : "");
                    if (r.getKomitent() != null && r.getKomitent().getSg() != null) {
                        id.setMbKupca(r.getKomitent() != null && r.getKomitent().getSg().getMaticniBroj() != null ? r.getKomitent().getSg().getMaticniBroj() : "");
                    } else {
                        id.setMbKupca(r.getKomitent() != null ? r.getKomitent().getMb() : "");
                    }
                    id.setPoslovnica(naziv != null && naziv.stringValue() != null ? naziv.stringValue() : "");
                    id.setPreduzece(nazivPreduzeca != null && nazivPreduzeca.stringValue() != null ? nazivPreduzeca.stringValue() : "");
                    id.setRacunBroj(racunBanka != null && racunBanka.stringValue() != null ? racunBanka.stringValue() : "");
                    id.setTel(telefon != null && telefon.stringValue() != null ? telefon.stringValue() : "");
                    id.setWeb(web != null && web.stringValue() != null && web.stringValue() != null ? web.stringValue() : "");
                    id.setuPDV(obveznikPDV != null ? (obveznikPDV.booleanValue() ? "DA" : "NE") : "");
                    id.setRacun(r);
                    InvoicePrintBuilder.printToDefault((org.eclipse.nebula.paperclips.core.Print)InvoicePrintBuilder.createNewDocument(InvoicePrintBuilder.makeTitle(id), InvoicePrintBuilder.createBody(new org.eclipse.nebula.paperclips.core.Print[]{InvoicePrintBuilder.makeCashHeader(id), InvoicePrintBuilder.makeItems(id, GotovinskiRacun.this.server, null, null), InvoicePrintBuilder.makeTaxes(id, null), InvoicePrintBuilder.makePayments(id), InvoicePrintBuilder.makeInvoiceFooter(id), InvoicePrintBuilder.makeInvoiceFooter1(id, GotovinskiRacun.this.server, brojBI)}), (org.eclipse.nebula.paperclips.core.Print)InvoicePrintBuilder.makePageFooter(id)), "Gotovinski racun br: " + r.getId(), 1);
                } else {
                    Document doc = new Document(false);
                    doc.addElement((Element)GotovinskiRacun.this.makeLogoHeader());
                    doc.addElement((Element)GotovinskiRacun.this.makeHotelHeader());
                    doc.addElement((Element)GotovinskiRacun.this.makeInvoiceHeader(r));
                    GotovinskiRacun.this.makeMainTable(doc, r, stope);
                    GotovinskiRacun.this.makePDVTable(doc, r, stope);
                    GotovinskiRacun.this.makePlacanjeTable(doc, r);
                    doc.addElement((Element)GotovinskiRacun.this.makeFooter(r.getKonobar()));
                    doc.addElement((Element)GotovinskiRacun.this.makePotpisFooter());
                    doc.setDefaultFooter();
                    Print.printPreview((Document)doc).startPrinterJob(false);
                }
            }
        };
        Konstante.PRINT_EXECUTOR.execute(printThread);
    }

    private Block makeHotelHeader() {
        Setting adresa = this.server.getSetting(Option.OBJEKAT_ADRESA);
        Setting obveznikPDV = this.server.getSetting(Option.U_SISTEMU_PDV);
        Setting banka = this.server.getSetting(Option.BANKA);
        Setting mesto = this.server.getSetting(Option.OBJEKAT_MESTO);
        Setting pib = this.server.getSetting(Option.OBJEKAT_PIB);
        Setting racun = this.server.getSetting(Option.RACUN_OBJEKTA);
        Setting telefon = this.server.getSetting(Option.OBJEKAT_TELEFON);
        Setting maticni = this.server.getSetting(Option.OBJEKAT_MATICNI_BROJ);
        Setting web = this.server.getSetting(Option.WEB_ADRESA);
        Setting fax = this.server.getSetting(Option.FAX);
        Setting sifraDelatnosti = this.server.getSetting(Option.SIFRA_DELATNOSTI);
        Setting email = this.server.getSetting(Option.EMAIL);
        Block b = new Block("Arial", 8, false, false);
        Split s = new Split();
        Block a = new Block(adresa != null ? "Adresa: " + adresa.stringValue() : "");
        a.setBold(true);
        Block opdv = new Block(obveznikPDV != null ? (obveznikPDV.booleanValue() ? "Obveznik PDV-a: DA" : "Obveznik PDV-a: NE") : "");
        opdv.setBold(true);
        Block ba = new Block(banka != null ? "Banka: " + banka.stringValue() : "");
        ba.setBold(true);
        s = new Split((Element)a, (Element)opdv, (Element)ba);
        b.addElement((Element)s);
        Block m = new Block(mesto != null ? "Mesto: " + mesto.stringValue() : "");
        m.setBold(true);
        Block p = new Block(pib != null ? "PIB: " + pib.stringValue() : "");
        p.setBold(true);
        Block rac = new Block(racun != null ? "Racun RSD: " + racun.stringValue() : "");
        rac.setBold(true);
        s = new Split((Element)m, (Element)p, (Element)rac);
        b.addElement((Element)s);
        Block t = new Block(telefon != null ? "Tel: " + telefon.stringValue() : "");
        t.setBold(true);
        Block mb = new Block(maticni != null ? "Maticni broj: " + maticni.stringValue() : "");
        mb.setBold(true);
        Block w = new Block(web != null ? "Web: " + web.stringValue() : "");
        w.setBold(true);
        s = new Split((Element)t, (Element)mb, (Element)w);
        b.addElement((Element)s);
        Block f = new Block(fax != null ? "Fax: " + fax.stringValue() : "");
        f.setBold(true);
        Block sd = new Block(sifraDelatnosti != null ? "Sifra delatnosti: " + sifraDelatnosti.stringValue() : "");
        sd.setBold(true);
        Block em = new Block(email != null ? "email: " + email.stringValue() : "");
        em.setBold(true);
        s = new Split((Element)f, (Element)sd, (Element)em);
        b.addElement((Element)s);
        b.setPaddingTop(1);
        b.setPaddingBottom(1);
        b.setBox(true);
        return b;
    }

    private Block makeLogoHeader() {
        Block b = new Block("Arial", 12, false, true);
        this.addlogoElement(b, Option.OBJEKAT_NAZIV, null);
        b.setPaddingBottom(2);
        return b;
    }

    private void addlogoElement(Block b, Option option, String right) {
        Setting s = this.server.getSetting(option);
        if (s != null) {
            Split sl = new Split();
            Block c = new Block((Element)new Text(s.stringValue()));
            c.setSize(14);
            sl.setLeft((Element)c);
            Block d = new Block(right != null ? right : "");
            sl.setRight((Element)d);
            b.addElement((Element)sl);
        }
    }

    private Block makeInvoiceHeader(Racun r) {
        Block b = new Block("Arial", 8, false, false);
        Block vp = new Block("");
        Block b1 = new Block(r.getStalniGost() != null ? "Kupac: " + r.getStalniGost().getNaziv() : "Kupac: ");
        Block b2 = new Block(r.getStalniGost() != null ? "Adresa: " + r.getStalniGost().getAdersa() : "Adresa: ");
        Block b3 = new Block(r.getStalniGost() != null ? "PIB: " + r.getStalniGost().getPib() : "PIB: ");
        Block date = new Block("Datum izdavanja: " + Konstante.getFullFormat(new Date()));
        Block no = new Block("");
        Split s = new Split((Element)date, (Element)no, (Element)b1);
        b.addElement((Element)s);
        Block time = new Block("Datum prometa: " + Konstante.getFullFormat(r.getDatum()));
        Block soba = new Block("");
        s = new Split((Element)time, (Element)soba, (Element)b2);
        b.addElement((Element)s);
        Setting ms = this.server.getSetting(Option.OBJEKAT_MESTO);
        String mesto = "";
        if (ms != null) {
            mesto = ms.stringValue();
        }
        Block mp = new Block("Mesto prometa: " + mesto);
        s = new Split((Element)mp, (Element)vp, (Element)b3);
        b.addElement((Element)s);
        b.setPaddingTop(10);
        b.setPaddingBottom(15);
        return b;
    }

    private void makeMainTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"usluga", "jm", "kol", "grupa", "pdv", "cena", "iznos"};
        model.setColumnIdentifiers(columns);
        if (r.getMeniPromet() == null) {
            for (StavkaRacuna st : r.getStavke()) {
                Object[] row = new String[columns.length];
                int pos = 0;
                row[pos++] = st.getNaziv();
                row[pos++] = st.getArtikal().getJedinicaMere();
                row[pos++] = Konstante.getNumber1(st.getKolicina());
                double pdv = 0.0;
                for (ObjectWrapper ow : stope) {
                    if (!ow.getData().equals(st.getArtikal().getPoreskaGrupa())) continue;
                    row[pos++] = ow.getPercent() + "%";
                    pdv = st.getVrednost() / (double)(100 + ow.getPercent()) * (double)ow.getPercent();
                    break;
                }
                row[pos++] = String.valueOf(Konstante.getNumber2(pdv));
                row[pos++] = String.valueOf(Konstante.getNumber2(st.getArtikal().getCena()));
                row[pos++] = String.valueOf(Konstante.getNumber2(st.getVrednost()));
                model.addRow(row);
            }
        } else {
            Object[] row = new String[columns.length];
            int pos = 0;
            row[pos++] = r.getMeniPromet().getNaziv();
            row[pos++] = "KOM";
            row[pos++] = Konstante.getNumber1(r.getMeniPromet().getKolicina());
            double pdv = 0.0;
            Setting meniPG = this.server.getSetting(Option.MENI_REDNI_BROJ_PG);
            PoreskaGrupa pg = null;
            PoreskaStopa ps = null;
            try {
                int pgIdx = 0;
                pgIdx = meniPG.intValue();
                pg = PoreskaGrupa.values()[pgIdx - 1];
                ps = PoreskeStope.getPoreskaStopa(pg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            row[pos++] = ps.getStopa() + "%";
            pdv = r.getMeniPromet().getKolicina() / (100.0 + ps.getStopa()) * ps.getStopa();
            row[pos++] = String.valueOf(Konstante.getNumber2(pdv));
            row[pos++] = String.valueOf(Konstante.getNumber2(r.getMeniPromet().getCena()));
            row[pos++] = String.valueOf(Konstante.getNumber2(r.getMeniPromet().getTotal()));
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("usluga", "Naziv usluge", 35));
        list.add(new TableColumn("jm", "JM", 15));
        list.add(new TableColumn("kol", "Kolicina", 15));
        list.add(new TableColumn("grupa", "PDV %", 9, "right"));
        list.add(new TableColumn("pdv", "PDV", 25, "right"));
        list.add(new TableColumn("cena", "Cena", 25, "right"));
        list.add(new TableColumn("iznos", "Iznos", 30, "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
        Block total = new Block("Ukupno: " + Konstante.getNumber2(r.total()));
        total.setTextAlign("right");
        total.setBold(true);
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
    }

    private void makePDVTable(Document doc, Racun r, List<ObjectWrapper> stope) {
        Block pdvNaslov = new Block("Obracun PDV:");
        pdvNaslov.setPaddingTop(5);
        pdvNaslov.setPaddingBottom(2);
        pdvNaslov.setBold(true);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"grupa", "stopa", "osnova", "iznos"};
        model.setColumnIdentifiers(columns);
        HashMap<PoreskaGrupa, Double> taxMap = new HashMap<PoreskaGrupa, Double>();
        HashMap<PoreskaGrupa, Double> baseMap = new HashMap<PoreskaGrupa, Double>();
        double porez = 0.0;
        for (StavkaRacuna st : r.getStavke()) {
            Double t;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(st.getArtikal().getPoreskaGrupa())) continue;
                stopa = ow.getPercent();
                break;
            }
            t = (t = (Double)taxMap.get(st.getArtikal().getPoreskaGrupa())) != null ? t : 0.0;
            Double b = (Double)baseMap.get(st.getArtikal().getPoreskaGrupa());
            b = b != null ? b : 0.0;
            t = t + st.getVrednost() / (double)(100 + stopa) * (double)stopa;
            b = b + st.getVrednost() / (double)(100 + stopa) * 100.0;
            taxMap.put(st.getArtikal().getPoreskaGrupa(), t);
            baseMap.put(st.getArtikal().getPoreskaGrupa(), b);
        }
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (taxMap.get(pg) == null) continue;
            int stopa = 0;
            for (ObjectWrapper ow : stope) {
                if (!ow.getData().equals(pg)) continue;
                stopa = ow.getPercent();
            }
            Object[] row = new String[columns.length];
            Double base = (Double)baseMap.get(pg);
            Double tax = (Double)taxMap.get(pg);
            porez += tax.doubleValue();
            int pos = 0;
            row[pos++] = pg.toString();
            row[pos++] = String.valueOf(stopa);
            row[pos++] = Konstante.getNumber2(base);
            row[pos++] = Konstante.getNumber2(tax);
            model.addRow(row);
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("grupa", "Poreska grupa"));
        list.add(new TableColumn("stopa", "Poreska stopa", "right"));
        list.add(new TableColumn("osnova", "Osnovica", "right"));
        list.add(new TableColumn("iznos", "Porez", "right"));
        Table table = new Table((TableModel)model, list);
        doc.addElement((Element)table);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        Block total = new Block("Ukupno porez: " + Konstante.getNumber2(porez));
        total.setBold(true);
        total.setTextAlign("right");
        total.setBorderTop(true);
        Split s = new Split((Element)new Block(""), (Element)total);
        doc.addElement((Element)s);
    }

    private void makePlacanjeTable(Document doc, Racun r) {
        Block pdvNaslov = new Block("");
        pdvNaslov.setPaddingTop(15);
        doc.addElement((Element)pdvNaslov);
        DefaultTableModel model = new DefaultTableModel();
        Object[] columns = new String[]{"datum", "vreme", "nacin", "iznos"};
        model.setColumnIdentifiers(columns);
        if (r.getPlacanja() != null) {
            Object[] row = null;
            for (Placanje rp : r.getPlacanja()) {
                row = new String[columns.length];
                int pos = 0;
                row[pos++] = Konstante.getFullFormat(r.getDatum());
                row[pos++] = rp.getNacin().name();
                row[pos++] = Konstante.getNumber2(rp.getIznos());
                row[pos++] = "";
                model.addRow(row);
            }
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        list.add(new TableColumn("vreme", "Vreme"));
        list.add(new TableColumn("nacin", "Nacin placanja"));
        list.add(new TableColumn("iznos", "Iznos", "right"));
        list.add(new TableColumn("", "", "right"));
        Table table = new Table((TableModel)model, list);
        table.setCellBorder(false);
        table.setHeaderBorder(false);
        doc.addElement((Element)table);
    }

    private Block makeFooter(Konobar k) {
        Block b = new Block("Arial", 12, false, false);
        String kon = k.getSkrIme() != null ? k.getSkrIme() : k.getPunoime();
        Split s = new Split((Element)new Block("Uslugu izvrsio: " + kon), (Element)new Block(""), (Element)new Block(""));
        b.addElement((Element)s);
        this.addCenterElement(b, Option.RACUN_FOOTER_1, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_2, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_3, "");
        this.addCenterElement(b, Option.RACUN_FOOTER_4, "");
        b.setPaddingTop(12);
        return b;
    }

    private void addCenterElement(Block b, Option option, String prefix) {
        Setting s = this.server.getSetting(option);
        if (s != null) {
            Block c = new Block((Element)new Text(prefix + s.stringValue()));
            c.setTextAlign("center");
            Center center = new Center((Element)c);
            center.setContentHeight(6);
            center.setContentWidth(150);
            b.addElement((Element)center);
        }
    }

    public Block makePotpisFooter() {
        Block b = new Block("Arial", 12, false, false);
        Block b1 = new Block("________________________");
        b1.setTextAlign("center");
        Block b2 = new Block("");
        Block b3 = new Block("________________________________");
        b3.setTextAlign("left");
        Split s1 = new Split((Element)b1, (Element)b2, (Element)b3);
        Block b4 = new Block("Mesto pecata");
        b4.setTextAlign("center");
        Block b5 = new Block("                      ");
        Block b6 = new Block("Potpis ovlascenog lica");
        b6.setTextAlign("center");
        Split s2 = new Split((Element)b4, (Element)b5, (Element)b6);
        b.addElement((Element)s1);
        b.addElement((Element)s2);
        b.setPaddingTop(32);
        return b;
    }
}

