/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.sistem.StalniGosti;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Dobavljaci {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    Composite dugmici;
    private StalniGost active;

    public Dobavljaci(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/dobavljaciV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(this.barmasterText.getString("TEXT_DOBAVLJACI"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        Button uputstvo = new Button(panel1, 8);
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_SPISAK_DOBAVLJACA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(this.barmasterText.getString("TEXT_ATRIBUTI_DOBAVLJACA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  " + String.format(this.barmasterText.getString("TEXT_NOVI_DOBAVLJAC"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Dobavljaci.this.addDobavljac();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  " + String.format(this.barmasterText.getString("TEXT_IZMENA_DOBAVLJACA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Dobavljaci.this.updateDobavljac();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText("  " + String.format(this.barmasterText.getString("TEXT_BRISANJE_DOBAVLJACA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Dobavljaci.this.deleteDobavljac();
            }
        });
        label1.setEnabled(false);
        data = new GridData(1808);
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = Dobavljaci.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                Dobavljaci.this.setActiveDobavljac((StalniGost)Dobavljaci.this.listModel.getElementAt(index));
            }
        });
        this.lista.getControl().setLayoutData((Object)data);
        this.display = new Label((Composite)grupa3, 0);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<StalniGost> grupe = this.server.allDobavljaci();
        for (StalniGost l : grupe) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addDobavljac() {
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        StalniGosti.StalniGostDialogPreduzece gd = new StalniGosti.StalniGostDialogPreduzece(shell2, null, this.server, true, true);
        SWTContainerClass.makeEnd(shell2);
        if (gd.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_UNOS_DOBAVLJACA"), new Object[0]) + ":   " + gd.getResult());
            try {
                this.server.addStalniGost(gd.getResult());
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.parent.getControl().getShell(), 40);
                mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
                mb.setMessage(ex.getMessage());
                mb.open();
                Logger.getLogger(Dobavljaci.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.reload();
        }
    }

    private void updateDobavljac() {
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        StalniGosti.StalniGostDialogPreduzece sd = new StalniGosti.StalniGostDialogPreduzece(shell2, this.active, this.server, true, true);
        SWTContainerClass.makeEnd(shell2);
        if (sd.getResult() != null) {
            this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_DOBAVLJACA"), new Object[0]) + ": " + sd.getResult());
            try {
                this.server.updateStalniGost(sd.getResult());
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.parent.getControl().getShell(), 40);
                mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
                mb.setMessage(ex.getMessage());
                mb.open();
                Logger.getLogger(Dobavljaci.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.reload();
        }
    }

    private void deleteDobavljac() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UKLONITE_DOBAVLJACA"), new Object[0]));
        if (ok == 0) {
            this.server.log(String.format(this.barmasterText.getString("LOG_BRISANJE_DOBAVLJACA"), new Object[0]) + ": " + this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActiveDobavljac(StalniGost d) {
        this.active = d;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": ").append(d.getNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_SKRACENI_NAZIV"), new Object[0]) + ": ").append(d.getSkrNaziv()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_ADRESA"), new Object[0]) + " ").append(d.getAdersa()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_MESTO"), new Object[0]) + ": ").append(d.getMesto()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_MOBILNI_SKR"), new Object[0]) + ": ").append(d.getMob()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_TELEFON_SKR"), new Object[0]) + ": ").append(d.getTelefon()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_FAX"), new Object[0]) + ": ").append(d.getFax()).append("\n");
        bld.append(" " + String.format(this.barmasterText.getString("TEXT_PIB"), new Object[0]) + ": ").append(d.getPib()).append("\n");
        this.display.setText(bld.toString());
    }
}

