/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.vafada.swtcalendar.SWTCalendarDialog;
import com.dev63.hotel.vafada.swtcalendar.SWTCalendarEvent;
import com.dev63.hotel.vafada.swtcalendar.SWTCalendarListener;
import com.dev63.restoran.parts.DateInput2;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public class CalendarAdapter
extends MouseAdapter {
    private DateInput2 input;
    private Shell shell;
    private Font font;

    public CalendarAdapter(DateInput2 input, Shell shell) {
        this.input = input;
        this.shell = shell;
    }

    public CalendarAdapter(DateInput2 input, Shell shell, Font font) {
        this.input = input;
        this.shell = shell;
        this.font = font;
    }

    public void mouseUp(MouseEvent e) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        final SWTCalendarDialog cal = new SWTCalendarDialog(this.shell);
        if (this.font == null || this.font.isDisposed()) {
            Font f;
            FontData fd = this.shell.getDisplay().getSystemFont().getFontData()[0];
            this.font = f = new Font((Device)this.shell.getDisplay(), fd.getName(), 18, fd.getStyle());
        }
        cal.setFont(this.font);
        cal.addDateChangedListener(new SWTCalendarListener(){

            @Override
            public void dateChanged(SWTCalendarEvent calendarEvent) {
                CalendarAdapter.this.input.setResult(calendarEvent.getCalendar().getTime());
                cal.close();
            }
        });
        if (this.input.getText() != null && this.input.getText().length() > 0) {
            try {
                Date d = formatter.parse(this.input.getText());
                cal.setDate(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        cal.open();
        this.font.dispose();
    }
}

