/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.RestoranServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BlokiraniArtikli {
    private RestoranServer server;
    private long sastojak_id;
    private String username;
    private Connection connection;

    public BlokiraniArtikli(long sastojak_id, String userName, RestoranServer server) {
        this.server = server;
        this.username = userName;
        this.sastojak_id = sastojak_id;
        this.connection = server.getConnection();
    }

    public void resiNormative() {
        List<Long> artikli = this.getArtikliIzSastojka(this.sastojak_id);
        if (artikli.size() > 0) {
            for (long id : artikli) {
                this.resiNormativ(id);
            }
        }
    }

    public void resiNormativ(long artikal_id) {
        String normativArtikalQuery = "INSERT INTO normativartikal (datum, uname, ARTIKAL_ID, aktivan) VALUES(NOW(),?,?,1) ";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(normativArtikalQuery);
            ps.setString(1, this.username);
            ps.setLong(2, artikal_id);
            System.out.println(ps);
            ps.execute();
            this.connection.commit();
        }
        catch (SQLException e2) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            e2.printStackTrace();
        }
        String normativQuery = "INSERT INTO normativ (kolicina, ARTIKAL_ID, ODELJENJE_ID, SASTOJAK_ID, NORMATIVARTIKAL_ID) SELECT n.kolicina, n.ARTIKAL_ID, n.ODELJENJE_ID, n.SASTOJAK_ID, na.id AS NORMATIVARTIKAL_ID \r\nFROM normativ n \r\nJOIN normativartikal na ON n.ARTIKAL_ID = na.ARTIKAL_ID \r\nWHERE n.ARTIKAL_ID = ? AND n.SASTOJAK_ID != ? AND na.id = \r\n\t(SELECT id FROM normativartikal ORDER BY id DESC LIMIT 1) \r\nAND n.NORMATIVARTIKAL_ID = \r\n\t(SELECT MAX(n.NORMATIVARTIKAL_ID) \r\n\tFROM normativ n \r\n\tJOIN normativartikal na ON n.ARTIKAL_ID = na.ARTIKAL_ID \r\n\tWHERE n.ARTIKAL_ID = ? AND n.SASTOJAK_ID != ? AND na.id = \r\n\t(SELECT id FROM normativartikal ORDER BY id DESC LIMIT 1) )";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps1 = this.connection.prepareStatement(normativQuery);
            ps1.setLong(1, artikal_id);
            ps1.setLong(2, this.sastojak_id);
            ps1.setLong(3, artikal_id);
            ps1.setLong(4, this.sastojak_id);
            System.out.println(ps1);
            ps1.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public boolean isSastojak() {
        String Query2 = "SELECT COUNT(SASTOJAK_ID) as sastojak FROM normativ n WHERE n.SASTOJAK_ID = ?";
        ArrayList artikli = new ArrayList();
        try {
            PreparedStatement ps = this.connection.prepareStatement(Query2);
            ps.setLong(1, this.sastojak_id);
            ResultSet rSet = ps.executeQuery();
            rSet.next();
            int sastojak = rSet.getInt("sastojak");
            if (sastojak > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public List<Long> getArtikliIzSastojka(long sastojak_id) {
        String Query2 = "SELECT n.ARTIKAL_ID FROM normativ n WHERE n.SASTOJAK_ID = ? GROUP BY n.ARTIKAL_ID";
        ArrayList<Long> artikli = new ArrayList<Long>();
        try {
            PreparedStatement ps = this.connection.prepareStatement(Query2);
            ps.setLong(1, sastojak_id);
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                artikli.add(rSet.getLong("ARTIKAL_ID"));
            }
            return artikli;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

