/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

public class BarmasterEmailer {
    private final String host;
    private final String from;
    private final String user;
    private final String pass;
    private final boolean startTls;
    private final boolean ssl;
    private final boolean authorization;
    private final int port;

    public BarmasterEmailer(Restoran restoran) {
        RestoranServer server = restoran.getServer();
        Setting sHost = server.getSetting(Option.BM_EMAILER_EMAIL_SERVER);
        this.host = sHost == null ? "" : sHost.stringValue();
        Setting sTls = server.getSetting(Option.BM_EMAILER_EMAIL_TLS);
        this.startTls = sTls == null ? false : sTls.booleanValue();
        Setting sSSL = server.getSetting(Option.BM_EMAILER_EMAIL_SSL);
        this.ssl = sSSL == null ? false : sSSL.booleanValue();
        Setting sPort = server.getSetting(Option.BM_EMAILER_EMAIL_PORT);
        this.port = sPort == null ? 45 : sPort.intValue();
        Setting sAuth = server.getSetting(Option.BM_EMAILER_EMAIL_AUTHORIZATION);
        this.authorization = sAuth == null ? false : sAuth.booleanValue();
        Setting sFrom = server.getSetting(Option.BM_EMAILER_EMAIL_ADRESA);
        this.user = this.from = sFrom == null ? "" : sFrom.stringValue();
        Setting sPass = server.getSetting(Option.BM_EMAILER_EMAIL_SIFRA);
        this.pass = sPass == null ? "" : sPass.stringValue();
    }

    public void sendEmail(String[] to, String subject, String message) {
        if (this.from == null || this.from.length() == 0) {
            Logger.getLogger(BarmasterEmailer.class.getName()).fine("Posaljilac mail-a prazan");
            return;
        }
        if (this.host == null || this.host.length() == 0) {
            Logger.getLogger(BarmasterEmailer.class.getName()).fine("Primaoci mail-a prazni");
            return;
        }
        if (to == null || to.length == 0) {
            Logger.getLogger(BarmasterEmailer.class.getName()).fine("Primaoci mail-a prazni");
            return;
        }
        if (subject == null) {
            subject = "";
        }
        if (message == null || message.length() == 0) {
            Logger.getLogger(BarmasterEmailer.class.getName()).fine("Sadrzaj mail-a prazan");
            return;
        }
        try {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(this.host);
            email.setSmtpPort(this.port);
            if (this.authorization) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.user, this.pass));
            }
            email.setFrom(this.from);
            email.setBounceAddress(this.from);
            email.setReplyTo(Arrays.asList(new InternetAddress(this.from)));
            email.setSubject(subject);
            email.setMsg(message);
            for (String address : to) {
                email.addTo(address.trim());
            }
            email.setDebug(true);
            if (this.ssl) {
                email.setSSLOnConnect(this.ssl);
                email.setSslSmtpPort(Integer.toString(this.port));
            }
            if (!this.ssl && this.startTls) {
                email.setStartTLSEnabled(true);
            }
            email.send();
        }
        catch (AddressException ex) {
            Logger.getLogger(BarmasterEmailer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (EmailException mex) {
            Logger.getLogger(BarmasterEmailer.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom slanja emaila", mex);
        }
    }

    private static class BMEmailAutheticator
    extends Authenticator {
        private PasswordAuthentication authentication;

        public BMEmailAutheticator(String username, String password) {
            this.authentication = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

