/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Pregled.PregledOtpisa;
import com.dev63.restoran.Pregled.PregledPopisa;
import com.dev63.restoran.Pregled.PregledPrijemnice2;
import com.dev63.restoran.Pregled.PregledProizvodnje;
import com.dev63.restoran.Pregled.PregledTrebovanja2;
import com.dev63.restoran.Pregled.PregledUtrosakDoc;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.NormativArtikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.sistem.ArtikalDialog;
import com.dev63.restoran.sistem.IzborTipaPrijemnice;
import com.dev63.restoran.sistem.IzborTipaTrebovanja;
import com.dev63.restoran.sistem.MagacinArtikal;
import com.dev63.restoran.sistem.Popis;
import com.dev63.restoran.sistem.PreostalaKolicina;
import com.dev63.restoran.sistem.UnosMedjutreb;
import com.dev63.restoran.sistem.UnosOtpisa;
import com.dev63.restoran.sistem.UnosPovratnice;
import com.dev63.restoran.sistem.UnosProizvodnje;
import com.dev63.restoran.sistem.UnosUtroskaDoc;
import com.dev63.restoran.sistem.UpravljanjePrijemnicom;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.sistem.VPfaktura;
import com.dev63.restoran.stampa.StampaIzvestajZalihe;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.InvalidStateException;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Artikli {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    EntityManagerImpl em;
    private Restoran restoran;
    private RestoranServer server;
    private Odeljenje odeljenje;
    private Odeljenje magacin;
    private List<String> checkedTreeItems = new LinkedList<String>();
    Map<PodgrupaArtikala, List<Artikal>> mapaPodgrupe;
    Map<GrupaArtikala, List<PodgrupaArtikala>> mapaGrupe;
    Map<String, String> noviNazivi = new HashMap<String, String>();
    final Shell shell;
    private Artikal active;
    DecimalFormat df = new DecimalFormat("#.####");
    Composite dugmici;
    Composite composite0;
    Composite composite1;
    Composite composite2;
    Composite composite3;
    Composite composite4;
    Composite composite5;
    Composite composite6;
    Label prodajni;
    Label slozeni;
    Label polu;
    Label sirov;
    Label dodatni;
    Label svi;
    Label blokir;
    Table tabela;
    boolean blokiranje = false;
    int treeIndex;
    Tree tree;
    boolean isTree = false;
    boolean srch = false;
    static TableEditor editor;
    public static TableItem item;
    private final Composite panel1;
    boolean inspektor;
    private Boolean hasap = false;

    public Artikli(Shell owner, Restoran hostel, Odeljenje od, final boolean inspektor) {
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.odeljenje = od;
        this.inspektor = inspektor;
        this.shell = new Shell(owner.getDisplay(), 1264);
        this.shell.setText("    " + String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + " " + this.odeljenje.getNaziv());
        this.magacin = this.server.returnMagacin();
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.panel1 = new Composite((Composite)this.shell, 0);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = 280;
        this.panel1.setLayoutData((Object)gd);
        this.panel1.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData();
        this.tree = this.getTree(this.odeljenje.getArtikli(), this.panel1);
        this.treeIndex = this.panel1.getChildren().length - 1;
        data = new GridData(4, 4, false, true, 2, 1);
        data.widthHint = 250;
        this.tree.setLayoutData((Object)data);
        data = new GridData(4, 4, true, false);
        data.heightHint = 40;
        data.widthHint = 125;
        Button izlaz = new Button(this.panel1, 0x1000040);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_PONISTI"), new Object[0]));
        izlaz.setBackground(this.shell.getDisplay().getSystemColor(1));
        izlaz.setLayoutData((Object)data);
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.tree = Artikli.this.getTree(Artikli.this.odeljenje.getArtikli(), Artikli.this.panel1);
                Artikli.this.tabela.removeAll();
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
            }
        });
        Button ok = new Button(this.panel1, 8);
        ok.setText(String.format(this.barmasterText.getString("TEXT_POTVRDA"), new Object[0]));
        ok.setBackground(this.shell.getDisplay().getSystemColor(1));
        ok.setLayoutData((Object)data);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Artikli.this.tabela.removeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Artikli.this.isTree = true;
                Artikli.this.srch = false;
                Artikli.this.reloadTree();
            }
        });
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(2, false));
        panel2.setLayoutData((Object)new GridData(4, 4, true, true));
        data = new GridData();
        data = new GridData(4, 4, false, true);
        data.widthHint = 230;
        Group grupa1 = new Group(panel2, 4);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(this.barmasterText.getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true);
        Group grupa2 = new Group(panel2, 8);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKLI"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  " + String.format(this.barmasterText.getString("TEXT_NOVI_ARTIKAL"), new Object[0]));
        label1.setEnabled(this.magacin == null || this.odeljenje.getId() != this.magacin.getId());
        label1.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Artikli.this.addArtikal();
                }
                catch (FiscalException ex) {
                    Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SerialIOException ex) {
                    Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NullPointerException ex) {
                    Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        if (this.odeljenje.equals(this.magacin)) {
            Button stampaB = Dugmici.getNovi(this.dugmici);
            stampaB.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
            stampaB.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    Artikli.this.stampa();
                }
            });
            Button uska = Dugmici.getNovi(this.dugmici);
            uska.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
            uska.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    int cols = Artikli.this.tabela.getColumnCount();
                    int items = Artikli.this.tabela.getItemCount();
                    String[][] ts = new String[items][cols];
                    for (int i = 0; i < items - 1; ++i) {
                        ts[i][1] = Artikli.this.tabela.getItem(i).getText(0);
                        ts[i][2] = Artikli.this.tabela.getItem(i).getText(1);
                        ts[i][3] = Artikli.this.tabela.getItem(i).getText(5);
                    }
                    new StampaIzvestajZalihe(Artikli.this.restoran, ts, String.format(Artikli.this.barmasterText.getString("TEXT_MAGACIN_DODATNIH_ZALIHA"), new Object[0]), null, null);
                }
            });
        }
        data = new GridData();
        data.widthHint = 200;
        Label ll = new Label(this.dugmici, 0);
        ll.setText(String.format(this.barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
        final Text tt = new Text(this.dugmici, 2048);
        tt.setLayoutData((Object)data);
        tt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (tt.getText().length() > 2 && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    Artikli.this.server.refresh();
                    Set<String> map = Artikli.this.server.getArtikliByNameOrBarcode(Artikli.this.odeljenje.getId(), tt.getText()).keySet();
                    if (map.isEmpty()) {
                        Artikli.this.tabela.removeAll();
                        TableItem ti = new TableItem(Artikli.this.tabela, 0);
                        ti.setText("Nema rezultata");
                    } else {
                        Artikli.this.tabela.removeAll();
                        for (String s : map) {
                            TableItem ti;
                            Artikal a = Artikli.this.server.getArtikal(s);
                            if (a == null) continue;
                            Color c = Artikli.this.obojiTabelu(a);
                            Artikli.this.srch = true;
                            if (TipArtikla.SLOZ.equals((Object)a.getTip()) || TipArtikla.DODA.equals((Object)a.getTip())) {
                                ti = new TableItem(Artikli.this.tabela, 0);
                                ti.setText(new String[]{a.getName(), a.getJedinicaMere(), Konstante.getNumber2(a.getCena())});
                                ti.setForeground(c);
                                continue;
                            }
                            try {
                                ti = new TableItem(Artikli.this.tabela, 0);
                                ti.setText(new String[]{a.getName(), a.getJedinicaMere(), Konstante.getNumber2(a.getCena())});
                                ti.setForeground(c);
                            }
                            catch (NoResultException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        Label sep1 = new Label(this.dugmici, 16384);
        sep1.setText(String.format(this.barmasterText.getString("TEXT_ZALIHE"), new Object[0]));
        sep1.setLayoutData((Object)new GridData(4, 4, true, false));
        Button bUlaz = new Button(this.dugmici, 72);
        bUlaz.setText(String.format(this.barmasterText.getString("TEXT_UNOS_ROBE"), new Object[0]));
        bUlaz.setLayoutData(label1.getLayoutData());
        bUlaz.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Artikli.this.odeljenje.equals(Artikli.this.magacin)) {
                    IzborTipaPrijemnice itt = new IzborTipaPrijemnice(Artikli.this.dugmici.getShell(), Artikli.this.server);
                    TipPrijemnice tip = itt.getType();
                    Artikli.this.hasap = itt.getHasap();
                    if (tip != null) {
                        new UpravljanjePrijemnicom(Artikli.this.dugmici.getShell(), Artikli.this.restoran, null, tip, null, false, Artikli.this.hasap);
                    }
                } else {
                    IzborTipaTrebovanja itt = new IzborTipaTrebovanja(Artikli.this.dugmici.getShell(), Artikli.this.server);
                    TipTrebovanja tip = itt.getType();
                    Artikli.this.hasap = itt.getHasap();
                    if (tip != null) {
                        Odeljenje ulazno = null;
                        Odeljenje izlazno = null;
                        if (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                            ulazno = Artikli.this.odeljenje;
                            izlazno = tip.getOdIzlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN ? Artikli.this.server.returnMagacin() : null;
                        } else {
                            izlazno = Artikli.this.odeljenje;
                            ulazno = tip.getOdUlaz() == TipTrebovanja.OdeljenjeAtribut.MAGACIN ? Artikli.this.server.returnMagacin() : null;
                        }
                        new UpravljanjeTrebovanjem(Artikli.this.dugmici.getShell(), Artikli.this.restoran, null, ulazno, izlazno, tip, null, false, inspektor, Artikli.this.hasap);
                    }
                }
            }
        });
        Button bPregled = new Button(this.dugmici, 72);
        bPregled.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_UNOSA"), new Object[0]));
        bPregled.setLayoutData(label1.getLayoutData());
        bPregled.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Artikli.this.odeljenje.equals(Artikli.this.magacin)) {
                    new PregledPrijemnice2.PregledPrijemnice2Input(Artikli.this.shell, Artikli.this.restoran, false, Artikli.this.odeljenje, null, inspektor, Artikli.this.hasap == null ? false : Artikli.this.hasap);
                } else {
                    new PregledTrebovanja2.PregledTrebovanja2Input(Artikli.this.shell, Artikli.this.restoran, false, Artikli.this.odeljenje, null, inspektor, Artikli.this.hasap == null ? false : Artikli.this.hasap);
                }
            }
        });
        Button unosVPfakture = new Button(this.dugmici, 72);
        unosVPfakture.setText(String.format(this.barmasterText.getString("TEXT_VP_FAKTURA"), new Object[0]));
        unosVPfakture.setLayoutData(label1.getLayoutData());
        unosVPfakture.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Shell shell2 = new Shell(Artikli.this.shell.getDisplay(), 0);
                new VPfaktura(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_VP_FAKTURA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                SWTContainerClass.makeEnd(shell2);
            }
        });
        Label separator = new Label(this.dugmici, 0);
        GridData data3 = new GridData(768);
        data3.heightHint = 10;
        data3.horizontalSpan = 2;
        separator.setBackground(this.shell.getDisplay().getSystemColor(22));
        separator.setLayoutData((Object)data3);
        final ArrayList<ExpandItem> itemi = new ArrayList<ExpandItem>();
        ExpandBar bar = new ExpandBar(this.dugmici, 512);
        bar.setBackground(this.shell.getDisplay().getSystemColor(1));
        GridData gridData = new GridData(4, 4, false, true);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 190;
        gridData.heightHint = 600;
        bar.setLayoutData((Object)gridData);
        this.composite0 = new Composite((Composite)bar, 0);
        this.composite0.setBackground(this.shell.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite0.setLayout((Layout)layout);
        ExpandItem item0 = new ExpandItem(bar, 2048);
        item0.setText("   " + String.format(this.barmasterText.getString("TEXT_ARTIKLI"), new Object[0]));
        item0.setControl((Control)this.composite0);
        final Image revImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/pregled.gif");
        item0.setImage(revImg);
        item0.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (revImg != null && !revImg.isDisposed()) {
                    revImg.dispose();
                }
            }
        });
        itemi.add(item0);
        this.composite1 = new Composite((Composite)bar, 0);
        this.composite1.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite1.setLayout((Layout)layout);
        this.composite2 = new Composite((Composite)bar, 0);
        this.composite2.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite2.setLayout((Layout)layout);
        this.composite3 = new Composite((Composite)bar, 0);
        this.composite3.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite3.setLayout((Layout)layout);
        ExpandItem item3 = new ExpandItem(bar, 0);
        item3.setText("  " + String.format(this.barmasterText.getString("TEXT_POPIS"), new Object[0]));
        Image entr2Img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/unos.gif");
        item3.setImage(entr2Img);
        item3.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)entr2Img));
        item3.setControl((Control)this.composite3);
        itemi.add(item3);
        this.composite4 = new Composite((Composite)bar, 0);
        this.composite4.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite4.setLayout((Layout)layout);
        this.composite5 = new Composite((Composite)bar, 0);
        this.composite5.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite5.setLayout((Layout)layout);
        this.composite6 = new Composite((Composite)bar, 0);
        this.composite6.setBackground(this.shell.getDisplay().getSystemColor(1));
        layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.verticalSpacing = 2;
        this.composite6.setLayout((Layout)layout);
        ExpandItem item4 = new ExpandItem(bar, 0);
        item4.setText("  " + String.format(this.barmasterText.getString("TEXT_OTPIS_SLOZENIH_ARTIKALA"), new Object[0]));
        final Image entr3Img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/unos.gif");
        item4.setImage(entr3Img);
        item4.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (entr3Img != null && !entr3Img.isDisposed()) {
                    entr3Img.dispose();
                }
            }
        });
        item4.setControl((Control)this.composite4);
        itemi.add(item4);
        if (this.odeljenje.equals(this.magacin)) {
            this.slozeni = this.getLabel0();
            this.slozeni.setText(String.format(this.barmasterText.getString("TEXT_SLOZENI"), new Object[0]));
            this.slozeni.setForeground(this.shell.getDisplay().getSystemColor(3));
            this.slozeni.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    Artikli.this.refreshLabel();
                    Artikli.this.slozeni.setBackground(null);
                    Artikli.this.reload(TipArtikla.SLOZ);
                }
            });
        } else {
            this.slozeni = this.getLabel0();
            this.slozeni.setText(String.format(this.barmasterText.getString("TEXT_SLOZENI"), new Object[0]));
            this.slozeni.setForeground(this.shell.getDisplay().getSystemColor(3));
            this.slozeni.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    Artikli.this.refreshLabel();
                    Artikli.this.slozeni.setBackground(null);
                    Artikli.this.reload(TipArtikla.SLOZ);
                }
            });
            Composite compositeProiz = new Composite((Composite)bar, 0);
            compositeProiz.setBackground(this.shell.getDisplay().getSystemColor(1));
            layout = new GridLayout(2, false);
            layout.marginBottom = 1;
            layout.marginRight = 1;
            layout.marginTop = 1;
            layout.marginLeft = 1;
            layout.verticalSpacing = 2;
            compositeProiz.setLayout((Layout)layout);
            ExpandItem itemProiz = new ExpandItem(bar, 2048);
            itemProiz.setText("     " + String.format(this.barmasterText.getString("TEXT_PROIZVODNJA"), new Object[0]));
            itemProiz.setControl((Control)compositeProiz);
            Image entrImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/unos.gif");
            itemProiz.setImage(entrImg);
            itemProiz.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)entrImg));
            itemi.add(itemProiz);
            GridData labeData2 = new GridData();
            labeData2.heightHint = 20;
            labeData2.horizontalSpan = 2;
            Label labelProiz = new Label(compositeProiz, 0);
            labelProiz.setBackground(this.shell.getDisplay().getSystemColor(1));
            labelProiz.setLayoutData((Object)labeData2);
            Label label = labelProiz;
            label.setText(String.format(this.barmasterText.getString("TEXT_UNOS"), new Object[0]));
            label.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    Shell shell2 = new Shell(Artikli.this.shell.getDisplay());
                    new UnosProizvodnje(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_UNOS_PROIZVODNJE_POLUPROIZVODA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor, null);
                    SWTContainerClass.makeEnd(shell2);
                }
            });
            labeData2 = new GridData();
            labeData2.heightHint = 20;
            labeData2.horizontalSpan = 2;
            labelProiz = new Label(compositeProiz, 0);
            labelProiz.setBackground(this.shell.getDisplay().getSystemColor(1));
            labelProiz.setLayoutData((Object)labeData2);
            label = labelProiz;
            label.setText(String.format(this.barmasterText.getString("TEXT_PREGLED"), new Object[0]));
            label.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    Shell shell2 = new Shell(Artikli.this.shell.getDisplay());
                    new PregledProizvodnje.PregledProizvodnjaInput(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_PREGLED_PROIZVODNJE"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                    SWTContainerClass.makeEnd(shell2);
                }
            });
            itemProiz.setHeight(compositeProiz.computeSize((int)-1, (int)-1).y);
        }
        Label label = this.getLabel4OtpisSpan();
        label.setText(String.format(this.barmasterText.getString("TEXT_UNOS"), new Object[0]));
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell2 = new Shell(Artikli.this.shell.getDisplay(), 0);
                new UnosOtpisa(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_UNOS_OTPISA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor, null);
                SWTContainerClass.makeEnd(shell2);
            }
        });
        label = this.getLabel4OtpisSpan();
        label.setText(String.format(this.barmasterText.getString("TEXT_PREGLED"), new Object[0]));
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell2 = new Shell(Artikli.this.shell.getDisplay());
                new PregledOtpisa.PregledOtpisInput(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_PREGLED_OTPISA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                SWTContainerClass.makeEnd(shell2);
            }
        });
        ExpandItem item41 = new ExpandItem(bar, 0);
        item41.setText("  " + String.format(this.barmasterText.getString("TEXT_UTROSAK_ARTIKALA"), new Object[0]));
        final Image entr3Img1 = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/unos.gif");
        item41.setImage(entr3Img1);
        item41.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (entr3Img1 != null && !entr3Img1.isDisposed()) {
                    entr3Img1.dispose();
                }
            }
        });
        item41.setControl((Control)this.composite5);
        itemi.add(item41);
        bar.setSpacing(3);
        bar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemExpanded(final ExpandEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (ExpandItem ei : itemi) {
                            ei.setExpanded(false);
                        }
                        ExpandItem o = (ExpandItem)e.item;
                        o.setExpanded(true);
                    }
                });
            }
        });
        Label label11 = this.getLabel5UtrosakSpan();
        label11.setText(String.format(this.barmasterText.getString("TEXT_UNOS"), new Object[0]));
        label11.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell2 = new Shell(Artikli.this.shell.getDisplay(), 0);
                new UnosUtroskaDoc(SWTContainerClass.makeContainer(shell2, String.format(Artikli.this.barmasterText.getString("TEXT_UTROSAK_ARTIKALA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                SWTContainerClass.makeEnd(shell2);
            }
        });
        label11 = this.getLabel5UtrosakSpan();
        label11.setText(String.format(this.barmasterText.getString("TEXT_PREGLED"), new Object[0]));
        label11.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell3 = new Shell(Artikli.this.shell.getDisplay());
                new PregledUtrosakDoc.PregledUtrosakDocInput(SWTContainerClass.makeContainer(shell3, String.format(Artikli.this.barmasterText.getString("TEXT_UTROSAK_ARTIKALA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                SWTContainerClass.makeEnd(shell3);
            }
        });
        label = this.getLabel3PopisSpan();
        label.setText(String.format(this.barmasterText.getString("TEXT_UNOS"), new Object[0]));
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell3 = new Shell(Artikli.this.shell.getDisplay());
                new Popis.PopisInput(SWTContainerClass.makeContainer(shell3, String.format(Artikli.this.barmasterText.getString("TEXT_POPIS"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, inspektor);
                SWTContainerClass.makeEnd(shell3);
            }
        });
        label = this.getLabel3PopisSpan();
        label.setText(String.format(this.barmasterText.getString("TEXT_PREGLED"), new Object[0]));
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Shell shell3 = new Shell(Artikli.this.shell.getDisplay());
                new PregledPopisa.PregledPopisInput(SWTContainerClass.makeContainer(shell3, String.format(Artikli.this.barmasterText.getString("TEXT_PREGLED_POPISA"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje);
                SWTContainerClass.makeEnd(shell3);
            }
        });
        label = this.getLabel3PopisSpan();
        label.setText(String.format(this.barmasterText.getString("TEXT_BLANKO"), new Object[0]));
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                new PregledPopisa.PopisBlanko(Artikli.this.shell.getDisplay(), Artikli.this.odeljenje, Artikli.this.server);
            }
        });
        this.polu = this.getLabel0();
        this.polu.setText(String.format(this.barmasterText.getString("TEXT_POLUPROIZVODI"), new Object[0]));
        this.polu.setForeground(this.shell.getDisplay().getSystemColor(11));
        this.polu.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.polu.setBackground(null);
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.reload(TipArtikla.POLU);
            }
        });
        this.prodajni = this.getLabel0();
        this.prodajni.setText(String.format(this.barmasterText.getString("TEXT_PRODAJNI"), new Object[0]));
        this.prodajni.setForeground(this.shell.getDisplay().getSystemColor(9));
        this.prodajni.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.prodajni.setBackground(null);
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.reload(TipArtikla.PROD);
            }
        });
        this.sirov = this.getLabel0();
        this.sirov.setText(String.format(this.barmasterText.getString("TEXT_SIROVINE"), new Object[0]));
        this.sirov.setForeground(this.shell.getDisplay().getSystemColor(2));
        this.sirov.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.sirov.setBackground(null);
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.reload(TipArtikla.SIRO);
            }
        });
        this.dodatni = this.getLabel0();
        this.dodatni.setText(String.format(Konstante.getBundle().getString("TEXT_DODATNI"), new Object[0]));
        this.dodatni.setForeground(this.shell.getDisplay().getSystemColor(14));
        this.dodatni.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.dodatni.setBackground(null);
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.reload(TipArtikla.DODA);
            }
        });
        this.blokir = this.getLabel0();
        this.blokir.setText(String.format(this.barmasterText.getString("TEXT_BLOKIRANI"), new Object[0]));
        this.blokir.setForeground(this.shell.getDisplay().getSystemColor(16));
        this.blokir.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.blokir.setBackground(null);
                Artikli.this.reloadBlokirane();
            }
        });
        this.svi = this.getLabel0();
        this.svi.setText(String.format(this.barmasterText.getString("TEXT_SVI_ARTIKLI"), new Object[0]));
        this.svi.setForeground(this.shell.getDisplay().getSystemColor(2));
        this.svi.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Artikli.this.refreshLabel();
                Artikli.this.svi.setBackground(null);
                Artikli.this.isTree = false;
                Artikli.this.srch = false;
                Artikli.this.reload(null);
            }
        });
        item0.setHeight(this.composite0.computeSize((int)-1, (int)-1).y);
        item0.setExpanded(true);
        item3.setHeight(this.composite3.computeSize((int)-1, (int)-1).y);
        item4.setHeight(this.composite4.computeSize((int)-1, (int)-1).y);
        item41.setHeight(this.composite5.computeSize((int)-1, (int)-1).y);
        data = new GridData(1808);
        this.tabela = new Table((Composite)grupa2, 98304);
        this.tabela.setLayoutData((Object)data);
        this.tabela.setHeaderVisible(true);
        this.tabela.setLinesVisible(true);
        editor = new TableEditor(this.tabela);
        Artikli.editor.horizontalAlignment = 16384;
        Artikli.editor.grabHorizontal = true;
        Artikli.editor.minimumWidth = 50;
        TableColumn tc = new TableColumn(this.tabela, 16384);
        tc.setWidth(250);
        tc.setText(String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
        tc = new TableColumn(this.tabela, 16384);
        tc.setWidth(70);
        tc.setText(String.format(this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
        tc = new TableColumn(this.tabela, 16384);
        tc.setWidth(100);
        tc.setText(String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]));
        this.tabela.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                if (Artikli.this.tabela.getSelectionIndex() > -1) {
                    Artikli.this.active = Artikli.this.server.getArtikal(Artikli.this.tabela.getSelection()[0].getText());
                    try {
                        Artikli.this.updateArtikal();
                    }
                    catch (FiscalException ex) {
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SerialIOException ex) {
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.tabela.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                item = (TableItem)e.item;
            }
        });
        this.tabela.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (Artikli.this.tabela.getSelectionIndex() > -1 && (e.keyCode == 0x1000050 || e.keyCode == 13)) {
                    Control oldEditor = editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    if (item == null) {
                        return;
                    }
                    Text newEditor = new Text((Composite)Artikli.this.tabela, 0);
                    newEditor.setText(item.getText(2));
                    newEditor.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent me) {
                            Text text = (Text)editor.getEditor();
                            if (!text.getText().isEmpty()) {
                                editor.getItem().setText(2, text.getText());
                            }
                        }
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    Artikli.this.server.refresh();
                    editor.setEditor((Control)newEditor, item, 2);
                    newEditor.addKeyListener((KeyListener)new KeyAdapter(){
                        Artikal art;
                        {
                            this.art = Artikli.this.server.ArtikalByName(Artikli.this.tabela.getSelection()[0].getText());
                        }

                        public void keyPressed(KeyEvent e) {
                            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                                Control oldEditor = editor.getEditor();
                                if (oldEditor != null) {
                                    oldEditor.dispose();
                                }
                                try {
                                    double c = Double.parseDouble(item.getText(2));
                                    this.art.setCena(c);
                                    Artikli.this.server.updateArtikal(this.art);
                                    item.setText(2, Konstante.getNumber2(c));
                                    Artikli.this.server.refresh();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            }
        });
        this.reload();
        this.shell.setMaximized(true);
        label1.forceFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void reload(TipArtikla ta) {
        this.blokiranje = false;
        this.tabela.removeAll();
        List<Object> artikli = new ArrayList();
        artikli = ta != null ? this.server.readArtikal2(this.odeljenje.getId(), ta.name()) : this.server.readArtikal2(this.odeljenje.getId(), null);
        for (List list : artikli) {
            TableItem t;
            Color c = this.obojiTabelu(list);
            if (((String)list.get(2)).equals("SLOZ")) {
                t = new TableItem(this.tabela, 0);
                t.setText(new String[]{(String)list.get(0), this.getJedMereInterName((String)list.get(1)), (String)list.get(2)});
                t.setForeground(c);
                continue;
            }
            if (this.magacin != null && this.odeljenje.getId() == this.magacin.getId()) {
                t = new TableItem(this.tabela, 0);
                t.setText(new String[]{(String)list.get(0), this.getJedMereInterName((String)list.get(1)), (String)list.get(2)});
                t.setForeground(c);
                this.server.refresh();
                continue;
            }
            t = new TableItem(this.tabela, 0);
            t.setText(new String[]{(String)list.get(0), this.getJedMereInterName((String)list.get(1)), (String)list.get(2)});
            t.setForeground(c);
            this.server.refresh();
        }
        this.active = null;
    }

    private Color obojiTabelu(List<String> a) {
        Color c = null;
        if (a.get(3).equals(TipArtikla.SLOZ.name())) {
            c = this.slozeni.getForeground();
        } else if (a.get(3).equals(TipArtikla.POLU.name())) {
            c = this.polu.getForeground();
        } else if (a.get(3).equals(TipArtikla.PROD.name())) {
            c = this.prodajni.getForeground();
        } else if (a.get(3).equals(TipArtikla.SIRO.name())) {
            c = this.sirov.getForeground();
        } else if (a.get(3).equals(TipArtikla.DODA.name())) {
            c = this.dodatni.getForeground();
        }
        return c;
    }

    private Color obojiTabelu(Artikal a) {
        Color c = this.shell.getDisplay().getSystemColor(21);
        if (a == null || a.getTip() == null) {
            return c;
        }
        switch (a.getTip()) {
            case SLOZ: {
                return this.slozeni.getForeground();
            }
            case POLU: {
                return this.polu.getForeground();
            }
            case PROD: {
                return this.prodajni.getForeground();
            }
            case SIRO: {
                return this.sirov.getForeground();
            }
            case DODA: {
                return this.dodatni.getForeground();
            }
        }
        return c;
    }

    private void reloadBlokirane() {
        this.blokiranje = true;
        try {
            this.tabela.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Object> artikli = new ArrayList();
        artikli = this.server.readBlokiraneArtikle(this.odeljenje.getId());
        for (List list : artikli) {
            TableItem t;
            Color c = this.blokir.getForeground();
            if (TipArtikla.SLOZ.name().equals(list.get(2)) || TipArtikla.DODA.name().equals(list.get(2))) {
                t = new TableItem(this.tabela, 0);
                t.setText(new String[]{(String)list.get(0), this.getJedMereInterName((String)list.get(1)), (String)list.get(2)});
                t.setForeground(c);
                continue;
            }
            t = new TableItem(this.tabela, 0);
            t.setText(new String[]{(String)list.get(0), this.getJedMereInterName((String)list.get(1)), (String)list.get(2)});
            t.setForeground(c);
            this.server.refresh();
        }
        this.active = null;
    }

    private void reloadTree() {
        this.blokiranje = false;
        try {
            this.tabela.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TreeItem t1 : this.tree.getItems()) {
            for (TreeItem t2 : t1.getItems()) {
                for (TreeItem t3 : t2.getItems()) {
                    TableItem t;
                    if (!t3.getChecked()) continue;
                    Artikal a = this.server.getArtikal2(t3.getText());
                    Color col = this.obojiTabelu(a);
                    if (TipArtikla.SLOZ.equals((Object)a.getTip()) || TipArtikla.DODA.equals((Object)a.getTip())) {
                        t = new TableItem(this.tabela, 0);
                        t.setText(new String[]{a.getName(), a.getJedinicaMere(), "" + a.getCena()});
                        t.setForeground(col);
                    } else {
                        t = new TableItem(this.tabela, 0);
                        try {
                            t.setText(new String[]{a.getName(), a.getJedinicaMere(), "" + a.getCena()});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        t.setForeground(col);
                        this.server.refresh();
                    }
                    this.active = null;
                }
            }
        }
    }

    private void reload() {
        this.blokiranje = false;
        try {
            this.tabela.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.active = null;
    }

    private void addArtikal() throws FiscalException, SerialIOException, NullPointerException {
        Shell shell2 = new Shell(this.shell, 34032);
        if (this.magacin != null && this.odeljenje.getId() == this.magacin.getId()) {
            MagacinArtikal ad = new MagacinArtikal(this.shell, this.restoran, null, this.odeljenje);
            if (ad.getResult() != null) {
                Artikal a = ad.getResult();
                try {
                    a = this.server.addArtikal2JPAMerge(a);
                }
                catch (Exception e) {
                    Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, "Doslo je do greske prilikom dodavanja artikla", e);
                    SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                    return;
                }
                for (Odeljenje o : a.getOdeljenja()) {
                    if (!o.getArtikli().contains(a)) {
                        o.getArtikli().add(a);
                    }
                    try {
                        o = this.server.updateOdeljenje(o);
                    }
                    catch (Exception e) {
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, "Doslo je do greske prilikom update odeljenja", e);
                        SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                        return;
                    }
                }
                this.odeljenje = this.server.getOdeljenjeJPA(this.odeljenje.getId());
                this.loadMap(this.odeljenje.getArtikli());
                this.tree = this.getTree(this.odeljenje.getArtikli(), this.panel1);
                this.reloadTree();
            }
        } else {
            ArtikalDialog ad = new ArtikalDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_NOVOG_ARTIKLA"), new Object[0])), this.restoran, null, this.odeljenje, this.inspektor);
            if (ad.getResult() != null) {
                Artikal a = ad.getResult();
                if (a.getId() != null) {
                    try {
                        a = this.server.updateArtikal(a);
                    }
                    catch (Exception e) {
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, "Doslo je do greske prilikom dodavanja artikla", e);
                        SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                        return;
                    }
                }
                try {
                    a = this.server.addArtikal2JPAMerge(a);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, "Doslo je do greske prilikom dodavanja artikla", e);
                    SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                    return;
                }
                this.createNormativ(a, ad.getResult2());
                for (Odeljenje o : a.getOdeljenja()) {
                    try {
                        this.server.updateOdeljenje(o);
                    }
                    catch (Exception e) {
                        Logger.getLogger(Artikli.class.getName()).log(Level.SEVERE, "Doslo je do greske prilikom update-a artikla", e);
                        SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                        return;
                    }
                }
                this.odeljenje = this.server.getOdeljenjeJPA(this.odeljenje.getId());
                this.tree = this.getTree(this.server.getArtikliOdeljenje2(this.odeljenje.getId()), this.panel1);
                this.reload();
            }
        }
    }

    private void updateArtikal() throws FiscalException, SerialIOException, EntityExistsException, InvalidStateException, NullPointerException {
        String oldName = null;
        if (this.active == null) {
            return;
        }
        oldName = this.active.getName();
        final Shell shell2 = new Shell(this.shell);
        System.out.println("OTVARA SE NOVI PROZOR");
        shell2.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!shell2.isDisposed()) {
                    shell2.dispose();
                }
            }
        });
        if (this.magacin != null && this.odeljenje.getId() == this.magacin.getId()) {
            MagacinArtikal ad = new MagacinArtikal(this.shell, this.restoran, this.active, this.odeljenje);
            if (ad.getResult() != null) {
                if (!ad.getResult().getName().equals(oldName) && this.checkedTreeItems.contains(oldName)) {
                    this.checkedTreeItems.remove(oldName);
                    this.checkedTreeItems.add(ad.getResult().getName());
                }
                this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_ARTIKLA"), new Object[0]) + ": " + ad.getResult() + String.format(this.barmasterText.getString("LOG_OD_STRANE"), new Object[0]) + " " + this.server.getUser().getName());
                Artikal a = ad.getResult();
                try {
                    this.server.updateArtikal(ad.getResult());
                    if (!this.odeljenje.containsArtikal(a)) {
                        this.odeljenje.getArtikli().add(a);
                    }
                    this.server.updateOdeljenje(this.odeljenje);
                }
                catch (Exception e) {
                    SWTOptionPane.showMessageDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_ARTIKLA"), new Object[0]));
                    return;
                }
                this.odeljenje = this.server.getOdeljenjeJPA(this.odeljenje.getId());
                this.loadMap(this.odeljenje.getArtikli());
                this.tree = this.getTree(this.odeljenje.getArtikli(), this.panel1);
                this.reload();
            }
        } else {
            ArtikalDialog ad = new ArtikalDialog(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_IZMENA_ARTIKLA"), new Object[0])), this.restoran, this.active, this.odeljenje, this.inspektor);
            if (ad.getResult() == null) {
                return;
            }
            Artikal a = this.server.updateArtikal(ad.getResult());
            if (ad.getResult() != null) {
                try {
                    if (ad.getResult().getName().equals(oldName)) {
                        return;
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                if (!ad.getResult().getName().equals(oldName) && this.checkedTreeItems.contains(oldName)) {
                    this.checkedTreeItems.remove(oldName);
                    this.checkedTreeItems.add(ad.getResult().getName());
                }
                this.server.log(String.format(this.barmasterText.getString("LOG_IZMENA_ARTIKLA"), new Object[0]) + ": " + ad.getResult() + String.format(this.barmasterText.getString("LOG_OD_STRANE"), new Object[0]) + " " + this.server.getUser().getName());
                try {
                    this.server.refresh();
                    for (Odeljenje o : this.server.readOdeljenje()) {
                        if (o.containsArtikal(a) && !a.getOdeljenja().contains(o)) {
                            o.removeArtikal(a);
                            this.server.updateOdeljenje(o);
                        }
                        if (!o.containsArtikal(a) && a.getOdeljenja().contains(o)) {
                            o.setArtikal(a);
                            this.server.updateOdeljenje(o);
                        }
                        if (!this.odeljenje.equals(o)) continue;
                        this.odeljenje = o;
                    }
                }
                catch (EntityExistsException e) {
                    e.printStackTrace();
                    Konstante.getPoruka(shell2, String.format(this.barmasterText.getString("PORUKA_ARTIKAL_SA_ZADATIM_IMENOM_VEC_POSTOJI_PROMENITE_NAZIV"), new Object[0]));
                    return;
                }
                this.odeljenje = this.server.getOdeljenjeJPA(this.odeljenje.getId());
                this.loadMap(this.odeljenje.getArtikli());
                this.tree = this.getTree(this.odeljenje.getArtikli(), this.panel1);
            }
        }
        if (!this.shell.isDisposed()) {
            if (this.blokiranje) {
                this.reloadBlokirane();
            } else if (this.isTree) {
                this.reloadTree();
            } else if (this.srch) {
                this.reload();
            } else if (this.active != null) {
                if (this.active.getBlokiran() != null && this.active.getBlokiran().booleanValue()) {
                    this.reloadBlokirane();
                } else {
                    this.reload(this.active.getTip());
                }
            } else {
                this.tabela.removeAll();
            }
        }
        this.server.refresh();
    }

    private void blokirajArtikal() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_BLOKIRATE_ARTIKAL"), this.active.getName()));
        if (ok == 0) {
            this.server.log(String.format(this.barmasterText.getString("LOG_BLOKIRANJE_ARTIKLA"), new Object[0]) + ": " + this.active);
            this.active.setBlokiran(Boolean.TRUE);
            this.server.updateArtikal(this.active);
            this.active = null;
            this.reload();
        }
    }

    private void odblokirajArtikal() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(SWTContainer.getSWTComponent((Control)this.shell), (Object)String.format(this.barmasterText.getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_ODBLOKIRATE_ARTIKAL"), this.active.getName()));
        if (ok == 0) {
            this.server.log(String.format(this.barmasterText.getString("LOG_AKTIVIRANJE_ARTIKLA"), new Object[0]) + ": " + this.active);
            this.active.setBlokiran(Boolean.FALSE);
            this.server.updateArtikal(this.active);
            this.active = null;
            this.reload();
        }
    }

    public void unosMedjutrebovanja() {
        final Shell shell2 = new Shell(this.shell.getDisplay());
        shell2.setBackground(this.shell.getDisplay().getSystemColor(1));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        final List<Odeljenje> odeljenja = this.server.readOdeljenje();
        Label pk = new Label((Composite)shell2, 0);
        pk.setText(String.format(this.barmasterText.getString("TEXT_UNOS_TREBOVANJA_IZ"), new Object[0]) + ":");
        pk.setBackground(shell2.getDisplay().getSystemColor(1));
        final Combo od = new Combo((Composite)shell2, 2572);
        for (int i = 0; i < odeljenja.size(); ++i) {
            if (this.magacin != null && odeljenja.get(i).getId() == this.magacin.getId() || odeljenja.get(i).equals(this.odeljenje)) continue;
            od.add(odeljenja.get(i).getNaziv());
        }
        od.select(0);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell2.close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(shell2);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    for (Odeljenje oiz : odeljenja) {
                        if (!oiz.getNaziv().equals(od.getItem(od.getSelectionIndex()))) continue;
                        if (!PreostalaKolicina.hasCommonArticles(oiz, Artikli.this.odeljenje, Artikli.this.server)) {
                            int style = 65600;
                            MessageBox messageBox = new MessageBox(shell2, style);
                            messageBox.setText(String.format(Artikli.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]));
                            messageBox.setMessage(String.format(Artikli.this.barmasterText.getString("PORUKA_NE_POSTOJE_ZAJEDNICKI_ARTIKLI_ZA_IZABRANA_ODELJENJA"), new Object[0]));
                            messageBox.open();
                            return;
                        }
                        shell2.close();
                        Shell shell3 = new Shell(Artikli.this.shell.getDisplay());
                        new UnosMedjutreb(SWTContainerClass.makeContainer(shell3, String.format(Artikli.this.barmasterText.getString("TEXT_UNOS_TREBOVANJA"), new Object[0])), Artikli.this.restoran, oiz, Artikli.this.odeljenje);
                        SWTContainerClass.makeEnd(shell3);
                    }
                }
                catch (Exception ex) {
                    return;
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        data.horizontalSpan = 2;
        od.setLayoutData((Object)data);
        shell2.pack();
        shell2.open();
    }

    public void unosPovratnice() {
        final Shell shell2 = new Shell(this.shell.getDisplay());
        shell2.setBackground(this.shell.getDisplay().getSystemColor(1));
        Monitor primary = shell2.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell2.getBounds();
        int x = bounds.x + rect.width / 2;
        int y = bounds.y + rect.height / 2;
        shell2.setLocation(x, y);
        final List<Odeljenje> odeljenja = this.server.readOdeljenje();
        Label pk = new Label((Composite)shell2, 0);
        pk.setText(String.format(this.barmasterText.getString("TEXT_POVRACAJ_U"), new Object[0]) + ":");
        pk.setBackground(shell2.getDisplay().getSystemColor(1));
        final Combo od = new Combo((Composite)shell2, 2572);
        for (int i = 0; i < odeljenja.size(); ++i) {
            if (odeljenja.get(i).equals(this.odeljenje)) continue;
            od.add(odeljenja.get(i).getNaziv());
        }
        od.select(0);
        Button cancelButt = Dugmici.getCancelButton(shell2);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell2.close();
            }
        });
        Button helpButt = Dugmici.getHelpButton(shell2);
        helpButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        Button okButt = Dugmici.getOkButton(shell2);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    for (Odeljenje oiz : odeljenja) {
                        if (!oiz.getNaziv().equals(od.getItem(od.getSelectionIndex()))) continue;
                        if (!PreostalaKolicina.hasCommonArticles(oiz, Artikli.this.odeljenje, Artikli.this.server)) {
                            int style = 65600;
                            MessageBox messageBox = new MessageBox(shell2, style);
                            messageBox.setText(String.format(Artikli.this.barmasterText.getString("TEXT_GRESKA"), new Object[0]));
                            messageBox.setMessage(String.format(Artikli.this.barmasterText.getString("PORUKA_NE_POSTOJE_ZAJEDNICKI_ARTIKLI_ZA_IZABRANA_ODELJENJA"), new Object[0]));
                            messageBox.open();
                            return;
                        }
                        shell2.close();
                        Shell shell3 = new Shell(Artikli.this.shell.getDisplay());
                        new UnosPovratnice(SWTContainerClass.makeContainer(shell3, String.format(Artikli.this.barmasterText.getString("TEXT_UNOS_POVRATNICE"), new Object[0])), Artikli.this.restoran, Artikli.this.odeljenje, oiz);
                        SWTContainerClass.makeEnd(shell3);
                    }
                }
                catch (Exception ex) {
                    return;
                }
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        shell2.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 200;
        data.horizontalAlignment = 131072;
        data.horizontalSpan = 2;
        od.setLayoutData((Object)data);
        shell2.pack();
        shell2.open();
    }

    public Label getLabel1Unos() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 30;
        labeData1.widthHint = 40;
        Label label1 = new Label(this.composite1, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel1UnosSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite1, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel1PregledSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite2, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel2Unos() {
        GridData labeData2 = new GridData();
        labeData2.heightHint = 20;
        Label label2 = new Label(this.composite1, 0);
        label2.setBackground(this.shell.getDisplay().getSystemColor(1));
        label2.setLayoutData((Object)labeData2);
        return label2;
    }

    public Label getLabel1Pregled() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 30;
        labeData1.widthHint = 40;
        Label label1 = new Label(this.composite2, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel2Pregled() {
        GridData labeData2 = new GridData();
        labeData2.heightHint = 20;
        labeData2.widthHint = 200;
        Label label2 = new Label(this.composite2, 0);
        label2.setBackground(this.shell.getDisplay().getSystemColor(1));
        label2.setLayoutData((Object)labeData2);
        return label2;
    }

    public Button getLabel1() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 35;
        labeData1.horizontalAlignment = 0x1000000;
        labeData1.widthHint = 190;
        Button label1 = new Button(this.dugmici, 8);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/novi.gif");
        label1.setImage(img);
        label1.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel3PopisSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite3, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel4OtpisSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite4, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel5UtrosakSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite5, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public Label getLabel6NabavnaCenaSpan() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        labeData1.horizontalSpan = 2;
        Label label1 = new Label(this.composite6, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    private Label getLabel0() {
        GridData labeData1 = new GridData();
        labeData1.heightHint = 20;
        Label label1 = new Label(this.composite0, 0);
        label1.setBackground(this.shell.getDisplay().getSystemColor(1));
        label1.setLayoutData((Object)labeData1);
        return label1;
    }

    public void refreshLabel() {
        this.prodajni.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.polu.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.sirov.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.dodatni.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.svi.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.blokir.setBackground(this.shell.getDisplay().getSystemColor(1));
        try {
            this.slozeni.setBackground(this.shell.getDisplay().getSystemColor(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Tree getTree(List<Artikal> artikli, Composite c) {
        this.loadMap(artikli);
        if (this.tree == null) {
            this.tree = new Tree(c, 2594);
            GridData data = new GridData(4, 4, false, true, 2, 1);
            data.widthHint = 250;
            this.tree.setLayoutData((Object)data);
            this.tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        boolean checked = item.getChecked();
                        Artikli.this.checkItems(item, checked);
                        Artikli.this.checkPath(item.getParentItem(), checked, false);
                    }
                }
            });
        } else {
            this.tree.removeAll();
        }
        for (GrupaArtikala ga : this.mapaGrupe.keySet()) {
            TreeItem item0 = new TreeItem(this.tree, 0);
            item0.setText(ga.getNaziv());
            for (PodgrupaArtikala pa : this.mapaGrupe.get(ga)) {
                TreeItem item1 = new TreeItem(item0, 0);
                item1.setText(pa.getNaziv());
                for (Artikal s : this.mapaPodgrupe.get(pa)) {
                    if (s.getBlokiran().booleanValue()) continue;
                    TreeItem item2 = new TreeItem(item1, 0);
                    item2.setText(s.getName());
                    if (!this.checkedTreeItems.contains(s.getName())) continue;
                    this.checkItems(item2, true);
                    this.checkPath(item2, true, false);
                }
            }
        }
        return this.tree;
    }

    public void loadMap(List<Artikal> artikli) {
        this.mapaPodgrupe = new HashMap<PodgrupaArtikala, List<Artikal>>();
        this.mapaGrupe = new HashMap<GrupaArtikala, List<PodgrupaArtikala>>();
        for (Artikal a : artikli) {
            ArrayList l;
            System.out.println(a.getName());
            if (a.getBlokiran().booleanValue()) continue;
            PodgrupaArtikala podgrupaArtikala = a.getPodgrupa();
            List<Artikal> test = this.mapaPodgrupe.get(podgrupaArtikala);
            if (test == null) {
                l = new ArrayList();
                l.add(a);
                this.mapaPodgrupe.put(a.getPodgrupa(), l);
                if (this.mapaGrupe.get(a.getPodgrupa().getGrupa()) == null) {
                    ArrayList<PodgrupaArtikala> l2 = new ArrayList<PodgrupaArtikala>();
                    l2.add(a.getPodgrupa());
                    this.mapaGrupe.put(a.getPodgrupa().getGrupa(), l2);
                    continue;
                }
                ArrayList l3 = (ArrayList)this.mapaGrupe.get(a.getPodgrupa().getGrupa());
                if (l3.contains(a.getPodgrupa())) continue;
                l3.add(a.getPodgrupa());
                this.mapaGrupe.put(a.getPodgrupa().getGrupa(), l3);
                continue;
            }
            l = (ArrayList)this.mapaPodgrupe.get(a.getPodgrupa());
            l.add(a);
            this.mapaPodgrupe.put(a.getPodgrupa(), l);
        }
    }

    private void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            TreeItem[] items = item.getItems();
            for (int index = 0; index < items.length; ++index) {
                TreeItem child = items[index];
                if (!child.getGrayed() && checked == child.getChecked()) continue;
                grayed = true;
                checked = true;
                break;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    private void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        if (items.length == 0) {
            int level = 1;
            TreeItem parent = item;
            while ((parent = parent.getParentItem()) != null) {
                ++level;
            }
            if (level == 3) {
                if (checked) {
                    if (!this.checkedTreeItems.contains(item.getText())) {
                        this.checkedTreeItems.add(item.getText());
                    }
                } else if (this.checkedTreeItems.contains(item.getText())) {
                    this.checkedTreeItems.remove(item.getText());
                }
            }
        }
        for (int i = 0; i < items.length; ++i) {
            this.checkItems(items[i], checked);
        }
    }

    public void stampa() {
        GridPrinter gp = new GridPrinter(new PrintHandler());
        gp.printTable(new TableWrapper(this.tabela), false, true, String.format(this.barmasterText.getString("TEXT_TRENUTNO_STANJE_ZALIHA"), new Object[0]) + ": ", this.shell, this.server);
    }

    public String getJedMereInterName(String jmn) {
        for (JedMere jm : JedMere.values()) {
            if (!jm.name().equalsIgnoreCase(jmn) && !jm.getInterName().equalsIgnoreCase(jmn)) continue;
            return jm.getInterName();
        }
        return "";
    }

    protected void createNormativ(Artikal input, List<Normativ> normativi) {
        if (input != null) {
            NormativArtikal normativArtikal = new NormativArtikal();
            normativArtikal.setArtikal(input);
            normativArtikal.setUname(this.server.getUser().getName());
            if (this.server.getNormativArtikal(input.getId()) == null) {
                normativArtikal.setDatum(this.server.getDatumisNotNUll());
            } else {
                normativArtikal.setDatum(new Date());
            }
            normativArtikal.setAktivan(true);
            this.server.addNormativArtikal(normativArtikal);
            for (Normativ normativ : normativi) {
                normativ.setId(null);
                normativ.setArtikal(input);
                normativ.setNormativArtikal(normativArtikal);
                this.server.addNormativ(normativ);
            }
        } else {
            NormativArtikal normativArtikal = new NormativArtikal();
            normativArtikal.setArtikal(input);
            normativArtikal.setUname(this.server.getUser().getName());
            normativArtikal.setDatum(new Date());
            normativArtikal.setAktivan(true);
            this.server.addNormativArtikal(normativArtikal);
            for (Normativ normativ : normativi) {
                normativ.setId(null);
                normativ.setArtikal(input);
                normativ.setNormativArtikal(normativArtikal);
                this.server.addNormativ(normativ);
            }
        }
    }
}

