/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.sistem;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.AdministracijaPopusta;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdministracijaPopustaSistem {
    private Shell shell;
    private SWTList lista;
    private DefaultListModel listModel;
    private Label display;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private AdministracijaPopusta active;
    Composite dugmici;
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());

    public AdministracijaPopustaSistem(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite panel1 = new Composite((Composite)this.shell, 0);
        panel1.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData();
        Composite panel2 = new Composite((Composite)this.shell, 0);
        panel2.setLayout((Layout)new GridLayout(3, false));
        data = new GridData();
        Label slika = new Label(panel1, 0);
        Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/podgrupeV.gif");
        slika.setImage(img);
        slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
        slika.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 80;
        data.widthHint = 440;
        Group grupaText = new Group(panel1, 0);
        grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_POPUSTI"), new Object[0]));
        grupaText.setLayout((Layout)new FillLayout());
        grupaText.setLayoutData((Object)data);
        Label text = new Label((Composite)grupaText, 64);
        text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
        Button uputstvo = new Button(panel1, 8);
        Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
        uputstvo.setImage(manImg);
        uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
        data = new GridData();
        data.widthHint = 115;
        data.heightHint = 100;
        uputstvo.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 230;
        data.heightHint = 500;
        Group grupa1 = new Group(panel2, 0x1000000);
        grupa1.setLayout((Layout)new GridLayout());
        grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_OPCIJE"), new Object[0]));
        grupa1.setLayoutData((Object)data);
        Group grupa2 = new Group(panel2, 0);
        grupa2.setLayout((Layout)new GridLayout());
        grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_SPISAK_POPUSTA"), new Object[0]));
        grupa2.setLayoutData((Object)data);
        Group grupa3 = new Group(panel2, 0);
        grupa3.setLayout((Layout)new GridLayout());
        grupa3.setText(String.format(Konstante.getBundle().getString("TEXT_ATRIBUTI_POPUSTA"), new Object[0]));
        grupa3.setLayoutData((Object)data);
        this.dugmici = new Composite((Composite)grupa1, 0);
        this.dugmici.setLayout((Layout)new GridLayout(1, false));
        Button label1 = Dugmici.getNovi(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_NOVI_POPUST"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                AdministracijaPopustaSistem.this.addPopust();
            }
        });
        label1 = Dugmici.getIzmena(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_IZMENA_POPUSTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                AdministracijaPopustaSistem.this.updatePopust();
            }
        });
        label1 = Dugmici.getBrisanje(this.dugmici);
        label1.setText("  " + String.format(Konstante.getBundle().getString("TEXT_BRISANJE_POPUSTA"), new Object[0]));
        label1.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                AdministracijaPopustaSistem.this.deletePopust();
            }
        });
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)grupa2, 512);
        list.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = AdministracijaPopustaSistem.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                AdministracijaPopustaSistem.this.setActivePopust((AdministracijaPopusta)AdministracijaPopustaSistem.this.listModel.getElementAt(index));
            }
        });
        this.display = new Label((Composite)grupa3, 0);
        data = new GridData(1808);
        this.lista.getControl().setLayoutData((Object)data);
        this.display.setLayoutData((Object)data);
        this.reload();
        SWTContainerClass.setDimension(this.shell);
    }

    private void reload() {
        this.listModel.clear();
        List<AdministracijaPopusta> popusti = this.restoran.getServer().readAdministracijaPopusti();
        for (AdministracijaPopusta l : popusti) {
            this.listModel.addElement(l);
        }
        this.active = null;
        this.display.setText("");
    }

    private void addPopust() {
        UnosNovogPopusta unp = new UnosNovogPopusta(this.shell, null);
        if (unp.getOutput() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_NOVI_POPUST"), new Object[0]) + ":   " + unp.getOutput());
            this.restoran.getServer().addAdministracijaPopust(unp.getOutput());
            this.reload();
        }
    }

    private void updatePopust() {
        if (this.active == null) {
            return;
        }
        UnosNovogPopusta unp = new UnosNovogPopusta(this.shell, this.active);
        if (unp.getOutput() != null) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_IZMENA_POPUSTA"), new Object[0]) + ": " + unp.getOutput());
            this.restoran.getServer().updateAdministracijaPopusta(unp.getOutput());
            this.reload();
        }
    }

    private void deletePopust() {
        if (this.active == null) {
            return;
        }
        int ok = SWTOptionPane.showConfirmDialog(this.parent, (Object)String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_OBRISETE_POPUST_IZ_SISTEMA"), this.active.getNaziv()));
        if (ok == 0) {
            this.server.log(String.format(Konstante.getBundle().getString("TEXT_BRISANJE_POPUSTA"), new Object[0]) + ": " + this.active.getNaziv());
            this.restoran.getServer().deleteAdministracijaPopusta(this.active);
            this.active = null;
            this.display.setText("");
            this.reload();
        }
    }

    private void setActivePopust(AdministracijaPopusta o) {
        this.active = o;
        StringBuilder bld = new StringBuilder("");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]) + ": ").append(o.getNaziv()).append("\n");
        bld.append(" " + String.format(Konstante.getBundle().getString("TEXT_VREDNOST"), new Object[0]) + ": ").append(o.getPopust()).append("\n");
        this.display.setText(bld.toString());
    }

    public class UnosNovogPopusta {
        private AdministracijaPopusta output = null;
        private Display display;
        private Image backImg;
        private Font buttFont;
        private Color buttCol;
        AdministracijaPopusta input;

        public UnosNovogPopusta(Shell parent, AdministracijaPopusta ap) {
            this.display = parent.getDisplay();
            this.input = ap;
            this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
            this.buttCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getButtonFontColor());
            final Shell sNew = new Shell(parent, 34912);
            sNew.setText(String.format(AdministracijaPopustaSistem.this.barmasterText.getString("TEXT_UNOS_NOVOG_POPUSTA"), new Object[0]));
            sNew.setLayout((Layout)new GridLayout(2, true));
            sNew.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    UnosNovogPopusta.this.output = null;
                }
            });
            Composite cData = new Composite((Composite)sNew, 0);
            GridData gdd = new GridData(4, 4, true, true, 2, 1);
            gdd.heightHint = 80;
            cData.setLayoutData((Object)gdd);
            cData.setLayout((Layout)new GridLayout(4, false));
            Label lName = new Label(cData, 131072);
            gdd = new GridData(4, 0x1000000, false, true);
            lName.setLayoutData((Object)gdd);
            lName.setFont(this.buttFont);
            lName.setText(String.format(AdministracijaPopustaSistem.this.barmasterText.getString("TEXT_NAZIV_POPUSTA"), new Object[0]) + ": ");
            final Text tName = new Text(cData, 2048);
            gdd = new GridData(4, 0x1000000, true, true);
            gdd.widthHint = 200;
            tName.setFont(this.buttFont);
            tName.setLayoutData((Object)gdd);
            Label lpopust = new Label(cData, 131072);
            gdd = new GridData(4, 0x1000000, false, true);
            lpopust.setLayoutData((Object)gdd);
            lpopust.setFont(this.buttFont);
            lpopust.setText(String.format(AdministracijaPopustaSistem.this.barmasterText.getString("TEXT_POPUST"), new Object[0]) + ": ");
            final Text tPopust = new Text(cData, 2048);
            gdd = new GridData(4, 0x1000000, true, true);
            gdd.widthHint = 200;
            tPopust.setFont(this.buttFont);
            tPopust.setLayoutData((Object)gdd);
            if (this.input != null) {
                tName.setText(this.input.getNaziv());
                tPopust.setText(String.valueOf(this.input.getPopust()));
            }
            GridData gd = new GridData(0x1000000, 0x1000000, true, false);
            gd.widthHint = 120;
            gd.heightHint = 50;
            ImageButton bCancel = new ImageButton((Composite)sNew, 0);
            bCancel.setLayoutData(gd);
            bCancel.setBackgroundImage(this.backImg);
            bCancel.setFont(this.buttFont);
            bCancel.setForeground(this.buttCol);
            bCancel.setText(AdministracijaPopustaSistem.this.barmasterText.getString("TEXT_OTKAZI"));
            bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sNew.dispose();
                }
            });
            final ImageButton bOk = new ImageButton((Composite)sNew, 0);
            bOk.setLayoutData(gd);
            bOk.setBackgroundImage(this.backImg);
            bOk.setFont(this.buttFont);
            bOk.setForeground(this.buttCol);
            bOk.setText(AdministracijaPopustaSistem.this.barmasterText.getString("TEXT_POTVRDI"));
            bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tName.getText().length() == 0) {
                        return;
                    }
                    if (UnosNovogPopusta.this.input != null) {
                        UnosNovogPopusta.this.input.setNaziv(tName.getText());
                        UnosNovogPopusta.this.input.setPopust(Double.valueOf(tPopust.getText()));
                        UnosNovogPopusta.this.output = UnosNovogPopusta.this.input;
                    } else {
                        AdministracijaPopusta newPopust = new AdministracijaPopusta();
                        newPopust.setNaziv(tName.getText());
                        newPopust.setPopust(Double.valueOf(tPopust.getText()));
                        UnosNovogPopusta.this.output = newPopust;
                    }
                    sNew.dispose();
                }
            });
            tName.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        bOk.notifyListeners(13, new Event());
                    }
                }
            });
            sNew.pack();
            Konstante.centerShellOnDisplay(sNew);
            sNew.open();
            while (!sNew.isDisposed()) {
                if (sNew.getDisplay().readAndDispatch()) continue;
                sNew.getDisplay().sleep();
            }
        }

        public AdministracijaPopusta getOutput() {
            return this.output;
        }

        public void setOutput(AdministracijaPopusta output) {
            this.output = output;
        }
    }
}

