/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.scale.overfolder;

import com.dev63.restoran.scale.IMeasurement;
import com.dev63.restoran.scale.IScale;
import com.dev63.restoran.scale.overfolder.OverFolderMeasurementCallable;
import com.dev63.restoran.scale.overfolder.OverFolderMeasurementFutureTask;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class OverFolderScale
implements IScale {
    private static final String FROM_FOLDER_NAME = "FROM";
    private static final String TO_FOLDER_NAME = "TO";
    private static volatile OverFolderScale instance;
    private static final String defaultFolder = "scale";
    private volatile Path folder;
    private volatile boolean closed;
    private volatile ExecutorService executor = Executors.newFixedThreadPool(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkInstance() {
        if (instance != null && !instance.isClosed()) return;
        Class<OverFolderScale> clazz = OverFolderScale.class;
        synchronized (OverFolderScale.class) {
            if (instance != null && !instance.isClosed()) return;
            instance = new OverFolderScale();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static OverFolderScale getInstance() throws IOException {
        return OverFolderScale.getInstance(defaultFolder);
    }

    public static OverFolderScale getInstance(String folder) throws IOException {
        Path folderPath;
        OverFolderScale.checkInstance();
        OverFolderScale.instance.folder = folderPath = OverFolderScale.checkFolder(folder);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Path checkFolder(String folder) throws IOException {
        Path toFolder;
        Path fPath = FileSystems.getDefault().getPath(folder, new String[0]);
        Class<OverFolderScale> clazz = OverFolderScale.class;
        // MONITORENTER : com.dev63.restoran.scale.overfolder.OverFolderScale.class
        if (!Files.exists(fPath, new LinkOption[0])) {
            Files.createDirectories(fPath, new FileAttribute[0]);
        }
        // MONITOREXIT : clazz
        if (!Files.isDirectory(fPath, new LinkOption[0])) {
            throw new IOException("Provided path doesn't point to a directory!");
        }
        Path fromFolder = OverFolderScale.getFromFolder(fPath);
        if (!Files.exists(fromFolder, new LinkOption[0])) {
            Class<OverFolderScale> clazz2 = OverFolderScale.class;
            // MONITORENTER : com.dev63.restoran.scale.overfolder.OverFolderScale.class
            if (!Files.exists(fromFolder, new LinkOption[0])) {
                Files.createDirectory(fromFolder, new FileAttribute[0]);
            }
            // MONITOREXIT : clazz2
        }
        if (Files.exists(toFolder = OverFolderScale.getToFolder(fPath), new LinkOption[0])) return fPath;
        Class<OverFolderScale> clazz3 = OverFolderScale.class;
        // MONITORENTER : com.dev63.restoran.scale.overfolder.OverFolderScale.class
        if (!Files.exists(toFolder, new LinkOption[0])) {
            Files.createDirectory(toFolder, new FileAttribute[0]);
        }
        // MONITOREXIT : clazz3
        return fPath;
    }

    private static Path getFromFolder(Path folder) {
        if (folder == null) {
            return null;
        }
        return folder.resolve(FROM_FOLDER_NAME);
    }

    private static Path getToFolder(Path folder) {
        if (folder == null) {
            return null;
        }
        return folder.resolve(TO_FOLDER_NAME);
    }

    protected OverFolderScale() {
    }

    protected Path getFromFolder() {
        return OverFolderScale.getFromFolder(this.folder);
    }

    protected Path getToFolder() {
        return OverFolderScale.getToFolder(this.folder);
    }

    @Override
    public FutureTask<? extends IMeasurement> measure() {
        OverFolderMeasurementFutureTask task = new OverFolderMeasurementFutureTask(new OverFolderMeasurementCallable(this.getFromFolder(), this.getToFolder()));
        this.executor.submit(task);
        return task;
    }

    @Override
    public void close() throws Exception {
        this.executor.shutdownNow();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

