/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.rekonstrukcija;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.TipArtikla;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StavkeRekonstrukcija {
    Connection connection;
    private long artikal_id;
    private long odeljenje_id;
    private String naziv;
    private TipArtikla tip;
    private double kolicina;
    private Date datum_racuna;
    private int zdBroj;
    private boolean crno;
    private long dokument_id;

    public StavkeRekonstrukcija() {
    }

    public StavkeRekonstrukcija(RestoranServer server) {
        this.connection = server.getConnection();
    }

    public long getArtikal_id() {
        return this.artikal_id;
    }

    public void setArtikal_id(long artikal_id) {
        this.artikal_id = artikal_id;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public TipArtikla getTip() {
        return this.tip;
    }

    public void setTip(TipArtikla tip) {
        this.tip = tip;
    }

    public double getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public Date getDatum_racuna() {
        return this.datum_racuna;
    }

    public void setDatum_racuna(Date datum_racuna) {
        this.datum_racuna = datum_racuna;
    }

    public int getZdBroj() {
        return this.zdBroj;
    }

    public void setZdBroj(int zdBroj) {
        this.zdBroj = zdBroj;
    }

    public boolean isCrno() {
        return this.crno;
    }

    public void setCrno(boolean crno) {
        this.crno = crno;
    }

    public long getOdeljenje_id() {
        return this.odeljenje_id;
    }

    public void setOdeljenje_id(long odeljenje_id) {
        this.odeljenje_id = odeljenje_id;
    }

    public long getDokument_id() {
        return this.dokument_id;
    }

    public void setDokument_id(long dokument_id) {
        this.dokument_id = dokument_id;
    }

    public List<StavkeRekonstrukcija> getStavkeRekonsrukcija(Date datumOd) {
        java.sql.Date od = new java.sql.Date(datumOd.getTime());
        LinkedList<StavkeRekonstrukcija> listaStavki = new LinkedList<StavkeRekonstrukcija>();
        String query = " SELECT sr.ARTIKAL_ID, sr.naziv, a.tip, \r\nif(a.tip = 'PROD' OR  a.tip = 'POLU', ROUND(a.mera * sr.kolicina ,4), sr.kolicina) AS kolicina , \r\nr.datum, r.zdBroj, r.crnoPlacanje, r.naOsnovno, \r\nko.ODELJENJA_ID AS  ODELJENJA_ID\r\nFROM stavkaracuna sr\r\nJOIN racun r ON sr.RACUN_ID = r.id\r\nJOIN artikal a ON sr.ARTIKAL_ID = a.id\r\nJOIN kasa_odeljenje ko ON r.KASA_ID = ko.KASA_ID \r\nWHERE r.zdBroj >=  \r\n(SELECT z.zdBroj FROM zd z WHERE z.datum = ? AND z.pocetak =1)\r\nAND ko.ODELJENJA_ID IN\r\n ((SELECT ko.ODELJENJA_ID FROM kasa_odeljenje ko WHERE ko.KASA_ID =r.KASA_ID AND ko.ODELJENJA_ID IN (\r\nSELECT ao.ODELJENJA_ID from artikal_odeljenje ao WHERE ao.ARTIKLI_ID = sr.ARTIKAL_ID AND ao.ODELJENJA_ID !=1)) )";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setDate(1, od);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkeRekonstrukcija srk = new StavkeRekonstrukcija();
                srk.setArtikal_id(rs.getLong("ARTIKAL_ID"));
                srk.setNaziv(rs.getString("naziv"));
                srk.setTip(this.getTipArtikla(rs.getString("tip".trim())));
                srk.setKolicina(rs.getDouble("kolicina"));
                srk.setDatum_racuna(rs.getTimestamp("datum"));
                srk.setZdBroj(rs.getInt("zdBroj"));
                boolean crno = rs.getString("crnoPlacanje") != null && !rs.getBoolean("naOsnovno");
                srk.setDokument_id(-1L);
                srk.setCrno(crno);
                srk.setOdeljenje_id(rs.getLong("ODELJENJA_ID"));
                listaStavki.add(srk);
            }
            return listaStavki;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StavkeRekonstrukcija> getStavkeRekonsrukcijaDokument(Date datumOd, String dokument) {
        java.sql.Date od = new java.sql.Date(datumOd.getTime());
        LinkedList<StavkeRekonstrukcija> listaStavki = new LinkedList<StavkeRekonstrukcija>();
        String queryProizvodnja = "SELECT prs.ARTIKAL_ID, a.name AS naziv, a.tip, prs.kolicina, CAST(concat(pr.datum,' ','23:59:00') AS DateTime) AS datum ,\r\npr.id AS dokument_id,pr.crno AS crnoPlacanje, pr.ODELJENJE_ID as ODELJENJA_ID\r\nFROM  proizvodnjastavka prs \r\nJOIN proizvodnja pr ON prs.PROIZVODNJA_ID = pr.id\r\nJOIN artikal a ON prs.ARTIKAL_ID = a.id\r\nWHERE pr.datum >= ?";
        String queryOtpis = "SELECT otps.ARTIKAL_ID, a.name AS naziv, a.tip,otps.kolicina,  CAST(concat(otp.datum,' ','23:59:00') AS DATETIME) AS datum\r\n,otp.id AS dokument_id,\r\notp.crno AS crnoPlacanje, otp.ODELJENJE_ID as ODELJENJA_ID\r\nFROM otpisstavka otps \r\nJOIN otpis otp ON otps.OTPIS_ID = otp.id\r\nJOIN artikal a ON otps.ARTIKAL_ID = a.id\r\nWHERE otp.datum >= ? ";
        String queryUtrosakDoc = "SELECT uds.ARTIKAL_ID, a.name AS naziv, a.tip,uds.kolicina, ud.datum,\r\nud.id AS dokument_id, ud.crno AS crnoplacanje, ud.ODELJENJE_ID AS ODELJENJA_ID\r\nFROM utrosakdocstavke uds \r\nJOIN utrosakdoc ud ON uds.UTROSAKDOC_ID = ud.id\r\nJOIN artikal a ON uds.ARTIKAL_ID = a.id\r\nWHERE ud.datum >= ?";
        try {
            PreparedStatement ps;
            switch (dokument) {
                case "PR": {
                    ps = this.connection.prepareStatement(queryProizvodnja);
                    break;
                }
                case "OTP": {
                    ps = this.connection.prepareStatement(queryOtpis);
                    break;
                }
                case "UDU": {
                    ps = this.connection.prepareStatement(queryUtrosakDoc);
                    break;
                }
                default: {
                    ps = this.connection.prepareStatement("");
                }
            }
            ps.setDate(1, od);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkeRekonstrukcija srk = new StavkeRekonstrukcija();
                srk.setArtikal_id(rs.getLong("ARTIKAL_ID"));
                srk.setNaziv(rs.getString("naziv"));
                srk.setTip(this.getTipArtikla(rs.getString("tip".trim())));
                srk.setKolicina(rs.getDouble("kolicina"));
                srk.setDatum_racuna(rs.getTimestamp("datum"));
                srk.setZdBroj(-1);
                srk.setDokument_id(rs.getLong("dokument_id"));
                srk.setCrno(rs.getBoolean("crnoPlacanje"));
                srk.setOdeljenje_id(rs.getLong("ODELJENJA_ID"));
                listaStavki.add(srk);
            }
            return listaStavki;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TipArtikla getTipArtikla(String tip) {
        switch (tip) {
            case "PROD": {
                return TipArtikla.PROD;
            }
            case "POLU": {
                return TipArtikla.POLU;
            }
            case "DODA": {
                return TipArtikla.DODA;
            }
            case "SLOZ": {
                return TipArtikla.SLOZ;
            }
        }
        return null;
    }
}

