/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.rekonstrukcija;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.rekonstrukcija.StavkeRekonstrukcija;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class NormativRekonstrukcija {
    Connection connection;
    RestoranServer server;
    private long artikal_id;
    private long sastojak_id;
    private String naziv_artikla;
    private String naziv_sastojka;
    private double kolicina;
    private Date datum_normativa;
    private long normativ_artikal_id;
    private long odeljenje_id;
    private boolean aktivan;
    private TipArtikla tip;
    private List<NormativRekonstrukcija> listaNormativa;

    public NormativRekonstrukcija() {
    }

    public NormativRekonstrukcija(RestoranServer theServer) {
        this.server = theServer;
        this.connection = this.server.getConnection();
        this.listaNormativa = this.getNormativLRekList();
    }

    public long getArtikal_id() {
        return this.artikal_id;
    }

    public void setArtikal_id(long artikal_id) {
        this.artikal_id = artikal_id;
    }

    public long getSastojak_id() {
        return this.sastojak_id;
    }

    public void setSastojak_id(long sastojak_id) {
        this.sastojak_id = sastojak_id;
    }

    public String getNaziv_artikla() {
        return this.naziv_artikla;
    }

    public void setNaziv_artikla(String naziv_artikla) {
        this.naziv_artikla = naziv_artikla;
    }

    public String getNaziv_sastojka() {
        return this.naziv_sastojka;
    }

    public void setNaziv_sastojka(String naziv_sastojka) {
        this.naziv_sastojka = naziv_sastojka;
    }

    public double getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(double kolicina) {
        this.kolicina = kolicina;
    }

    public Date getDatum_normativa() {
        return this.datum_normativa;
    }

    public void setDatum_normativa(Date datum_normativa) {
        this.datum_normativa = datum_normativa;
    }

    public long getOdeljenje_id() {
        return this.odeljenje_id;
    }

    public void setOdeljenje_id(long odeljenje_id) {
        this.odeljenje_id = odeljenje_id;
    }

    public long getNormativ_artikal_id() {
        return this.normativ_artikal_id;
    }

    public void setNormativ_artikal_id(long normativ_artikal_id) {
        this.normativ_artikal_id = normativ_artikal_id;
    }

    public boolean isAktivan() {
        return this.aktivan;
    }

    public void setAktivan(boolean aktivan) {
        this.aktivan = aktivan;
    }

    public TipArtikla getTip() {
        return this.tip;
    }

    public void setTip(TipArtikla tip) {
        this.tip = tip;
    }

    private List<NormativRekonstrukcija> getNormativLRekList() {
        ArrayList<NormativRekonstrukcija> listaNormativa = new ArrayList<NormativRekonstrukcija>();
        String query = "SELECT n.ARTIKAL_ID, art.name AS nazivArtikal, n.kolicina, n.SASTOJAK_ID,\r\nsast.name AS nazivSastojak, sast.tip, na.datum, n.NORMATIVARTIKAL_ID, n.ODELJENJE_ID, na.aktivan\r\nFROM normativ n\r\nJOIN normativartikal na ON n.NORMATIVARTIKAL_ID = na.id\r\nJOIN artikal art ON n.ARTIKAL_ID = art.id \r\nJOIN artikal sast ON n.SASTOJAK_ID = sast.id\r\nORDER BY n.ARTIKAL_ID, na.datum DESC , n.id DESC";
        try {
            Statement st = this.connection.createStatement();
            System.out.println(query);
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                NormativRekonstrukcija nrk = new NormativRekonstrukcija();
                nrk.setArtikal_id(rs.getLong("ARTIKAL_ID"));
                nrk.setNaziv_artikla(rs.getString("nazivArtikal"));
                nrk.setKolicina(rs.getDouble("kolicina"));
                nrk.setSastojak_id(rs.getLong("SASTOJAK_ID"));
                nrk.setNaziv_sastojka(rs.getString("nazivSastojak"));
                nrk.setDatum_normativa(rs.getTimestamp("datum"));
                nrk.setTip(this.getTipArtikla(rs.getString("tip").trim()));
                nrk.setNormativ_artikal_id(rs.getLong("NORMATIVARTIKAL_ID"));
                nrk.setOdeljenje_id(rs.getLong("ODELJENJE_ID"));
                nrk.setAktivan(rs.getBoolean("aktivan"));
                listaNormativa.add(nrk);
            }
            return listaNormativa;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<StavkeRekonstrukcija> razloziArtikal(Double kolicina, StavkeRekonstrukcija stavka) {
        long normativArtikal = 0L;
        LinkedList<StavkeRekonstrukcija> listaStavki = new LinkedList<StavkeRekonstrukcija>();
        List filter = this.listaNormativa.stream().filter(nrk -> nrk.artikal_id == stavka.getArtikal_id()).collect(Collectors.toList());
        System.out.println(filter.size());
        for (NormativRekonstrukcija nrk2 : filter) {
            System.out.println(nrk2.getNaziv_artikla() + ",  " + nrk2.getNaziv_sastojka() + " , " + nrk2.getKolicina() + " , " + nrk2.getDatum_normativa() + ",   " + nrk2.getNormativ_artikal_id());
        }
        for (NormativRekonstrukcija nrk2 : filter) {
            StavkeRekonstrukcija srk;
            System.out.println(nrk2);
            if (normativArtikal == 0L) {
                System.out.println(nrk2.getArtikal_id());
                System.out.println(stavka.getArtikal_id());
                System.out.println(nrk2.datum_normativa);
                System.out.println(stavka.getDatum_racuna());
                if (nrk2.artikal_id != stavka.getArtikal_id() || !nrk2.datum_normativa.before(stavka.getDatum_racuna()) || !nrk2.isAktivan()) continue;
                if (nrk2.getTip() == TipArtikla.SLOZ || nrk2.getTip() == TipArtikla.DODA) {
                    srk = new StavkeRekonstrukcija();
                    srk.setArtikal_id(nrk2.sastojak_id);
                    srk.setCrno(stavka.isCrno());
                    srk.setKolicina(kolicina * nrk2.getKolicina());
                    srk.setNaziv(nrk2.getNaziv_sastojka());
                    srk.setTip(nrk2.getTip());
                    srk.setDatum_racuna(stavka.getDatum_racuna());
                    srk.setZdBroj(stavka.getZdBroj());
                    srk.setOdeljenje_id(nrk2.getOdeljenje_id());
                    srk.setDokument_id(stavka.getDokument_id());
                    listaStavki.addAll(this.razloziArtikal(srk.getKolicina(), srk));
                    normativArtikal = nrk2.getNormativ_artikal_id();
                } else {
                    srk = new StavkeRekonstrukcija();
                    srk.setArtikal_id(nrk2.sastojak_id);
                    srk.setCrno(stavka.isCrno());
                    srk.setKolicina(kolicina * nrk2.getKolicina());
                    srk.setNaziv(nrk2.getNaziv_sastojka());
                    srk.setTip(nrk2.getTip());
                    srk.setZdBroj(stavka.getZdBroj());
                    srk.setDatum_racuna(stavka.getDatum_racuna());
                    srk.setOdeljenje_id(nrk2.getOdeljenje_id());
                    srk.setDokument_id(stavka.getDokument_id());
                    listaStavki.add(srk);
                }
                normativArtikal = nrk2.getNormativ_artikal_id();
                continue;
            }
            if (nrk2.normativ_artikal_id != normativArtikal) break;
            if (nrk2.getTip() == TipArtikla.SLOZ || nrk2.getTip() == TipArtikla.DODA) {
                srk = new StavkeRekonstrukcija();
                srk.setArtikal_id(nrk2.sastojak_id);
                srk.setCrno(stavka.isCrno());
                srk.setKolicina(kolicina * nrk2.getKolicina());
                srk.setNaziv(nrk2.getNaziv_sastojka());
                srk.setTip(nrk2.getTip());
                srk.setZdBroj(stavka.getZdBroj());
                srk.setDatum_racuna(stavka.getDatum_racuna());
                srk.setOdeljenje_id(nrk2.getOdeljenje_id());
                srk.setDokument_id(stavka.getDokument_id());
                listaStavki.addAll(this.razloziArtikal(srk.getKolicina(), srk));
                normativArtikal = nrk2.getNormativ_artikal_id();
                continue;
            }
            srk = new StavkeRekonstrukcija();
            srk.setArtikal_id(nrk2.sastojak_id);
            srk.setCrno(stavka.isCrno());
            srk.setKolicina(kolicina * nrk2.getKolicina());
            srk.setNaziv(nrk2.getNaziv_sastojka());
            srk.setTip(nrk2.getTip());
            srk.setZdBroj(stavka.getZdBroj());
            srk.setDatum_racuna(stavka.getDatum_racuna());
            srk.setOdeljenje_id(nrk2.getOdeljenje_id());
            srk.setDokument_id(stavka.getDokument_id());
            listaStavki.add(srk);
            normativArtikal = nrk2.getNormativ_artikal_id();
        }
        return listaStavki;
    }

    private TipArtikla getTipArtikla(String tip) {
        switch (tip) {
            case "PROD": {
                return TipArtikla.PROD;
            }
            case "POLU": {
                return TipArtikla.POLU;
            }
            case "DODA": {
                return TipArtikla.DODA;
            }
            case "SLOZ": {
                return TipArtikla.SLOZ;
            }
        }
        return null;
    }
}

