/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.patches;

import com.dev63.restoran.RestoranServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StornoPatch {
    private RestoranServer server;
    private Connection conn;
    private int tableNumber;
    private long turaId;

    public StornoPatch(RestoranServer server, int tableNumber) {
        this.server = server;
        this.conn = server.getConnection();
        this.tableNumber = tableNumber;
        this.turaId = this.getTuraIdFromTableNumber();
    }

    public void makeStorno() {
        this.deleteTuraByTuraId();
        this.deleteStavkeByTuraId();
        this.deleteStoByTableNumber();
    }

    private void deleteStoByTableNumber() {
        String query = "DELETE FROM sto  WHERE broj = ?";
        try {
            PreparedStatement ps = this.conn.prepareStatement(query);
            ps.setInt(1, this.tableNumber);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void deleteStavkeByTuraId() {
        String query = "DELETE FROM stavkaracuna  WHERE TURA_ID = ?";
        try {
            PreparedStatement ps = this.conn.prepareStatement(query);
            ps.setLong(1, this.turaId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void deleteTuraByTuraId() {
        long turaID = this.getTuraIdFromTableNumber();
        String query = "DELETE FROM tura WHERE id = ?";
        try {
            PreparedStatement ps = this.conn.prepareStatement(query);
            ps.setLong(1, turaID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private long getTuraIdFromTableNumber() {
        String query = "SELECT t.id FROM tura t WHERE t.brojStola = ? \r\nORDER BY t.id LIMIT 1";
        try {
            PreparedStatement ps = this.conn.prepareStatement(query);
            ps.setInt(1, this.tableNumber);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getLong("id");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }
}

