/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.fiscal.FiscalItem;
import com.dev63.fiscal.FiscalRecipet;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.StavkaRacuna;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriterHCP {
    static String hcpPath = BMTerminalSettings.getSetting(OptionBO.HCP_PUTANJA).stringValue();
    static String path = hcpPath + "TO_FP/";
    static String resPath = hcpPath + "FROM_FP/";
    static String copyPath = hcpPath + "COPY/";
    static String tmp = hcpPath;
    public static final DateFormat format = new SimpleDateFormat("ddMMyy");
    static int brojac = 100000;
    static int plu = 1;

    private XMLWriterHCP() throws ClassNotFoundException, SQLException {
    }

    private static void showErrorPane(String message, String title) {
        JOptionPane pane = new JOptionPane(message, 0);
        JDialog dialog = pane.createDialog(title);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
    }

    public static synchronized void proveraFiskalnogDana() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("DATA");
        e1.setAttribute("CMD", "PROVERI_FISKALNI_DAN");
        rootElement.appendChild(e1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writeNonFiscal(String line) throws Exception {
        String d = "TXT_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("NEFISKALNI_TEKST");
        newDoc.appendChild(rootElement);
        Element c1 = newDoc.createElement("DATA");
        c1.setAttribute("TXT", line);
        rootElement.appendChild(c1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writeDnevniIzvestajIPresekStanja() throws Exception {
        XMLWriterHCP.writePresekStanja();
        XMLWriterHCP.writeDnevniIzvestaj();
    }

    public static synchronized void writeProdatiArtikli() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("DATA");
        e1.setAttribute("CMD", "PRODATI_ARTIKLI");
        rootElement.appendChild(e1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writePeriodicniIzvestaj(Date from, Date to) throws TransformerConfigurationException, TransformerException, ParserConfigurationException {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("DATA");
        e1.setAttribute("CMD", "PERIODICNI_IZVESTAJ");
        e1.setAttribute("FROM", format.format(from));
        e1.setAttribute("TO", format.format(to));
        rootElement.appendChild(e1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writePresekStanja() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("DATA");
        e1.setAttribute("CMD", "PRESEK_STANJA");
        rootElement.appendChild(e1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writeDnevniIzvestaj() throws ParserConfigurationException, TransformerConfigurationException, TransformerException, SQLException, ClassNotFoundException, Exception {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("DATA");
        e1.setAttribute("CMD", "DNEVNI_IZVESTAJ");
        rootElement.appendChild(e1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
    }

    public static synchronized void writeArtikle() throws ParserConfigurationException, TransformerConfigurationException, TransformerException, SQLException, ClassNotFoundException, Exception {
        String d = "KOM_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KOMANDA");
        newDoc.appendChild(rootElement);
        Element e2 = newDoc.createElement("DATA");
        e2.setAttribute("CMD", "OBRISI_SVE_ARTIKLE");
        rootElement.appendChild(e2);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File f2 = new File(path + d + ".xml");
        System.out.println("f2.getName() = " + f2.getName());
        System.out.println("f2.getAbsolutePath() = " + f2.getAbsolutePath());
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
        Class.forName("com.mysql.jdbc.Driver");
        Connection connBO = DriverManager.getConnection("jdbc:mysql://localhost/restoranbo", "root", "928374");
        Statement selectBO = connBO.createStatement();
        ResultSet rsBO = selectBO.executeQuery("select actual from setting where name = 'adresa';");
        String host = "";
        while (rsBO.next()) {
            host = rsBO.getString(1);
        }
        rsBO.close();
        selectBO.close();
        connBO.close();
        Class.forName("com.mysql.jdbc.Driver");
        Connection conn = DriverManager.getConnection("jdbc:mysql://" + host + "/restoran", "root", "928374");
        Statement select = conn.createStatement();
        ResultSet rs = select.executeQuery("select * from artikal where (tip = 'PROD' or tip = 'SLOZ') and cena > 0;");
        Thread.sleep(5000L);
        XMLWriterHCP.popuniBazu(rs);
        if (rs != null) {
            rs.close();
        }
        if (select != null) {
            select.close();
        }
        if (conn != null) {
            conn.close();
        }
    }

    public static synchronized void writeFiscalReciept(FiscalRecipet fis, String konobar) throws Exception {
        String d = "RAC_" + brojac++;
        if (brojac == 999999) {
            brojac = 100000;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("RACUN");
        newDoc.appendChild(rootElement);
        for (FiscalItem f : fis.getItems()) {
            Element e1 = newDoc.createElement("DATA");
            e1.setAttribute("BCR", "" + f.getPLU());
            e1.setAttribute("PRC", "" + Konstante.getNumber2(f.getCena()));
            e1.setAttribute("AMN", Konstante.getNumber03(f.getKolicina()));
            rootElement.appendChild(e1);
        }
        Element e2 = newDoc.createElement("DATA");
        e2.setAttribute("PAY", "G");
        e2.setAttribute("AMN", "" + fis.getPlatiGotovinom());
        Element e3 = newDoc.createElement("DATA");
        e3.setAttribute("PAY", "K");
        e3.setAttribute("AMN", "" + fis.getPlatiKarticom());
        Element e4 = newDoc.createElement("DATA");
        e4.setAttribute("PAY", "C");
        e4.setAttribute("AMN", "" + fis.getPlatiCekom());
        rootElement.appendChild(e2);
        rootElement.appendChild(e3);
        rootElement.appendChild(e4);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        File f = new File(tmp + d + ".xml.tmp");
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        File fc = new File(copyPath + d + ".xml");
        StreamResult destC = new StreamResult(fc);
        aTransformer.transform(src, destC);
        File f2 = new File(path + d + ".xml");
        if (!f.renameTo(f2)) {
            f.renameTo(f2);
        }
        boolean b = true;
        while (b) {
            int length;
            File fERR;
            File fOK = new File(resPath + d + ".OK");
            if (fOK.exists()) {
                b = false;
            }
            if (!(fERR = new File(resPath + d + ".ERR")).exists()) continue;
            b = true;
            XMLWriterHCP.showErrorPane("Racun nije odstampan", "Greska");
            FileInputStream in = new FileInputStream(fc);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            fERR.delete();
        }
    }

    private static synchronized void popuniBazu(ResultSet rs) throws TransformerException, ParserConfigurationException, SQLException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("ARTICAL");
        newDoc.appendChild(rootElement);
        while (rs.next()) {
            Element e1 = newDoc.createElement("DATA");
            e1.setAttribute("PLU", rs.getString("id"));
            e1.setAttribute("DESC", rs.getString("name"));
            e1.setAttribute("VAT", rs.getString("poreskaGrupa"));
            e1.setAttribute("BCR", "-1");
            e1.setAttribute("PRC", "" + rs.getInt("cena") * 100);
            e1.setAttribute("DEP", "0");
            if (rs.getString("jedinicaMere").equals("KG")) {
                e1.setAttribute("MES", "1");
            } else if (rs.getString("jedinicaMere").equals("LIT")) {
                e1.setAttribute("MES", "4");
            } else {
                e1.setAttribute("MES", "11");
            }
            rootElement.appendChild(e1);
            int cena2 = rs.getInt("cena2");
            if (!((double)cena2 > 0.5)) continue;
            e1 = newDoc.createElement("DATA");
            e1.setAttribute("PLU", "" + (16000 + rs.getInt("id")));
            e1.setAttribute("DESC", "* " + rs.getString("name"));
            e1.setAttribute("VAT", rs.getString("poreskaGrupa"));
            e1.setAttribute("BCR", "-1");
            e1.setAttribute("PRC", "" + rs.getInt("cena2") * 100);
            e1.setAttribute("DEP", "0");
            if (rs.getString("jedinicaMere").equals("KG")) {
                e1.setAttribute("MES", "1");
            } else if (rs.getString("jedinicaMere").equals("LIT")) {
                e1.setAttribute("MES", "4");
            } else {
                e1.setAttribute("MES", "11");
            }
            rootElement.appendChild(e1);
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String slj = "ART_" + brojac++;
        File f = new File(path + slj + ".xml");
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
    }

    public static synchronized void dodavanjeArtikala(List<StavkaRacuna> arts) throws TransformerException, ParserConfigurationException, SQLException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("ARTICAL");
        newDoc.appendChild(rootElement);
        for (StavkaRacuna sr : arts) {
            if (!(sr.getCena() > 0.5)) continue;
            Artikal art = sr.getArtikal();
            Element e1 = newDoc.createElement("DATA");
            if (art.getCena() / 1.0 != sr.getCena() / 1.0) {
                e1.setAttribute("PLU", "" + (16000L + art.getId()));
                e1.setAttribute("DESC", "* " + art.getName());
            } else {
                e1.setAttribute("PLU", "" + art.getId());
                e1.setAttribute("DESC", art.getName());
            }
            e1.setAttribute("VAT", "" + art.getPoreskaGrupa().getMetalinkCode());
            e1.setAttribute("BCR", "-1");
            e1.setAttribute("PRC", "" + (int)(sr.getCena() * 100.0));
            e1.setAttribute("DEP", "0");
            if (art.getJedinicaMere().equalsIgnoreCase("KG")) {
                e1.setAttribute("MES", "1");
            } else if (art.getJedinicaMere().equalsIgnoreCase("LIT")) {
                e1.setAttribute("MES", "4");
            } else {
                e1.setAttribute("MES", "11");
            }
            rootElement.appendChild(e1);
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String slj = "ART_" + brojac++;
        File f = new File(path + slj + ".xml");
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
    }

    public static synchronized void main(String[] args) {
        try {
            XMLWriterHCP.writeArtikle();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(XMLWriterHCP.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        File f1 = new File(path);
        if (f1.exists() && f1.isDirectory()) {
            File f2 = new File(copyPath);
            if (!f2.exists()) {
                f2.mkdir();
            } else if (!f2.isDirectory() && f2.delete()) {
                f2.mkdir();
            }
        }
    }
}

