/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.sistem.fpProtocols.FLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.MetaLinkProtocol;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UplataDepozitaInput {
    private Text deposit;

    public UplataDepozitaInput(Shell parent) {
        if (Konstante.getTipStampaca() != 1) {
            MessageBox mb = new MessageBox(parent, 34);
            mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
            mb.setMessage(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_UPLATA_DEPOZITA_ZA_DATI_TIP_STAMPACA_NIJE_MOGUCA"));
            mb.open();
            return;
        }
        final Shell shell = new Shell(parent, 34912);
        shell.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPLATA_DEPOZITA"));
        shell.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, false, true);
        gd.heightHint = 30;
        gd.widthHint = 80;
        Label ld = new Label((Composite)shell, 131072);
        ld.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_DEPOZITA"));
        ld.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 30;
        gd.widthHint = 170;
        this.deposit = new Text((Composite)shell, 2048);
        this.deposit.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true, 2, 1);
        Button bOk = new Button((Composite)shell, 72);
        bOk.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POTVRDI"));
        bOk.setLayoutData((Object)gd);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Double d = UplataDepozitaInput.this.izracunajDepozit();
                if (d == null) {
                    MessageBox mb = new MessageBox(shell, 40);
                    mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
                    mb.setMessage(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_IZRACUNAVANJA_DEPOZITA"));
                    mb.open();
                    return;
                }
                MessageBox mb = new MessageBox(shell, 194);
                mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
                mb.setMessage(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_POTVRDITE_DA_JE_UNETI_IZNOS_TACAN") + ":\n" + Konstante.getNumber2(d));
                int resp = mb.open();
                if (resp == 128) {
                    return;
                }
                if (Konstante.getTipStampaca() == 1) {
                    try {
                        XMLWriter.writeDeposit(d);
                        shell.close();
                    }
                    catch (Exception ex) {
                        MessageBox mb2 = new MessageBox(shell, 40);
                        mb2.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
                        mb2.setMessage(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_SLANJA_DEPOZITA_NA_STAMPAC"));
                        mb2.open();
                    }
                } else if (Konstante.getTipStampaca() == 21) {
                    FLinkProtocol.getInstance().uplataDepozita(d);
                } else if (Konstante.getTipStampaca() == 21) {
                    try {
                        MetaLinkProtocol.getInstance().uplataDepozita(d);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(UplataDepozitaInput.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }

    private Double izracunajDepozit() {
        Double d;
        NumberFormat nf = NumberFormat.getInstance(Locale.GERMAN);
        nf.setGroupingUsed(false);
        try {
            d = nf.parse(this.deposit.getText()).doubleValue();
        }
        catch (Exception e) {
            nf = NumberFormat.getInstance(Locale.UK);
            nf.setGroupingUsed(false);
            try {
                d = nf.parse(this.deposit.getText()).doubleValue();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return d;
    }
}

