/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTTextField;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class TimeInput2
extends SWTTextField
implements Input<Date> {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    public static final String TIME_FORMAT = "HH:mm";
    private boolean nullable = true;
    private String name;
    private SimpleDateFormat format = new SimpleDateFormat("HH:mm");
    private Date defaultValue;

    public TimeInput2(SWTContainer parent, String name) {
        super(parent);
        this.name = name;
    }

    public TimeInput2(SWTContainer parent, String name, boolean nullable) {
        this(parent, name);
        this.nullable = nullable;
    }

    public TimeInput2(SWTContainer parent, String name, Date date) {
        super(parent);
        this.name = name;
        this.defaultValue = date;
        this.setResult(date);
    }

    public TimeInput2(SWTContainer parent, String name, Date date, boolean nullable) {
        super(parent);
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
    }

    @Override
    public Date getResult() throws InputException {
        String text = this.getText().trim();
        Date ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException(String.format(this.barmasterText.getString("TEXT_MORATE_POPUNITI_POLJE"), new Object[0]) + ": " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text);
            }
            catch (ParseException ex) {
                throw new InputException(String.format(this.barmasterText.getString("TEXT_MORATE_UNETI_VREME_U_FROMATU"), new Object[0]) + ": " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Date in) {
        if (in != null) {
            this.getTextControl().setText(this.format.format(in));
        } else {
            this.getTextControl().setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

