/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JTextField;

public class TimeInput
extends JTextField
implements Input<Date> {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    public static final String TIME_FORMAT = "HH:mm";
    private boolean nullable = true;
    private String name;
    private SimpleDateFormat format = new SimpleDateFormat("HH:mm");
    private Date defaultValue;

    public TimeInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    public TimeInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public TimeInput(String name, Date date) {
        this.name = name;
        this.defaultValue = date;
        this.setResult(date);
        this.setDisabledTextColor(Color.BLACK);
    }

    public TimeInput(String name, Date date, boolean nullable) {
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public Date getResult() throws InputException {
        String text = this.getText().trim();
        Date ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException(String.format(this.barmasterText.getString("TEXT_MORATE_POPUNITI_POLJE"), new Object[0]) + ": " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text);
            }
            catch (ParseException ex) {
                throw new InputException(String.format(this.barmasterText.getString("TEXT_MORATE_UNETI_VREME_U_FROMATU"), new Object[0]) + ": " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Date in) {
        if (in != null) {
            this.setText(this.format.format(in));
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

