/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IzborMeniPrometa
implements Runnable {
    public final Shell shell;
    private MeniPromet meniPromet;
    private Combo combo;
    private DoubleInput2 cena;
    private DoubleInput2 kolicina;
    private DoubleInput2 zbir;
    private RestoranServer server;
    private Label iznos;
    private double izn;
    private Button noviMeni;
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Image backImg;
    private Font buttFont;
    private Color buttCol;
    private Display display;
    private Rectangle bounds;
    List<Meni> meniji;
    private double rez;

    public IzborMeniPrometa(Shell parent, final RestoranServer server, double izn) {
        this.server = server;
        this.izn = izn;
        DecimalFormat df = new DecimalFormat("####0.00");
        Setting s = server.getSetting(Option.PROMET_NA_MENI);
        double procenat = Double.parseDouble(s.getActual());
        this.meniji = new LinkedList<Meni>();
        this.display = parent.getDisplay();
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        this.buttCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.shell = new Shell(parent, 67680);
        this.shell.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZBOR_MENIJA"));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        this.shell.setBackgroundMode(1);
        int x = this.bounds.width / 2 - 120;
        int y = this.bounds.height / 2 - 160;
        this.shell.setLocation(x, y);
        GridData gd = new GridData(4, 4, false, true);
        gd.heightHint = 25;
        gd.widthHint = 120;
        Label l = new Label((Composite)this.shell, 131072);
        l.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NABAVNA_VREDNOST") + ": ");
        l.setLayoutData((Object)gd);
        this.iznos = new Label((Composite)this.shell, 131072);
        this.iznos.setText(String.valueOf(Konstante.getNumber2(izn)));
        this.iznos.setLayoutData((Object)gd);
        this.meniji = server.getAllMenus();
        this.combo = new Combo((Composite)this.shell, 0);
        for (Meni m : this.meniji) {
            this.combo.add(m.getNaziv());
        }
        this.combo.select(0);
        this.combo.setLayoutData((Object)gd);
        this.noviMeni = Dugmici.getPlusButton((Composite)this.shell);
        this.noviMeni.setLayoutData((Object)gd);
        this.noviMeni.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UnosNovogMenija unm = new UnosNovogMenija(IzborMeniPrometa.this.shell, IzborMeniPrometa.this.meniji);
                if (unm.getOutput() != null) {
                    IzborMeniPrometa.this.meniji = server.getAllMenus();
                    IzborMeniPrometa.this.combo.add(unm.getOutput().getNaziv());
                }
            }
        });
        Label c = new Label((Composite)this.shell, 131072);
        c.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPISI_CENU") + ": ");
        c.setLayoutData((Object)gd);
        this.cena = new DoubleInput2((Composite)this.shell, ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPISI_CENU"));
        this.cena.getControl().setLayoutData((Object)gd);
        if (procenat != 0.0) {
            this.cena.setResult(Double.parseDouble(df.format(izn * (1.0 + procenat / 100.0))));
        }
        this.cena.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    IzborMeniPrometa.this.zbir.setResult(IzborMeniPrometa.this.cena.getResult() * IzborMeniPrometa.this.kolicina.getResult());
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label k = new Label((Composite)this.shell, 131072);
        k.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPISI_KOLICINU") + ": ");
        k.setLayoutData((Object)gd);
        this.kolicina = new DoubleInput2((Composite)this.shell, ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UPISI_KOLICINU"));
        this.kolicina.getControl().setLayoutData((Object)gd);
        this.kolicina.setResult(1.0);
        this.kolicina.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    IzborMeniPrometa.this.zbir.setResult(IzborMeniPrometa.this.cena.getResult() * IzborMeniPrometa.this.kolicina.getResult());
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        try {
            this.rez = this.cena.getResult() * this.kolicina.getResult();
        }
        catch (InputException e1) {
            e1.printStackTrace();
        }
        Label z = new Label((Composite)this.shell, 131072);
        z.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZBIR") + ": ");
        z.setLayoutData((Object)gd);
        this.zbir = new DoubleInput2((Composite)this.shell, ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZBIR"));
        this.zbir.getControl().setLayoutData((Object)gd);
        this.zbir.setResult(Double.parseDouble(df.format(this.rez)));
        Button bOk = Dugmici.getOkButton(this.shell);
        bOk.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POTVRDI"));
        bOk.setLayoutData((Object)gd);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IzborMeniPrometa.this.combo.getSelectionIndex() == -1) {
                    Konstante.getPoruka3(IzborMeniPrometa.this.shell, "Niste odabrali Meni");
                    return;
                }
                Meni meni = IzborMeniPrometa.this.meniji.get(IzborMeniPrometa.this.combo.getSelectionIndex());
                try {
                    if (IzborMeniPrometa.this.cena.getResult().equals(0.0) || IzborMeniPrometa.this.kolicina.getResult().equals(0.0)) {
                        Konstante.getPoruka3(IzborMeniPrometa.this.shell, "Morate popuniti sva polja!");
                        return;
                    }
                    IzborMeniPrometa.this.meniPromet = new MeniPromet();
                    IzborMeniPrometa.this.meniPromet.setMeni(meni);
                    IzborMeniPrometa.this.meniPromet.setCena(IzborMeniPrometa.this.cena.getResult());
                    IzborMeniPrometa.this.meniPromet.setKolicina(IzborMeniPrometa.this.kolicina.getResult());
                    IzborMeniPrometa.this.meniPromet.setNaziv(meni.getNaziv());
                }
                catch (InputException e1) {
                    e1.printStackTrace();
                }
                IzborMeniPrometa.this.shell.close();
            }
        });
        Button cancel = Dugmici.getCancelButton(this.shell);
        cancel.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ZATVORI"));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IzborMeniPrometa.this.shell.close();
            }
        });
        this.shell.open();
        this.shell.pack();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public MeniPromet getResult() {
        return this.meniPromet;
    }

    @Override
    public void run() {
        new IzborMeniPrometa(this.shell, this.server, this.izn);
    }

    public class UnosNovogMenija {
        private Meni output = null;
        private List<Meni> existing;

        public UnosNovogMenija(Shell parent, List<Meni> existingMenus) {
            this.existing = existingMenus != null ? existingMenus : new LinkedList();
            final Shell sNew = new Shell(parent, 67680);
            sNew.setText(String.format(IzborMeniPrometa.this.barmasterText.getString("TEXT_UNOS_NOVOG_MENIJA"), new Object[0]));
            sNew.setLayout((Layout)new GridLayout(2, true));
            sNew.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    UnosNovogMenija.this.output = null;
                }
            });
            Composite cData = new Composite((Composite)sNew, 0);
            GridData gdd = new GridData(4, 4, true, true, 2, 1);
            gdd.heightHint = 80;
            cData.setLayoutData((Object)gdd);
            cData.setLayout((Layout)new GridLayout(2, false));
            Label lName = new Label(cData, 131072);
            gdd = new GridData(4, 0x1000000, false, true);
            lName.setLayoutData((Object)gdd);
            lName.setFont(IzborMeniPrometa.this.buttFont);
            lName.setText(String.format(IzborMeniPrometa.this.barmasterText.getString("TEXT_NAZIV_MENIJA"), new Object[0]) + ": ");
            final Text tName = new Text(cData, 2048);
            gdd = new GridData(4, 0x1000000, true, true);
            gdd.widthHint = 200;
            tName.setFont(IzborMeniPrometa.this.buttFont);
            tName.setLayoutData((Object)gdd);
            tName.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        Runtime.getRuntime().exec("cmd /c C:\\Windows\\System32\\osk.exe");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            GridData gd = new GridData(0x1000000, 0x1000000, true, false);
            gd.widthHint = 120;
            gd.heightHint = 50;
            ImageButton bCancel = new ImageButton((Composite)sNew, 0);
            bCancel.setLayoutData(gd);
            bCancel.setBackgroundImage(IzborMeniPrometa.this.backImg);
            bCancel.setFont(IzborMeniPrometa.this.buttFont);
            bCancel.setForeground(IzborMeniPrometa.this.buttCol);
            bCancel.setText(IzborMeniPrometa.this.barmasterText.getString("TEXT_OTKAZI"));
            bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sNew.dispose();
                }
            });
            final ImageButton bOk = new ImageButton((Composite)sNew, 0);
            bOk.setLayoutData(gd);
            bOk.setBackgroundImage(IzborMeniPrometa.this.backImg);
            bOk.setFont(IzborMeniPrometa.this.buttFont);
            bOk.setForeground(IzborMeniPrometa.this.buttCol);
            bOk.setText(IzborMeniPrometa.this.barmasterText.getString("TEXT_POTVRDI"));
            bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tName.getText().length() == 0) {
                        return;
                    }
                    for (Meni meni : UnosNovogMenija.this.existing) {
                        if (!meni.getNaziv().equals(tName.getText())) continue;
                        MessageBox mb = new MessageBox(sNew, 34);
                        mb.setText(String.format(IzborMeniPrometa.this.barmasterText.getString("TEXT_INFO"), new Object[0]));
                        mb.setMessage(String.format(IzborMeniPrometa.this.barmasterText.getString("PORUKA_MENI_SA_ZADATIM_IMENOM_VEC_POSTOJI"), new Object[0]));
                        mb.open();
                        return;
                    }
                    Meni newMeni = new Meni();
                    newMeni.setNaziv(tName.getText());
                    IzborMeniPrometa.this.server.addMeni(newMeni);
                    UnosNovogMenija.this.output = newMeni;
                    sNew.dispose();
                }
            });
            tName.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        bOk.notifyListeners(13, new Event());
                    }
                }
            });
            sNew.pack();
            Konstante.centerShellOnDisplay(sNew);
            sNew.open();
            while (!sNew.isDisposed()) {
                if (sNew.getDisplay().readAndDispatch()) continue;
                sNew.getDisplay().sleep();
            }
        }

        public Meni getOutput() {
            return this.output;
        }

        public void setOutput(Meni output) {
            this.output = output;
        }
    }
}

