/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTComboBox;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.ItemWrapper;
import java.util.List;

public class ItemInput2<T extends BObject>
extends SWTComboBox
implements Input<T> {
    private boolean nullable = true;
    private String name;

    public ItemInput2(SWTContainer parent, String name, List<T> items, boolean nullable) {
        super(parent);
        this.name = name;
        if (nullable) {
            this.addItem(null);
        }
        for (BObject t : items) {
            this.addItem(new ItemWrapper<BObject>(t));
        }
        this.nullable = nullable;
    }

    public ItemInput2(SWTContainer parent, String name, List<T> items) {
        this(parent, name, items, false);
    }

    @Override
    public T getResult() throws InputException {
        ItemWrapper iw = (ItemWrapper)this.getSelectedItem();
        if (iw == null) {
            if (!this.nullable) {
                throw new InputException("Morate napraviti izbor na polju: " + this.name);
            }
            return null;
        }
        return iw.getData();
    }

    @Override
    public void setResult(T in) {
        if (in != null) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                ItemWrapper iw = (ItemWrapper)this.getItemAt(i);
                if (iw == null || !((BObject)iw.getData()).getId().equals(((BObject)in).getId())) continue;
                this.setSelectedIndex(i);
                return;
            }
            throw new RuntimeException("Item not found:" + in);
        }
    }

    @Override
    public void clear() {
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }
}

