/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTTextField;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import org.eclipse.swt.widgets.Composite;

public class IntInput2
extends SWTTextField
implements Input<Integer> {
    private boolean nullable = true;
    private String name;
    private Integer defaultValue;

    public IntInput2(SWTContainer parent, String name) {
        super(parent);
        this.name = name;
    }

    public IntInput2(Composite c, String name) {
        super(c);
        this.name = name;
    }

    public IntInput2(SWTContainer parent, String name, boolean nullable) {
        this(parent, name);
        this.nullable = nullable;
    }

    public IntInput2(Composite c, String name, boolean nullable) {
        this(c, name);
        this.nullable = nullable;
    }

    public IntInput2(SWTContainer parent, String name, Integer defaultValue) {
        super(parent);
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
    }

    public IntInput2(Composite c, String name, Integer defaultValue) {
        super(c);
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
    }

    public IntInput2(SWTContainer parent, String name, Integer defaultValue, boolean nullable) {
        super(parent);
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
    }

    public IntInput2(Composite parent, String name, Integer defaultValue, boolean nullable) {
        super(parent);
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
    }

    @Override
    public Integer getResult() throws InputException {
        String text = this.getText().trim();
        Integer ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException(String.format(Konstante.getBundle().getString("TEXT_MORATE_POPUNITI_POLJE"), new Object[0]) + ": " + this.name);
            }
        } else {
            try {
                ret = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                throw new InputException(String.format(Konstante.getBundle().getString("TEXT_MORATE_UNETI_VALIDAN_CEO_BROJ_U_POLJE"), new Object[0]) + ": " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Integer in) {
        if (in != null) {
            this.getTextControl().setText(String.valueOf(in));
        } else {
            this.getTextControl().setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

