/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import javax.swing.JTextField;

public class IntInput
extends JTextField
implements Input<Integer> {
    private boolean nullable = true;
    private String name;
    private Integer defaultValue;

    public IntInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    public IntInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public IntInput(String name, Integer defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
        this.setDisabledTextColor(Color.BLACK);
    }

    public IntInput(String name, Integer defaultValue, boolean nullable) {
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
        this.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public Integer getResult() throws InputException {
        String text = this.getText().trim();
        Integer ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
        } else {
            try {
                ret = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                throw new InputException("Morate uneti validan ceo broj na polje: " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Integer in) {
        if (in != null) {
            this.setText(String.valueOf(in));
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

