/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTTextField;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileInput2
extends SWTTextField
implements Input<String> {
    private boolean nullable = true;
    private String name;
    private String defaultValue;
    private String result;
    SWTContainer parent;

    public FileInput2(SWTContainer parent, String name) {
        super(parent);
        this.name = name;
        this.parent = parent;
        this.getControl().addMouseListener((MouseListener)new BrowseListener());
    }

    public FileInput2(SWTContainer parent, String name, boolean nullable) {
        super(parent);
        this.name = name;
        this.parent = parent;
        this.nullable = nullable;
        this.getControl().addMouseListener((MouseListener)new BrowseListener());
    }

    public FileInput2(SWTContainer parent, String name, String defaultValue) {
        super(parent);
        this.parent = parent;
        this.name = name;
        this.defaultValue = defaultValue;
        this.getControl().addMouseListener((MouseListener)new BrowseListener());
    }

    public FileInput2(SWTContainer parent, String name, String defaultValue, boolean nullable) {
        super(parent);
        this.parent = parent;
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = null;
        this.getControl().addMouseListener((MouseListener)new BrowseListener());
    }

    @Override
    public String getResult() throws InputException {
        if (this.result == null) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
            return null;
        }
        return this.result;
    }

    @Override
    public void setResult(String in) {
        this.result = in;
        if (in != null) {
            this.getTextControl().setText(in);
        } else {
            this.getTextControl().setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }

    private class BrowseListener
    extends MouseAdapter {
        private BrowseListener() {
        }

        public void mouseDown(MouseEvent e) {
            Shell shell = new Shell(FileInput2.this.parent.getControl().getDisplay());
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFilterNames(new String[]{"DBF Files (*.dbf*)"});
            dialog.setFilterExtensions(new String[]{"*.dbf"});
            dialog.setFilterPath("/home/petcom/Desktop/");
            if (FileInput2.this.defaultValue != null) {
                dialog.setFileName(FileInput2.this.defaultValue);
            }
            FileInput2.this.setResult(dialog.open());
        }
    }
}

