/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class FileInput
extends JTextField
implements Input<File> {
    private boolean nullable = true;
    private String name;
    private File defaultValue;
    private File result;
    private int dialogType;

    public FileInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
        this.dialogType = 0;
        this.addMouseListener(new BrowseListener());
    }

    public FileInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public FileInput(String name, File defaultValue) {
        super(defaultValue.getAbsolutePath());
        this.name = name;
        this.defaultValue = defaultValue;
        this.setDisabledTextColor(Color.BLACK);
        this.addMouseListener(new BrowseListener());
    }

    public FileInput(String name, File defaultValue, boolean nullable) {
        super(defaultValue.getAbsolutePath());
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setDisabledTextColor(Color.BLACK);
        this.addMouseListener(new BrowseListener());
    }

    @Override
    public File getResult() throws InputException {
        if (this.result == null) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
            return null;
        }
        return this.result;
    }

    @Override
    public void setResult(File in) {
        this.result = in;
        if (in != null) {
            this.setText(in.getAbsolutePath());
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }

    public void setSaveDialog(boolean in) {
        this.dialogType = in ? 1 : 0;
    }

    private class BrowseListener
    extends MouseAdapter {
        private BrowseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(FileInput.this.dialogType);
            chooser.setMultiSelectionEnabled(false);
            int ok = chooser.showDialog(FileInput.this, "Open");
            if (ok == 0) {
                FileInput.this.setResult(chooser.getSelectedFile());
            }
        }
    }
}

