/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

public class DoubleInput
extends JTextField
implements Input<Double> {
    private boolean nullable = true;
    private String name;
    private NumberFormat format = NumberFormat.getInstance(Locale.UK);
    private Double defaultValue;

    public DoubleInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    public DoubleInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public DoubleInput(String name, Double defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
        this.setDisabledTextColor(Color.BLACK);
    }

    public DoubleInput(String name, Double defaultValue, boolean nullable) {
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setResult(defaultValue);
        this.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public Double getResult() throws InputException {
        String text = this.getText().trim();
        Double ret = 0.0;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text).doubleValue();
            }
            catch (ParseException ex) {
                throw new InputException("Morate uneti validan broj na polje: " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Double in) {
        if (in != null) {
            this.setText(this.format.format(in));
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

