/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTTextField;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;

public class DateInput2
extends SWTTextField
implements Input<Date> {
    public static final String DATE_FORMAT = "dd.MM.yyyy";
    private boolean nullable = true;
    private String name;
    private SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private Date defaultValue;
    private boolean valutaPlacanja;
    private RestoranServer server;

    public DateInput2(SWTContainer parent, String name, RestoranServer server) {
        super(parent);
        this.server = server;
        this.name = name;
    }

    public DateInput2(Composite parent, String name, RestoranServer server) {
        super(parent);
        this.server = server;
        this.name = name;
    }

    public DateInput2(SWTContainer parent, String name, boolean nullable, RestoranServer server) {
        this(parent, name, server);
        this.nullable = nullable;
    }

    public DateInput2(Composite parent, String name, boolean nullable, RestoranServer server) {
        this(parent, name, server);
        this.nullable = nullable;
    }

    public DateInput2(SWTContainer parent, String name, Date date, RestoranServer server) {
        super(parent);
        this.server = server;
        this.name = name;
        this.defaultValue = date;
        this.setResult(date);
    }

    public DateInput2(Composite parent, String name, Date date, RestoranServer server) {
        super(parent);
        this.server = server;
        this.name = name;
        this.defaultValue = date;
        this.setResult(date);
    }

    public DateInput2(SWTContainer parent, String name, Date date, boolean nullable, RestoranServer server) {
        super(parent);
        this.server = server;
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
    }

    public DateInput2(SWTContainer parent, String name, Date date, boolean nullable) {
        super(parent);
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
    }

    public DateInput2(Composite parent, String name, Date date, boolean nullable, RestoranServer server) {
        super(parent);
        this.server = server;
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
    }

    @Override
    public Date getResult() throws InputException {
        String text = this.getText().trim();
        Date ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text);
            }
            catch (ParseException ex) {
                throw new InputException("Morate uneti datum u formatu dd.MM.gggg u polje: " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Date in) {
        if (in != null) {
            if (this.valutaPlacanja) {
                LocalDate alowedDate = LocalDate.now().minusMonths(2L);
                LocalDate inDate = in.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                try {
                    if (!this.server.getUser().getService().booleanValue() && inDate.isBefore(alowedDate)) {
                        in = Date.from(alowedDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.getTextControl().setText(this.format.format(in));
            } else {
                Date today = new Date();
                Date tommorow = Konstante.getTomorrowDate(today);
                SimpleDateFormat formmater = new SimpleDateFormat("yyyy-MM-dd");
                String todayf = formmater.format(in);
                String tommorowf = formmater.format(tommorow);
                if (in.before(new Date()) || in.equals(new Date()) || todayf.equals(tommorowf)) {
                    LocalDate inDate = in.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    try {
                        if (!this.server.getUser().getService().booleanValue()) {
                            in = Date.from(inDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (this.server != null) {
                        if (in.before(this.server.getFirstDateZD())) {
                            in = this.server.getFirstDateZD();
                        }
                        if (in.after(this.server.getLastDateZD())) {
                            in = this.server.getLastDateZD();
                        }
                    }
                    this.getTextControl().setText(this.format.format(in));
                }
            }
        } else {
            this.getTextControl().setText("");
        }
    }

    public boolean isValutaPlacanja() {
        return this.valutaPlacanja;
    }

    public void setValutaPlacanja(boolean valutaPlacanja) {
        this.valutaPlacanja = valutaPlacanja;
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

