/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.StampaPorudzbine1;
import droid.IBarDroidServis;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BarDroidServis
extends UnicastRemoteObject
implements IBarDroidServis {
    private RestoranServer server;
    private Restoran restoran;

    public BarDroidServis(Restoran restoran) throws RemoteException {
        this.server = restoran.getServer();
        this.restoran = restoran;
    }

    public String[] unosNoveTure(int[] input) throws RemoteException {
        this.restoran.getLog().info("Remote call!!!!!!!!");
        int konobarId = input[input.length - 1];
        int stoBroj = input[input.length - 2];
        Sto sto = this.server.getSto(stoBroj);
        if (sto != null) {
            if (sto.getBlokiran().booleanValue()) {
                return new String[]{"0", "Izabrani sto je blokiran."};
            }
            if (sto.getKonobar().getId() != (long)konobarId) {
                return new String[]{"0", "Sto je otvorio drugi konobar."};
            }
        } else {
            sto = new Sto();
            sto.setBlokiran(false);
            sto.setBroj(stoBroj);
            sto.setKonobar(this.server.getKonobar(new Long(konobarId)));
            this.server.addStoQuery(sto);
        }
        List<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
        Tura tura = new Tura();
        tura.setBrojStola(stoBroj);
        tura.setPocetak(new Timestamp(0L));
        tura.setKraj(new Timestamp(0L));
        tura.setDatum(new Date());
        tura.setBrojTure(this.server.sledeciBrojTure());
        this.server.incrementBrojTure(String.valueOf(tura.getBrojTure() + 1));
        tura = this.server.addTura(tura);
        for (int i = 0; i < input.length - 2; i += 2) {
            int artikalId = input[i];
            double kolicina = (double)input[i + 1] / 100.0;
            StavkaRacuna sr = new StavkaRacuna();
            sr.setArtikal(this.server.getArtikal(new Long(artikalId)));
            sr.setKolicina(kolicina);
            sr.setBrojStola(stoBroj);
            sr.setCena(sr.getArtikal().getCena());
            sr.setTura(tura);
            sr.setNaziv(sr.getArtikal().getName());
            stavke.add(sr);
        }
        stavke = StavkeSumarno.getSumarno(stavke);
        for (StavkaRacuna sr : stavke) {
            this.server.addStavkaRacuna(sr);
        }
        tura.setStavke(stavke);
        new StampaPorudzbine1(stavke, this.restoran);
        return new String[]{"1", "PORUDZBINA USPESNO ZAPAMCENA!"};
    }

    public String hello() throws RemoteException {
        return "HELLO WORLD!!!";
    }
}

