/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.dao.internal;

import com.dev63.restoran.model.EntityObject;
import com.dev63.restoran.model.dao.internal.TransactionalBatchActivity;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.EntityManager;

public class BatchMergeAndRefreshActivity<E extends EntityObject>
implements TransactionalBatchActivity<E, List<E>> {
    @Override
    public List<E> executeBatch(List<E> entities, EntityManager em, Integer maxBatchSize) {
        EntityObject entity;
        if (maxBatchSize == null) {
            maxBatchSize = DEFAULT_MAX_BATCH_SIZE;
        }
        int c = 0;
        if (entities == null) {
            return Collections.emptyList();
        }
        ListIterator<E> listIterator = entities.listIterator();
        while (listIterator.hasNext()) {
            entity = (EntityObject)listIterator.next();
            if (++c % maxBatchSize == 0) {
                em.flush();
            }
            if (entity == null) continue;
            em.merge((Object)entity);
        }
        em.flush();
        while (listIterator.hasPrevious()) {
            entity = (EntityObject)listIterator.previous();
            em.refresh((Object)entity);
        }
        return entities;
    }
}

