/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.dao;

import com.dev63.restoran.db.queries.Queries;
import com.dev63.restoran.db.queries.QueryName;
import com.dev63.restoran.izvestaji.nivelacija.NivelacijaRow;
import com.dev63.restoran.jpa.SingletonEmReference;
import com.dev63.restoran.jpa.ThreadLocalEntityManager;
import com.dev63.restoran.model.Nivelacija;
import com.dev63.restoran.model.dao.EntityDAO;
import com.dev63.restoran.utils.LogUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class NivelacijaDAO
extends EntityDAO<Nivelacija> {
    private static Pattern p = Pattern.compile("\\?");

    public NivelacijaDAO(Class<Nivelacija> entityType, EntityManagerFactory emf, SingletonEmReference singletonEmReference, ThreadLocalEntityManager sessioneEm) {
        super(entityType, emf, singletonEmReference, sessioneEm);
    }

    public NivelacijaDAO(Class<Nivelacija> entityType, EntityManagerFactory emf, SingletonEmReference singletonEmReference) {
        super(entityType, emf, singletonEmReference);
    }

    public List<NivelacijaRow> nivelacija(Date date) {
        String query = Queries.QUERIES.get((Object)QueryName.NIVELACIJA);
        Matcher matcher = p.matcher(query);
        query = matcher.replaceFirst(String.format("'%1$tY-%1$tm-%1$td'", date));
        String[] queries = query.split(";");
        LinkedList<NivelacijaRow> results = new LinkedList<NivelacijaRow>();
        EntityManager actionEm = this.getEmForScope(EntityDAO.EMScope.ACTION);
        try (Connection conn = (Connection)actionEm.unwrap(Connection.class);
             Statement ps = conn.createStatement();){
            ps.executeUpdate(queries[0]);
            ResultSet rs = ps.executeQuery(queries[1]);
            while (rs.next()) {
                NivelacijaRow row = new NivelacijaRow();
                row.redniBroj = rs.getInt("redni_broj");
                row.naziv = rs.getString("artikal_naziv");
                row.jedinicaMere = rs.getString("jedinica_mere");
                row.kolicina = rs.getBigDecimal("kolicina");
                row.staraCena = rs.getBigDecimal("stara_cena");
                row.novaCena = rs.getBigDecimal("nova_cena");
                row.povecanjeCene = rs.getBigDecimal("povecanje_cene");
                row.PDV = rs.getBigDecimal("pdv");
                row.povecanjePDVa = rs.getBigDecimal("povecanje_pdva");
                row.staraCenaSaPDVom = rs.getBigDecimal("stara_cena_sa_pdv");
                row.novaCenaSaPDVom = rs.getBigDecimal("nova_cena_sa_pdv");
                row.povecanjeRazlikeUCeni = rs.getBigDecimal("povecanje_razlike_u_ceni");
                row.povecanjePoreza = rs.getBigDecimal("povecanje_poreza");
                results.add(row);
            }
        }
        catch (SQLException ex) {
            String message = "Greska kod ucitavanja podataka o nivelaciji";
            LogUtils.severe(ex, message, new Object[0]);
            throw new RuntimeException(message);
        }
        finally {
            this.cleanUpEm(actionEm, EntityDAO.EMScope.ACTION, true);
        }
        return results;
    }
}

